/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.client.tools.WebDavTunnelHelper;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SimpleWebDavPanel
extends JPanel
implements CidsBeanStore,
EditorSaveListener,
Disposable,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(SimpleWebDavPanel.class);
    protected final WebDavTunnelHelper webdavHelper;
    protected final String beanCollProp;
    protected final String nameProp;
    protected final String bildClassName;
    protected final JFileChooser fileChooser = new JFileChooser();
    protected final List<CidsBean> removeNewAddedFotoBean = new ArrayList<CidsBean>();
    protected final List<CidsBean> removedFotoBeans = new ArrayList<CidsBean>();
    protected final MappingComponent map = new MappingComponent();
    protected boolean listListenerEnabled = true;
    protected CidsBean cidsBean;
    private final ConnectionContext connectionContext;
    JButton btnAddImg;
    JButton btnRemoveImg;
    JList lstFotos;
    private BindingGroup bindingGroup;

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        RoundedPanel pnlFotos = new RoundedPanel();
        SemiRoundedPanel pnlHeaderFotos = new SemiRoundedPanel();
        JLabel lblHeaderFotos = new JLabel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel1 = new JPanel();
        JScrollPane jspFotoList = new JScrollPane();
        this.lstFotos = new JList();
        JPanel pnlCtrlButtons = new JPanel();
        this.btnAddImg = new JButton();
        this.btnRemoveImg = new JButton();
        FormListener formListener = new FormListener();
        this.setName("Form");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        pnlFotos.setMinimumSize(new Dimension(400, 200));
        pnlFotos.setName("pnlFotos");
        pnlFotos.setPreferredSize(new Dimension(400, 200));
        pnlFotos.setLayout((LayoutManager)new GridBagLayout());
        pnlHeaderFotos.setBackground(new Color(51, 51, 51));
        pnlHeaderFotos.setForeground(new Color(51, 51, 51));
        pnlHeaderFotos.setName("pnlHeaderFotos");
        pnlHeaderFotos.setLayout((LayoutManager)new FlowLayout());
        lblHeaderFotos.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)lblHeaderFotos, (String)NbBundle.getMessage(SimpleWebDavPanel.class, (String)"SimpleWebDavPanel.lblHeaderFotos.text"));
        lblHeaderFotos.setName("lblHeaderFotos");
        pnlHeaderFotos.add((Component)lblHeaderFotos);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        pnlFotos.add((Component)pnlHeaderFotos, (Object)gridBagConstraints);
        jPanel2.setName("jPanel2");
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new GridBagLayout());
        jPanel1.setName("jPanel1");
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new GridBagLayout());
        jspFotoList.setMinimumSize(new Dimension(250, 130));
        jspFotoList.setName("jspFotoList");
        this.lstFotos.setName("lstFotos");
        ELProperty eLProperty = ELProperty.create((String)("${cidsBean." + this.beanCollProp + "}"));
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JList)this.lstFotos);
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.lstFotos.addMouseListener(formListener);
        this.lstFotos.addListSelectionListener(formListener);
        jspFotoList.setViewportView(this.lstFotos);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add((Component)jspFotoList, gridBagConstraints);
        pnlCtrlButtons.setName("pnlCtrlButtons");
        pnlCtrlButtons.setOpaque(false);
        pnlCtrlButtons.setLayout(new GridBagLayout());
        this.btnAddImg.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddImg, (String)NbBundle.getMessage(SimpleWebDavPanel.class, (String)"SimpleWebDavPanel.btnAddImg.text"));
        this.btnAddImg.setBorderPainted(false);
        this.btnAddImg.setContentAreaFilled(false);
        this.btnAddImg.setName("btnAddImg");
        this.btnAddImg.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        pnlCtrlButtons.add((Component)this.btnAddImg, gridBagConstraints);
        this.btnRemoveImg.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveImg, (String)NbBundle.getMessage(SimpleWebDavPanel.class, (String)"SimpleWebDavPanel.btnRemoveImg.text"));
        this.btnRemoveImg.setBorderPainted(false);
        this.btnRemoveImg.setContentAreaFilled(false);
        this.btnRemoveImg.setName("btnRemoveImg");
        this.btnRemoveImg.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        pnlCtrlButtons.add((Component)this.btnRemoveImg, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel1.add((Component)pnlCtrlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 5);
        jPanel2.add((Component)jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        pnlFotos.add((Component)jPanel2, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)pnlFotos, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public SimpleWebDavPanel() {
        this(true, "dokumente", "dokumentClass", "name", "webDavTunnelAction", ConnectionContext.createDummy());
    }

    public SimpleWebDavPanel(boolean editable, String beanCollProp, String bildClassName, final String nameProp, String tunnelAction, ConnectionContext connectionContext) {
        this.beanCollProp = beanCollProp;
        this.bildClassName = bildClassName;
        this.nameProp = nameProp;
        this.connectionContext = connectionContext;
        WebDavTunnelHelper webdavHelper = null;
        try {
            webdavHelper = new WebDavTunnelHelper("WUNDA_BLAU", tunnelAction);
        }
        catch (Exception ex) {
            String message = "Fehler beim Initialisieren der Bilderablage.";
            LOG.error((Object)"Fehler beim Initialisieren der Bilderablage.", (Throwable)ex);
            ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Initialisieren der Bilderablage.", ex, null);
        }
        this.webdavHelper = webdavHelper;
        this.initComponents();
        this.lstFotos.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (component instanceof JLabel && value instanceof CidsBean) {
                    CidsBean dokumentBean = (CidsBean)value;
                    String name = (String)dokumentBean.getProperty(nameProp);
                    ((JLabel)component).setText(name);
                }
                return component;
            }
        });
        this.fileChooser.setMultiSelectionEnabled(true);
        this.lstFotos.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        this.btnAddImg.setVisible(editable);
        this.btnRemoveImg.setVisible(editable);
    }

    private void lstFotosValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting() || this.listListenerEnabled) {
            // empty if block
        }
    }

    private void btnAddImgActionPerformed(ActionEvent evt) {
        File[] selFiles;
        if (0 == this.fileChooser.showOpenDialog(this) && (selFiles = this.fileChooser.getSelectedFiles()) != null && selFiles.length > 0) {
            CismetThreadPool.execute((Runnable)new ImageUploadWorker(Arrays.asList(selFiles)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnRemoveImgActionPerformed(ActionEvent evt) {
        int answer;
        Object[] selection = this.lstFotos.getSelectedValues();
        if (selection != null && selection.length > 0 && (answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Sollen die Fotos wirklich gel\u00f6scht werden?", "Fotos entfernen", 0)) == 0) {
            try {
                this.listListenerEnabled = false;
                List<Object> removeList = Arrays.asList(selection);
                List fotos = this.cidsBean.getBeanCollectionProperty(this.beanCollProp);
                if (fotos != null) {
                    fotos.removeAll(removeList);
                }
                for (int i = 0; i < this.lstFotos.getModel().getSize(); ++i) {
                    CidsBean foto = (CidsBean)this.lstFotos.getModel().getElementAt(i);
                    foto.setProperty("laufende_nummer", (Object)(i + 1));
                }
                for (Object toDeleteObj : removeList) {
                    if (!(toDeleteObj instanceof CidsBean)) continue;
                    CidsBean fotoToDelete = (CidsBean)toDeleteObj;
                    this.removedFotoBeans.add(fotoToDelete);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                SimpleWebDavPanel.showExceptionToUser(ex, this);
            }
            finally {
                this.listListenerEnabled = true;
                int modelSize = this.lstFotos.getModel().getSize();
                if (modelSize > 0) {
                    this.lstFotos.setSelectedIndex(0);
                }
            }
        }
    }

    private void lstFotosMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            final CidsBean dokumentBean = (CidsBean)this.lstFotos.getSelectedValue();
            if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this.getParent())) {
                final String jobname = DownloadManagerDialog.getInstance().getJobName();
                AbstractDownload download = new AbstractDownload(){
                    {
                        this.status = Download.State.WAITING;
                        this.directory = jobname;
                        String dateiname = (String)dokumentBean.getProperty("dateiname");
                        int extIndex = dateiname.lastIndexOf(".");
                        String extension = extIndex >= 0 ? dateiname.substring(extIndex) : "";
                        String filename = extIndex >= 0 ? dateiname.substring(0, extIndex) : dateiname;
                        this.determineDestinationFile(filename, extension);
                    }

                    public void run() {
                        try {
                            this.status = Download.State.RUNNING;
                            this.stateChanged();
                            InputStream is = SimpleWebDavPanel.this.webdavHelper.getFileFromWebDAV((String)dokumentBean.getProperty(SimpleWebDavPanel.this.nameProp), SimpleWebDavPanel.this.getConnectionContext());
                            try (FileOutputStream os = new FileOutputStream(this.fileToSaveTo);){
                                IOUtils.copy((InputStream)is, (OutputStream)os);
                            }
                            if (this.status == Download.State.RUNNING) {
                                this.status = Download.State.COMPLETED;
                                this.stateChanged();
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                            this.status = Download.State.ABORTED;
                            this.stateChanged();
                        }
                    }
                };
                DownloadManager.instance().add((Download)download);
            }
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        this.bindingGroup.bind();
        if (cidsBean != null && this.lstFotos.getModel().getSize() > 0) {
            this.lstFotos.setSelectedIndex(0);
        }
    }

    public static Image adjustScale(BufferedImage bi, JComponent component, int insetX, int insetY) {
        double scaley;
        double scalex = (double)component.getWidth() / (double)bi.getWidth();
        double scale = Math.min(scalex, scaley = (double)component.getHeight() / (double)bi.getHeight());
        if (scale <= 1.0) {
            return bi.getScaledInstance((int)((double)bi.getWidth() * scale) - insetX, (int)((double)bi.getHeight() * scale) - insetY, 4);
        }
        return bi;
    }

    private static void showExceptionToUser(Exception ex, JComponent parent) {
        ErrorInfo ei = new ErrorInfo("Fehler", "Beim Vorgang ist ein Fehler aufgetreten", null, null, (Throwable)ex, Level.SEVERE, null);
        JXErrorPane.showDialog((Component)parent, (ErrorInfo)ei);
    }

    public void editorClosed(EditorClosedEvent event) {
        if (EditorSaveListener.EditorSaveStatus.SAVE_SUCCESS == event.getStatus()) {
            for (CidsBean deleteBean : this.removedFotoBeans) {
                String fileName = (String)deleteBean.getProperty(this.nameProp);
                try {
                    this.webdavHelper.deleteFileFromWebDAV(fileName, this.getConnectionContext());
                    deleteBean.delete();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    SimpleWebDavPanel.showExceptionToUser(ex, this);
                }
            }
        } else {
            for (CidsBean deleteBean : this.removeNewAddedFotoBean) {
                String fileName = (String)deleteBean.getProperty(this.nameProp);
                try {
                    this.webdavHelper.deleteFileFromWebDAV(fileName, this.getConnectionContext());
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    SimpleWebDavPanel.showExceptionToUser(ex, this);
                }
            }
        }
    }

    public boolean prepareForSave() {
        return true;
    }

    public void dispose() {
        this.bindingGroup.unbind();
        this.map.getFeatureCollection().removeAllFeatures();
        this.map.dispose();
        this.cidsBean = null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    protected class ImageUploadWorker
    extends SwingWorker<Collection<CidsBean>, Void> {
        private final Collection<File> dokumente;

        public ImageUploadWorker(Collection<File> dokumente) {
            this.dokumente = dokumente;
        }

        @Override
        protected Collection<CidsBean> doInBackground() throws Exception {
            ArrayList<CidsBean> newBeans = new ArrayList<CidsBean>();
            for (File dokument : this.dokumente) {
                SimpleWebDavPanel.this.webdavHelper.uploadFileToWebDAV(dokument.getName(), dokument, (Component)SimpleWebDavPanel.this, SimpleWebDavPanel.this.getConnectionContext());
                CidsBean newDokument = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)SimpleWebDavPanel.this.bildClassName, (ConnectionContext)SimpleWebDavPanel.this.getConnectionContext());
                newDokument.setProperty(SimpleWebDavPanel.this.nameProp, (Object)dokument.getName());
                newDokument.setProperty("messstelle", SimpleWebDavPanel.this.cidsBean.getProperty("id"));
                newBeans.add(newDokument);
            }
            return newBeans;
        }

        @Override
        protected void done() {
            try {
                Collection newBeans = (Collection)this.get();
                if (!newBeans.isEmpty()) {
                    List oldBeans = SimpleWebDavPanel.this.cidsBean.getBeanCollectionProperty(SimpleWebDavPanel.this.beanCollProp);
                    oldBeans.addAll(newBeans);
                    SimpleWebDavPanel.this.removeNewAddedFotoBean.addAll(newBeans);
                    SimpleWebDavPanel.this.lstFotos.setSelectedValue(newBeans.iterator().next(), true);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    private class FormListener
    implements ActionListener,
    MouseListener,
    ListSelectionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == SimpleWebDavPanel.this.btnAddImg) {
                SimpleWebDavPanel.this.btnAddImgActionPerformed(evt);
            } else if (evt.getSource() == SimpleWebDavPanel.this.btnRemoveImg) {
                SimpleWebDavPanel.this.btnRemoveImgActionPerformed(evt);
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getSource() == SimpleWebDavPanel.this.lstFotos) {
                SimpleWebDavPanel.this.lstFotosMouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt.getSource() == SimpleWebDavPanel.this.lstFotos) {
                SimpleWebDavPanel.this.lstFotosValueChanged(evt);
            }
        }
    }
}

