/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.utils.VkConfProperties;
import de.cismet.cids.custom.objecteditors.utils.VkDocumentLoader;
import de.cismet.cids.custom.objecteditors.wunda_blau.TwBrunnenEditor;
import de.cismet.cids.custom.objecteditors.wunda_blau.VkVorhabenEditor;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class VkFotoPanel
extends JPanel
implements Disposable,
CidsBeanStore,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(VkFotoPanel.class);
    public static final int FOTO_WIDTH = 500;
    public static final String FIELD__ANZEIGE = "anzeige";
    public static final String FIELD__URL = "url";
    public static final String FIELD__FK_VORHABEN = "fk_vorhaben";
    public static final String TABLE__NAME = "vk_vorhaben_fotos";
    public static final String BUNDLE_NOLOAD = "VkFotoPanel.loadPictureWithUrl().noLoad";
    public static final String BUNDLE_NOURL = "VkFotoPanel.isOkForSaving().noUrl";
    public static final String BUNDLE_ANZEIGE = "VkFotoPanel.isOkForSaving().anzeige";
    public static final String BUNDLE_ANZEIGE_EMPTY = "VkFotoPanel.isOkForSaving().anzeigeEmpty";
    public static final String BUNDLE_WHICH = "VkFotoPanel.isOkForSaving().welchesFoto";
    public static final String BUNDLE_PANE_PREFIX = "VkFotoPanel.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "VkFotoPanel.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "VkFotoPanel.isOkForSaving().JOptionPane.title";
    public static final String BUNDLE_NOSAVE_MESSAGE = "VkFotoPanel.noSave().message";
    public static final String BUNDLE_NOSAVE_TITLE = "VkFotoPanel.noSave().title";
    private static final int MAX_ZEICHEN = 75;
    private static String PATH_FOTOS;
    private static Exception errorNoSave;
    private final boolean editor;
    private final VkDocumentLoader vkDocumentLoader;
    private CidsBean cidsBean;
    private String saveAnzeige;
    private String saveUrl;
    private final ImageIcon statusFalsch = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status-busy.png"));
    private final ImageIcon statusOk = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status.png"));
    private SwingWorker worker_url;
    private final PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "anzeige": {
                    if (evt.getNewValue() == VkFotoPanel.this.saveAnzeige) break;
                    VkFotoPanel.this.setChangeFlag();
                    break;
                }
                case "url": {
                    if (evt.getNewValue() == VkFotoPanel.this.saveUrl) break;
                    VkFotoPanel.this.setChangeFlag();
                    VkFotoPanel.this.checkLink();
                    break;
                }
                default: {
                    VkFotoPanel.this.setChangeFlag();
                }
            }
        }
    };
    JLabel lblAnzeige;
    JLabel lblFotoAnzeigen;
    JLabel lblUrl;
    JLabel lblUrlCheck;
    JPanel panDaten;
    JPanel panFoto;
    JPanel panUrl;
    JTextField txtAnzeige;
    JTextField txtUrl;
    private BindingGroup bindingGroup;

    public VkFotoPanel() {
        this((VkDocumentLoader)null);
    }

    public VkFotoPanel(VkDocumentLoader vdlInstance) {
        this.vkDocumentLoader = vdlInstance;
        this.editor = vdlInstance != null ? vdlInstance.getParentOrganizer().isEditor() : false;
        this.initComponents();
        this.initProperties();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panDaten = new JPanel();
        this.panFoto = new JPanel();
        this.lblAnzeige = new JLabel();
        this.txtAnzeige = new JTextField();
        this.lblUrl = new JLabel();
        this.txtUrl = new JTextField();
        this.panUrl = new JPanel();
        this.lblUrlCheck = new JLabel();
        this.lblFotoAnzeigen = new JLabel();
        this.setName("Form");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.panDaten.setName("panDaten");
        this.panDaten.setOpaque(false);
        this.panDaten.setLayout(new GridBagLayout());
        this.panFoto.setMinimumSize(new Dimension(100, 10));
        this.panFoto.setName("panFoto");
        this.panFoto.setOpaque(false);
        this.panFoto.setPreferredSize(new Dimension(520, 270));
        this.panFoto.setLayout(new GridBagLayout());
        this.lblAnzeige.setFont(new Font("Tahoma", 1, 11));
        Mnemonics.setLocalizedText((JLabel)this.lblAnzeige, (String)NbBundle.getMessage(VkFotoPanel.class, (String)"VkFotoPanel.lblAnzeige.text"));
        this.lblAnzeige.setToolTipText(NbBundle.getMessage(VkFotoPanel.class, (String)"VkFotoPanel.lblAnzeige.toolTipText"));
        this.lblAnzeige.setName("lblAnzeige");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panFoto.add((Component)this.lblAnzeige, gridBagConstraints);
        this.txtAnzeige.setEnabled(false);
        this.txtAnzeige.setName("txtAnzeige");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.anzeige}"), (Object)this.txtAnzeige, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue(null);
        binding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panFoto.add((Component)this.txtAnzeige, gridBagConstraints);
        this.lblUrl.setFont(new Font("Tahoma", 1, 11));
        Mnemonics.setLocalizedText((JLabel)this.lblUrl, (String)NbBundle.getMessage(VkFotoPanel.class, (String)"VkFotoPanel.lblUrl.text"));
        this.lblUrl.setName("lblUrl");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panFoto.add((Component)this.lblUrl, gridBagConstraints);
        this.txtUrl.setEnabled(false);
        this.txtUrl.setName("txtUrl");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.url}"), (Object)this.txtUrl, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue(null);
        binding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panFoto.add((Component)this.txtUrl, gridBagConstraints);
        this.panUrl.setName("panUrl");
        this.panUrl.setOpaque(false);
        this.panUrl.setLayout(new GridBagLayout());
        this.lblUrlCheck.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status-busy.png")));
        this.lblUrlCheck.setName("lblUrlCheck");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panUrl.add((Component)this.lblUrlCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panFoto.add((Component)this.panUrl, gridBagConstraints);
        this.lblFotoAnzeigen.setFont(new Font("Tahoma", 1, 11));
        this.lblFotoAnzeigen.setName("lblFotoAnzeigen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.panFoto.add((Component)this.lblFotoAnzeigen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panDaten.add((Component)this.panFoto, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panDaten, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        MappingComponent mc = new MappingComponent();
        CismapBroker.getInstance().setMappingComponent(mc);
        DevelopmentTools.createEditorFromRestfulConnection((String)"http://localhost:9986/callserver/binary", (String)"WUNDA_BLAU", null, (boolean)true, (String)TABLE__NAME, (int)1, (int)800, (int)600);
    }

    private boolean isEditor() {
        return this.editor;
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            RendererTools.makeReadOnly(this.txtAnzeige);
            RendererTools.makeReadOnly(this.txtUrl);
            this.txtAnzeige.setEnabled(true);
            this.txtUrl.setEnabled(true);
        }
    }

    private void initProperties() {
        try {
            PATH_FOTOS = VkConfProperties.getInstance().getPathFotos();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Get no conf properties.", (Throwable)ex);
        }
    }

    private void checkLink() {
        this.lblUrlCheck.setIcon(this.statusFalsch);
        this.lblUrlCheck.setCursor(new Cursor(0));
        if (this.txtUrl.getText() != null && this.txtUrl.getText().length() > 5) {
            final String foto = PATH_FOTOS.concat(this.txtUrl.getText());
            EventQueue.invokeLater(new Thread("checkLinkThread"){

                @Override
                public void run() {
                    VkFotoPanel.this.checkUrl(foto, VkFotoPanel.this.lblUrlCheck);
                    VkFotoPanel.this.loadPictureWithUrl(foto, VkFotoPanel.this.lblFotoAnzeigen);
                }
            });
        }
    }

    private void loadPictureWithUrl(final String url, final JLabel showLabel) {
        showLabel.setCursor(new Cursor(0));
        SwingWorker<ImageIcon, Void> worker = new SwingWorker<ImageIcon, Void>(){

            @Override
            protected ImageIcon doInBackground() throws Exception {
                return VkFotoPanel.this.loadPicture(new URL(url));
            }

            @Override
            protected void done() {
                try {
                    ImageIcon check = (ImageIcon)this.get();
                    if (check != null) {
                        showLabel.setIcon(check);
                        showLabel.setText("");
                        showLabel.setCursor(new Cursor(12));
                    } else {
                        showLabel.setIcon(null);
                        showLabel.setText(NbBundle.getMessage(TwBrunnenEditor.class, (String)VkFotoPanel.BUNDLE_NOLOAD));
                        showLabel.setCursor(new Cursor(0));
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    showLabel.setText(NbBundle.getMessage(TwBrunnenEditor.class, (String)VkFotoPanel.BUNDLE_NOLOAD));
                    showLabel.setCursor(new Cursor(0));
                    LOG.warn((Object)"load picture Problem in Worker.", (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    public ImageIcon loadPicture(URL url) {
        try {
            int bildZielBreite = 500;
            BufferedImage originalBild = ImageIO.read(WebAccessManager.getInstance().doRequest(url));
            Image skaliertesBild = originalBild.getScaledInstance(500, -1, 4);
            return new ImageIcon(skaliertesBild);
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not load picture.", (Throwable)ex);
            return null;
        }
    }

    private void checkUrl(final String url, final JLabel showLabel) {
        showLabel.setIcon(this.statusFalsch);
        showLabel.setCursor(new Cursor(0));
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                return WebAccessManager.getInstance().checkIfURLaccessible(new URL(url));
            }

            @Override
            protected void done() {
                try {
                    if (this.isCancelled()) {
                        return;
                    }
                    Boolean check = (Boolean)this.get();
                    if (check.booleanValue()) {
                        showLabel.setIcon(VkFotoPanel.this.statusOk);
                        showLabel.setCursor(new Cursor(12));
                    } else {
                        showLabel.setIcon(VkFotoPanel.this.statusFalsch);
                        showLabel.setCursor(new Cursor(0));
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    showLabel.setIcon(VkFotoPanel.this.statusFalsch);
                    showLabel.setCursor(new Cursor(0));
                    LOG.warn((Object)"URL Check Problem in Worker.", (Throwable)e);
                }
            }
        };
        if (this.worker_url != null && !this.worker_url.isCancelled()) {
            this.worker_url.cancel(true);
        }
        this.worker_url = worker;
        this.worker_url.execute();
    }

    private void setChangeFlag() {
        if (this.getVkDocumentLoader() != null && this.getVkDocumentLoader().getParentOrganizer() != null && this.getVkDocumentLoader().getParentOrganizer().getCidsBean() != null) {
            this.getVkDocumentLoader().getParentOrganizer().getCidsBean().setArtificialChangeFlag(true);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.vkDocumentLoader != null && this.vkDocumentLoader.getParentOrganizer() != null ? this.vkDocumentLoader.getParentOrganizer().getConnectionContext() : null;
    }

    public void dispose() {
        this.vkDocumentLoader.clearAllMaps();
        this.bindingGroup.unbind();
        if (this.isEditor() && this.getCidsBean() != null) {
            this.getCidsBean().removePropertyChangeListener(this.changeListener);
        }
        this.cidsBean = null;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void setSaveValues() {
        this.saveAnzeige = this.getCidsBean().getProperty(FIELD__ANZEIGE) != null ? (String)this.getCidsBean().getProperty(FIELD__ANZEIGE) : null;
        this.saveUrl = this.getCidsBean().getProperty(FIELD__URL) != null ? (String)this.getCidsBean().getProperty(FIELD__URL) : null;
    }

    public void setCidsBean(CidsBean cidsBean) {
        block8: {
            if (!Objects.equals(this.getCidsBean(), cidsBean)) {
                if (this.isEditor() && this.getCidsBean() != null) {
                    this.getCidsBean().removePropertyChangeListener(this.changeListener);
                }
                try {
                    this.lblFotoAnzeigen.setIcon(null);
                    this.lblFotoAnzeigen.setCursor(new Cursor(0));
                    this.bindingGroup.unbind();
                    this.cidsBean = cidsBean;
                    if (this.getCidsBean() != null && this.isEditor()) {
                        this.setSaveValues();
                    }
                    if (this.getCidsBean() != null) {
                        DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)this.getCidsBean(), (ConnectionContext)this.getConnectionContext());
                    }
                    this.bindingGroup.bind();
                    this.checkLink();
                    if (this.isEditor() && this.getCidsBean() != null) {
                        this.getCidsBean().addPropertyChangeListener(this.changeListener);
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"problem in setCidsBean.", (Throwable)ex);
                    if (!this.isEditor()) break block8;
                    VkFotoPanel.setErrorNoSave(ex);
                    this.noSave();
                }
            }
        }
        this.setReadOnly();
        if (this.isEditor()) {
            this.nullNoEdit(this.getCidsBean() != null);
        }
    }

    public void noSave() {
        ErrorInfo info = new ErrorInfo(NbBundle.getMessage(VkFotoPanel.class, (String)BUNDLE_NOSAVE_TITLE), NbBundle.getMessage(VkFotoPanel.class, (String)BUNDLE_NOSAVE_MESSAGE), null, null, (Throwable)VkFotoPanel.getErrorNoSave(), Level.SEVERE, null);
        JXErrorPane.showDialog((Component)this, (ErrorInfo)info);
    }

    private void nullNoEdit(boolean edit) {
        this.txtAnzeige.setEnabled(edit);
        this.txtUrl.setEnabled(edit);
    }

    public boolean isOkForSaving(CidsBean saveFotoBean) {
        if (VkFotoPanel.getErrorNoSave() != null) {
            this.noSave();
            return false;
        }
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (saveFotoBean.getProperty(FIELD__URL) == null || saveFotoBean.getProperty(FIELD__URL).toString().trim().isEmpty()) {
                LOG.warn((Object)"No url specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(VkFotoPanel.class, (String)BUNDLE_NOURL));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"url not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (saveFotoBean.getProperty(FIELD__ANZEIGE) != null && !saveFotoBean.getProperty(FIELD__ANZEIGE).toString().isEmpty()) {
                if (saveFotoBean.getProperty(FIELD__ANZEIGE).toString().length() > 75) {
                    LOG.warn((Object)"Long Anzeige specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(VkFotoPanel.class, (String)BUNDLE_ANZEIGE));
                    save = false;
                } else if (saveFotoBean.getProperty(FIELD__ANZEIGE).toString().trim().isEmpty()) {
                    LOG.warn((Object)"Empty Anzeige specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(VkFotoPanel.class, (String)BUNDLE_ANZEIGE_EMPTY));
                    save = false;
                }
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"anzeige too long.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            if (this.vkDocumentLoader.getParentOrganizer() instanceof VkVorhabenEditor) {
                errorMessage.append(NbBundle.getMessage(VkFotoPanel.class, (String)BUNDLE_WHICH)).append(saveFotoBean.getPrimaryKeyValue());
            }
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(VkFotoPanel.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(VkFotoPanel.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(VkFotoPanel.class, (String)BUNDLE_PANE_TITLE), 2);
        }
        return save;
    }

    public static Exception getErrorNoSave() {
        return errorNoSave;
    }

    public static void setErrorNoSave(Exception errorNoSave) {
        VkFotoPanel.errorNoSave = errorNoSave;
    }

    public VkDocumentLoader getVkDocumentLoader() {
        return this.vkDocumentLoader;
    }

    static {
        errorNoSave = null;
    }
}

