/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.treppe;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objecteditors.wunda_blau.TreppeEditor;
import de.cismet.cids.custom.objecteditors.wunda_blau.treppe.TreppeStuetzmauerPanel;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.Disposable;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TreppeStuetzmauernPanel
extends JPanel
implements Disposable,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(TreppeStuetzmauernPanel.class);
    private final boolean netbeansDesignDummy;
    private List<CidsBean> cidsBeans;
    private final boolean editable;
    private final HashMap<CidsBean, CidsBean> zustandBeanMap = new HashMap();
    private final ConnectionContext connectionContext;
    Box.Filler filler1;
    JPanel jPanel1;
    TreppeStuetzmauerPanel treppeStuetzmauerPanel1;

    public TreppeStuetzmauernPanel() {
        this(ConnectionContext.createDeprecated());
    }

    public TreppeStuetzmauernPanel(ConnectionContext connectionContext) {
        this(true, true, connectionContext);
    }

    public TreppeStuetzmauernPanel(boolean editable, ConnectionContext connectionContext) {
        this(editable, false, connectionContext);
    }

    public TreppeStuetzmauernPanel(boolean editable, boolean netbeansDesignDummy, ConnectionContext connectionContext) {
        this.netbeansDesignDummy = netbeansDesignDummy;
        this.editable = editable;
        this.connectionContext = connectionContext;
        this.initComponents();
    }

    public Collection<CidsBean> getZustandBeans() {
        return this.zustandBeanMap.values();
    }

    public void setCidsBeans(List<CidsBean> cidsBeans) {
        this.zustandBeanMap.clear();
        this.jPanel1.removeAll();
        this.cidsBeans = cidsBeans;
        if (cidsBeans != null) {
            for (final CidsBean cidsBean : cidsBeans) {
                final Integer mauerId = (Integer)cidsBean.getProperty("mauer");
                if (mauerId == null) continue;
                new SwingWorker<CidsBean, Void>(){

                    @Override
                    protected CidsBean doInBackground() throws Exception {
                        MetaClass mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"mauer", (ConnectionContext)TreppeStuetzmauernPanel.this.getConnectionContext());
                        MetaObject mo = SessionManager.getProxy().getMetaObject(mauerId.intValue(), mc.getID(), "WUNDA_BLAU", TreppeStuetzmauernPanel.this.getConnectionContext());
                        CidsBean mauerBean = mo.getBean();
                        return mauerBean;
                    }

                    @Override
                    protected void done() {
                        try {
                            CidsBean mauerBean = (CidsBean)this.get();
                            TreppeStuetzmauernPanel.this.addMauerPanel(cidsBean, mauerBean);
                        }
                        catch (Exception ex) {
                            String message = "Fehler beim Laden der St\u00fctzmauer. (mauerId: " + mauerId + ")";
                            LOG.error((Object)message, (Throwable)ex);
                            ObjectRendererUtils.showExceptionWindowToUser(message, ex, TreppeStuetzmauernPanel.this);
                        }
                    }
                }.execute();
            }
        }
    }

    private void addMauerPanel(final CidsBean cidsBean, final CidsBean mauerBean) {
        this.jPanel1.remove(this.filler1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.cidsBeans.size();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.filler1, gridBagConstraints);
        new SwingWorker<JPanel, Void>(){

            @Override
            protected JPanel doInBackground() throws Exception {
                TreppeStuetzmauerPanel panel = new TreppeStuetzmauerPanel(TreppeStuetzmauernPanel.this.editable);
                panel.setMauerBean(mauerBean);
                Integer kostenGelaender = (Integer)mauerBean.getProperty("san_kosten_gelaender");
                Integer kostenGruendung = (Integer)mauerBean.getProperty("san_kosten_gruendung");
                Integer kostenverformung = (Integer)mauerBean.getProperty("san_kosten_verformung");
                Integer kostenGelaende = (Integer)mauerBean.getProperty("san_kosten_gelaende");
                Integer kostenAnsicht = (Integer)mauerBean.getProperty("san_kosten_ansicht");
                Integer kostenKopf = (Integer)mauerBean.getProperty("san_kosten_kopf");
                double summe = 0.0;
                summe += kostenGelaender != null ? (double)kostenGelaender.intValue() : 0.0;
                summe += kostenGruendung != null ? (double)kostenGruendung.intValue() : 0.0;
                summe += kostenverformung != null ? (double)kostenverformung.intValue() : 0.0;
                summe += kostenGelaende != null ? (double)kostenGelaende.intValue() : 0.0;
                summe += kostenAnsicht != null ? (double)kostenAnsicht.intValue() : 0.0;
                summe += kostenKopf != null ? (double)kostenKopf.intValue() : 0.0;
                CidsBean zustandBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"TREPPE_ZUSTAND", (ConnectionContext)TreppeStuetzmauernPanel.this.getConnectionContext());
                zustandBean.setProperty("verkehrssicherheit", null);
                zustandBean.setProperty("dauerhaftigkeit", null);
                zustandBean.setProperty("standsicherheit", null);
                zustandBean.setProperty("sanierungsmassnahmen", (Object)"siehe Mauer-Beschreibung");
                zustandBean.setProperty("gesamt", mauerBean.getProperty("zustand_gesamt"));
                zustandBean.setProperty("kosten", (Object)summe);
                TreppeStuetzmauernPanel.this.zustandBeanMap.put(cidsBean, zustandBean);
                panel.setZustandBean(zustandBean);
                panel.setCidsBean(cidsBean);
                panel.setParent(TreppeStuetzmauernPanel.this);
                return panel;
            }

            @Override
            protected void done() {
                try {
                    JPanel panel = (JPanel)this.get();
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = TreppeStuetzmauernPanel.this.cidsBeans.indexOf(cidsBean);
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.insets = new Insets(0, 0, 5, 0);
                    TreppeStuetzmauernPanel.this.jPanel1.add((Component)panel, gridBagConstraints);
                    TreppeStuetzmauernPanel.this.jPanel1.repaint();
                    TreppeStuetzmauernPanel.this.refreshOverview();
                }
                catch (Exception ex) {
                    String message = "Fehler beim Hinzuf\u00fcgen der St\u00fctzmauer.";
                    LOG.error((Object)"Fehler beim Hinzuf\u00fcgen der St\u00fctzmauer.", (Throwable)ex);
                    ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Hinzuf\u00fcgen der St\u00fctzmauer.", ex, TreppeStuetzmauernPanel.this);
                }
            }
        }.execute();
    }

    private void refreshOverview() {
        TreppeEditor treppeEditor = (TreppeEditor)this.getParent().getParent().getParent().getParent();
        TreppeEditor.ZustandOverview overview = treppeEditor.getOverview();
        overview.recalculateStuetzmauern();
        overview.recalculateGesamt();
        overview.refreshView();
    }

    public Map<CidsBean, CidsBean> getMauerBeans() {
        HashMap<CidsBean, CidsBean> mauerBeans = new HashMap<CidsBean, CidsBean>();
        for (Component comp : this.jPanel1.getComponents()) {
            if (!(comp instanceof TreppeStuetzmauerPanel)) continue;
            TreppeStuetzmauerPanel mauerPanel = (TreppeStuetzmauerPanel)comp;
            mauerBeans.put(mauerPanel.getCidsBean(), mauerPanel.getMauerBean());
        }
        return mauerBeans;
    }

    public void removeMauerPanel(TreppeStuetzmauerPanel panel) {
        if (panel != null) {
            CidsBean cidsBean = panel.getCidsBean();
            this.zustandBeanMap.remove(cidsBean);
            this.cidsBeans.remove(cidsBean);
            this.jPanel1.remove(panel);
            this.jPanel1.repaint();
            this.refreshOverview();
        }
    }

    public List<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        if (this.netbeansDesignDummy) {
            this.treppeStuetzmauerPanel1 = new TreppeStuetzmauerPanel();
        }
        DroppedLabel jLabel1 = new DroppedLabel();
        this.setName("Form");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        jScrollPane1.setBorder(null);
        jScrollPane1.setName("jScrollPane1");
        jScrollPane1.setOpaque(false);
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.filler1.setName("filler1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.filler1, gridBagConstraints);
        if (this.netbeansDesignDummy) {
            this.treppeStuetzmauerPanel1.setName("treppeStuetzmauerPanel1");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            this.jPanel1.add((Component)this.treppeStuetzmauerPanel1, gridBagConstraints);
        }
        jScrollPane1.setViewportView(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane1, gridBagConstraints);
        jScrollPane1.getViewport().setOpaque(false);
        jLabel1.setHorizontalAlignment(0);
        jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/metasearch/mauer.png")));
        Mnemonics.setLocalizedText((JLabel)jLabel1, (String)NbBundle.getMessage(TreppeStuetzmauernPanel.class, (String)"TreppeStuetzmauernPanel.jLabel1.text"));
        jLabel1.setBorder(BorderFactory.createEtchedBorder());
        jLabel1.setName("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jLabel1, gridBagConstraints);
        jLabel1.setVisible(this.editable);
        try {
            new CidsBeanDropTarget((Component)jLabel1);
        }
        catch (Exception ex) {
            LOG.warn((Object)"error while init CidsBeanDropTarget", (Throwable)ex);
        }
    }

    public void dispose() {
        for (Component comp : this.jPanel1.getComponents()) {
            if (!(comp instanceof TreppeStuetzmauerPanel)) continue;
            TreppeStuetzmauerPanel panel = (TreppeStuetzmauerPanel)comp;
            panel.dispose();
            this.jPanel1.remove(panel);
        }
        this.zustandBeanMap.clear();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public class DroppedLabel
    extends JLabel
    implements CidsBeanDropListener {
        public void beansDropped(ArrayList<CidsBean> droppedBeans) {
            try {
                CidsBean droppedBean;
                if (droppedBeans.size() > 1) {
                    // empty if block
                }
                if ((droppedBean = droppedBeans.get(0)) != null && droppedBean.getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("mauer")) {
                    try {
                        CidsBean treppeMauerBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"TREPPE_STUETZMAUER", (ConnectionContext)TreppeStuetzmauernPanel.this.getConnectionContext());
                        TreppeStuetzmauernPanel.this.addMauerPanel(treppeMauerBean, droppedBean);
                        TreppeStuetzmauernPanel.this.cidsBeans.add(treppeMauerBean);
                        treppeMauerBean.setProperty("mauer", droppedBean.getProperty("id"));
                    }
                    catch (Exception treppeMauerBean) {}
                }
            }
            catch (Exception ex) {
                String message = "Fehler beim Erzeugen der St\u00fctzmauer.";
                LOG.error((Object)"Fehler beim Erzeugen der St\u00fctzmauer.", (Throwable)ex);
                ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Erzeugen der St\u00fctzmauer.", ex, this);
            }
        }
    }
}

