/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.CismetThreadPool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JFrame;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.swing.JRViewer;
import org.apache.log4j.Logger;

public abstract class AbstractJasperReportPrint {
    protected static final Logger log = Logger.getLogger(AbstractJasperReportPrint.class);
    private final Collection<CidsBean> beans;
    private final String reportURL;
    private JasperPrintWorker jpw;
    private boolean beansCollection = true;

    public AbstractJasperReportPrint(String reportURL, Collection<CidsBean> beans) {
        if (reportURL == null || beans == null) {
            throw new NullPointerException();
        }
        this.reportURL = reportURL;
        this.beans = beans;
    }

    public AbstractJasperReportPrint(String reportURL, CidsBean bean) {
        if (reportURL == null || bean == null) {
            throw new NullPointerException();
        }
        this.reportURL = reportURL;
        this.beans = new ArrayList<CidsBean>();
        this.beans.add(bean);
        this.jpw = null;
    }

    public abstract Map generateReportParam(CidsBean var1);

    public abstract Map generateReportParam(Collection<CidsBean> var1);

    public void print() {
        if (EventQueue.isDispatchThread()) {
            this.executePrint();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractJasperReportPrint.this.executePrint();
                }
            });
        }
    }

    private void executePrint() {
        JasperPrintWorker old = this.jpw;
        if (old != null && !old.isDone()) {
            old.cancel(true);
        }
        this.jpw = new JasperPrintWorker();
        CismetThreadPool.execute((Runnable)this.jpw);
    }

    public boolean isBeansCollection() {
        return this.beansCollection;
    }

    public void setBeansCollection(boolean beansCollection) {
        this.beansCollection = beansCollection;
    }

    public JasperPrint getJasperPrint() throws Exception {
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)this.getClass().getResourceAsStream(this.reportURL));
        JasperPrint jasperPrint = null;
        if (this.isBeansCollection()) {
            Map params = this.generateReportParam(this.beans);
            JRBeanCollectionDataSource beanArray = new JRBeanCollectionDataSource(this.beans);
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)params, (JRDataSource)beanArray);
        } else {
            for (CidsBean current : this.beans) {
                Map params = this.generateReportParam(current);
                JRBeanArrayDataSource beanArray = new JRBeanArrayDataSource((Object[])new CidsBean[]{current});
                if (jasperPrint == null) {
                    jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)params, (JRDataSource)beanArray);
                    continue;
                }
                jasperPrint.addPage((JRPrintPage)JasperFillManager.fillReport((JasperReport)jasperReport, (Map)params, (JRDataSource)beanArray).getPages().get(0));
            }
        }
        return jasperPrint;
    }

    final class JasperPrintWorker
    extends SwingWorker<JasperPrint, Void> {
        @Override
        protected JasperPrint doInBackground() throws Exception {
            if (this.isCancelled()) {
                return null;
            }
            return AbstractJasperReportPrint.this.getJasperPrint();
        }

        @Override
        protected void done() {
            try {
                JasperPrint jp = (JasperPrint)this.get();
                if (jp != null && !this.isCancelled()) {
                    JRViewer aViewer = new JRViewer(jp);
                    aViewer.setZoomRatio(0.35f);
                    this.setupPrintFrame(aViewer);
                }
            }
            catch (InterruptedException ex) {
                log.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                log.error((Object)ex, (Throwable)ex);
            }
        }

        private void setupPrintFrame(JRViewer aViewer) {
            JFrame aFrame = new JFrame("Druckvorschau");
            aFrame.getContentPane().add((Component)aViewer);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            aFrame.setSize(screenSize.width / 2, screenSize.height / 2);
            Insets insets = aFrame.getInsets();
            aFrame.setSize(aFrame.getWidth() + insets.left + insets.right, aFrame.getHeight() + insets.top + insets.bottom + 20);
            JFrame main = ComponentRegistry.getRegistry().getMainWindow();
            aFrame.setLocationRelativeTo(main);
            aFrame.setVisible(true);
        }
    }
}

