/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;

final class ImagedButtonMouseAdapter
extends MouseAdapter {
    protected final JButton button;
    protected boolean over = false;
    protected boolean pressed = false;
    private final Icon plainIcon;
    private final Icon highlightIcon;
    private final Icon pressedIcon;

    public ImagedButtonMouseAdapter(JButton button, Icon highlight, Icon pressed) {
        this(button, button.getIcon(), highlight, pressed);
    }

    public ImagedButtonMouseAdapter(JButton button, Icon plain, Icon highlight, Icon pressed) {
        this.button = button;
        ObjectRendererUtils.decorateComponentWithMouseOverCursorChange(button, 12, 0);
        this.plainIcon = plain;
        this.highlightIcon = highlight;
        this.pressedIcon = pressed;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.over = true;
        this.handleEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.over = false;
        this.handleEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressed = true;
        this.handleEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
        this.handleEvent(e);
    }

    private void testAndSet(Icon icon) {
        if (this.button.getIcon() != icon) {
            this.button.setIcon(icon);
        }
    }

    protected void handleEvent(MouseEvent e) {
        if (this.button.isEnabled()) {
            if (this.pressed && this.over) {
                this.testAndSet(this.pressedIcon);
            } else if (this.over) {
                this.testAndSet(this.highlightIcon);
            } else {
                this.testAndSet(this.plainIcon);
            }
        } else {
            this.testAndSet(this.plainIcon);
        }
    }
}

