/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.AbstractAttributeRepresentationFormater;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import Sirius.server.newuser.permission.PermissionHolder;
import de.cismet.cids.custom.objectrenderer.utils.AlphanumComparator;
import de.cismet.cids.custom.objectrenderer.utils.ImagedButtonMouseAdapter;
import de.cismet.cids.custom.objectrenderer.utils.LabelLinkBehaviourMouseAdapter;
import de.cismet.cids.custom.objectrenderer.utils.SyncLabelButtonMouseAdapter;
import de.cismet.cids.custom.objectrenderer.utils.TableHeaderUnsortMouseAdapter;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.FeatureGroups;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.graphics.ShadowRenderer;

public class ObjectRendererUtils {
    private static final String ICON_RES_PACKAGE = "/de/cismet/cids/custom/wunda_blau/res/";
    public static final ImageIcon FORWARD_PRESSED;
    public static final ImageIcon FORWARD_SELECTED;
    public static final ImageIcon BACKWARD_PRESSED;
    public static final ImageIcon BACKWARD_SELECTED;
    private static final Logger log;
    private static final String CISMAP_PLUGIN_NAME = "cismap";

    private ObjectRendererUtils() {
        throw new AssertionError((Object)"so gehts aber nicht ;-)");
    }

    public static void addBeanGeomsAsFeaturesToCismapMap(Collection<MetaObject> metaObjectList, boolean clear) {
        if (metaObjectList != null) {
            MappingComponent bigMap = CismapBroker.getInstance().getMappingComponent();
            if (clear) {
                bigMap.getFeatureCollection().removeAllFeatures();
            }
            ArrayList addedFeatures = TypeSafeCollections.newArrayList((int)metaObjectList.size());
            for (MetaObject mo : metaObjectList) {
                CidsFeature newGeomFeature = new CidsFeature(mo);
                addedFeatures.addAll(FeatureGroups.expandAll((FeatureGroup)newGeomFeature));
            }
            bigMap.getFeatureCollection().addFeatures((Collection)addedFeatures);
            bigMap.zoomToFeatureCollection();
        }
    }

    public static void setAllDimensions(JComponent comp, Dimension dim) {
        comp.setMaximumSize(dim);
        comp.setMinimumSize(dim);
        comp.setPreferredSize(dim);
    }

    public static void switchToCismapMap() {
        ComponentRegistry.getRegistry().showComponent("map");
    }

    public static void addBeanGeomAsFeatureToCismapMap(CidsBean bean, boolean clear) {
        if (bean != null) {
            MetaObject mo = bean.getMetaObject();
            ArrayList mos = TypeSafeCollections.newArrayList((int)1);
            mos.add(mo);
            ObjectRendererUtils.addBeanGeomsAsFeaturesToCismapMap(mos, clear);
        }
    }

    public static void selectAllTextInEditableCombobox(JComboBox box) {
        Component editor = box.getEditor().getEditorComponent();
        if (editor instanceof JTextField) {
            JTextField textEditor = (JTextField)editor;
            textEditor.selectAll();
        } else {
            log.warn((Object)("Editor of Combobox " + box + " is not instanceof JTextField - can not select the text : " + editor));
        }
    }

    public static void showExceptionWindowToUser(String titleMessage, Exception ex, Component parent) {
        if (ex != null && parent != null && parent.isShowing()) {
            ErrorInfo ei = new ErrorInfo(titleMessage, ex.getMessage(), null, null, (Throwable)ex, Level.ALL, null);
            JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrame((Component)parent), (ErrorInfo)ei);
        }
    }

    public static MetaObject[] getLightweightMetaObjectsForTable(String tabName, String[] fields, ConnectionContext connectionContext) {
        return ObjectRendererUtils.getLightweightMetaObjectsForTable(tabName, fields, null, connectionContext);
    }

    public static MetaObject[] getLightweightMetaObjectsForTable(String tabName, final String[] fields, AbstractAttributeRepresentationFormater formatter, ConnectionContext connectionContext) {
        if (formatter == null) {
            formatter = new AbstractAttributeRepresentationFormater(){

                public String getRepresentation() {
                    StringBuffer sb = new StringBuffer();
                    for (String attribute : fields) {
                        sb.append(this.getAttribute(attribute.toLowerCase())).append(" ");
                    }
                    return sb.toString().trim();
                }
            };
        }
        try {
            User user = SessionManager.getSession().getUser();
            MetaClass mc = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)tabName, (ConnectionContext)connectionContext);
            return SessionManager.getProxy().getAllLightweightMetaObjectsForClass(mc.getID(), user, fields, formatter, connectionContext);
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
            return new MetaObject[0];
        }
    }

    public static BufferedImage generateShadow(Image in, int shadowPixel) {
        BufferedImage input;
        if (in == null) {
            return null;
        }
        if (in instanceof BufferedImage) {
            input = (BufferedImage)in;
        } else {
            BufferedImage temp = new BufferedImage(in.getWidth(null), in.getHeight(null), 6);
            Graphics2D tg = temp.createGraphics();
            tg.drawImage(in, 0, 0, null);
            tg.dispose();
            input = temp;
        }
        if (shadowPixel < 1) {
            return input;
        }
        ShadowRenderer renderer = new ShadowRenderer(shadowPixel, 0.5f, Color.BLACK);
        BufferedImage shadow = renderer.createShadow(input);
        BufferedImage result = new BufferedImage(input.getWidth() + 2 * shadowPixel, input.getHeight() + 2 * shadowPixel, 6);
        Graphics2D rg = result.createGraphics();
        rg.drawImage((Image)shadow, 0, 0, null);
        rg.drawImage((Image)input, 0, 0, null);
        rg.dispose();
        return result;
    }

    public static boolean checkActionTag(String tagToCheck, ConnectionContext connectionContext) {
        boolean result = false;
        try {
            result = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), tagToCheck, connectionContext);
        }
        catch (ConnectionException ex) {
            log.error((Object)"Can not check ActionTag!", (Throwable)ex);
        }
        return result;
    }

    public static MouseListener decorateComponentWithMouseOverCursorChange(final JComponent toDecorate, final int mouseEntered, final int mouseExited) {
        MouseAdapter toAdd = new MouseAdapter(){
            private final Cursor entered;
            private final Cursor exited;
            {
                this.entered = new Cursor(mouseEntered);
                this.exited = new Cursor(mouseExited);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (toDecorate.isEnabled()) {
                    toDecorate.setCursor(this.entered);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (toDecorate.isEnabled()) {
                    toDecorate.setCursor(this.exited);
                }
            }
        };
        toDecorate.addMouseListener(toAdd);
        return toAdd;
    }

    public static void openURL(String url) {
        if (url == null) {
            return;
        }
        String gotoUrl = url;
        try {
            BrowserLauncher.openURL((String)gotoUrl);
        }
        catch (Exception e2) {
            log.warn((Object)("das 1te Mal ging schief.Fehler beim Oeffnen von:" + gotoUrl + "\nLetzter Versuch"), (Throwable)e2);
            try {
                gotoUrl = gotoUrl.replaceAll("\\\\", "/");
                gotoUrl = gotoUrl.replaceAll(" ", "%20");
                BrowserLauncher.openURL((String)("file:///" + gotoUrl));
            }
            catch (Exception e3) {
                log.error((Object)("Auch das 2te Mal ging schief.Fehler beim Oeffnen von:file://" + gotoUrl), (Throwable)e3);
            }
        }
    }

    public static boolean hasCurrentUserPermissionOnMetaClass(String mcTableName, String domain, PermissionType permissionToCheck, ConnectionContext connecitonContext) {
        MetaClass mc = ClassCacheMultiple.getMetaClass((String)domain, (String)mcTableName, (ConnectionContext)connecitonContext);
        return ObjectRendererUtils.hasCurrentUserPermissionOnMetaClass(mc, permissionToCheck);
    }

    public static boolean hasCurrentUserPermissionOnMetaClass(MetaClass mc, PermissionType permissionToCheck) {
        return ObjectRendererUtils.hasUserPermissionOnMetaClass(mc, SessionManager.getSession().getUser(), permissionToCheck);
    }

    public static boolean hasUserPermissionOnMetaClass(MetaClass mc, User user, PermissionType permissionToCheck) {
        if (mc != null && user != null && permissionToCheck != null) {
            PermissionHolder mcPermissions = mc.getPermissions();
            switch (permissionToCheck) {
                case READ: {
                    return mcPermissions.hasReadPermission(user);
                }
                case WRITE: {
                    return mcPermissions.hasWritePermission(user);
                }
                case READ_WRITE: {
                    return mcPermissions.hasWritePermission(user) && mcPermissions.hasReadPermission(user);
                }
            }
        }
        return false;
    }

    public static String propertyPrettyPrint(Object propertyValue) {
        if (propertyValue instanceof Collection) {
            Collection beanCollection = (Collection)propertyValue;
            StringBuilder resultSB = new StringBuilder();
            for (Object bean : beanCollection) {
                if (resultSB.length() != 0) {
                    resultSB.append(", ");
                }
                resultSB.append(String.valueOf(bean));
            }
            return resultSB.toString();
        }
        if (propertyValue != null) {
            return propertyValue.toString();
        }
        return "-";
    }

    public static int findComboBoxItemForString(JComboBox box, String searchString) {
        ComboBoxModel model;
        if (box != null && searchString != null && (model = box.getModel()) != null) {
            int i = model.getSize();
            while (--i >= 0) {
                if (!searchString.equals(String.valueOf(model.getElementAt(i)))) continue;
                return i;
            }
        }
        return -1;
    }

    public static String getUrlFromBean(CidsBean bean, String suffix) {
        Object obj = bean.getProperty("url_base_id");
        if (obj instanceof CidsBean) {
            CidsBean urlBase = (CidsBean)obj;
            StringBuffer bildURL = new StringBuffer(urlBase.getProperty("prot_prefix").toString());
            bildURL.append(urlBase.getProperty("server").toString());
            bildURL.append(urlBase.getProperty("path").toString());
            bildURL.append(bean.getProperty("object_name").toString());
            if (suffix != null) {
                bildURL.append(suffix);
            }
            return bildURL.toString();
        }
        return null;
    }

    public static TableRowSorter<TableModel> decorateTableWithSorter(JTable tbl) {
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(tbl.getModel());
        for (int i = 0; i < tbl.getColumnCount(); ++i) {
            sorter.setComparator(i, Comparator.nullsLast(AlphanumComparator.getInstance()));
        }
        tbl.setRowSorter(sorter);
        tbl.getTableHeader().addMouseListener(new TableHeaderUnsortMouseAdapter(tbl));
        return sorter;
    }

    public static MouseAdapter decorateJLabelWithLinkBehaviour(JLabel label) {
        LabelLinkBehaviourMouseAdapter llbma = new LabelLinkBehaviourMouseAdapter(label);
        label.addMouseListener(llbma);
        return llbma;
    }

    public static MouseAdapter decorateJLabelAndButtonSynced(JLabel label, JButton button, Icon highlight, Icon pressed) {
        SyncLabelButtonMouseAdapter syncedAdapter = new SyncLabelButtonMouseAdapter(label, button, highlight, pressed);
        label.addMouseListener(syncedAdapter);
        button.addMouseListener(syncedAdapter);
        return syncedAdapter;
    }

    public static MouseAdapter decorateButtonWithStatusImages(JButton button, Icon plain, Icon highlight, Icon pressed) {
        ImagedButtonMouseAdapter ibma = new ImagedButtonMouseAdapter(button, plain, highlight, pressed);
        button.addMouseListener(ibma);
        return ibma;
    }

    public static MouseAdapter decorateButtonWithStatusImages(JButton button, Icon highlight, Icon pressed) {
        ImagedButtonMouseAdapter ibma = new ImagedButtonMouseAdapter(button, highlight, pressed);
        button.addMouseListener(ibma);
        return ibma;
    }

    static {
        log = Logger.getLogger(ObjectRendererUtils.class);
        BACKWARD_SELECTED = new ImageIcon(ObjectRendererUtils.class.getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left-sel.png"));
        BACKWARD_PRESSED = new ImageIcon(ObjectRendererUtils.class.getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left-pressed.png"));
        FORWARD_SELECTED = new ImageIcon(ObjectRendererUtils.class.getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-right-sel.png"));
        FORWARD_PRESSED = new ImageIcon(ObjectRendererUtils.class.getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-right-pressed.png"));
    }

    public static enum PermissionType {
        READ,
        WRITE,
        READ_WRITE;

    }

    public static enum DateDiff {
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

