/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.util.collections.MultiMap;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.objectrenderer.wunda_blau.BaulastenReportDownloadHelper;
import de.cismet.cids.custom.objectrenderer.wunda_blau.TableModelIndexConvertingToViewIndexComparator;
import de.cismet.cids.custom.utils.alkis.BaulastenReportGenerator;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanAggregationRenderer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.TitleComponentProvider;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;

public class Alb_baulastAggregationRendererPanel
extends JPanel
implements CidsBeanAggregationRenderer,
TitleComponentProvider,
ConnectionContextProvider {
    private static final Color BELASTET_COLOR = new Color(0, 255, 0);
    private static final Color BEGUENSTIGT_COLOR = new Color(255, 255, 0);
    private static final Color BEIDES_COLOR = Color.RED;
    private static final double BUFFER = 0.005;
    private static final String REPORT_ACTION_TAG_BLATT = "baulast.report.blatt_disabled@WUNDA_BLAU";
    private static final String REPORT_ACTION_TAG_PLAN = "baulast.report.plan_disabled@WUNDA_BLAU";
    private static final String REPORT_ACTION_TAG_RASTER = "baulast.report.raster_disabled@WUNDA_BLAU";
    private static final Logger LOG = Logger.getLogger(Alb_baulastAggregationRendererPanel.class);
    private static final String[] AGR_COMLUMN_NAMES = new String[]{"Auswahl", "Blattnummer", "Laufende Nummer", "Art", "Eintragungsdatum", "Befristungsdatum", "Geschlossen am", "L\u00f6schungsdatum", "Gepr\u00fcft"};
    private static final String[] AGR_PROPERTY_NAMES = new String[]{"blattnummer", "laufende_nummer", "art", "eintragungsdatum", "befristungsdatum", "geschlossen_am", "loeschungsdatum", "geprueft"};
    private static final int[] AGR_COMLUMN_WIDTH = new int[]{40, 40, 40, 100, 75, 75, 75, 75, 40};
    private List<CidsBean> cidsBeans;
    private BaulastblattTableModel tableModel;
    private MultiMap featuresMM;
    private final Comparator<Integer> tableComparator;
    private final ConnectionContext connectionContext;
    private JButton btnGenerateReport;
    private JComboBox cmbType;
    private Box.Filler flrGap;
    private JLabel lblAgrTitle;
    private JLabel lblJobnumber;
    private JLabel lblProjectname;
    private JLabel lblType;
    private MappingComponent mappingComponent;
    private JPanel panMap;
    private JPanel panTitle;
    private JPanel panTitleString;
    private JPanel pnlReport;
    private JScrollPane scpRisse;
    private JTable tblRisse;
    private JTextField txtJobnumber;
    private JTextField txtProjectname;

    public Alb_baulastAggregationRendererPanel(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.scpRisse.getViewport().setOpaque(false);
        this.tblRisse.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.tableComparator = new TableModelIndexConvertingToViewIndexComparator(this.tblRisse);
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void animateToOverview() {
        this.mappingComponent.gotoInitialBoundingBox();
        Rectangle2D viewBounds = this.mappingComponent.getCamera().getViewBounds().getBounds2D();
        double scale = this.mappingComponent.getScaleDenominator();
        double newX = (viewBounds.getX() / scale - 0.005) * scale;
        double newY = (viewBounds.getY() / scale - 0.005) * scale;
        double newWidth = (viewBounds.getWidth() / scale + 0.01) * scale;
        double newHeight = (viewBounds.getHeight() / scale + 0.01) * scale;
        viewBounds.setRect(newX, newY, newWidth, newHeight);
        this.mappingComponent.getCamera().animateViewToCenterBounds(viewBounds, true, (long)this.mappingComponent.getAnimationDuration());
    }

    private void initComponents() {
        this.panTitle = new JPanel();
        this.panTitleString = new JPanel();
        this.lblAgrTitle = new JLabel();
        this.scpRisse = new JScrollPane();
        this.tblRisse = new JTable();
        this.panMap = new JPanel();
        this.mappingComponent = new MappingComponent();
        this.pnlReport = new JPanel();
        this.flrGap = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblProjectname = new JLabel();
        this.txtProjectname = new JTextField();
        this.lblJobnumber = new JLabel();
        this.txtJobnumber = new JTextField();
        this.btnGenerateReport = new JButton();
        this.cmbType = new JComboBox();
        this.lblType = new JLabel();
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new BorderLayout());
        this.panTitleString.setOpaque(false);
        this.panTitleString.setLayout(new GridBagLayout());
        this.lblAgrTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblAgrTitle.setForeground(new Color(255, 255, 255));
        this.lblAgrTitle.setText("error ...");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panTitleString.add((Component)this.lblAgrTitle, gridBagConstraints);
        this.panTitle.add((Component)this.panTitleString, "Center");
        this.setLayout(new GridBagLayout());
        this.tblRisse.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.tblRisse.setSelectionMode(0);
        this.tblRisse.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Alb_baulastAggregationRendererPanel.this.tblRisseFocusLost(evt);
            }
        });
        this.scpRisse.setViewportView(this.tblRisse);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.scpRisse, gridBagConstraints);
        this.panMap.setMaximumSize(new Dimension(300, 450));
        this.panMap.setMinimumSize(new Dimension(300, 450));
        this.panMap.setOpaque(false);
        this.panMap.setPreferredSize(new Dimension(300, 450));
        this.panMap.setLayout(new GridBagLayout());
        this.mappingComponent.setBorder(BorderFactory.createEtchedBorder());
        this.mappingComponent.setMaximumSize(new Dimension(100, 100));
        this.mappingComponent.setMinimumSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panMap.add((Component)this.mappingComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.panMap, gridBagConstraints);
        this.pnlReport.setOpaque(false);
        this.pnlReport.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        this.pnlReport.add((Component)this.flrGap, gridBagConstraints);
        this.lblProjectname.setText("Projektbezeichnung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlReport.add((Component)this.lblProjectname, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlReport.add((Component)this.txtProjectname, gridBagConstraints);
        this.lblJobnumber.setText("Auftragsnummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.pnlReport.add((Component)this.lblJobnumber, gridBagConstraints);
        this.txtJobnumber.setMaximumSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.pnlReport.add((Component)this.txtJobnumber, gridBagConstraints);
        this.btnGenerateReport.setText("Erzeugen");
        this.btnGenerateReport.setToolTipText("Erzeugen");
        this.btnGenerateReport.setFocusPainted(false);
        this.btnGenerateReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastAggregationRendererPanel.this.btnGenerateReportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.pnlReport.add((Component)this.btnGenerateReport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.pnlReport.add((Component)this.cmbType, gridBagConstraints);
        this.lblType.setText("Verf\u00fcgbare Berichte:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 12, 6, 6);
        this.pnlReport.add((Component)this.lblType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.pnlReport, gridBagConstraints);
    }

    private void tblRisseFocusLost(FocusEvent evt) {
        this.tblRisse.clearSelection();
        this.animateToOverview();
    }

    private void btnGenerateReportActionPerformed(ActionEvent evt) {
        final Collection<CidsBean> selectedBaulasten = this.getSelectedBaulasten();
        if (selectedBaulasten.isEmpty()) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Bitte w\u00e4hlen Sie Baulasten zur Report-Generierung aus.", "Keine Baulasten gew\u00e4hlt", 1);
            return;
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Object typeObj = Alb_baulastAggregationRendererPanel.this.cmbType.getSelectedItem();
                if (typeObj instanceof BaulastenReportGenerator.Type) {
                    BaulastenReportGenerator.Type type = (BaulastenReportGenerator.Type)typeObj;
                    try {
                        if (BillingPopup.doBilling("bla", "no.yet", (Geometry)null, Alb_baulastAggregationRendererPanel.this.getConnectionContext(), new BillingProductGroupAmount("ea_bla", selectedBaulasten.size())) && DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)Alb_baulastAggregationRendererPanel.this)) {
                            String projectname = Alb_baulastAggregationRendererPanel.this.txtProjectname.getText();
                            if (projectname == null || projectname.trim().length() == 0) {
                                projectname = "";
                            }
                            Download download = BaulastenReportDownloadHelper.createDownload(type, selectedBaulasten, Alb_baulastAggregationRendererPanel.this.txtJobnumber.getText(), projectname, Alb_baulastAggregationRendererPanel.this.getConnectionContext());
                            DownloadManager.instance().add(download);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
                    }
                } else {
                    LOG.info((Object)("Unknown type '" + typeObj + "' encountered. Skipping report generation."));
                }
                return null;
            }
        }.execute();
    }

    protected Collection<CidsBean> getSelectedBaulasten() {
        LinkedList<CidsBean> result = new LinkedList<CidsBean>();
        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
        TableModel tModel = this.tblRisse.getModel();
        for (int i = 0; i < tModel.getRowCount(); ++i) {
            Object includedObj = tModel.getValueAt(i, 0);
            if (!(includedObj instanceof Boolean) || !((Boolean)includedObj).booleanValue()) continue;
            selectedIndexes.add(i);
        }
        Collections.sort(selectedIndexes, this.tableComparator);
        for (Integer selectedIndex : selectedIndexes) {
            result.add(this.cidsBeans.get(selectedIndex));
        }
        return result;
    }

    public Collection<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    public void setCidsBeans(Collection<CidsBean> beans) {
        this.cidsBeans = new ArrayList<CidsBean>(new LinkedHashSet<CidsBean>(beans));
        this.featuresMM = new MultiMap();
        this.initMap();
        ArrayList<Object[]> tableData = new ArrayList<Object[]>();
        for (CidsBean baulastBean : this.cidsBeans) {
            tableData.add(this.cidsBean2Row(baulastBean));
        }
        this.tableModel = new BaulastblattTableModel((Object[][])tableData.toArray((T[])new Object[tableData.size()][]), AGR_COMLUMN_NAMES);
        this.tblRisse.setModel(this.tableModel);
        TableColumnModel cModel = this.tblRisse.getColumnModel();
        for (int i = 0; i < cModel.getColumnCount(); ++i) {
            cModel.getColumn(i).setPreferredWidth(AGR_COMLUMN_WIDTH[i]);
        }
        TableRowSorter<TableModel> tableSorter = ObjectRendererUtils.decorateTableWithSorter(this.tblRisse);
        LinkedList<RowSorter.SortKey> sortKeys = new LinkedList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(3, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(4, SortOrder.DESCENDING));
        tableSorter.setSortKeys(sortKeys);
        ArrayList<BaulastenReportGenerator.Type> items = new ArrayList<BaulastenReportGenerator.Type>();
        boolean billingAllowed = BillingPopup.isBillingAllowed("bla", this.getConnectionContext());
        if (!ObjectRendererUtils.checkActionTag(REPORT_ACTION_TAG_BLATT, this.getConnectionContext()) && billingAllowed) {
            items.add(BaulastenReportGenerator.Type.TEXTBLATT);
        }
        if (!ObjectRendererUtils.checkActionTag(REPORT_ACTION_TAG_PLAN, this.getConnectionContext()) && billingAllowed) {
            items.add(BaulastenReportGenerator.Type.TEXTBLATT_PLAN);
        }
        if (!ObjectRendererUtils.checkActionTag(REPORT_ACTION_TAG_RASTER, this.getConnectionContext()) && billingAllowed) {
            items.add(BaulastenReportGenerator.Type.TEXTBLATT_PLAN_RASTER);
        }
        boolean enabled = billingAllowed && !items.isEmpty();
        this.cmbType.setModel(new DefaultComboBoxModel<BaulastenReportGenerator.Type>(items.toArray(new BaulastenReportGenerator.Type[0])));
        this.cmbType.setEnabled(enabled);
        this.btnGenerateReport.setEnabled(enabled);
        this.txtJobnumber.setEnabled(enabled);
        this.txtProjectname.setEnabled(enabled);
        this.setTitle(null);
    }

    public void dispose() {
        this.mappingComponent.dispose();
    }

    protected Object[] cidsBean2Row(CidsBean baulast) {
        if (baulast != null) {
            Object[] result = new Object[AGR_COMLUMN_NAMES.length];
            result[0] = Boolean.TRUE;
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
            for (int i = 0; i < AGR_PROPERTY_NAMES.length; ++i) {
                Object property = baulast.getProperty(AGR_PROPERTY_NAMES[i]);
                String propertyString = property instanceof Boolean ? ((Boolean)property != false ? "ja" : "nein") : (property instanceof Date ? sdf.format((Date)property) : ObjectRendererUtils.propertyPrettyPrint(property));
                result[i + 1] = propertyString;
            }
            return result;
        }
        return new Object[0];
    }

    protected void initMap() {
        try {
            ActiveLayerModel mappingModel = new ActiveLayerModel();
            mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
            XBoundingBox box = this.boundingBoxFromPointList(this.cidsBeans);
            mappingModel.addHome(new XBoundingBox(box.getX1(), box.getY1(), box.getX2(), box.getY2(), ClientAlkisConf.getInstance().getSrsService(), true));
            SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
            swms.setName("Alb_Baulast");
            mappingModel.addLayer((RetrievalServiceLayer)swms);
            this.mappingComponent.setMappingModel((MappingModel)mappingModel);
            this.mappingComponent.setAnimationDuration(0);
            this.mappingComponent.gotoInitialBoundingBox();
            this.mappingComponent.setInteractionMode("ZOOM");
            this.mappingComponent.unlock();
            ArrayList<BLFeature> allFeatures = new ArrayList<BLFeature>();
            for (CidsBean cidsBean : this.cidsBeans) {
                BLFeature blf;
                ArrayList<Geometry> geomsBel = new ArrayList<Geometry>();
                ArrayList<Geometry> geomsBeg = new ArrayList<Geometry>();
                ArrayList<Geometry> geomsBoth = new ArrayList<Geometry>();
                for (CidsBean bel : cidsBean.getBeanCollectionProperty("flurstuecke_belastet")) {
                    geomsBel.add((Geometry)bel.getProperty("fs_referenz.umschreibendes_rechteck"));
                }
                for (CidsBean beg : cidsBean.getBeanCollectionProperty("flurstuecke_beguenstigt")) {
                    geomsBeg.add((Geometry)beg.getProperty("fs_referenz.umschreibendes_rechteck"));
                }
                geomsBoth.addAll(geomsBel);
                geomsBoth.addAll(geomsBeg);
                geomsBoth.retainAll(geomsBel);
                geomsBoth.retainAll(geomsBeg);
                geomsBel.removeAll(geomsBeg);
                geomsBeg.removeAll(geomsBel);
                for (Geometry geomBel : geomsBel) {
                    blf = new BLFeature(geomBel, Type.BEL);
                    allFeatures.add(blf);
                    this.featuresMM.put((Object)cidsBean, (Object)blf);
                }
                for (Geometry geomBeg : geomsBeg) {
                    blf = new BLFeature(geomBeg, Type.BEG);
                    allFeatures.add(blf);
                    this.featuresMM.put((Object)cidsBean, (Object)blf);
                }
                for (Geometry geomBoth : geomsBoth) {
                    blf = new BLFeature(geomBoth, Type.BOTH);
                    allFeatures.add(blf);
                    this.featuresMM.put((Object)cidsBean, (Object)blf);
                }
            }
            this.mappingComponent.getFeatureCollection().addFeatures(allFeatures);
            this.mappingComponent.setAnimationDuration(500);
        }
        catch (Exception e) {
            LOG.fatal((Object)e, (Throwable)e);
        }
    }

    protected XBoundingBox boundingBoxFromPointList(Collection<CidsBean> baulasten) {
        LinkedList<Geometry> geometries = new LinkedList<Geometry>();
        for (CidsBean baulast : baulasten) {
            try {
                Geometry geom;
                List<CidsBean> fs_kickers = CidsBeanSupport.getBeanCollectionFromProperty(baulast, "flurstuecke_belastet");
                for (CidsBean fs_kicker : fs_kickers) {
                    geom = (Geometry)fs_kicker.getProperty("fs_referenz.umschreibendes_rechteck");
                    if (geom == null) continue;
                    geometries.add(geom);
                }
                fs_kickers = CidsBeanSupport.getBeanCollectionFromProperty(baulast, "flurstuecke_beguenstigt");
                for (CidsBean fs_kicker : fs_kickers) {
                    geom = (Geometry)fs_kicker.getProperty("fs_referenz.umschreibendes_rechteck");
                    if (geom == null) continue;
                    geometries.add(geom);
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Could not add geometry to create a bounding box.", (Throwable)ex);
            }
        }
        GeometryCollection geoCollection = new GeometryCollection(geometries.toArray(new Geometry[geometries.size()]), new GeometryFactory());
        return new XBoundingBox(geoCollection.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
    }

    public String getTitle() {
        return this.lblAgrTitle.getText();
    }

    public void setTitle(String title) {
        String desc = "Baulasten";
        this.lblAgrTitle.setText("Baulasten");
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    class BLFeature
    extends PureNewFeature {
        private final Type blType;

        public BLFeature(Geometry geom, Type type) {
            super(geom);
            this.setFillingPaint(new Color(0.5f, 0.5f, 0.5f, 0.5f));
            this.blType = type;
        }

        public Type getBlType() {
            return this.blType;
        }
    }

    class BaulastblattTableModel
    extends DefaultTableModel {
        public BaulastblattTableModel(Object[][] data, String[] labels) {
            super(data, labels);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || Alb_baulastAggregationRendererPanel.this.cidsBeans == null) {
                return;
            }
            ArrayList featuresToSelect = new ArrayList();
            int[] indexes = Alb_baulastAggregationRendererPanel.this.tblRisse.getSelectedRows();
            if (indexes != null && indexes.length > 0) {
                for (int viewIdx : indexes) {
                    int modelIdx = Alb_baulastAggregationRendererPanel.this.tblRisse.getRowSorter().convertRowIndexToModel(viewIdx);
                    if (modelIdx <= -1 || modelIdx >= Alb_baulastAggregationRendererPanel.this.cidsBeans.size()) continue;
                    CidsBean selectedBean = (CidsBean)Alb_baulastAggregationRendererPanel.this.cidsBeans.get(modelIdx);
                    featuresToSelect.addAll((Collection)Alb_baulastAggregationRendererPanel.this.featuresMM.get((Object)selectedBean));
                    break;
                }
            }
            Object object = Alb_baulastAggregationRendererPanel.this.featuresMM.keySet().iterator();
            while (object.hasNext()) {
                CidsBean key = (CidsBean)object.next();
                for (Feature feature : (Collection)Alb_baulastAggregationRendererPanel.this.featuresMM.get((Object)key)) {
                    BLFeature blFeature = (BLFeature)feature;
                    if (featuresToSelect.contains(feature)) {
                        switch (blFeature.getBlType()) {
                            case BEL: {
                                blFeature.setFillingPaint(BELASTET_COLOR);
                                break;
                            }
                            case BEG: {
                                blFeature.setFillingPaint(BEGUENSTIGT_COLOR);
                                break;
                            }
                            case BOTH: {
                                blFeature.setFillingPaint(BEIDES_COLOR);
                            }
                        }
                        ((PFeature)Alb_baulastAggregationRendererPanel.this.mappingComponent.getPFeatureHM().get(feature)).moveToFront();
                    } else {
                        blFeature.setFillingPaint(new Color(0.5f, 0.5f, 0.5f, 0.5f));
                    }
                    Alb_baulastAggregationRendererPanel.this.mappingComponent.reconsiderFeature(feature);
                }
            }
            if (!featuresToSelect.isEmpty()) {
                Geometry[] geometries = new Geometry[featuresToSelect.size()];
                for (int index = 0; index < featuresToSelect.size(); ++index) {
                    geometries[index] = (Polygon)((Feature)featuresToSelect.get(index)).getGeometry();
                }
                GeometryCollection geoCollection = new GeometryCollection(geometries, new GeometryFactory());
                XBoundingBox boxToGoto = new XBoundingBox(geoCollection.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
                boxToGoto.setX1(boxToGoto.getX1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
                boxToGoto.setX2(boxToGoto.getX2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
                boxToGoto.setY1(boxToGoto.getY1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
                boxToGoto.setY2(boxToGoto.getY2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
                Alb_baulastAggregationRendererPanel.this.mappingComponent.gotoBoundingBox((BoundingBox)boxToGoto, false, true, 500);
            } else {
                Alb_baulastAggregationRendererPanel.this.mappingComponent.gotoInitialBoundingBox();
            }
        }
    }

    private static enum Type {
        BEG,
        BEL,
        BOTH;

    }
}

