/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.DescriptionPane;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.clientutils.BaulastBescheinigungDialog;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisProductDownloadHelper;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisProducts;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.objectrenderer.wunda_blau.AlkisEigentuemerPanel;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungBillingDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.DownloadInfoFactory;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisEinzelnachweisDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisKarteDownloadInfo;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanAggregationRenderer;
import de.cismet.cids.tools.metaobjectrenderer.SelfDisposingPanel;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.util.NbBundle;

public class AlkisLandparcelAggregationRenderer
extends JPanel
implements CidsBeanAggregationRenderer,
RequestsFullSizeComponent,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(AlkisLandparcelAggregationRenderer.class);
    private static final Color[] COLORS = new Color[]{new Color(247, 150, 70, 192), new Color(155, 187, 89, 192), new Color(128, 100, 162, 192), new Color(75, 172, 198, 192), new Color(192, 80, 77, 192)};
    private static volatile boolean initialisedMap = false;
    private List<CidsBeanWrapper> cidsBeanWrappers;
    private final LandparcelTableModel tableModel;
    private MappingComponent map;
    private CidsBeanWrapper selectedCidsBeanWrapper;
    private Thread mapThread;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final boolean eigentuemerPermission = AlkisProductDownloadHelper.validateUserHasEigentuemerAccess(this.getConnectionContext());
    private AlkisEigentuemerPanel eigentuemerPanel;
    private JLabel jLabel1;
    private JXHyperlink jxlBaulastBescheinigung;
    private JXHyperlink jxlFlurstuecksnachweis;
    private JXHyperlink jxlKarte;
    private JXHyperlink jxlNachweisKommunal;
    private JXHyperlink jxlNachweisKommunalIntern;
    private JXHyperlink jxlNachweisNRW;
    private JLabel lblHeaderButtons;
    private JLabel lblHeaderLandparcels;
    private JPanel panBuchungEigentum;
    private JPanel pnlButtons;
    private JPanel pnlLandparcels;
    private JPanel pnlMap;
    private JScrollPane scpLandparcels;
    private SemiRoundedPanel semiRoundedPanel1;
    private SemiRoundedPanel srpHeaderButtons;
    private SemiRoundedPanel srpHeaderLandparcels;
    private JTable tblLandparcels;

    public AlkisLandparcelAggregationRenderer() {
        this.tableModel = new LandparcelTableModel();
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.eigentuemerPanel.initWithConnectionContext(connectionContext);
        this.map = new MappingComponent();
        this.pnlMap.add((Component)this.map, "Center");
        this.tblLandparcels.setDefaultRenderer(Color.class, new ColorRenderer());
        this.tblLandparcels.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    AlkisLandparcelAggregationRenderer.this.selectedCidsBeanWrapper = null;
                } else {
                    AlkisLandparcelAggregationRenderer.this.selectedCidsBeanWrapper = AlkisLandparcelAggregationRenderer.this.tableModel.get(lsm.getLeadSelectionIndex());
                }
                AlkisLandparcelAggregationRenderer.this.changeMap();
                if (AlkisLandparcelAggregationRenderer.this.showEigentuemer()) {
                    AlkisLandparcelAggregationRenderer.this.eigentuemerPanel.setFlurstuecke(AlkisLandparcelAggregationRenderer.this.selectedCidsBeanWrapper != null ? Arrays.asList(AlkisLandparcelAggregationRenderer.this.selectedCidsBeanWrapper.getCidsBean()) : null);
                }
            }
        });
    }

    private DescriptionPane waitForDescriptionPane() {
        Container component = this;
        while (component.getParent() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        while ((component = component.getParent()) != null) {
            if (component instanceof SelfDisposingPanel) {
                while (component.getParent() == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
                continue;
            }
            if (!(component instanceof DescriptionPane)) continue;
            return (DescriptionPane)component;
        }
        return null;
    }

    private boolean showEigentuemer() {
        return this.eigentuemerPermission;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void initComponents() {
        this.pnlButtons = new RoundedPanel();
        this.srpHeaderButtons = new SemiRoundedPanel();
        this.lblHeaderButtons = new JLabel();
        this.jxlFlurstuecksnachweis = new JXHyperlink();
        this.jxlNachweisNRW = new JXHyperlink();
        this.jxlNachweisKommunal = new JXHyperlink();
        this.jxlNachweisKommunalIntern = new JXHyperlink();
        this.jxlKarte = new JXHyperlink();
        this.jxlBaulastBescheinigung = new JXHyperlink();
        this.pnlMap = new JPanel();
        this.pnlLandparcels = new RoundedPanel();
        this.srpHeaderLandparcels = new SemiRoundedPanel();
        this.lblHeaderLandparcels = new JLabel();
        this.scpLandparcels = new JScrollPane();
        this.tblLandparcels = new JTable();
        this.panBuchungEigentum = new RoundedPanel();
        this.semiRoundedPanel1 = new SemiRoundedPanel();
        this.jLabel1 = new JLabel();
        this.eigentuemerPanel = new AlkisEigentuemerPanel();
        this.setLayout(new GridBagLayout());
        this.pnlButtons.setOpaque(false);
        this.pnlButtons.setLayout(new GridBagLayout());
        this.srpHeaderButtons.setBackground(Color.darkGray);
        this.srpHeaderButtons.setLayout((LayoutManager)new GridBagLayout());
        this.lblHeaderButtons.setForeground(Color.white);
        this.lblHeaderButtons.setText(NbBundle.getMessage(AlkisLandparcelAggregationRenderer.class, (String)"AlkisLandparcelAggregationRenderer.lblHeaderButtons.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.srpHeaderButtons.add((Component)this.lblHeaderButtons, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlButtons.add((Component)this.srpHeaderButtons, gridBagConstraints);
        this.jxlFlurstuecksnachweis.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jxlFlurstuecksnachweis.setText(NbBundle.getMessage(AlkisLandparcelAggregationRenderer.class, (String)"AlkisLandparcelAggregationRenderer.jxlFlurstuecksnachweis.text"));
        this.jxlFlurstuecksnachweis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelAggregationRenderer.this.jxlFlurstuecksnachweisActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        this.pnlButtons.add((Component)this.jxlFlurstuecksnachweis, gridBagConstraints);
        this.jxlNachweisNRW.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jxlNachweisNRW.setText(NbBundle.getMessage(AlkisLandparcelAggregationRenderer.class, (String)"AlkisLandparcelAggregationRenderer.jxlNachweisNRW.text"));
        this.jxlNachweisNRW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelAggregationRenderer.this.jxlNachweisNRWActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        this.pnlButtons.add((Component)this.jxlNachweisNRW, gridBagConstraints);
        this.jxlNachweisKommunal.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jxlNachweisKommunal.setText(NbBundle.getMessage(AlkisLandparcelAggregationRenderer.class, (String)"AlkisLandparcelAggregationRenderer.jxlNachweisKommunal.text"));
        this.jxlNachweisKommunal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelAggregationRenderer.this.jxlNachweisKommunalActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        this.pnlButtons.add((Component)this.jxlNachweisKommunal, gridBagConstraints);
        this.jxlNachweisKommunalIntern.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jxlNachweisKommunalIntern.setText(NbBundle.getMessage(AlkisLandparcelAggregationRenderer.class, (String)"AlkisLandparcelAggregationRenderer.jxlNachweisKommunalIntern.text"));
        this.jxlNachweisKommunalIntern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelAggregationRenderer.this.jxlNachweisKommunalInternActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        this.pnlButtons.add((Component)this.jxlNachweisKommunalIntern, gridBagConstraints);
        this.jxlKarte.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jxlKarte.setText(NbBundle.getMessage(AlkisLandparcelAggregationRenderer.class, (String)"AlkisLandparcelAggregationRenderer.jxlKarte.text"));
        this.jxlKarte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelAggregationRenderer.this.jxlKarteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 10, 10);
        this.pnlButtons.add((Component)this.jxlKarte, gridBagConstraints);
        this.jxlBaulastBescheinigung.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.jxlBaulastBescheinigung.setText(NbBundle.getMessage(AlkisLandparcelAggregationRenderer.class, (String)"AlkisLandparcelAggregationRenderer.jxlBaulastBescheinigung.text"));
        this.jxlBaulastBescheinigung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisLandparcelAggregationRenderer.this.jxlBaulastBescheinigungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        this.pnlButtons.add((Component)this.jxlBaulastBescheinigung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.pnlButtons, gridBagConstraints);
        this.pnlMap.setBorder(BorderFactory.createEtchedBorder());
        this.pnlMap.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.pnlMap, gridBagConstraints);
        this.pnlLandparcels.setMinimumSize(new Dimension(309, 207));
        this.pnlLandparcels.setOpaque(false);
        this.pnlLandparcels.setLayout(new GridBagLayout());
        this.srpHeaderLandparcels.setBackground(Color.darkGray);
        this.srpHeaderLandparcels.setLayout((LayoutManager)new GridBagLayout());
        this.lblHeaderLandparcels.setForeground(Color.white);
        this.lblHeaderLandparcels.setText(NbBundle.getMessage(AlkisLandparcelAggregationRenderer.class, (String)"AlkisLandparcelAggregationRenderer.lblHeaderLandparcels.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.srpHeaderLandparcels.add((Component)this.lblHeaderLandparcels, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.pnlLandparcels.add((Component)this.srpHeaderLandparcels, gridBagConstraints);
        this.scpLandparcels.setPreferredSize(new Dimension(250, 402));
        this.tblLandparcels.setModel(this.tableModel);
        this.tblLandparcels.setSelectionMode(0);
        this.tblLandparcels.setShowVerticalLines(false);
        this.tblLandparcels.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AlkisLandparcelAggregationRenderer.this.tblLandparcelsFocusLost(evt);
            }
        });
        this.scpLandparcels.setViewportView(this.tblLandparcels);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.35;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlLandparcels.add((Component)this.scpLandparcels, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.add((Component)this.pnlLandparcels, gridBagConstraints);
        this.panBuchungEigentum.setLayout(new GridBagLayout());
        this.semiRoundedPanel1.setBackground(Color.darkGray);
        this.semiRoundedPanel1.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText(NbBundle.getMessage(AlkisLandparcelAggregationRenderer.class, (String)"AlkisLandparcelAggregationRenderer.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel1.add((Component)this.jLabel1, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.panBuchungEigentum.add((Component)this.semiRoundedPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panBuchungEigentum.add((Component)this.eigentuemerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.panBuchungEigentum, gridBagConstraints);
        this.panBuchungEigentum.setVisible(false);
    }

    private void jxlFlurstuecksnachweisActionPerformed(ActionEvent evt) {
        this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKSNACHWEIS_PDF), true);
    }

    private void jxlNachweisNRWActionPerformed(ActionEvent evt) {
        this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_NRW_PDF), true);
    }

    private void jxlNachweisKommunalActionPerformed(ActionEvent evt) {
        this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_PDF), true);
    }

    private void jxlNachweisKommunalInternActionPerformed(ActionEvent evt) {
        this.downloadEinzelnachweisProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_INTERN_PDF), true);
    }

    private void jxlKarteActionPerformed(ActionEvent evt) {
        this.downloadKarteProduct();
    }

    private void tblLandparcelsFocusLost(FocusEvent evt) {
        this.map.gotoInitialBoundingBox();
        this.tblLandparcels.clearSelection();
    }

    private void jxlBaulastBescheinigungActionPerformed(ActionEvent evt) {
        ArrayList<CidsBean> selectedFlurstuecke = new ArrayList<CidsBean>();
        for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
            if (!cidsBeanWrapper.isSelected()) continue;
            selectedFlurstuecke.add(cidsBeanWrapper.getCidsBean());
        }
        BaulastBescheinigungDialog.getInstance().show(selectedFlurstuecke, this, this.getConnectionContext());
    }

    public Collection<CidsBean> getCidsBeans() {
        LinkedList<CidsBean> result = new LinkedList<CidsBean>();
        for (CidsBeanWrapper wrapper : this.cidsBeanWrappers) {
            result.add(wrapper.getCidsBean());
        }
        return result;
    }

    public void setCidsBeans(final Collection<CidsBean> cidsBeans) {
        if (cidsBeans != null) {
            int colorIndex = 0;
            this.cidsBeanWrappers = new LinkedList<CidsBeanWrapper>();
            for (CidsBean cidsBean : cidsBeans) {
                this.cidsBeanWrappers.add(new CidsBeanWrapper(cidsBean, true));
            }
            Collections.sort(this.cidsBeanWrappers);
            for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
                cidsBeanWrapper.setColor(COLORS[colorIndex]);
                colorIndex = (colorIndex + 1) % COLORS.length;
            }
            this.tableModel.setCidsBeans(this.cidsBeanWrappers);
            this.initMap();
            if (this.tblLandparcels != null && this.tblLandparcels.getColumnModel() != null) {
                TableColumn column = this.tblLandparcels.getColumnModel().getColumn(0);
                if (column != null) {
                    column.setPreferredWidth(20);
                }
                if ((column = this.tblLandparcels.getColumnModel().getColumn(3)) != null) {
                    column.setPreferredWidth(15);
                }
            }
            this.changeButtonAvailability(this.cidsBeanWrappers.size() > 0);
        }
        if (this.showEigentuemer()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new SwingWorker<DescriptionPane, Void>(){

                        @Override
                        protected DescriptionPane doInBackground() throws Exception {
                            return AlkisLandparcelAggregationRenderer.this.waitForDescriptionPane();
                        }

                        @Override
                        protected void done() {
                            try {
                                DescriptionPane descriptionPane = (DescriptionPane)this.get();
                                if (descriptionPane != null && descriptionPane.getParent() instanceof AlkisEigentuemerDescriptionPaneParent) {
                                    AlkisLandparcelAggregationRenderer.this.panBuchungEigentum.setVisible(true);
                                    AlkisLandparcelAggregationRenderer.this.eigentuemerPanel.setFlurstuecke(cidsBeans);
                                }
                            }
                            catch (Exception ex) {
                                LOG.error((Object)ex, (Throwable)ex);
                            }
                        }
                    }.execute();
                }
            });
        }
    }

    public void dispose() {
        this.eigentuemerPanel.cancelWorker();
        this.map.dispose();
    }

    public String getTitle() {
        return NbBundle.getMessage(AlkisLandparcelAggregationRenderer.class, (String)"AlkisLandparcelAggregationRenderer.title", (Object)(this.cidsBeanWrappers != null ? Integer.valueOf(this.cidsBeanWrappers.size()) : "0"));
    }

    public void setTitle(String title) {
    }

    private void initMap() {
        this.mapThread = new Thread(new InitialiseMapRunnable());
        if (EventQueue.isDispatchThread()) {
            this.mapThread.start();
        } else {
            EventQueue.invokeLater(this.mapThread);
        }
        this.revalidate();
        this.repaint();
    }

    private void changeMap() {
        if (this.mapThread != null && this.mapThread.isAlive()) {
            if (initialisedMap) {
                this.mapThread.interrupt();
            } else {
                return;
            }
        }
        this.mapThread = new Thread(new ChangeMapRunnable());
        if (EventQueue.isDispatchThread()) {
            this.mapThread.start();
        } else {
            EventQueue.invokeLater(this.mapThread);
        }
        this.revalidate();
        this.repaint();
    }

    private void changeButtonAvailability(boolean enable) {
        boolean billingAllowedFsueKom = BillingPopup.isBillingAllowed("fsuekom", this.getConnectionContext());
        boolean billingAllowedFsueNw = BillingPopup.isBillingAllowed("fsuenw", this.getConnectionContext());
        boolean billingAllowedFsNw = BillingPopup.isBillingAllowed("fsnw", this.getConnectionContext());
        boolean billingAllowedBlab_be = BillingPopup.isBillingAllowed("blab_be", this.getConnectionContext());
        this.jxlKarte.setEnabled(enable && ObjectRendererUtils.checkActionTag("custom.alkis.product.karte@WUNDA_BLAU", this.getConnectionContext()));
        this.jxlFlurstuecksnachweis.setEnabled(enable && ObjectRendererUtils.checkActionTag("custom.alkis.product.flurstuecksnachweis@WUNDA_BLAU", this.getConnectionContext()) && billingAllowedFsNw);
        this.jxlNachweisKommunal.setEnabled(enable && ObjectRendererUtils.checkActionTag("custom.alkis.product.flurstuecks_eigentumsnachweis_kom@WUNDA_BLAU", this.getConnectionContext()) && billingAllowedFsueKom);
        this.jxlNachweisKommunalIntern.setEnabled(enable && ObjectRendererUtils.checkActionTag("custom.alkis.product.flurstuecks_eigentumsnachweis_kom_intern@WUNDA_BLAU", this.getConnectionContext()));
        this.jxlNachweisNRW.setEnabled(enable && ObjectRendererUtils.checkActionTag("custom.alkis.product.flurstuecks_eigentumsnachweis_nrw@WUNDA_BLAU", this.getConnectionContext()) && billingAllowedFsueNw);
        this.jxlBaulastBescheinigung.setEnabled(enable && ObjectRendererUtils.checkActionTag("baulast.report.bescheinigung_enabled@WUNDA_BLAU", this.getConnectionContext()) && !ObjectRendererUtils.checkActionTag("baulast.report.bescheinigung_disabled@WUNDA_BLAU", this.getConnectionContext()) && billingAllowedBlab_be);
    }

    private void downloadEinzelnachweisProduct(String product, boolean berechtigungspruefung) {
        if (!ObjectRendererUtils.checkActionTag(ClientAlkisProducts.getInstance().getActionTag(product), this.getConnectionContext())) {
            AlkisProductDownloadHelper.showNoProductPermissionWarning(this);
            return;
        }
        int stueck = 0;
        for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
            if (!cidsBeanWrapper.isSelected()) continue;
            ++stueck;
        }
        try {
            ArrayList<String> parcelCodes = new ArrayList<String>(this.cidsBeanWrappers.size());
            for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
                if (!cidsBeanWrapper.isSelected()) continue;
                parcelCodes.add(AlkisProducts.getLandparcelCodeFromParcelBeanObject((Object)cidsBeanWrapper.getCidsBean()));
            }
            BerechtigungspruefungAlkisEinzelnachweisDownloadInfo berechtigungspruefungAlkisEinzelnachweisDownloadInfo = DownloadInfoFactory.createBerechtigungspruefungAlkisEinzelnachweisDownloadInfo((String)product, parcelCodes);
            String billingKey = ClientAlkisProducts.getInstance().getBillingKey(product);
            if (billingKey == null || BillingPopup.doBilling(billingKey, "no.yet", (Geometry)null, (BerechtigungspruefungBillingDownloadInfo)(berechtigungspruefung && AlkisProductDownloadHelper.checkBerechtigungspruefung(berechtigungspruefungAlkisEinzelnachweisDownloadInfo.getProduktTyp(), this.getConnectionContext()) ? berechtigungspruefungAlkisEinzelnachweisDownloadInfo : null), this.getConnectionContext(), new BillingProductGroupAmount("ea", stueck))) {
                AlkisProductDownloadHelper.downloadEinzelnachweisProduct(berechtigungspruefungAlkisEinzelnachweisDownloadInfo, this.getConnectionContext());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
        }
    }

    private void downloadKarteProduct() {
        if (!ObjectRendererUtils.checkActionTag("custom.alkis.product.karte@WUNDA_BLAU", this.getConnectionContext())) {
            AlkisProductDownloadHelper.showNoProductPermissionWarning(this);
            return;
        }
        ArrayList<String> parcelCodes = new ArrayList<String>(this.cidsBeanWrappers.size());
        for (CidsBeanWrapper cidsBeanWrapper : this.cidsBeanWrappers) {
            if (!cidsBeanWrapper.isSelected()) continue;
            parcelCodes.add(AlkisProducts.getLandparcelCodeFromParcelBeanObject((Object)cidsBeanWrapper.getCidsBean()));
        }
        BerechtigungspruefungAlkisKarteDownloadInfo downloadInfo = DownloadInfoFactory.createBerechtigungspruefungAlkisKarteDownloadInfo(parcelCodes);
        AlkisProductDownloadHelper.downloadKarteProduct(downloadInfo, this.getConnectionContext());
    }

    private class CidsBeanWrapper
    implements Comparable<CidsBeanWrapper> {
        private CidsBean cidsBean;
        private boolean selected;
        private Color color;
        private String gemarkung;
        private String bezeichnung;
        private Geometry geometry;
        private StyledFeature feature;

        public CidsBeanWrapper(CidsBean cidsBean, boolean selected) {
            this.cidsBean = cidsBean;
            this.selected = selected;
            this.gemarkung = cidsBean.getProperty("gemarkung").toString();
            this.bezeichnung = cidsBean.getProperty("bezeichnung").toString();
            if (cidsBean.getProperty("geometrie") instanceof Geometry) {
                this.geometry = CrsTransformer.transformToGivenCrs((Geometry)((Geometry)cidsBean.getProperty("geometrie")), (String)ClientAlkisConf.getInstance().getSrsService());
            }
            DefaultStyledFeature dsf = new DefaultStyledFeature();
            dsf.setGeometry(this.geometry);
            dsf.setTransparency(0.8f);
            this.feature = dsf;
        }

        public CidsBean getCidsBean() {
            return this.cidsBean;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
            this.feature.setFillingPaint((Paint)this.color);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getGemarkung() {
            return this.gemarkung;
        }

        public String getBezeichnung() {
            return this.bezeichnung;
        }

        public Geometry getGeometry() {
            return this.geometry;
        }

        public StyledFeature getFeature() {
            return this.feature;
        }

        @Override
        public int compareTo(CidsBeanWrapper o) {
            CidsBean cidsBean1 = this.cidsBean;
            CidsBean cidsBean2 = o.cidsBean;
            if (cidsBean1 == null && cidsBean2 == null) {
                return 0;
            }
            if (cidsBean1 == null) {
                return -1;
            }
            if (cidsBean2 == null) {
                return 1;
            }
            int districtComparison = cidsBean1.getProperty("gemarkung").toString().compareTo(cidsBean2.getProperty("gemarkung").toString());
            if (districtComparison != 0) {
                return districtComparison;
            }
            return cidsBean1.getProperty("bezeichnung").toString().compareTo(cidsBean2.getProperty("bezeichnung").toString());
        }
    }

    private class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            return this;
        }
    }

    private class ChangeMapRunnable
    implements Runnable {
        private ChangeMapRunnable() {
        }

        @Override
        public void run() {
            XBoundingBox boxToGoto = new XBoundingBox(AlkisLandparcelAggregationRenderer.this.selectedCidsBeanWrapper.getGeometry().getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
            boxToGoto.setX1(boxToGoto.getX1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
            boxToGoto.setX2(boxToGoto.getX2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
            boxToGoto.setY1(boxToGoto.getY1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
            boxToGoto.setY2(boxToGoto.getY2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
            AlkisLandparcelAggregationRenderer.this.map.gotoBoundingBox((BoundingBox)boxToGoto, false, true, 500);
        }
    }

    private class InitialiseMapRunnable
    implements Runnable {
        private InitialiseMapRunnable() {
        }

        @Override
        public void run() {
            initialisedMap = false;
            ActiveLayerModel mappingModel = new ActiveLayerModel();
            mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
            mappingModel.addHome(this.getBoundingBox());
            SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
            swms.setName("Flurstueck");
            mappingModel.addLayer((RetrievalServiceLayer)swms);
            AlkisLandparcelAggregationRenderer.this.map.setMappingModel((MappingModel)mappingModel);
            int duration = AlkisLandparcelAggregationRenderer.this.map.getAnimationDuration();
            AlkisLandparcelAggregationRenderer.this.map.setAnimationDuration(0);
            AlkisLandparcelAggregationRenderer.this.map.gotoInitialBoundingBox();
            AlkisLandparcelAggregationRenderer.this.map.setInteractionMode("ZOOM");
            AlkisLandparcelAggregationRenderer.this.map.unlock();
            AlkisLandparcelAggregationRenderer.this.map.setInteractionMode("MUTE");
            for (CidsBeanWrapper cidsBeanWrapper : AlkisLandparcelAggregationRenderer.this.cidsBeanWrappers) {
                AlkisLandparcelAggregationRenderer.this.map.getFeatureCollection().addFeature((Feature)cidsBeanWrapper.getFeature());
            }
            AlkisLandparcelAggregationRenderer.this.map.setAnimationDuration(duration);
            initialisedMap = true;
        }

        private XBoundingBox getBoundingBox() {
            XBoundingBox result = null;
            for (CidsBeanWrapper cidsBeanWrapper : AlkisLandparcelAggregationRenderer.this.cidsBeanWrappers) {
                Geometry geometry = cidsBeanWrapper.getGeometry();
                if (result == null) {
                    result = new XBoundingBox(geometry.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
                    result.setSrs(ClientAlkisConf.getInstance().getSrsService());
                    result.setMetric(true);
                    continue;
                }
                XBoundingBox temp = new XBoundingBox(geometry.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
                temp.setSrs(ClientAlkisConf.getInstance().getSrsService());
                temp.setMetric(true);
                if (temp.getX1() < result.getX1()) {
                    result.setX1(temp.getX1());
                }
                if (temp.getY1() < result.getY1()) {
                    result.setY1(temp.getY1());
                }
                if (temp.getX2() > result.getX2()) {
                    result.setX2(temp.getX2());
                }
                if (!(temp.getY2() > result.getY2())) continue;
                result.setY2(temp.getY2());
            }
            return result;
        }
    }

    private class LandparcelTableModel
    extends AbstractTableModel {
        private int selectedCidsBeans = 0;

        private LandparcelTableModel() {
        }

        @Override
        public int getRowCount() {
            if (AlkisLandparcelAggregationRenderer.this.cidsBeanWrappers == null) {
                return 0;
            }
            return AlkisLandparcelAggregationRenderer.this.cidsBeanWrappers.size();
        }

        @Override
        public int getColumnCount() {
            if (AlkisLandparcelAggregationRenderer.this.cidsBeanWrappers == null) {
                return 0;
            }
            return 4;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 3) {
                return Color.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return NbBundle.getMessage(AlkisLandparcelAggregationRenderer.class, (String)("AlkisLandparcelAggregationRenderer.LandparcelTableModel.getColumnName(" + column + ")"));
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (AlkisLandparcelAggregationRenderer.this.cidsBeanWrappers == null) {
                return null;
            }
            CidsBeanWrapper cidsBeanWrapper = (CidsBeanWrapper)AlkisLandparcelAggregationRenderer.this.cidsBeanWrappers.get(rowIndex);
            if (columnIndex == 0) {
                return cidsBeanWrapper.isSelected();
            }
            if (columnIndex == 1) {
                return cidsBeanWrapper.getGemarkung();
            }
            if (columnIndex == 2) {
                return cidsBeanWrapper.getBezeichnung();
            }
            return cidsBeanWrapper.getColor();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public void setCidsBeans(Collection<CidsBeanWrapper> cidsBeans) {
            if (cidsBeans != null) {
                this.selectedCidsBeans = AlkisLandparcelAggregationRenderer.this.cidsBeanWrappers.size();
                this.fireTableStructureChanged();
            }
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            CidsBeanWrapper cidsBeanWrapper;
            if (column != 0) {
                return;
            }
            cidsBeanWrapper.setSelected(!(cidsBeanWrapper = (CidsBeanWrapper)AlkisLandparcelAggregationRenderer.this.cidsBeanWrappers.get(row)).isSelected());
            this.selectedCidsBeans = cidsBeanWrapper.isSelected() ? ++this.selectedCidsBeans : --this.selectedCidsBeans;
            this.fireTableRowsUpdated(row, row);
            AlkisLandparcelAggregationRenderer.this.changeMap();
            AlkisLandparcelAggregationRenderer.this.changeButtonAvailability(this.selectedCidsBeans > 0);
        }

        public CidsBeanWrapper get(int index) {
            return (CidsBeanWrapper)AlkisLandparcelAggregationRenderer.this.cidsBeanWrappers.get(index);
        }
    }

    public static interface AlkisEigentuemerDescriptionPaneParent {
    }
}

