/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.clientutils.ByteArrayActionDownload;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisProductDownloadHelper;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisProducts;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.objectrenderer.wunda_blau.AlkisPointRenderer;
import de.cismet.cids.custom.objectrenderer.wunda_blau.TableModelIndexConvertingToViewIndexComparator;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.wunda_blau.search.actions.AlkisPointReportServerAction;
import de.cismet.cids.custom.wunda_blau.search.actions.AlkisProductServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanAggregationRenderer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public final class AlkisPointAggregationRenderer
extends JPanel
implements CidsBeanAggregationRenderer,
RequestsFullSizeComponent,
ConnectionContextStore {
    private static final Logger log = Logger.getLogger(AlkisPointAggregationRenderer.class);
    private static final double BUFFER = 0.005;
    private static final String[] AGR_COMLUMN_NAMES = new String[]{"Auswahl", "Punktkennung", "Punktart", "Punktort"};
    private static final int[] AGR_COMLUMN_WIDTH = new int[]{40, 80, 200, 200};
    private static final String[] AGR_PROPERTY_NAMES = new String[]{"pointcode", "pointtype", "geom"};
    private static final NumberFormat HW_RW_NUMBER_FORMAT = new DecimalFormat("##########.###");
    private static final String PDF = "Punktliste (PDF)";
    private static final String HTML = "Punktliste (HTML)";
    private static final String TEXT = "Punktliste (TEXT)";
    private static final String APMAP = "AP-Karten (PDF)";
    private static final Set<CidsBean> gehaltenePunkte = TypeSafeCollections.newLinkedHashSet();
    private List<CidsBean> cidsBeans = null;
    private Collection<CidsBean> pureSelectionCidsBeans = null;
    private String title = "";
    private PointTableModel tableModel;
    private Map<CidsBean, CidsFeature> features;
    private Comparator<Integer> tableComparator;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JButton btnCreate;
    private JButton btnRelease;
    private JButton btnRemember;
    private JComboBox cbProducts;
    private JLabel lblProductDescr;
    private MappingComponent mappingComponent;
    private JPanel panMap;
    private JPanel panProdukte;
    private JScrollPane scpAggregationTable;
    private JTable tblAggregation;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.scpAggregationTable.getViewport().setOpaque(false);
        this.tblAggregation.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.tableComparator = new TableModelIndexConvertingToViewIndexComparator(this.tblAggregation);
        this.btnRelease.setEnabled(gehaltenePunkte.size() > 0);
        this.btnRemember.setVisible(false);
        this.btnRelease.setVisible(false);
        boolean billingAllowed = BillingPopup.isBillingAllowed("appdf", this.getConnectionContext()) || BillingPopup.isBillingAllowed("pktlsttxt", this.getConnectionContext());
        this.btnCreate.setEnabled(billingAllowed && ObjectRendererUtils.checkActionTag("custom.alkis.product.punktliste@WUNDA_BLAU", this.getConnectionContext()));
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void initComponents() {
        this.scpAggregationTable = new JScrollPane();
        this.tblAggregation = new JTable();
        this.panProdukte = new JPanel();
        this.cbProducts = new JComboBox();
        this.btnCreate = new JButton();
        this.lblProductDescr = new JLabel();
        this.btnRemember = new JButton();
        this.btnRelease = new JButton();
        this.panMap = new JPanel();
        this.mappingComponent = new MappingComponent();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                AlkisPointAggregationRenderer.this.formAncestorAdded(evt);
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.setLayout(new BorderLayout());
        this.tblAggregation.setOpaque(false);
        this.tblAggregation.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AlkisPointAggregationRenderer.this.tblAggregationFocusLost(evt);
            }
        });
        this.scpAggregationTable.setViewportView(this.tblAggregation);
        this.add((Component)this.scpAggregationTable, "Center");
        this.panProdukte.setOpaque(false);
        this.panProdukte.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.panProdukte.add((Component)this.cbProducts, gridBagConstraints);
        this.btnCreate.setText("Erzeugen");
        this.btnCreate.setFocusPainted(false);
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointAggregationRenderer.this.btnCreateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 5);
        this.panProdukte.add((Component)this.btnCreate, gridBagConstraints);
        this.lblProductDescr.setText("Verf\u00fcgbare Berichte:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.panProdukte.add((Component)this.lblProductDescr, gridBagConstraints);
        this.btnRemember.setText("Merken");
        this.btnRemember.setFocusPainted(false);
        this.btnRemember.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointAggregationRenderer.this.btnRememberActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        this.panProdukte.add((Component)this.btnRemember, gridBagConstraints);
        this.btnRelease.setText("Vergessen");
        this.btnRelease.setFocusPainted(false);
        this.btnRelease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointAggregationRenderer.this.btnReleaseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 5, 5, 10);
        this.panProdukte.add((Component)this.btnRelease, gridBagConstraints);
        this.add((Component)this.panProdukte, "South");
        this.panMap.setMaximumSize(new Dimension(300, 450));
        this.panMap.setMinimumSize(new Dimension(300, 450));
        this.panMap.setOpaque(false);
        this.panMap.setPreferredSize(new Dimension(300, 450));
        this.panMap.setLayout(new GridBagLayout());
        this.mappingComponent.setBorder(BorderFactory.createEtchedBorder());
        this.mappingComponent.setMaximumSize(new Dimension(100, 100));
        this.mappingComponent.setMinimumSize(new Dimension(100, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panMap.add((Component)this.mappingComponent, gridBagConstraints);
        this.add((Component)this.panMap, "East");
    }

    private void btnCreateActionPerformed(ActionEvent evt) {
        if (!ObjectRendererUtils.checkActionTag("custom.alkis.product.punktliste@WUNDA_BLAU", this.getConnectionContext())) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Sie besitzen keine Berechtigung zur Erzeugung dieses Produkts!");
            return;
        }
        String format = this.cbProducts.getSelectedItem().toString();
        if (APMAP.equalsIgnoreCase(format)) {
            Collection<CidsBean> selectedAlkisPoints = this.getSelectedAlkisPointsContainingAPMap();
            int numOfPoints = selectedAlkisPoints.size();
            if (selectedAlkisPoints.isEmpty()) {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(AlkisPointAggregationRenderer.class, (String)"AlkisPointAggregationRenderer.btnCreateActionPerformed(ActionEvent).emptySelection_apmaps.message"), NbBundle.getMessage(AlkisPointAggregationRenderer.class, (String)"AlkisPointAggregationRenderer.btnCreateActionPerformed(ActionEvent).emptySelection_apmaps.title"), 1);
                return;
            }
            try {
                if (BillingPopup.doBilling("appdf", "no.yet", (Geometry)null, this.getConnectionContext(), new BillingProductGroupAmount("ea", numOfPoints))) {
                    this.generateAPMapReport(selectedAlkisPoints);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
            }
        } else {
            Collection<CidsBean> selectedAlkisPoints = this.getSelectedAlkisPoints();
            if (selectedAlkisPoints.isEmpty()) {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(AlkisPointAggregationRenderer.class, (String)"AlkisPointAggregationRenderer.btnCreateActionPerformed(ActionEvent).emptySelection.message"), NbBundle.getMessage(AlkisPointAggregationRenderer.class, (String)"AlkisPointAggregationRenderer.btnCreateActionPerformed(ActionEvent).emptySelection.title"), 1);
                return;
            }
            int numOfPoints = selectedAlkisPoints.size();
            if (format.equalsIgnoreCase(PDF)) {
                try {
                    if (BillingPopup.doBilling("pktlstpdf", "no.yet", (Geometry)null, this.getConnectionContext(), new BillingProductGroupAmount("ea", 1))) {
                        CismetThreadPool.execute((Runnable)new GenerateProduct(format, selectedAlkisPoints));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
                }
            } else if (format.equalsIgnoreCase(TEXT)) {
                try {
                    ArrayList<BillingProductGroupAmount> productGroupAmounts = this.getProductGroupAmountForObject("eapkt", numOfPoints);
                    BillingProductGroupAmount[] groupAmounts = productGroupAmounts.toArray(new BillingProductGroupAmount[productGroupAmounts.size()]);
                    if (BillingPopup.doBilling("pktlsttxt", "no.yet", (Geometry)null, this.getConnectionContext(), groupAmounts)) {
                        CismetThreadPool.execute((Runnable)new GenerateProduct(format, selectedAlkisPoints));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
                }
            } else if (format.equalsIgnoreCase(APMAP)) {
                try {
                    if (BillingPopup.doBilling("appdf", "no.yet", (Geometry)null, this.getConnectionContext(), new BillingProductGroupAmount("ea", numOfPoints))) {
                        CismetThreadPool.execute((Runnable)new GenerateProduct(format, selectedAlkisPoints));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
                }
            } else {
                CismetThreadPool.execute((Runnable)new GenerateProduct(format, selectedAlkisPoints));
            }
        }
    }

    private ArrayList<BillingProductGroupAmount> getProductGroupAmountForObject(String objectBaseKey, int amount) {
        int tmpPoints;
        ArrayList<BillingProductGroupAmount> result = new ArrayList<BillingProductGroupAmount>();
        if (amount > 1000000) {
            tmpPoints = amount - 1000000;
            result.add(new BillingProductGroupAmount(objectBaseKey + "_1000001", tmpPoints));
            amount = 1000000;
        }
        if (amount > 100000) {
            tmpPoints = amount - 100000;
            result.add(new BillingProductGroupAmount(objectBaseKey + "_100001-1000000", tmpPoints));
            amount = 100000;
        }
        if (amount > 10000) {
            tmpPoints = amount - 10000;
            result.add(new BillingProductGroupAmount(objectBaseKey + "_10001-100000", tmpPoints));
            amount = 10000;
        }
        if (amount > 1000) {
            tmpPoints = amount - 1000;
            result.add(new BillingProductGroupAmount(objectBaseKey + "_1001-10000", tmpPoints));
            amount = 1000;
        }
        result.add(new BillingProductGroupAmount(objectBaseKey + "_1000", amount));
        return result;
    }

    private void btnReleaseActionPerformed(ActionEvent evt) {
        gehaltenePunkte.clear();
        this.setCidsBeans(this.pureSelectionCidsBeans);
        this.btnRelease.setEnabled(false);
    }

    private void btnRememberActionPerformed(ActionEvent evt) {
        gehaltenePunkte.addAll(this.cidsBeans);
        this.btnRelease.setEnabled(true);
    }

    private void tblAggregationFocusLost(FocusEvent evt) {
        this.animateToOverview();
        this.tblAggregation.clearSelection();
    }

    private void formAncestorAdded(AncestorEvent evt) {
        CismetThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    log.warn((Object)"Sleeping to wait for zooming to added features was interrupted.", (Throwable)ex);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlkisPointAggregationRenderer.this.animateToOverview();
                    }
                });
            }
        });
    }

    private Collection<CidsBean> getSelectedAlkisPoints() {
        LinkedList<CidsBean> result = new LinkedList<CidsBean>();
        TableModel tableModel = this.tblAggregation.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            Object includedObj = tableModel.getValueAt(i, 0);
            if (!(includedObj instanceof Boolean) || !((Boolean)includedObj).booleanValue()) continue;
            result.add(this.cidsBeans.get(i));
        }
        return result;
    }

    private Collection<CidsBean> getSelectedAlkisPointsContainingAPMap() {
        LinkedList<CidsBean> result = new LinkedList<CidsBean>();
        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
        TableModel tableModel = this.tblAggregation.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            Object includedObj = tableModel.getValueAt(i, 0);
            if (!(includedObj instanceof Boolean) || !((Boolean)includedObj).booleanValue() || !AlkisPointRenderer.hasAPMap(this.cidsBeans.get(i))) continue;
            selectedIndexes.add(i);
        }
        Collections.sort(selectedIndexes, this.tableComparator);
        for (Integer selectedIndex : selectedIndexes) {
            result.add(this.cidsBeans.get(selectedIndex));
        }
        return result;
    }

    private String getPunktlistenStringForChosenPoints(Collection<CidsBean> alkisPoints) {
        StringBuffer punktListeString = new StringBuffer();
        for (CidsBean alkisPoint : alkisPoints) {
            if (punktListeString.length() > 0) {
                punktListeString.append(",");
            }
            ClientAlkisProducts.getInstance();
            punktListeString.append(ClientAlkisProducts.getPointDataForProduct((CidsBean)alkisPoint));
        }
        return punktListeString.toString();
    }

    public Collection<CidsBean> getCidsBeans() {
        return this.cidsBeans;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String desc = "Punktliste";
        List<CidsBean> beans = this.cidsBeans;
        if (beans != null && beans.size() > 0) {
            desc = desc + " - " + beans.size() + " Punkte ausgew\u00e4hlt";
        }
        this.title = desc;
    }

    public void setCidsBeans(Collection<CidsBean> beans) {
        if (beans instanceof List) {
            this.pureSelectionCidsBeans = beans;
            if (gehaltenePunkte.size() > 0) {
                gehaltenePunkte.addAll(beans);
                this.cidsBeans = Arrays.asList(gehaltenePunkte.toArray(new CidsBean[gehaltenePunkte.size()]));
            } else {
                this.cidsBeans = (List)beans;
            }
            this.features = new HashMap<CidsBean, CidsFeature>(beans.size());
            this.initMap();
            boolean allowAPMapReport = false;
            ArrayList tableData = TypeSafeCollections.newArrayList();
            for (CidsBean punktBean : this.cidsBeans) {
                tableData.add(this.cidsBean2Row(punktBean));
                if (allowAPMapReport) continue;
                allowAPMapReport = AlkisPointRenderer.hasAPMap(punktBean);
            }
            this.tableModel = new PointTableModel((Object[][])tableData.toArray((T[])new Object[tableData.size()][]), AGR_COMLUMN_NAMES);
            this.tblAggregation.setModel(this.tableModel);
            TableColumnModel cModel = this.tblAggregation.getColumnModel();
            for (int i = 0; i < cModel.getColumnCount(); ++i) {
                cModel.getColumn(i).setPreferredWidth(AGR_COMLUMN_WIDTH[i]);
            }
            ObjectRendererUtils.decorateTableWithSorter(this.tblAggregation);
            ArrayList<String> comboBoxContent = new ArrayList<String>();
            comboBoxContent.add(TEXT);
            comboBoxContent.add(PDF);
            if (AlkisProductDownloadHelper.validateUserHasAlkisHTMLProductAccess(this.getConnectionContext())) {
                comboBoxContent.add(HTML);
            }
            if (allowAPMapReport) {
                comboBoxContent.add(APMAP);
            }
            this.cbProducts.setModel(new DefaultComboBoxModel<String>(comboBoxContent.toArray(new String[0])));
        }
        this.setTitle(null);
    }

    private Object[] cidsBean2Row(CidsBean baulastBean) {
        if (baulastBean != null) {
            Object[] result = new Object[AGR_COMLUMN_NAMES.length];
            result[0] = Boolean.TRUE;
            for (int i = 0; i < AGR_PROPERTY_NAMES.length; ++i) {
                String propertyString;
                Object property = baulastBean.getProperty(AGR_PROPERTY_NAMES[i]);
                if (property instanceof Point) {
                    Point point = (Point)property;
                    propertyString = "RW: " + HW_RW_NUMBER_FORMAT.format(point.getX()) + "; HW: " + HW_RW_NUMBER_FORMAT.format(point.getY());
                } else {
                    propertyString = ObjectRendererUtils.propertyPrettyPrint(property);
                }
                result[i + 1] = propertyString;
            }
            return result;
        }
        return new Object[0];
    }

    private void initMap() {
        try {
            ActiveLayerModel mappingModel = new ActiveLayerModel();
            mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
            XBoundingBox box = this.boundingBoxFromPointList(this.cidsBeans);
            mappingModel.addHome(new XBoundingBox(box.getX1(), box.getY1(), box.getX2(), box.getY2(), ClientAlkisConf.getInstance().getSrsService(), true));
            SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
            swms.setName("Alkis_Points");
            mappingModel.addLayer((RetrievalServiceLayer)swms);
            this.mappingComponent.setMappingModel((MappingModel)mappingModel);
            this.mappingComponent.setAnimationDuration(0);
            this.mappingComponent.gotoInitialBoundingBox();
            this.mappingComponent.setInteractionMode("ZOOM");
            this.mappingComponent.unlock();
            this.mappingComponent.setInteractionMode("MUTE");
            for (CidsBean cidsBean : this.cidsBeans) {
                CidsFeature feature = new CidsFeature(cidsBean.getMetaObject());
                this.features.put(cidsBean, feature);
            }
            this.mappingComponent.getFeatureCollection().addFeatures(this.features.values());
        }
        catch (Throwable t) {
            log.fatal((Object)t, t);
        }
    }

    public void animateToOverview() {
        this.mappingComponent.gotoInitialBoundingBox();
        Rectangle2D viewBounds = this.mappingComponent.getCamera().getViewBounds().getBounds2D();
        double scale = this.mappingComponent.getScaleDenominator();
        double newX = (viewBounds.getX() / scale - 0.005) * scale;
        double newY = (viewBounds.getY() / scale - 0.005) * scale;
        double newWidth = (viewBounds.getWidth() / scale + 0.01) * scale;
        double newHeight = (viewBounds.getHeight() / scale + 0.01) * scale;
        viewBounds.setRect(newX, newY, newWidth, newHeight);
        this.mappingComponent.getCamera().animateViewToCenterBounds(viewBounds, true, (long)this.mappingComponent.getAnimationDuration());
    }

    private XBoundingBox boundingBoxFromPointList(Collection<CidsBean> lpList) {
        ArrayList allGeomList = TypeSafeCollections.newArrayList();
        for (CidsBean parcel : lpList) {
            try {
                allGeomList.add((Geometry)parcel.getProperty("geom"));
            }
            catch (Exception ex) {
                log.warn((Object)ex, (Throwable)ex);
            }
        }
        GeometryCollection geoCollection = new GeometryCollection(allGeomList.toArray(new Geometry[allGeomList.size()]), new GeometryFactory());
        return new XBoundingBox(geoCollection.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
    }

    public void dispose() {
        this.mappingComponent.dispose();
    }

    public static void main(String[] args) throws Exception {
        CidsBean[] cidsBeans = DevelopmentTools.createCidsBeansFromRMIConnectionOnLocalhost((String)"WUNDA_BLAU", (String)"Administratoren", (String)"admin", (String)"sb", (String)"alkis_point", (String)"pointtype=4", (int)10);
        DevelopmentTools.createAggregationRendererInFrameFromRMIConnectionOnLocalhost(Arrays.asList(cidsBeans), (String)"ALKIS-Punkte Aggregationsrenderer", (int)1024, (int)768);
    }

    private void generateAPMapReport(Collection<CidsBean> alkisPoints) {
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this)) {
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            ArrayList<MetaObjectNode> alkisMons = new ArrayList<MetaObjectNode>();
            for (CidsBean alkisPoint : alkisPoints) {
                alkisMons.add(new MetaObjectNode(alkisPoint));
            }
            ServerActionParameter sapMons = new ServerActionParameter(AlkisPointReportServerAction.Parameter.POINT_MONS.toString(), alkisMons);
            DownloadManager.instance().add((Download)new ByteArrayActionDownload("alkisPointReport", null, new ServerActionParameter[]{sapMons}, "AP-Karten", jobname, "apkarten", ".pdf", this.getConnectionContext()));
        }
    }

    protected class GenerateProduct
    implements Runnable {
        private String format;
        private Collection<CidsBean> alkisPoints;

        public GenerateProduct(String format, Collection<CidsBean> alkisPoints) {
            this.format = format;
            this.alkisPoints = alkisPoints;
        }

        @Override
        public void run() {
            String extension;
            String product;
            String punktListenString = AlkisPointAggregationRenderer.this.getPunktlistenStringForChosenPoints(this.alkisPoints);
            if (AlkisPointAggregationRenderer.PDF.equals(this.format)) {
                product = ClientAlkisProducts.getInstance().get(AlkisProducts.Type.PUNKTLISTE_PDF);
                extension = ".pdf";
            } else if (AlkisPointAggregationRenderer.HTML.equals(this.format)) {
                product = ClientAlkisProducts.getInstance().get(AlkisProducts.Type.PUNKTLISTE_HTML);
                extension = ".html";
            } else {
                product = ClientAlkisProducts.getInstance().get(AlkisProducts.Type.PUNKTLISTE_TXT);
                extension = ".plst";
            }
            if (punktListenString.length() > 3 && product != null && product.length() > 0) {
                try {
                    if (!DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)AlkisPointAggregationRenderer.this)) {
                        return;
                    }
                    String title = "Punktnachweis";
                    String filename = product;
                    String directory = DownloadManagerDialog.getInstance().getJobName();
                    ByteArrayActionDownload download = new ByteArrayActionDownload("alkisProduct", (Object)AlkisProductServerAction.Body.LISTENNACHWEIS, new ServerActionParameter[]{new ServerActionParameter(AlkisProductServerAction.Parameter.PRODUKT.toString(), (Object)product), new ServerActionParameter(AlkisProductServerAction.Parameter.ALKIS_CODE.toString(), (Object)punktListenString)}, "Punktnachweis", directory, filename, extension, AlkisPointAggregationRenderer.this.connectionContext);
                    DownloadManager.instance().add((Download)download);
                    DownloadManager.instance().add((Download)download);
                }
                catch (Exception ex) {
                    ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Aufruf des Produkts: " + product, ex, AlkisPointAggregationRenderer.this);
                    log.error((Object)("The URL to download product '" + product + "' (actionTag: " + "custom.alkis.product.punktliste@WUNDA_BLAU" + ") could not be constructed."), (Throwable)ex);
                }
            }
        }
    }

    static final class PointTableModel
    extends DefaultTableModel {
        public PointTableModel(Object[][] data, String[] labels) {
            super(data, labels);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }
    }

    final class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] indexes;
            if (!e.getValueIsAdjusting() && AlkisPointAggregationRenderer.this.cidsBeans != null && (indexes = AlkisPointAggregationRenderer.this.tblAggregation.getSelectedRows()) != null && indexes.length > 0) {
                for (int viewIdx : indexes) {
                    int modelIdx = AlkisPointAggregationRenderer.this.tblAggregation.getRowSorter().convertRowIndexToModel(viewIdx);
                    if (modelIdx <= -1 || modelIdx >= AlkisPointAggregationRenderer.this.cidsBeans.size()) continue;
                    CidsBean selectedBean = (CidsBean)AlkisPointAggregationRenderer.this.cidsBeans.get(modelIdx);
                    XBoundingBox boxToGoto = new XBoundingBox(((CidsFeature)AlkisPointAggregationRenderer.this.features.get(selectedBean)).getGeometry().getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
                    boxToGoto.setX1(boxToGoto.getX1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
                    boxToGoto.setX2(boxToGoto.getX2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getWidth());
                    boxToGoto.setY1(boxToGoto.getY1() - ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
                    boxToGoto.setY2(boxToGoto.getY2() + ClientAlkisConf.getInstance().getGeoBufferMultiplier() * boxToGoto.getHeight());
                    AlkisPointAggregationRenderer.this.mappingComponent.gotoBoundingBox((BoundingBox)boxToGoto, false, true, 500);
                    break;
                }
            }
        }
    }
}

