/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import com.vividsolutions.jts.geom.Geometry;
import de.aedsicad.aaaweb.rest.model.Point;
import de.aedsicad.aaaweb.rest.model.PointLocation;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.clientutils.ByteArrayActionDownload;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisProductDownloadHelper;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisProducts;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisRestUtils;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.alkis.AlkisSOAPWorkerService;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.wunda_blau.search.actions.AlkisProductServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.security.WebAccessManager;
import de.cismet.security.exceptions.AccessMethodIsNotSupportedException;
import de.cismet.security.exceptions.MissingArgumentException;
import de.cismet.security.exceptions.NoHandlerForURLException;
import de.cismet.security.exceptions.RequestFailedException;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.gui.BorderProvider;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.TitleComponentProvider;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.HttpDownload;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JComboBoxBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.graphics.ReflectionRenderer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.openide.util.Exceptions;

public class AlkisPointRenderer
extends JPanel
implements CidsBeanRenderer,
TitleComponentProvider,
FooterComponentProvider,
BorderProvider,
RequestsFullSizeComponent,
ConnectionContextStore,
RasterfariDocumentLoaderPanel.Listener {
    private static final String ICON_RES_PACKAGE = "/de/cismet/cids/custom/wunda_blau/res/";
    private static final String ALKIS_RES_PACKAGE = "/de/cismet/cids/custom/wunda_blau/res/alkis/";
    private static final String CARD_1 = "CARD_1";
    private static final String CARD_2 = "CARD_2";
    private static final String CARD_PREVIEW = "preview";
    private static final String CARD_APMAP = "apmap";
    private static final String ERHEBUNGS_PROPERTIES = "datenerhebung.properties";
    static final String PRODUCT_ACTION_TAG_PUNKTLISTE = "custom.alkis.product.punktliste@WUNDA_BLAU";
    private static final Color PUNKTORT_MIT_KARTENDARSTELLUNG = new Color(120, 255, 190);
    private static final Logger LOG = Logger.getLogger(AlkisPointRenderer.class);
    protected static final String POINTTYPE_AUFNAHMEPUNKT = "Aufnahmepunkt";
    protected static final String POINTTYPE_SONSTIGERVERMESSUNGSPUNKT = "Sonstiger Vermessungspunkt";
    protected static XBoundingBox INITIAL_BOUNDINGBOX = new XBoundingBox(2583621.251964098, 5682507.032498134, 2584022.9413952776, 5682742.852810634, ClientAlkisConf.getInstance().getSrsService(), true);
    protected static Crs CRS = new Crs(ClientAlkisConf.getInstance().getSrsService(), ClientAlkisConf.getInstance().getSrsService(), ClientAlkisConf.getInstance().getSrsService(), true, true);
    private static final Converter<String, String> ALKIS_BOOLEAN_CONVERTER = new Converter<String, String>(){
        private static final String TRUE_REP = "Ja";
        private static final String FALSE_REP = "Nein";

        public String convertForward(String s) {
            if (s != null && s.equals("1")) {
                return TRUE_REP;
            }
            return FALSE_REP;
        }

        public String convertReverse(String t) {
            if (TRUE_REP.equals(t)) {
                return "1";
            }
            return "0";
        }
    };
    private static final Converter<String, String> ALKIS_ERHEBUNG_CONVERTER = new Converter<String, String>(){
        private final Properties datenerhebungWerte = new Properties();
        {
            try {
                this.datenerhebungWerte.load(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/datenerhebung.properties").openStream());
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }

        public String convertForward(String s) {
            String descr = "keine Angabe (-)";
            String searchKey = "0000";
            if (s != null) {
                try {
                    SAXBuilder builder = new SAXBuilder();
                    StringReader in = new StringReader(s);
                    Document doc = builder.build((Reader)in);
                    Element root = doc.getRootElement();
                    ElementFilter filter = new ElementFilter("AX_Datenerhebung_Punktort");
                    Iterator it = root.getDescendants((Filter)filter);
                    while (it.hasNext()) {
                        Element c = (Element)it.next();
                        searchKey = c.getTextNormalize();
                    }
                    descr = this.datenerhebungWerte.getProperty(searchKey);
                    if (descr != null) {
                        return "<html><table width=\"300\" border=\"0\"><tr><td>(" + searchKey + ") " + descr + "</tr></table></html>";
                    }
                    LOG.warn((Object)("No description found for Erhebung with key: " + searchKey));
                }
                catch (Exception e) {
                    LOG.error((Object)"Error in converter", (Throwable)e);
                }
                LOG.warn((Object)("Could not translate response: " + s));
            }
            return "keine Angabe";
        }

        public String convertReverse(String t) {
            throw new UnsupportedOperationException("Will not be supported!");
        }
    };
    private static final Converter<CidsBean, String> ALKIS_VERMARKUNG_CONVERTER = new Converter<CidsBean, String>(){

        public String convertForward(CidsBean bean) {
            Object markenObj = bean.getProperty("abmarkung");
            if (markenObj == null) {
                markenObj = bean.getProperty("vermarkung");
            }
            return markenObj == null ? null : markenObj.toString();
        }

        public CidsBean convertReverse(String vermarkungText) {
            throw new UnsupportedOperationException("Will/Can not be supported!");
        }
    };
    private static final Comparator<PointLocation> POINTLOCATION_COMPARATOR = new Comparator<PointLocation>(){

        @Override
        public int compare(PointLocation p1, PointLocation p2) {
            int result = this.compareKartendarstellung(p1, p2);
            if (result != 0) {
                return -result;
            }
            return -this.compareDate(p1, p2);
        }

        private int compareKartendarstellung(PointLocation p1, PointLocation p2) {
            String kd2;
            String kd1 = p1.getKartendarstellung();
            if (kd1 != (kd2 = p2.getKartendarstellung())) {
                if (kd1 != null) {
                    if (kd2 != null) {
                        return kd1.compareTo(kd2);
                    }
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        private int compareDate(PointLocation p1, PointLocation p2) {
            String lz2;
            String lz1 = p1.getLebenszeitIntervallBeginnt();
            if (lz1 != (lz2 = p2.getLebenszeitIntervallBeginnt())) {
                if (lz1 != null) {
                    if (lz2 != null) {
                        if (lz1.length() > 9 && lz2.length() > 9) {
                            return this.compareDateStrings(lz1.substring(0, 11), lz2.substring(0, 11));
                        }
                        throw new IllegalStateException("Could not parse Dates: " + lz1 + " or " + lz2);
                    }
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        private int compareDateStrings(String ds1, String ds2) {
            String[] ymd1 = ds1.split("-");
            String[] ymd2 = ds2.split("-");
            if (ymd1.length == 3 && ymd2.length == 3) {
                int result = 0;
                for (int i = 0; i < 3 && result == 0; ++i) {
                    result = ymd1[i].compareTo(ymd2[i]);
                }
                return result;
            }
            throw new IllegalStateException("Could not parse Dates: " + ds1 + " or " + ds2);
        }
    };
    private final Map<Object, ImageIcon> productPreviewImages;
    private final List<JLabel> retrieveableLabels;
    private Point point;
    private CidsBean cidsBean;
    private String title;
    private CardLayout cardLayout;
    private CardLayout cardLayoutForContent;
    private List<PointLocation> pointLocations;
    private ImageIcon PUNKT_PDF;
    private ImageIcon PUNKT_HTML;
    private ImageIcon PUNKT_TXT;
    private String documentOfAPMap;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final RasterfariDocumentLoaderPanel rasterfariLoader = new RasterfariDocumentLoaderPanel(ClientAlkisConf.getInstance().getRasterfariUrl(), (RasterfariDocumentLoaderPanel.Listener)this, this.getConnectionContext());
    private ButtonGroup bgrAPMapControls;
    private JXBusyLabel blWaiting;
    private JButton btnBack;
    private JButton btnForward;
    private JButton btnHome;
    private JButton btnOpen;
    private JButton btnRetrieve;
    private JComboBox cbPunktorte;
    private Box.Filler gluFiller;
    private JXHyperlink hlPunktlisteHtml;
    private JXHyperlink hlPunktlistePdf;
    private JXHyperlink hlPunktlisteTxt;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel7;
    private JLabel lblBack;
    private JLabel lblDescAnlass;
    private JLabel lblDescBeginn;
    private JLabel lblDescDatenerhebung;
    private JLabel lblDescDienststelle;
    private JLabel lblDescEnde;
    private JLabel lblDescGenauigkeitsstufe;
    private JLabel lblDescHinweise;
    private JLabel lblDescHochwert;
    private JLabel lblDescIdentifikator;
    private JLabel lblDescKartendarstellung;
    private JLabel lblDescKoordStatus;
    private JLabel lblDescLand;
    private JLabel lblDescMarke;
    private JLabel lblDescModellart;
    private JLabel lblDescPLIdentifikator;
    private JLabel lblDescPLObjektart;
    private JLabel lblDescPOAnlass;
    private JLabel lblDescPOBeginn;
    private JLabel lblDescPOEnde;
    private JLabel lblDescPOModellart;
    private JLabel lblDescPunktart;
    private JLabel lblDescPunktkennung;
    private JLabel lblDescPunktorte;
    private JLabel lblDescRechtswert;
    private JLabel lblForw;
    private JLabel lblHeaderAPMap;
    private JLabel lblLocHead;
    private JLabel lblMissingAPMap;
    private JLabel lblPointHead;
    private JLabel lblPreviewHead;
    private JLabel lblProductPreview;
    private JLabel lblTitle;
    private JLabel lblTxtAbmarkungMarke;
    private JLabel lblTxtAnlass;
    private JLabel lblTxtBeginn;
    private JLabel lblTxtDatenerhebung;
    private JLabel lblTxtDienststelle;
    private JLabel lblTxtEnde;
    private JLabel lblTxtGenauigkeitsstufe;
    private JLabel lblTxtHinweise;
    private JLabel lblTxtHochwert;
    private JLabel lblTxtIdentifikator;
    private JLabel lblTxtKartendarstellung;
    private JLabel lblTxtKoordStatus;
    private JLabel lblTxtLand;
    private JLabel lblTxtModellart;
    private JLabel lblTxtPLIdentifikator;
    private JLabel lblTxtPLObjektart;
    private JLabel lblTxtPOAnlass;
    private JLabel lblTxtPOBeginn;
    private JLabel lblTxtPOEnde;
    private JLabel lblTxtPOModellart;
    private JLabel lblTxtPunktart;
    private JLabel lblTxtPunktkennung;
    private JLabel lblTxtRechtswert;
    private JPanel panButtons;
    private JPanel panFooter;
    private JPanel panFooterLeft;
    private JPanel panFooterRight;
    private JPanel panHtmlProducts;
    private JPanel panInfo;
    private JPanel panLocationInfos;
    private JPanel panPdfProducts;
    private JPanel panPointInfo;
    private JPanel panProductPreview;
    private JPanel panProducts;
    private JPanel panTitle;
    private JPanel panTxtProducts;
    private RoundedPanel pnlAPMap;
    private JPanel pnlContent;
    private RoundedPanel pnlControls;
    private SemiRoundedPanel pnlHeaderAPMap;
    private SemiRoundedPanel semiRoundedPanel3;
    private SemiRoundedPanel semiRoundedPanel4;
    private SemiRoundedPanel semiRoundedPanel5;
    private SemiRoundedPanel semiRoundedPanel6;
    private SemiRoundedPanel semiRoundedPanel7;
    private SemiRoundedPanel srpHeadLocInfo;
    private SemiRoundedPanel srpPointInfo;
    private JToggleButton togPan;
    private JToggleButton togZoom;
    private BindingGroup bindingGroup;

    public AlkisPointRenderer() {
        this.retrieveableLabels = TypeSafeCollections.newArrayList();
        this.productPreviewImages = TypeSafeCollections.newHashMap();
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initIcons();
        this.initComponents();
        this.initFooterElements();
        this.initProductPreview();
        this.setWait(false);
        this.panLocationInfos.setVisible(false);
        this.cbPunktorte.setRenderer(new LocationComboBoxRenderer());
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof CardLayout) {
            this.cardLayout = (CardLayout)layoutManager;
            this.cardLayout.show(this, CARD_1);
        } else {
            this.cardLayout = new CardLayout();
            LOG.error((Object)("AlkisPointRenderer exspects CardLayout as major layout manager, but has " + this.getLayout() + "!"));
        }
        layoutManager = this.pnlContent.getLayout();
        if (layoutManager instanceof CardLayout) {
            this.cardLayoutForContent = (CardLayout)layoutManager;
            this.cardLayoutForContent.show(this.pnlContent, CARD_APMAP);
        } else {
            this.cardLayoutForContent = new CardLayout();
            LOG.error((Object)("AlkisPointRenderer exspects CardLayout as layout manager to display preview and AP maps, but has " + this.getLayout() + "!"));
        }
        this.retrieveableLabels.add(this.lblTxtBeginn);
        this.retrieveableLabels.add(this.lblTxtEnde);
        this.retrieveableLabels.add(this.lblTxtModellart);
        this.retrieveableLabels.add(this.lblTxtDienststelle);
        this.retrieveableLabels.add(this.lblTxtLand);
        this.retrieveableLabels.add(this.lblTxtDienststelle);
        this.retrieveableLabels.add(this.lblTxtAnlass);
        if (!AlkisProductDownloadHelper.validateUserHasAlkisProductAccess(this.getConnectionContext())) {
            this.btnForward.setEnabled(false);
            this.lblForw.setEnabled(false);
        }
        this.panHtmlProducts.setVisible(AlkisProductDownloadHelper.validateUserHasAlkisHTMLProductAccess(this.getConnectionContext()));
        boolean billingAllowedPdf = BillingPopup.isBillingAllowed("pktlstpdf", this.getConnectionContext());
        boolean billingAllowedTxt = BillingPopup.isBillingAllowed("pktlsttxt", this.getConnectionContext());
        boolean billingAllowedHtml = billingAllowedPdf || billingAllowedTxt;
        this.hlPunktlisteHtml.setEnabled(billingAllowedHtml && ObjectRendererUtils.checkActionTag(PRODUCT_ACTION_TAG_PUNKTLISTE, this.getConnectionContext()));
        this.hlPunktlistePdf.setEnabled(billingAllowedPdf && ObjectRendererUtils.checkActionTag(PRODUCT_ACTION_TAG_PUNKTLISTE, this.getConnectionContext()));
        this.hlPunktlisteTxt.setEnabled(billingAllowedTxt && ObjectRendererUtils.checkActionTag(PRODUCT_ACTION_TAG_PUNKTLISTE, this.getConnectionContext()));
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void initProductPreviewImages() {
        this.productPreviewImages.put(this.hlPunktlistePdf, this.PUNKT_PDF);
        this.productPreviewImages.put(this.hlPunktlisteHtml, this.PUNKT_HTML);
        this.productPreviewImages.put(this.hlPunktlisteTxt, this.PUNKT_TXT);
        ProductLabelMouseAdaper productListener = new ProductLabelMouseAdaper();
        this.hlPunktlistePdf.addMouseListener((MouseListener)productListener);
        this.hlPunktlisteHtml.addMouseListener((MouseListener)productListener);
        this.hlPunktlisteTxt.addMouseListener((MouseListener)productListener);
    }

    private void initProductPreview() {
        this.initProductPreviewImages();
        int maxX = 0;
        int maxY = 0;
        for (ImageIcon ii : this.productPreviewImages.values()) {
            if (ii.getIconWidth() > maxX) {
                maxX = ii.getIconWidth();
            }
            if (ii.getIconHeight() <= maxY) continue;
            maxY = ii.getIconHeight();
        }
        Dimension previewDim = new Dimension(maxX + 20, maxY + 40);
        ObjectRendererUtils.setAllDimensions(this.panProductPreview, previewDim);
    }

    private void initFooterElements() {
        ObjectRendererUtils.decorateJLabelAndButtonSynced(this.lblForw, this.btnForward, ObjectRendererUtils.FORWARD_SELECTED, ObjectRendererUtils.FORWARD_PRESSED);
        ObjectRendererUtils.decorateJLabelAndButtonSynced(this.lblBack, this.btnBack, ObjectRendererUtils.BACKWARD_SELECTED, ObjectRendererUtils.BACKWARD_PRESSED);
    }

    private void initIcons() {
        ReflectionRenderer reflectionRenderer = new ReflectionRenderer(0.5f, 0.15f, false);
        BufferedImage i1 = null;
        BufferedImage i2 = null;
        BufferedImage i3 = null;
        try {
            i1 = reflectionRenderer.appendReflection(ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/punktlistepdf.png")));
            i2 = reflectionRenderer.appendReflection(ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/punktlistehtml.png")));
            i3 = reflectionRenderer.appendReflection(ImageIO.read(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/alkis/punktlistetxt.png")));
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        this.PUNKT_PDF = new ImageIcon(i1);
        this.PUNKT_HTML = new ImageIcon(i2);
        this.PUNKT_TXT = new ImageIcon(i3);
    }

    private void setWait(boolean waiting) {
        this.blWaiting.setBusy(waiting);
        this.blWaiting.setVisible(waiting);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.blWaiting = new JXBusyLabel();
        this.panFooter = new JPanel();
        this.panButtons = new JPanel();
        this.panFooterLeft = new JPanel();
        this.lblBack = new JLabel();
        this.btnBack = new JButton();
        this.panFooterRight = new JPanel();
        this.btnForward = new JButton();
        this.lblForw = new JLabel();
        this.bgrAPMapControls = new ButtonGroup();
        this.panInfo = new JPanel();
        this.panPointInfo = new RoundedPanel();
        this.lblTxtPunktkennung = new JLabel();
        this.lblTxtIdentifikator = new JLabel();
        this.btnRetrieve = new JButton();
        this.lblDescIdentifikator = new JLabel();
        this.lblDescMarke = new JLabel();
        this.lblDescPunktart = new JLabel();
        this.lblTxtPunktart = new JLabel();
        this.lblDescPunktkennung = new JLabel();
        this.lblTxtAbmarkungMarke = new JLabel();
        this.lblTxtBeginn = new JLabel();
        this.lblDescModellart = new JLabel();
        this.lblDescLand = new JLabel();
        this.lblDescDienststelle = new JLabel();
        this.lblDescBeginn = new JLabel();
        this.lblTxtModellart = new JLabel();
        this.lblTxtLand = new JLabel();
        this.lblTxtDienststelle = new JLabel();
        this.lblDescEnde = new JLabel();
        this.lblTxtEnde = new JLabel();
        this.lblDescAnlass = new JLabel();
        this.lblTxtAnlass = new JLabel();
        this.srpPointInfo = new SemiRoundedPanel();
        this.lblPointHead = new JLabel();
        this.jPanel3 = new JPanel();
        this.panLocationInfos = new RoundedPanel();
        this.cbPunktorte = new JComboBox();
        this.lblDescKartendarstellung = new JLabel();
        this.lblDescRechtswert = new JLabel();
        this.lblDescHochwert = new JLabel();
        this.lblDescDatenerhebung = new JLabel();
        this.lblTxtRechtswert = new JLabel();
        this.lblTxtHochwert = new JLabel();
        this.lblTxtHinweise = new JLabel();
        this.lblDescKoordStatus = new JLabel();
        this.lblTxtKoordStatus = new JLabel();
        this.lblDescGenauigkeitsstufe = new JLabel();
        this.lblDescHinweise = new JLabel();
        this.lblTxtGenauigkeitsstufe = new JLabel();
        this.lblTxtDatenerhebung = new JLabel();
        this.srpHeadLocInfo = new SemiRoundedPanel();
        this.lblLocHead = new JLabel();
        this.lblDescPunktorte = new JLabel();
        this.lblDescPOModellart = new JLabel();
        this.lblTxtPOModellart = new JLabel();
        this.lblDescPOAnlass = new JLabel();
        this.lblTxtPOAnlass = new JLabel();
        this.lblDescPOBeginn = new JLabel();
        this.lblTxtPOBeginn = new JLabel();
        this.lblDescPOEnde = new JLabel();
        this.lblTxtPOEnde = new JLabel();
        this.jPanel4 = new JPanel();
        this.lblDescPLIdentifikator = new JLabel();
        this.lblTxtPLIdentifikator = new JLabel();
        this.lblDescPLObjektart = new JLabel();
        this.lblTxtPLObjektart = new JLabel();
        this.lblTxtKartendarstellung = new JLabel();
        this.panProducts = new JPanel();
        this.panPdfProducts = new RoundedPanel();
        this.hlPunktlistePdf = new JXHyperlink();
        this.jPanel1 = new JPanel();
        this.semiRoundedPanel4 = new SemiRoundedPanel();
        this.jLabel4 = new JLabel();
        this.panHtmlProducts = new RoundedPanel();
        this.hlPunktlisteHtml = new JXHyperlink();
        this.jPanel2 = new JPanel();
        this.semiRoundedPanel5 = new SemiRoundedPanel();
        this.jLabel5 = new JLabel();
        this.panTxtProducts = new RoundedPanel();
        this.hlPunktlisteTxt = new JXHyperlink();
        this.jPanel7 = new JPanel();
        this.semiRoundedPanel6 = new SemiRoundedPanel();
        this.jLabel6 = new JLabel();
        this.pnlControls = new RoundedPanel();
        this.togPan = new JToggleButton();
        this.togZoom = new JToggleButton();
        this.btnHome = new JButton();
        this.semiRoundedPanel7 = new SemiRoundedPanel();
        this.jLabel3 = new JLabel();
        this.btnOpen = new JButton();
        this.pnlContent = new JPanel();
        this.panProductPreview = new RoundedPanel();
        this.lblProductPreview = new JLabel();
        this.semiRoundedPanel3 = new SemiRoundedPanel();
        this.lblPreviewHead = new JLabel();
        this.pnlAPMap = new RoundedPanel();
        this.pnlHeaderAPMap = new SemiRoundedPanel();
        this.lblHeaderAPMap = new JLabel();
        this.lblMissingAPMap = new JLabel();
        this.gluFiller = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.panTitle.setMinimumSize(new Dimension(101, 32));
        this.panTitle.setOpaque(false);
        this.panTitle.setPreferredSize(new Dimension(101, 32));
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setText("TITLE");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panTitle.add((Component)this.blWaiting, gridBagConstraints);
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new BorderLayout());
        this.panButtons.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.panButtons.setOpaque(false);
        this.panButtons.setLayout(new GridBagLayout());
        this.panFooterLeft.setMaximumSize(new Dimension(124, 40));
        this.panFooterLeft.setMinimumSize(new Dimension(124, 40));
        this.panFooterLeft.setOpaque(false);
        this.panFooterLeft.setPreferredSize(new Dimension(124, 40));
        this.panFooterLeft.setLayout(new FlowLayout(2, 10, 5));
        this.lblBack.setFont(new Font("Tahoma", 1, 14));
        this.lblBack.setForeground(new Color(255, 255, 255));
        this.lblBack.setText("Info");
        this.lblBack.setEnabled(false);
        this.lblBack.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlkisPointRenderer.this.lblBackMouseClicked(evt);
            }
        });
        this.panFooterLeft.add(this.lblBack);
        this.btnBack.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left.png")));
        this.btnBack.setBorder(null);
        this.btnBack.setBorderPainted(false);
        this.btnBack.setContentAreaFilled(false);
        this.btnBack.setEnabled(false);
        this.btnBack.setFocusPainted(false);
        this.btnBack.setMaximumSize(new Dimension(30, 30));
        this.btnBack.setMinimumSize(new Dimension(30, 30));
        this.btnBack.setPreferredSize(new Dimension(30, 30));
        this.btnBack.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left-pressed.png")));
        this.btnBack.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left-sel.png")));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointRenderer.this.btnBackActionPerformed(evt);
            }
        });
        this.panFooterLeft.add(this.btnBack);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panButtons.add((Component)this.panFooterLeft, gridBagConstraints);
        this.panFooterRight.setMaximumSize(new Dimension(124, 40));
        this.panFooterRight.setOpaque(false);
        this.panFooterRight.setLayout(new FlowLayout(0, 10, 5));
        this.btnForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-right.png")));
        this.btnForward.setBorder(null);
        this.btnForward.setBorderPainted(false);
        this.btnForward.setContentAreaFilled(false);
        this.btnForward.setFocusPainted(false);
        this.btnForward.setMaximumSize(new Dimension(30, 30));
        this.btnForward.setMinimumSize(new Dimension(30, 30));
        this.btnForward.setPreferredSize(new Dimension(30, 30));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointRenderer.this.btnForwardActionPerformed(evt);
            }
        });
        this.panFooterRight.add(this.btnForward);
        this.lblForw.setFont(new Font("Tahoma", 1, 14));
        this.lblForw.setForeground(new Color(255, 255, 255));
        this.lblForw.setText("Produkte");
        this.lblForw.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AlkisPointRenderer.this.lblForwMouseClicked(evt);
            }
        });
        this.panFooterRight.add(this.lblForw);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panButtons.add((Component)this.panFooterRight, gridBagConstraints);
        this.panFooter.add((Component)this.panButtons, "Center");
        this.setLayout(new CardLayout());
        this.panInfo.setOpaque(false);
        this.panInfo.setLayout(new GridBagLayout());
        this.panPointInfo.setMaximumSize(new Dimension(350, 500));
        this.panPointInfo.setMinimumSize(new Dimension(350, 500));
        this.panPointInfo.setOpaque(false);
        this.panPointInfo.setPreferredSize(new Dimension(350, 500));
        this.panPointInfo.setLayout(new GridBagLayout());
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.pointcode}"), (Object)this.lblTxtPunktkennung, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblTxtPunktkennung, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.uuid}"), (Object)this.lblTxtIdentifikator, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblTxtIdentifikator, gridBagConstraints);
        this.btnRetrieve.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/network-wired.png")));
        this.btnRetrieve.setText("Punktorte laden");
        this.btnRetrieve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointRenderer.this.btnRetrieveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panPointInfo.add((Component)this.btnRetrieve, gridBagConstraints);
        this.lblDescIdentifikator.setFont(new Font("Tahoma", 1, 11));
        this.lblDescIdentifikator.setText("Identifikator:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblDescIdentifikator, gridBagConstraints);
        this.lblDescMarke.setFont(new Font("Tahoma", 1, 11));
        this.lblDescMarke.setText("Marke:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblDescMarke, gridBagConstraints);
        this.lblDescPunktart.setFont(new Font("Tahoma", 1, 11));
        this.lblDescPunktart.setText("Punktart:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblDescPunktart, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.pointtype.bezeichnung}"), (Object)this.lblTxtPunktart, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblTxtPunktart, gridBagConstraints);
        this.lblDescPunktkennung.setFont(new Font("Tahoma", 1, 11));
        this.lblDescPunktkennung.setText("Punktkennung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblDescPunktkennung, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.marker}"), (Object)this.lblTxtAbmarkungMarke, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblTxtAbmarkungMarke, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.beginn}"), (Object)this.lblTxtBeginn, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblTxtBeginn, gridBagConstraints);
        this.lblDescModellart.setFont(new Font("Tahoma", 1, 11));
        this.lblDescModellart.setText("Modellart:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblDescModellart, gridBagConstraints);
        this.lblDescLand.setFont(new Font("Tahoma", 1, 11));
        this.lblDescLand.setText("Land:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblDescLand, gridBagConstraints);
        this.lblDescDienststelle.setFont(new Font("Tahoma", 1, 11));
        this.lblDescDienststelle.setText("Dienststelle:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblDescDienststelle, gridBagConstraints);
        this.lblDescBeginn.setFont(new Font("Tahoma", 1, 11));
        this.lblDescBeginn.setText("Lebenszeit-Beginn:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblDescBeginn, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.modellart}"), (Object)this.lblTxtModellart, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblTxtModellart, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.land}"), (Object)this.lblTxtLand, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblTxtLand, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.dienststelle}"), (Object)this.lblTxtDienststelle, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblTxtDienststelle, gridBagConstraints);
        this.lblDescEnde.setFont(new Font("Tahoma", 1, 11));
        this.lblDescEnde.setText("Lebenszeit-Ende:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblDescEnde, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.ende}"), (Object)this.lblTxtEnde, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblTxtEnde, gridBagConstraints);
        this.lblDescAnlass.setFont(new Font("Tahoma", 1, 11));
        this.lblDescAnlass.setText("Anlass:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblDescAnlass, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)ELProperty.create((String)"${cidsBean.anlass}"), (Object)this.lblTxtAnlass, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panPointInfo.add((Component)this.lblTxtAnlass, gridBagConstraints);
        this.srpPointInfo.setBackground(Color.darkGray);
        this.srpPointInfo.setLayout((LayoutManager)new GridBagLayout());
        this.lblPointHead.setForeground(new Color(255, 255, 255));
        this.lblPointHead.setText("Info");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.srpPointInfo.add((Component)this.lblPointHead, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panPointInfo.add((Component)this.srpPointInfo, gridBagConstraints);
        this.jPanel3.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        this.panPointInfo.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.panInfo.add((Component)this.panPointInfo, gridBagConstraints);
        this.panLocationInfos.setMaximumSize(new Dimension(500, 500));
        this.panLocationInfos.setMinimumSize(new Dimension(500, 500));
        this.panLocationInfos.setOpaque(false);
        this.panLocationInfos.setPreferredSize(new Dimension(500, 500));
        this.panLocationInfos.setLayout(new GridBagLayout());
        this.cbPunktorte.setMaximumSize(new Dimension(200, 20));
        this.cbPunktorte.setMinimumSize(new Dimension(200, 20));
        this.cbPunktorte.setPreferredSize(new Dimension(200, 20));
        ELProperty eLProperty = ELProperty.create((String)"${pointLocations}");
        JComboBoxBinding jComboBoxBinding = SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this, (Property)eLProperty, (JComboBox)this.cbPunktorte);
        jComboBoxBinding.setSourceNullValue(null);
        jComboBoxBinding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)jComboBoxBinding);
        this.cbPunktorte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointRenderer.this.cbPunktorteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 7, 7, 7);
        this.panLocationInfos.add((Component)this.cbPunktorte, gridBagConstraints);
        this.lblDescKartendarstellung.setFont(new Font("Tahoma", 1, 11));
        this.lblDescKartendarstellung.setText("Kartendarstellung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescKartendarstellung, gridBagConstraints);
        this.lblDescRechtswert.setFont(new Font("Tahoma", 1, 11));
        this.lblDescRechtswert.setText("Rechtswert:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescRechtswert, gridBagConstraints);
        this.lblDescHochwert.setFont(new Font("Tahoma", 1, 11));
        this.lblDescHochwert.setText("Hochwert:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescHochwert, gridBagConstraints);
        this.lblDescDatenerhebung.setFont(new Font("Tahoma", 1, 11));
        this.lblDescDatenerhebung.setText("Datenerhebung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescDatenerhebung, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.rechtswert}"), (Object)this.lblTxtRechtswert, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtRechtswert, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.hochwert}"), (Object)this.lblTxtHochwert, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtHochwert, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.hinweis}"), (Object)this.lblTxtHinweise, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtHinweise, gridBagConstraints);
        this.lblDescKoordStatus.setFont(new Font("Tahoma", 1, 11));
        this.lblDescKoordStatus.setText("Koordinatenstatus:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescKoordStatus, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.koordinatenStatusName}"), (Object)this.lblTxtKoordStatus, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtKoordStatus, gridBagConstraints);
        this.lblDescGenauigkeitsstufe.setFont(new Font("Tahoma", 1, 11));
        this.lblDescGenauigkeitsstufe.setText("Genauigkeitsstufe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescGenauigkeitsstufe, gridBagConstraints);
        this.lblDescHinweise.setFont(new Font("Tahoma", 1, 11));
        this.lblDescHinweise.setText("Hinweise:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescHinweise, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.qualitaetsangabenGenauigkeitsstufeName}"), (Object)this.lblTxtGenauigkeitsstufe, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtGenauigkeitsstufe, gridBagConstraints);
        this.lblTxtDatenerhebung.setVerticalAlignment(3);
        this.lblTxtDatenerhebung.setVerticalTextPosition(1);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.qualitaetsangabenHerkunft}"), (Object)this.lblTxtDatenerhebung, (Property)BeanProperty.create((String)"text"));
        binding.setConverter(ALKIS_ERHEBUNG_CONVERTER);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtDatenerhebung, gridBagConstraints);
        this.srpHeadLocInfo.setBackground(Color.darkGray);
        this.srpHeadLocInfo.setLayout((LayoutManager)new GridBagLayout());
        this.lblLocHead.setForeground(new Color(255, 255, 255));
        this.lblLocHead.setText("Punktorte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.srpHeadLocInfo.add((Component)this.lblLocHead, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panLocationInfos.add((Component)this.srpHeadLocInfo, gridBagConstraints);
        this.lblDescPunktorte.setFont(new Font("Tahoma", 1, 11));
        this.lblDescPunktorte.setText("Koordinatensystem:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(14, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescPunktorte, gridBagConstraints);
        this.lblDescPOModellart.setFont(new Font("Tahoma", 1, 11));
        this.lblDescPOModellart.setText("Modellart:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescPOModellart, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.modellArt}"), (Object)this.lblTxtPOModellart, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtPOModellart, gridBagConstraints);
        this.lblDescPOAnlass.setFont(new Font("Tahoma", 1, 11));
        this.lblDescPOAnlass.setText("Anlass:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescPOAnlass, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.anlass}"), (Object)this.lblTxtPOAnlass, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtPOAnlass, gridBagConstraints);
        this.lblDescPOBeginn.setFont(new Font("Tahoma", 1, 11));
        this.lblDescPOBeginn.setText("Lebenszeit-Beginn:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescPOBeginn, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.lebenszeitIntervallBeginnt}"), (Object)this.lblTxtPOBeginn, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtPOBeginn, gridBagConstraints);
        this.lblDescPOEnde.setFont(new Font("Tahoma", 1, 11));
        this.lblDescPOEnde.setText("Lebenszeit-Ende:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescPOEnde, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.lebenszeitIntervallEndet}"), (Object)this.lblTxtPOEnde, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtPOEnde, gridBagConstraints);
        this.jPanel4.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        this.panLocationInfos.add((Component)this.jPanel4, gridBagConstraints);
        this.lblDescPLIdentifikator.setFont(new Font("Tahoma", 1, 11));
        this.lblDescPLIdentifikator.setText("Identifikator:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescPLIdentifikator, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.uuid}"), (Object)this.lblTxtPLIdentifikator, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtPLIdentifikator, gridBagConstraints);
        this.lblDescPLObjektart.setFont(new Font("Tahoma", 1, 11));
        this.lblDescPLObjektart.setText("Objektart:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblDescPLObjektart, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.pointLocationType}"), (Object)this.lblTxtPLObjektart, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtPLObjektart, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.cbPunktorte, (Property)ELProperty.create((String)"${selectedItem.kartendarstellung}"), (Object)this.lblTxtKartendarstellung, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"keine Angabe");
        binding.setSourceUnreadableValue((Object)"<Error>");
        binding.setConverter(ALKIS_BOOLEAN_CONVERTER);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        this.panLocationInfos.add((Component)this.lblTxtKartendarstellung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.panInfo.add((Component)this.panLocationInfos, gridBagConstraints);
        this.add((Component)this.panInfo, CARD_1);
        this.panProducts.setOpaque(false);
        this.panProducts.setLayout(new GridBagLayout());
        this.panPdfProducts.setMaximumSize(new Dimension(175, 80));
        this.panPdfProducts.setMinimumSize(new Dimension(175, 80));
        this.panPdfProducts.setOpaque(false);
        this.panPdfProducts.setPreferredSize(new Dimension(175, 80));
        this.panPdfProducts.setLayout(new GridBagLayout());
        this.hlPunktlistePdf.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/pdf.png")));
        this.hlPunktlistePdf.setText("Punktliste");
        this.hlPunktlistePdf.setToolTipText("Punktliste f\u00fcr Einzelpunkt (PDF)");
        this.hlPunktlistePdf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointRenderer.this.hlPunktlistePdfActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 7, 7, 7);
        this.panPdfProducts.add((Component)this.hlPunktlistePdf, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panPdfProducts.add((Component)this.jPanel1, gridBagConstraints);
        this.semiRoundedPanel4.setBackground(Color.darkGray);
        this.semiRoundedPanel4.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel4.setForeground(new Color(255, 255, 255));
        this.jLabel4.setText("PDF-Produkte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel4.add((Component)this.jLabel4, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panPdfProducts.add((Component)this.semiRoundedPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 9, 5);
        this.panProducts.add((Component)this.panPdfProducts, gridBagConstraints);
        this.panHtmlProducts.setMaximumSize(new Dimension(175, 80));
        this.panHtmlProducts.setMinimumSize(new Dimension(175, 80));
        this.panHtmlProducts.setOpaque(false);
        this.panHtmlProducts.setPreferredSize(new Dimension(175, 80));
        this.panHtmlProducts.setLayout(new GridBagLayout());
        this.hlPunktlisteHtml.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/text-html.png")));
        this.hlPunktlisteHtml.setText("Punktliste");
        this.hlPunktlisteHtml.setToolTipText("Punktliste f\u00fcr Einzelpunkt (HTML)");
        this.hlPunktlisteHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointRenderer.this.hlPunktlisteHtmlActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(17, 7, 7, 7);
        this.panHtmlProducts.add((Component)this.hlPunktlisteHtml, gridBagConstraints);
        this.jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panHtmlProducts.add((Component)this.jPanel2, gridBagConstraints);
        this.semiRoundedPanel5.setBackground(Color.darkGray);
        this.semiRoundedPanel5.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel5.setForeground(new Color(255, 255, 255));
        this.jLabel5.setText("HTML-Produkte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel5.add((Component)this.jLabel5, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panHtmlProducts.add((Component)this.semiRoundedPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 5, 5, 5);
        this.panProducts.add((Component)this.panHtmlProducts, gridBagConstraints);
        this.panTxtProducts.setMaximumSize(new Dimension(175, 80));
        this.panTxtProducts.setMinimumSize(new Dimension(175, 80));
        this.panTxtProducts.setOpaque(false);
        this.panTxtProducts.setPreferredSize(new Dimension(175, 80));
        this.panTxtProducts.setLayout(new GridBagLayout());
        this.hlPunktlisteTxt.setIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/text-plain.png")));
        this.hlPunktlisteTxt.setText("Punktliste");
        this.hlPunktlisteTxt.setToolTipText("Punktliste f\u00fcr Einzelpunkt (TEXT)");
        this.hlPunktlisteTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointRenderer.this.hlPunktlisteTxtActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(17, 7, 7, 7);
        this.panTxtProducts.add((Component)this.hlPunktlisteTxt, gridBagConstraints);
        this.jPanel7.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panTxtProducts.add((Component)this.jPanel7, gridBagConstraints);
        this.semiRoundedPanel6.setBackground(Color.darkGray);
        this.semiRoundedPanel6.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel6.setForeground(new Color(255, 255, 255));
        this.jLabel6.setText("Textformat-Produkte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel6.add((Component)this.jLabel6, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panTxtProducts.add((Component)this.semiRoundedPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 5, 5, 5);
        this.panProducts.add((Component)this.panTxtProducts, gridBagConstraints);
        this.pnlControls.setLayout((LayoutManager)new GridBagLayout());
        this.bgrAPMapControls.add(this.togPan);
        this.togPan.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/pan.gif")));
        this.togPan.setSelected(true);
        this.togPan.setText("Verschieben");
        this.togPan.setToolTipText("Verschieben");
        this.togPan.setEnabled(false);
        this.togPan.setFocusPainted(false);
        this.togPan.setHorizontalAlignment(2);
        this.togPan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointRenderer.this.togPanActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 3, 5);
        this.pnlControls.add((Component)this.togPan, (Object)gridBagConstraints);
        this.bgrAPMapControls.add(this.togZoom);
        this.togZoom.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/zoom.gif")));
        this.togZoom.setText("Zoomen");
        this.togZoom.setToolTipText("Zoomen");
        this.togZoom.setEnabled(false);
        this.togZoom.setFocusPainted(false);
        this.togZoom.setHorizontalAlignment(2);
        this.togZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointRenderer.this.togZoomActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 3, 5);
        this.pnlControls.add((Component)this.togZoom, (Object)gridBagConstraints);
        this.btnHome.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/home.gif")));
        this.btnHome.setText("\u00dcbersicht");
        this.btnHome.setToolTipText("\u00dcbersicht");
        this.btnHome.setEnabled(false);
        this.btnHome.setFocusPainted(false);
        this.btnHome.setHorizontalAlignment(2);
        this.btnHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointRenderer.this.btnHomeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 3, 5);
        this.pnlControls.add((Component)this.btnHome, (Object)gridBagConstraints);
        this.semiRoundedPanel7.setBackground(new Color(51, 51, 51));
        this.semiRoundedPanel7.setLayout((LayoutManager)new FlowLayout());
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText("Steuerung");
        this.semiRoundedPanel7.add((Component)this.jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlControls.add((Component)this.semiRoundedPanel7, (Object)gridBagConstraints);
        this.btnOpen.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/folder-image.png")));
        this.btnOpen.setText("\u00d6ffnen");
        this.btnOpen.setToolTipText("Download zum \u00d6ffnen in externer Anwendung");
        this.btnOpen.setEnabled(false);
        this.btnOpen.setFocusPainted(false);
        this.btnOpen.setHorizontalAlignment(2);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlkisPointRenderer.this.btnOpenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.pnlControls.add((Component)this.btnOpen, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.panProducts.add((Component)this.pnlControls, gridBagConstraints);
        this.pnlContent.setOpaque(false);
        this.pnlContent.setLayout(new CardLayout());
        this.panProductPreview.setOpaque(false);
        this.panProductPreview.setLayout(new BorderLayout());
        this.lblProductPreview.setHorizontalAlignment(0);
        this.lblProductPreview.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.panProductPreview.add((Component)this.lblProductPreview, "Center");
        this.semiRoundedPanel3.setBackground(Color.darkGray);
        this.semiRoundedPanel3.setLayout((LayoutManager)new GridBagLayout());
        this.lblPreviewHead.setText("Vorschau");
        this.lblPreviewHead.setForeground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel3.add((Component)this.lblPreviewHead, (Object)gridBagConstraints);
        this.panProductPreview.add((Component)this.semiRoundedPanel3, "North");
        this.pnlContent.add((Component)this.panProductPreview, CARD_PREVIEW);
        this.pnlAPMap.setLayout((LayoutManager)new GridBagLayout());
        this.pnlHeaderAPMap.setBackground(Color.darkGray);
        this.pnlHeaderAPMap.setLayout((LayoutManager)new GridBagLayout());
        this.lblHeaderAPMap.setForeground(Color.white);
        this.lblHeaderAPMap.setText("AP-Karte");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlHeaderAPMap.add((Component)this.lblHeaderAPMap, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        this.pnlAPMap.add((Component)this.pnlHeaderAPMap, (Object)gridBagConstraints);
        this.lblMissingAPMap.setBackground(Color.white);
        this.lblMissingAPMap.setHorizontalAlignment(0);
        this.lblMissingAPMap.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/missingRasterdocument.png")));
        this.lblMissingAPMap.setText("<html><body><strong>Zu diesem ALKIS-Punkt wurde keine<br />AP-Karte gefunden.</strong></body></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.pnlAPMap.add((Component)this.lblMissingAPMap, (Object)gridBagConstraints);
        this.pnlContent.add((Component)this.pnlAPMap, CARD_APMAP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.pnlAPMap.add((Component)this.rasterfariLoader, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panProducts.add((Component)this.pnlContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.panProducts.add((Component)this.gluFiller, gridBagConstraints);
        this.add((Component)this.panProducts, CARD_2);
        this.bindingGroup.bind();
    }

    private void btnRetrieveActionPerformed(ActionEvent evt) {
        String pointCode;
        CidsBean bean = this.cidsBean;
        if (bean != null && (pointCode = String.valueOf(bean.getProperty("pointcode"))) != null) {
            AlkisSOAPWorkerService.execute((Runnable)new RetrieveWorker(pointCode));
        }
    }

    private void lblBackMouseClicked(MouseEvent evt) {
        if (this.lblBack.isEnabled()) {
            this.btnBackActionPerformed(null);
        }
    }

    private void btnBackActionPerformed(ActionEvent evt) {
        this.cardLayout.show(this, CARD_1);
        this.btnBack.setEnabled(false);
        this.btnForward.setEnabled(true);
        this.lblBack.setEnabled(false);
        this.lblForw.setEnabled(true);
        this.lblTitle.setText(this.title);
    }

    private void btnForwardActionPerformed(ActionEvent evt) {
        this.cardLayout.show(this, CARD_2);
        this.btnBack.setEnabled(true);
        this.btnForward.setEnabled(false);
        this.lblBack.setEnabled(true);
        this.lblForw.setEnabled(false);
        this.lblTitle.setText("Produkte");
    }

    private void lblForwMouseClicked(MouseEvent evt) {
        if (this.lblForw.isEnabled()) {
            this.btnForwardActionPerformed(null);
        }
    }

    private void showNoProductPermissionWarning() {
        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Sie besitzen keine Berechtigung zur Erzeugung dieses Produkts!");
    }

    private void downloadProduct(String product) {
        if (!ObjectRendererUtils.checkActionTag(PRODUCT_ACTION_TAG_PUNKTLISTE, this.getConnectionContext())) {
            this.showNoProductPermissionWarning();
            return;
        }
        String extension = ".pdf";
        if (ClientAlkisProducts.getInstance().get(AlkisProducts.Type.PUNKTLISTE_HTML).equals(product)) {
            extension = ".html";
        } else if (ClientAlkisProducts.getInstance().get(AlkisProducts.Type.PUNKTLISTE_TXT).equals(product)) {
            extension = ".plst";
        }
        String pointData = ClientAlkisProducts.getPointDataForProduct((CidsBean)this.cidsBean);
        if (pointData != null && pointData.length() > 0) {
            try {
                if (!DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this)) {
                    return;
                }
                String title = "Punktnachweis";
                String filename = product;
                String directory = DownloadManagerDialog.getInstance().getJobName();
                ByteArrayActionDownload download = new ByteArrayActionDownload("alkisProduct", (Object)AlkisProductServerAction.Body.LISTENNACHWEIS, new ServerActionParameter[]{new ServerActionParameter(AlkisProductServerAction.Parameter.PRODUKT.toString(), (Object)product), new ServerActionParameter(AlkisProductServerAction.Parameter.ALKIS_CODE.toString(), (Object)pointData)}, "Punktnachweis", directory, filename, extension, this.connectionContext);
                DownloadManager.instance().add((Download)download);
            }
            catch (Exception ex) {
                ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Aufruf des Produkts: " + product, ex, this);
                LOG.error((Object)("The URL to download product '" + product + "' (actionTag: " + PRODUCT_ACTION_TAG_PUNKTLISTE + ") could not be constructed."), (Throwable)ex);
            }
        }
    }

    private void hlPunktlistePdfActionPerformed(ActionEvent evt) {
        try {
            if (BillingPopup.doBilling("pktlstpdf", "no.yet", (Geometry)null, this.getConnectionContext(), new BillingProductGroupAmount("ea", 1))) {
                this.downloadProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.PUNKTLISTE_PDF));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
        }
    }

    private void hlPunktlisteHtmlActionPerformed(ActionEvent evt) {
        this.downloadProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.PUNKTLISTE_HTML));
    }

    private void cbPunktorteActionPerformed(ActionEvent evt) {
        Object selection = this.cbPunktorte.getSelectedItem();
        if (selection instanceof PointLocation) {
            PointLocation pointLoc = (PointLocation)selection;
            if (pointLoc.getKartendarstellung() != null && pointLoc.getKartendarstellung().equals("1")) {
                this.cbPunktorte.setBackground(PUNKTORT_MIT_KARTENDARSTELLUNG);
            } else {
                this.cbPunktorte.setBackground(Color.WHITE);
            }
        }
    }

    private void hlPunktlisteTxtActionPerformed(ActionEvent evt) {
        try {
            if (BillingPopup.doBilling("pktlsttxt", "no.yet", (Geometry)null, this.getConnectionContext(), new BillingProductGroupAmount("eapkt_1000", 1))) {
                this.downloadProduct(ClientAlkisProducts.getInstance().get(AlkisProducts.Type.PUNKTLISTE_TXT));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
        }
    }

    private void togPanActionPerformed(ActionEvent evt) {
        this.rasterfariLoader.actionPan();
    }

    private void togZoomActionPerformed(ActionEvent evt) {
        this.rasterfariLoader.actionZoom();
    }

    private void btnHomeActionPerformed(ActionEvent evt) {
        this.rasterfariLoader.actionOverview();
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        if (this.documentOfAPMap != null) {
            URL url;
            try {
                url = new URL(this.documentOfAPMap);
            }
            catch (Exception ex) {
                LOG.info((Object)("Couldn't download AP map from '" + this.documentOfAPMap + "'."), (Throwable)ex);
                return;
            }
            try {
                if (BillingPopup.doBilling("appdf", url.toString(), (Geometry)null, this.getConnectionContext(), new BillingProductGroupAmount("ea", 1))) {
                    CismetThreadPool.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)AlkisPointRenderer.this)) {
                                String filename = AlkisPointRenderer.this.documentOfAPMap.substring(AlkisPointRenderer.this.documentOfAPMap.lastIndexOf("/") + 1);
                                DownloadManager.instance().add((Download)new HttpDownload(url, "", DownloadManagerDialog.getInstance().getJobName(), "AP-Karte", filename.substring(0, filename.lastIndexOf(".")), filename.substring(filename.lastIndexOf("."))));
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error when trying to produce a alkis product", (Throwable)e);
            }
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public static boolean hasAPMap(CidsBean alkisPoint) {
        boolean result = false;
        Object pointtype = alkisPoint.getProperty("pointtype.bezeichnung");
        if (pointtype instanceof String && (POINTTYPE_AUFNAHMEPUNKT.equalsIgnoreCase(pointtype.toString()) || POINTTYPE_SONSTIGERVERMESSUNGSPUNKT.equalsIgnoreCase(pointtype.toString()))) {
            result = true;
        }
        return result;
    }

    public void setCidsBean(CidsBean cb) {
        this.bindingGroup.unbind();
        if (cb != null) {
            this.cidsBean = cb;
            this.bindingGroup.bind();
            if (!AlkisPointRenderer.hasAPMap(this.cidsBean)) {
                this.pnlControls.setVisible(false);
                this.cardLayoutForContent.show(this.pnlContent, CARD_PREVIEW);
            } else {
                Object pointcode = this.cidsBean.getProperty("pointcode");
                if (pointcode != null) {
                    CismetThreadPool.execute((Runnable)new RefreshDocumentWorker(pointcode.toString()));
                } else {
                    LOG.error((Object)"The given CidsBean (alkis_point) has no pointcode.");
                }
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        title = title == null ? "<Error>" : "Punkt " + title;
        this.title = title;
        this.lblTitle.setText(this.title);
    }

    public Border getTitleBorder() {
        return new EmptyBorder(10, 10, 10, 10);
    }

    public Border getFooterBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public Border getCenterrBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public List<PointLocation> getPointLocations() {
        return this.pointLocations;
    }

    public void setPointLocations(List<PointLocation> pointLocations) {
        this.pointLocations = pointLocations;
    }

    public void dispose() {
        this.bindingGroup.unbind();
    }

    public static void main(String[] args) {
        try {
            DevelopmentTools.createRendererInFrameFromRMIConnectionOnLocalhost((String)"WUNDA_BLAU", (String)"Administratoren", (String)"admin", (String)"sb", (String)"alkis_point", (int)574043, (String)"ALKIS-Punkt-Renderer", (int)1024, (int)768);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void showMeasureIsLoading() {
    }

    public void showMeasurePanel() {
    }

    class RefreshDocumentWorker
    extends SwingWorker<String, Object> {
        private final String pointcode;

        public RefreshDocumentWorker(String pointcode) {
            this.pointcode = pointcode;
        }

        @Override
        protected String doInBackground() throws Exception {
            Collection validDocuments = ClientAlkisProducts.getInstance().getCorrespondingPointDocuments(this.pointcode);
            String document = null;
            for (String validDocument : validDocuments) {
                try {
                    URL url = ClientAlkisConf.getInstance().getDownloadUrlForDocument(validDocument);
                    if (!WebAccessManager.getInstance().checkIfURLaccessible(url)) continue;
                    document = validDocument;
                    AlkisPointRenderer.this.documentOfAPMap = url.toExternalForm();
                }
                catch (MissingArgumentException ex) {
                    LOG.warn((Object)("Could not read AP map from URL '" + validDocument + "'. Skipping this url."), (Throwable)ex);
                }
                catch (AccessMethodIsNotSupportedException ex) {
                    LOG.warn((Object)("Can't access AP map URL '" + validDocument + "' with default access method. Skipping this url."), (Throwable)ex);
                }
                catch (RequestFailedException ex) {
                    LOG.warn((Object)("Requesting AP map from URL '" + validDocument + "' failed. Skipping this url."), (Throwable)ex);
                }
                catch (NoHandlerForURLException ex) {
                    LOG.warn((Object)("Can't handle URL '" + validDocument + "'. Skipping this url."), (Throwable)ex);
                }
                catch (Exception ex) {
                    LOG.warn((Object)("An exception occurred while opening URL '" + validDocument + "'. Skipping this url."), (Throwable)ex);
                }
            }
            return document;
        }

        @Override
        protected void done() {
            String document = null;
            try {
                if (!this.isCancelled()) {
                    document = (String)this.get();
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)"Was interrupted while refreshing AP map.", (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOG.warn((Object)"There was an exception while refreshing AP map.", (Throwable)ex);
            }
            AlkisPointRenderer.this.rasterfariLoader.reset();
            if (document != null && !this.isCancelled()) {
                AlkisPointRenderer.this.rasterfariLoader.setVisible(true);
                AlkisPointRenderer.this.lblMissingAPMap.setVisible(false);
                AlkisPointRenderer.this.rasterfariLoader.setDocument(document);
                AlkisPointRenderer.this.btnHome.setEnabled(true);
                AlkisPointRenderer.this.btnOpen.setEnabled(true);
                AlkisPointRenderer.this.togPan.setEnabled(true);
                AlkisPointRenderer.this.togZoom.setEnabled(true);
            } else {
                AlkisPointRenderer.this.rasterfariLoader.setVisible(false);
                AlkisPointRenderer.this.lblMissingAPMap.setVisible(true);
                AlkisPointRenderer.this.btnHome.setEnabled(false);
                AlkisPointRenderer.this.btnOpen.setEnabled(false);
                AlkisPointRenderer.this.togPan.setEnabled(false);
                AlkisPointRenderer.this.togZoom.setEnabled(false);
            }
        }
    }

    class ProductLabelMouseAdaper
    extends MouseAdapter {
        ProductLabelMouseAdaper() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Object srcObj = e.getSource();
            ImageIcon imageIcon = (ImageIcon)AlkisPointRenderer.this.productPreviewImages.get(srcObj);
            if (imageIcon != null) {
                AlkisPointRenderer.this.lblProductPreview.setIcon(imageIcon);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AlkisPointRenderer.this.lblProductPreview.setIcon(null);
        }
    }

    static final class LocationComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public LocationComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(Color.WHITE);
                this.setForeground(list.getForeground());
            }
            if (value instanceof PointLocation) {
                PointLocation loc = (PointLocation)value;
                this.setText(loc.getKoordinatenReferenzSystem());
                if (loc.getKartendarstellung() != null && loc.getKartendarstellung().equals("1") && !isSelected) {
                    this.setBackground(PUNKTORT_MIT_KARTENDARSTELLUNG);
                }
            } else {
                this.setText(value == null ? "" : value.toString());
            }
            return this;
        }
    }

    final class RetrieveWorker
    extends SwingWorker<Point, Void> {
        private final String pointCode;

        public RetrieveWorker(String pointCode) {
            AlkisPointRenderer.this.setWait(true);
            this.pointCode = pointCode;
            AlkisPointRenderer.this.btnRetrieve.setEnabled(false);
        }

        @Override
        protected Point doInBackground() throws Exception {
            return ClientAlkisRestUtils.getPoint(this.pointCode, AlkisPointRenderer.this.getConnectionContext());
        }

        private void restoreOnException() {
            AlkisPointRenderer.this.btnRetrieve.setEnabled(true);
        }

        @Override
        protected void done() {
            AlkisPointRenderer.this.setWait(false);
            if (!this.isCancelled()) {
                try {
                    Point point = (Point)this.get();
                    if (point != null) {
                        AlkisPointRenderer.this.setPoint(point);
                        List pointlocArr = point.getPointLocations();
                        if (pointlocArr != null) {
                            ArrayList<PointLocation> sortedPointlocArr = new ArrayList<PointLocation>(pointlocArr);
                            sortedPointlocArr.sort(POINTLOCATION_COMPARATOR);
                            AlkisPointRenderer.this.setPointLocations(sortedPointlocArr);
                        }
                        AlkisPointRenderer.this.bindingGroup.unbind();
                        AlkisPointRenderer.this.bindingGroup.bind();
                        AlkisPointRenderer.this.panLocationInfos.setVisible(true);
                    }
                }
                catch (InterruptedException ex) {
                    this.restoreOnException();
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                catch (Exception ex) {
                    this.restoreOnException();
                    ErrorInfo ei = new ErrorInfo("Fehler beim Retrieve", ex.getMessage(), null, null, (Throwable)ex, Level.ALL, null);
                    JXErrorPane.showDialog((Component)StaticSwingTools.getParentFrame((Component)AlkisPointRenderer.this), (ErrorInfo)ei);
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }
    }
}

