/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.custom.deprecated.CoolTabPanel;
import de.cismet.cids.custom.deprecated.JBreakLabel;
import de.cismet.cids.custom.deprecated.TabbedPaneUITransparent;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class Bplan_verfahrenRenderer
extends JPanel
implements CidsBeanRenderer,
ChangeListener,
RequestsFullSizeComponent {
    private static final String TITLE = "Bebauungsplanverfahren";
    private static final int HISTORIE_INDEX = 1;
    private static int lastSelected = 0;
    private static Date timer = new Date();
    private static final Logger LOG = Logger.getLogger(Bplan_verfahrenRenderer.class);
    private CidsBean cidsBean;
    private Object historie = null;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel9;
    private JLabel lblAlkRelevant;
    private JLabel lblNummer;
    private JLabel lblStatus;
    private JPanel panAlkis;
    private JPanel panAllgemein;
    private JPanel panContent;
    private DefaultPreviewMapPanel panPreviewMap;
    private JPanel panTabAlkis;
    private JPanel panTabAllgemein;
    private JTabbedPane tabbedPane;
    private JTextArea txtBezeichnung;
    private BindingGroup bindingGroup;

    public Bplan_verfahrenRenderer() {
        this.initComponents();
        this.tabbedPane.addChangeListener(this);
        if (new Date().getTime() - timer.getTime() < 60000L) {
            this.tabbedPane.setSelectedIndex(lastSelected);
        }
        this.assignSingle();
    }

    public void assignSingle() {
        if (this.historie == null) {
            this.tabbedPane.removeTabAt(1);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panContent = new JPanel();
        this.panPreviewMap = new DefaultPreviewMapPanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setUI(new TabbedPaneUITransparent());
        this.panTabAllgemein = new CoolTabPanel();
        this.panAllgemein = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.lblNummer = new JBreakLabel();
        this.lblStatus = new JLabel();
        this.txtBezeichnung = new JTextArea();
        this.panTabAlkis = new CoolTabPanel();
        this.panAlkis = new JPanel();
        this.jLabel9 = new JLabel();
        this.lblAlkRelevant = new JLabel();
        this.setMinimumSize(new Dimension(400, 300));
        this.setLayout(new BorderLayout());
        this.panContent.setOpaque(false);
        this.panContent.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.panContent.add((Component)this.panPreviewMap, gridBagConstraints);
        this.tabbedPane.setTabPlacement(2);
        this.tabbedPane.setFont(new Font("Tahoma", 1, 11));
        this.panTabAllgemein.setOpaque(false);
        this.panTabAllgemein.setLayout(new FlowLayout(0, 10, 5));
        this.panAllgemein.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panAllgemein.setOpaque(false);
        this.panAllgemein.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Nummer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 30);
        this.panAllgemein.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Bezeichnung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 30);
        this.panAllgemein.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName("Bezeichnung");
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Status:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 30);
        this.panAllgemein.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName("Status");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.nummer}"), (Object)this.lblNummer, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.panAllgemein.add((Component)this.lblNummer, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.status}"), (Object)this.lblStatus, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.panAllgemein.add((Component)this.lblStatus, gridBagConstraints);
        this.txtBezeichnung.setEditable(false);
        this.txtBezeichnung.setColumns(30);
        this.txtBezeichnung.setLineWrap(true);
        this.txtBezeichnung.setRows(1);
        this.txtBezeichnung.setToolTipText("");
        this.txtBezeichnung.setWrapStyleWord(true);
        this.txtBezeichnung.setBorder(null);
        this.txtBezeichnung.setOpaque(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtBezeichnung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.panAllgemein.add((Component)this.txtBezeichnung, gridBagConstraints);
        this.panTabAllgemein.add(this.panAllgemein);
        this.tabbedPane.addTab("Allgemein", this.panTabAllgemein);
        this.panTabAlkis.setOpaque(false);
        this.panTabAlkis.setLayout(new FlowLayout(0, 10, 5));
        this.panAlkis.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panAlkis.setOpaque(false);
        this.panAlkis.setLayout(new GridBagLayout());
        this.jLabel9.setFont(new Font("Tahoma", 1, 11));
        this.jLabel9.setText("ALKIS relevant");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 30);
        this.panAlkis.add((Component)this.jLabel9, gridBagConstraints);
        this.lblAlkRelevant.setText("ja/nein");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panAlkis.add((Component)this.lblAlkRelevant, gridBagConstraints);
        this.panTabAlkis.add(this.panAlkis);
        this.tabbedPane.addTab("Historie", this.panTabAlkis);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 10);
        this.panContent.add((Component)this.tabbedPane, gridBagConstraints);
        this.add((Component)this.panContent, "Center");
        this.bindingGroup.bind();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        lastSelected = this.tabbedPane.getSelectedIndex();
        timer = new Date();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            this.panPreviewMap.initMap(cidsBean, "geometrie.geo_field");
            this.bindingGroup.bind();
        }
    }

    public void dispose() {
        this.bindingGroup.unbind();
    }

    public String getTitle() {
        String title = this.cidsBean.toString();
        if (title != null) {
            if (title.length() > 50) {
                title = title.substring(0, 50);
                title = title + "...";
            }
            title = "Bebauungsplanverfahren - " + title;
        } else {
            title = TITLE;
        }
        return title;
    }

    public void setTitle(String title) {
    }
}

