/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objectrenderer.converter.SQLDateToStringConverter;
import de.cismet.cids.custom.objectrenderer.utils.ClientStaticProperties;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.wunda_blau.search.server.CidsAlkisSearchStatement;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.BorderProvider;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.TitleComponentProvider;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.util.NbBundle;

public class FlurstueckRenderer
extends JPanel
implements BorderProvider,
CidsBeanRenderer,
TitleComponentProvider,
FooterComponentProvider,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(FlurstueckRenderer.class);
    private CidsBean cidsBean;
    private String title;
    private MappingComponent map;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JLabel jLabel6;
    private JXHyperlink jXHyperlink1;
    private JXHyperlink jxhFortfuehrungsnummer;
    private JLabel lblDescFlur;
    private JLabel lblDescFlurstueck;
    private JLabel lblDescFortfuehrungsnummer;
    private JLabel lblDescGemarkung;
    private JLabel lblDescHist;
    private JLabel lblFlur;
    private JLabel lblFlurstueck;
    private JLabel lblGemarkung;
    private JLabel lblHist;
    private JLabel lblTitle;
    private JPanel panDescription;
    private JPanel panFlurstueckMap;
    private JPanel panFooter;
    private JPanel panMainInfo;
    private JPanel panTitle;
    private SemiRoundedPanel semiRoundedPanel2;
    private BindingGroup bindingGroup;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.map = new MappingComponent();
        this.panFlurstueckMap.add((Component)this.map, "Center");
        this.jXHyperlink1.setVisible(false);
    }

    public void setCidsBean(CidsBean cb) {
        this.bindingGroup.unbind();
        if (cb != null) {
            this.cidsBean = cb;
            this.initMap();
            this.bindingGroup.bind();
            String z = String.valueOf(cb.getProperty("fstnr_z"));
            String n = String.valueOf(cb.getProperty("fstnr_n"));
            String result = z;
            if (n != null && !n.trim().equals("0") && n.trim().length() != 0) {
                result = result + "/" + n;
            }
            this.lblFlurstueck.setText(result);
            String fnr = String.valueOf(this.cidsBean.getProperty("fortfuehrungsnummer"));
            if (this.cidsBean.getProperty("fortfuehrungsnummer") != null && fnr != null && fnr.trim().length() > 0) {
                try {
                    String f = fnr.substring(0, 6) + "-" + fnr.substring(6, fnr.length());
                    this.jxhFortfuehrungsnummer.setText(f);
                }
                catch (Exception e) {
                    LOG.warn((Object)("fnr problem: " + fnr), (Throwable)e);
                    this.jxhFortfuehrungsnummer.setText(fnr);
                }
            }
            this.title = "Flurst\u00fcck " + this.lblFlurstueck.getText();
            this.lblTitle.setText(this.title);
        }
        if (this.lblHist.getText().trim().equals("----")) {
            this.jXHyperlink1.setVisible(true);
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.panFooter = new JPanel();
        this.jXHyperlink1 = new JXHyperlink();
        this.panDescription = new JPanel();
        this.panMainInfo = new RoundedPanel();
        this.lblFlurstueck = new JLabel();
        this.lblDescFlurstueck = new JLabel();
        this.lblDescFlur = new JLabel();
        this.lblFlur = new JLabel();
        this.lblDescGemarkung = new JLabel();
        this.lblGemarkung = new JLabel();
        this.lblDescHist = new JLabel();
        this.lblDescFortfuehrungsnummer = new JLabel();
        this.semiRoundedPanel2 = new SemiRoundedPanel();
        this.jLabel6 = new JLabel();
        this.lblHist = new JLabel();
        this.jxhFortfuehrungsnummer = new JXHyperlink();
        this.panFlurstueckMap = new JPanel();
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 18));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setText(NbBundle.getMessage(FlurstueckRenderer.class, (String)"FlurstueckRenderer.lblTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.panFooter.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.jXHyperlink1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jXHyperlink1.setForeground(new Color(204, 204, 204));
        this.jXHyperlink1.setText(NbBundle.getMessage(FlurstueckRenderer.class, (String)"FlurstueckRenderer.jXHyperlink1.text"));
        this.jXHyperlink1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckRenderer.this.jXHyperlink1ActionPerformed(evt);
            }
        });
        this.panFooter.add((Component)this.jXHyperlink1, new GridBagConstraints());
        this.setLayout(new BorderLayout());
        this.panDescription.setOpaque(false);
        this.panDescription.setLayout(new GridBagLayout());
        this.panMainInfo.setLayout(new GridBagLayout());
        this.lblFlurstueck.setText(NbBundle.getMessage(FlurstueckRenderer.class, (String)"FlurstueckRenderer.lblFlurstueck.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 5, 10);
        this.panMainInfo.add((Component)this.lblFlurstueck, gridBagConstraints);
        this.lblDescFlurstueck.setFont(new Font("Tahoma", 1, 11));
        this.lblDescFlurstueck.setText(NbBundle.getMessage(FlurstueckRenderer.class, (String)"FlurstueckRenderer.lblDescFlurstueck.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panMainInfo.add((Component)this.lblDescFlurstueck, gridBagConstraints);
        this.lblDescFlur.setFont(new Font("Tahoma", 1, 11));
        this.lblDescFlur.setText(NbBundle.getMessage(FlurstueckRenderer.class, (String)"FlurstueckRenderer.lblDescFlur.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panMainInfo.add((Component)this.lblDescFlur, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.flur}"), (Object)this.lblFlur, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"----");
        binding.setSourceUnreadableValue((Object)"----");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 5, 10);
        this.panMainInfo.add((Component)this.lblFlur, gridBagConstraints);
        this.lblDescGemarkung.setFont(new Font("Tahoma", 1, 11));
        this.lblDescGemarkung.setText(NbBundle.getMessage(FlurstueckRenderer.class, (String)"FlurstueckRenderer.lblDescGemarkung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 5, 5);
        this.panMainInfo.add((Component)this.lblDescGemarkung, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.gemarkungs_nr.name}"), (Object)this.lblGemarkung, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"----");
        binding.setSourceUnreadableValue((Object)"----");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 6, 5, 10);
        this.panMainInfo.add((Component)this.lblGemarkung, gridBagConstraints);
        this.lblDescHist.setFont(new Font("Tahoma", 1, 11));
        this.lblDescHist.setText(NbBundle.getMessage(FlurstueckRenderer.class, (String)"FlurstueckRenderer.lblDescHist.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panMainInfo.add((Component)this.lblDescHist, gridBagConstraints);
        this.lblDescFortfuehrungsnummer.setFont(new Font("Tahoma", 1, 11));
        this.lblDescFortfuehrungsnummer.setText(NbBundle.getMessage(FlurstueckRenderer.class, (String)"FlurstueckRenderer.lblDescFortfuehrungsnummer.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.panMainInfo.add((Component)this.lblDescFortfuehrungsnummer, gridBagConstraints);
        this.semiRoundedPanel2.setBackground(Color.darkGray);
        this.semiRoundedPanel2.setLayout((LayoutManager)new GridBagLayout());
        this.jLabel6.setText(NbBundle.getMessage(FlurstueckRenderer.class, (String)"FlurstueckRenderer.jLabel6.text"));
        this.jLabel6.setForeground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.semiRoundedPanel2.add((Component)this.jLabel6, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.panMainInfo.add((Component)this.semiRoundedPanel2, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.historisch}"), (Object)this.lblHist, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"----");
        binding.setSourceUnreadableValue((Object)"----");
        binding.setConverter((Converter)new SQLDateToStringConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 5, 10);
        this.panMainInfo.add((Component)this.lblHist, gridBagConstraints);
        this.jxhFortfuehrungsnummer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlurstueckRenderer.this.jxhFortfuehrungsnummerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 30);
        this.panMainInfo.add((Component)this.jxhFortfuehrungsnummer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.panDescription.add((Component)this.panMainInfo, gridBagConstraints);
        this.panFlurstueckMap.setBorder(BorderFactory.createEtchedBorder());
        this.panFlurstueckMap.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.panDescription.add((Component)this.panFlurstueckMap, gridBagConstraints);
        this.add((Component)this.panDescription, "Center");
        this.bindingGroup.bind();
    }

    private void jxhFortfuehrungsnummerActionPerformed(ActionEvent evt) {
        String fnr = String.valueOf(this.cidsBean.getProperty("fortfuehrungsnummer"));
        if (this.cidsBean.getProperty("fortfuehrungsnummer") != null && fnr != null && fnr.trim().length() > 0) {
            try {
                Date d = (Date)this.cidsBean.getProperty("historisch");
                SimpleDateFormat formater = new SimpleDateFormat("yyyy");
                String year = formater.format(d);
                String laufendeNr = fnr.substring(6, fnr.length());
                String documentName = "FN_" + year + "_" + this.cidsBean.getProperty("gemarkungs_nr.gemarkungsnummer") + "_" + laufendeNr;
                String prefix = ClientStaticProperties.getInstance().getFortfuehrungsnachweiseUrlPrefix();
                if (prefix == null) {
                    prefix = "file://///S102gs/_102-alkis-dokumente/Fortf\u00fchrungsnachweise/";
                }
                BrowserLauncher.openURLorFile((String)(prefix + year + "/" + documentName + ".pdf"));
            }
            catch (Exception e) {
                LOG.error((Object)"Hier muss noch ne Messagebox hin", (Throwable)e);
            }
        }
    }

    private void jXHyperlink1ActionPerformed(ActionEvent evt) {
        SwingWorker<MetaObjectNode, Void> searchWorker = new SwingWorker<MetaObjectNode, Void>(){

            @Override
            protected MetaObjectNode doInBackground() throws Exception {
                return FlurstueckRenderer.searchAlkisLandparcel(FlurstueckRenderer.this.cidsBean, FlurstueckRenderer.this.getConnectionContext());
            }

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        MetaObjectNode mon = (MetaObjectNode)this.get();
                        ComponentRegistry.getRegistry().getDescriptionPane().gotoMetaObjectNode(mon);
                    }
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        };
        CismetThreadPool.execute((Runnable)searchWorker);
    }

    public static MetaObjectNode searchAlkisLandparcel(CidsBean fsBean, ConnectionContext context) throws Exception {
        String z = String.valueOf(fsBean.getProperty("fstnr_z"));
        String n = String.valueOf(fsBean.getProperty("fstnr_n"));
        String zf = String.format("%05d", new Integer(z));
        String nf = String.format("%04d", new Integer(n));
        String f = zf;
        if (!nf.equals("0000")) {
            f = f + "/" + nf;
        }
        String fString = "05" + fsBean.getProperty("gemarkungs_nr.gemarkungsnummer") + "-" + fsBean.getProperty("flur") + "-" + f;
        CidsAlkisSearchStatement stmnt = new CidsAlkisSearchStatement(CidsAlkisSearchStatement.Resulttyp.FLURSTUECK, CidsAlkisSearchStatement.SucheUeber.FLURSTUECKSNUMMER, fString, null);
        Collection nodes = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)stmnt, context);
        return nodes != null && !nodes.isEmpty() ? (MetaObjectNode)nodes.iterator().next() : null;
    }

    private void initMap() {
        Object geoObj = this.cidsBean.getProperty("umschreibendes_rechteck");
        if (geoObj instanceof Geometry) {
            final Geometry pureGeom = CrsTransformer.transformToGivenCrs((Geometry)((Geometry)geoObj), (String)ClientAlkisConf.getInstance().getSrsService());
            final BoundingBox box = new BoundingBox(pureGeom.getEnvelope().buffer(ClientAlkisConf.getInstance().getGeoBuffer()));
            Runnable mapRunnable = new Runnable(){

                @Override
                public void run() {
                    ActiveLayerModel mappingModel = new ActiveLayerModel();
                    mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
                    mappingModel.addHome(new XBoundingBox(box.getX1(), box.getY1(), box.getX2(), box.getY2(), ClientAlkisConf.getInstance().getSrsService(), true));
                    SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
                    swms.setName("Flurstueck");
                    DefaultStyledFeature dsf = new DefaultStyledFeature();
                    dsf.setGeometry(pureGeom);
                    dsf.setFillingPaint((Paint)new Color(1.0f, 0.0f, 0.0f, 0.5f));
                    mappingModel.addLayer((RetrievalServiceLayer)swms);
                    FlurstueckRenderer.this.map.setMappingModel((MappingModel)mappingModel);
                    int duration = FlurstueckRenderer.this.map.getAnimationDuration();
                    FlurstueckRenderer.this.map.setAnimationDuration(0);
                    FlurstueckRenderer.this.map.gotoInitialBoundingBox();
                    FlurstueckRenderer.this.map.setInteractionMode("ZOOM");
                    FlurstueckRenderer.this.map.unlock();
                    FlurstueckRenderer.this.map.addCustomInputListener("MUTE", new PBasicInputEventHandler(){

                        public void mouseClicked(PInputEvent evt) {
                            if (evt.getClickCount() > 1) {
                                CidsBean bean = FlurstueckRenderer.this.cidsBean;
                                ObjectRendererUtils.switchToCismapMap();
                                ObjectRendererUtils.addBeanGeomAsFeatureToCismapMap(bean, false);
                            }
                        }
                    });
                    FlurstueckRenderer.this.map.setInteractionMode("MUTE");
                    FlurstueckRenderer.this.map.getFeatureCollection().addFeature((Feature)dsf);
                    FlurstueckRenderer.this.map.setAnimationDuration(duration);
                }
            };
            if (EventQueue.isDispatchThread()) {
                mapRunnable.run();
            } else {
                EventQueue.invokeLater(mapRunnable);
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
    }

    public Border getTitleBorder() {
        return new EmptyBorder(10, 10, 10, 10);
    }

    public Border getFooterBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public Border getCenterrBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public void dispose() {
        this.bindingGroup.unbind();
        this.map.dispose();
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

