/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import de.cismet.cids.custom.objectrenderer.utils.ClientStaticProperties;
import de.cismet.cids.dynamics.CidsBean;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class PoiTools {
    private static final ImageIcon DEFAULT_ICON = PoiTools.getIconFromResourceString(ClientStaticProperties.getInstance().getPoiSignaturDefaultIcon());
    private static final Logger LOG = Logger.getLogger(PoiTools.class);

    public static ImageIcon createPoiIconFromFileName(String in) {
        if (in != null && in.length() > 0) {
            in = ClientStaticProperties.getInstance().getPoiSignaturUrlPrefix() + in + ClientStaticProperties.getInstance().getPoiSignaturUrlSuffix();
            try {
                URL symbolURL = Object.class.getResource(in);
                if (symbolURL == null) {
                    symbolURL = new URL(in);
                }
                if (symbolURL != null) {
                    return new ImageIcon(symbolURL);
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
        }
        return null;
    }

    public static ImageIcon getIconFromResourceString(String in) {
        if (in != null && in.length() > 0) {
            try {
                URL symbolURL = Object.class.getResource(in);
                if (symbolURL == null) {
                    symbolURL = new URL(in);
                }
                if (symbolURL != null) {
                    ImageIcon ret = new ImageIcon(symbolURL);
                    if (ret == null) {
                        LOG.error((Object)("could not create icon from :" + symbolURL));
                    }
                    return ret;
                }
                LOG.error((Object)("could not create icon from :" + symbolURL));
            }
            catch (Exception ex) {
                LOG.warn((Object)("Error in getSymbolFromResourceString(" + in + ")"), (Throwable)ex);
            }
        }
        return null;
    }

    public static ImageIcon getPoiSignatureIcon(CidsBean cidsBean) {
        String iconUrl = "";
        ImageIcon symbol = null;
        if (cidsBean != null) {
            Object o = cidsBean.getProperty("signatur");
            if (o instanceof CidsBean && (iconUrl = PoiTools.getUrlStringFromSignature(o)) != null) {
                symbol = PoiTools.getIconFromResourceString(iconUrl);
            }
            if (symbol == null) {
                CidsBean mainLocationType;
                o = cidsBean.getProperty("mainlocationtype");
                if (o instanceof CidsBean && (iconUrl = PoiTools.getUrlStringFromSignature(((CidsBean)o).getProperty("signatur"))) != null) {
                    symbol = PoiTools.getIconFromResourceString(iconUrl);
                }
                if (symbol == null && (o = cidsBean.getProperty("mainlocationtype")) instanceof CidsBean && (iconUrl = PoiTools.getUrlStringFromSignature(o = (mainLocationType = (CidsBean)o).getProperty("signatur"))) != null) {
                    symbol = PoiTools.getIconFromResourceString(iconUrl);
                }
                if (symbol == null) {
                    symbol = DEFAULT_ICON;
                }
            }
        }
        return symbol;
    }

    public static String getUrlStringFromSignature(Object signature) {
        if (signature instanceof CidsBean) {
            CidsBean signatur = (CidsBean)signature;
            try {
                Object fileName = signatur.getProperty("filename");
                if (fileName != null) {
                    String ret = ClientStaticProperties.getInstance().getPoiSignaturUrlPrefix() + fileName + ClientStaticProperties.getInstance().getPoiSignaturUrlSuffix();
                    LOG.info((Object)("Signatur Url: " + ret));
                    return ret;
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        return null;
    }
}

