/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import de.cismet.cids.custom.clientutils.StadtbilderUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.Image;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.SwingWorker;

public abstract class Sb_AbstractPictureGridObject
implements ConnectionContextProvider {
    private SwingWorker<Image, Void> worker;
    private LastShownImage lastShownImage;
    private boolean preview;
    private final ConnectionContext connectionContext;

    public Sb_AbstractPictureGridObject(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    protected abstract StadtbilderUtils.StadtbildInfo getStadtbildInfo();

    protected abstract int getDownloadPrority();

    protected abstract boolean isPreviewAllowed();

    protected abstract CidsBean getStadtbildserie();

    protected abstract void notifyModel();

    public Image getImage(int cellDimension, boolean invert) {
        StadtbilderUtils.StadtbildInfo stadtbildInfo = this.getStadtbildInfo();
        if (this.lastShownImage != null && this.lastShownImage.stadtbildInfo.equals(stadtbildInfo)) {
            Image imageToReturn = this.lastShownImage.image;
            if (this.lastShownImage.image == null) {
                return null;
            }
            return StadtbilderUtils.scaleImage(imageToReturn, cellDimension, invert);
        }
        int priority = this.getDownloadPrority();
        Object mightBeAnImage = StadtbilderUtils.fetchImageForBildnummer(this.getStadtbildserie(), stadtbildInfo, priority, this.getConnectionContext());
        if (mightBeAnImage instanceof Image) {
            this.lastShownImage = new LastShownImage(stadtbildInfo, (Image)mightBeAnImage);
            Image toReturn = (Image)mightBeAnImage;
            return StadtbilderUtils.scaleImage(toReturn, cellDimension, invert);
        }
        if (mightBeAnImage instanceof Future) {
            this.retrieveFutureImage((Future)mightBeAnImage, stadtbildInfo);
            return StadtbilderUtils.scaleImage(StadtbilderUtils.PLACEHOLDER_IMAGE, cellDimension, invert);
        }
        return null;
    }

    protected void setPreview(boolean preview) {
        this.preview = preview;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void retrieveFutureImage(final Future<Image> futureImage, final StadtbilderUtils.StadtbildInfo stadtbildInfo) {
        SwingWorker<Image, Void> worker;
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.worker = worker = new SwingWorker<Image, Void>(){

            @Override
            protected Image doInBackground() throws Exception {
                return (Image)futureImage.get();
            }

            @Override
            protected void done() {
                try {
                    Image image = (Image)this.get();
                    if (image != null) {
                        Sb_AbstractPictureGridObject.this.lastShownImage = new LastShownImage(stadtbildInfo, image);
                    } else {
                        Sb_AbstractPictureGridObject.this.lastShownImage = new LastShownImage(stadtbildInfo, null);
                    }
                }
                catch (InterruptedException ex) {
                    Sb_AbstractPictureGridObject.this.lastShownImage = new LastShownImage(stadtbildInfo, null);
                }
                catch (ExecutionException ex) {
                    Sb_AbstractPictureGridObject.this.lastShownImage = new LastShownImage(stadtbildInfo, null);
                }
                catch (CancellationException cancellationException) {
                }
                finally {
                    Sb_AbstractPictureGridObject.this.notifyModel();
                }
            }
        };
        worker.execute();
    }

    public void clearLastShownImage() {
        if (this.lastShownImage != null) {
            this.lastShownImage.stadtbildInfo = null;
            this.lastShownImage.image = null;
        }
    }

    private class LastShownImage {
        StadtbilderUtils.StadtbildInfo stadtbildInfo;
        Image image;

        public LastShownImage(StadtbilderUtils.StadtbildInfo stadtbildInfo, Image image) {
            this.stadtbildInfo = stadtbildInfo;
            this.image = image;
        }
    }
}

