/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import de.cismet.cids.custom.clientutils.Sb_RestrictionLevelUtils;
import de.cismet.cids.custom.clientutils.StadtbilderUtils;
import de.cismet.cids.custom.objecteditors.utils.Sb_StadtbildPreviewImage;
import de.cismet.cids.custom.objecteditors.utils.Sb_StadtbildserieProvider;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_stadtbildserieAggregationRenderer;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_stadtbildserieGridObject;
import de.cismet.cids.custom.objectrenderer.wunda_blau.Sb_stadtbildserieGridObjectListener;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class Sb_stadtbildserieAggregationRendererInfoPanel
extends JPanel
implements ListSelectionListener,
TableModelListener,
Sb_StadtbildserieProvider,
Sb_stadtbildserieGridObjectListener,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(Sb_stadtbildserieAggregationRendererInfoPanel.class);
    private static final String[] COLUMN_NAMES = new String[]{"Ausgew\u00e4hlt", "Bildnummer"};
    private static final boolean EDITABLE = false;
    private CidsBean stadtbildserie;
    private Sb_stadtbildserieAggregationRenderer aggregationRenderer;
    private Sb_RestrictionLevelUtils.RestrictionLevel restrictedLevel = new Sb_RestrictionLevelUtils.RestrictionLevel();
    private Sb_stadtbildserieGridObject gridObject;
    private final ConnectionContext connectionContext;
    private JButton btnInvertSelection;
    private JButton btnSelectAll;
    private JButton btnSelectNone;
    private Box.Filler filler1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JLabel lblAufnahmedatum;
    private JLabel lblStrasse;
    private JLabel lblSuchworte;
    private Sb_StadtbildPreviewImage previewImage;
    private RoundedPanel roundedPanel2;
    private RoundedPanel roundedPanel3;
    private SemiRoundedPanel semiRoundedPanel1;
    private JTable tblStadtbilder;

    public Sb_stadtbildserieAggregationRendererInfoPanel() {
        this(ConnectionContext.createDeprecated());
    }

    public Sb_stadtbildserieAggregationRendererInfoPanel(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void initComponents() {
        this.roundedPanel2 = new RoundedPanel();
        this.previewImage = new Sb_StadtbildPreviewImage(this.getConnectionContext());
        this.roundedPanel3 = new RoundedPanel();
        this.semiRoundedPanel1 = new SemiRoundedPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.lblAufnahmedatum = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tblStadtbilder = new JTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component c = super.prepareRenderer(renderer, row, col);
                if (Sb_stadtbildserieAggregationRendererInfoPanel.this.gridObject != null) {
                    c.setEnabled(!Sb_stadtbildserieAggregationRendererInfoPanel.this.gridObject.isIsInBin());
                }
                return c;
            }
        };
        this.jPanel1 = new JPanel();
        this.btnSelectNone = new JButton();
        this.btnSelectAll = new JButton();
        this.btnInvertSelection = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jLabel4 = new JLabel();
        this.lblSuchworte = new JLabel();
        this.jLabel6 = new JLabel();
        this.lblStrasse = new JLabel();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.roundedPanel2.setLayout((LayoutManager)new GridBagLayout());
        this.previewImage.setMinimumSize(new Dimension(140, 300));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel2.add((Component)this.previewImage, (Object)gridBagConstraints);
        this.previewImage.setBtnDownloadHighResImageVisible(false);
        this.previewImage.setTbtnIsPreviewImageVisible(false);
        this.roundedPanel3.setLayout((LayoutManager)new GridBagLayout());
        this.semiRoundedPanel1.setBackground(new Color(51, 51, 51));
        this.semiRoundedPanel1.setLayout((LayoutManager)new FlowLayout());
        this.jLabel1.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.jLabel1.text"));
        this.semiRoundedPanel1.add((Component)this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.roundedPanel3.add((Component)this.semiRoundedPanel1, (Object)gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel3.add((Component)this.jLabel2, (Object)gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel3.add((Component)this.jLabel3, (Object)gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblAufnahmedatum, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.lblAufnahmedatum.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel3.add((Component)this.lblAufnahmedatum, (Object)gridBagConstraints);
        this.lblAufnahmedatum.setVisible(false);
        this.tblStadtbilder.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Ausgew\u00e4hlt", "Bildnummer"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, Object.class};
                this.canEdit = new boolean[]{true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblStadtbilder.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.tblStadtbilder);
        this.tblStadtbilder.getSelectionModel().addListSelectionListener(this);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.tblStadtbilder.getModel());
        this.tblStadtbilder.setRowSorter(sorter);
        this.tblStadtbilder.setDefaultRenderer(Object.class, new CustomTableCellRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel3.add((Component)this.jScrollPane2, (Object)gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnSelectNone.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/table.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectNone, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.btnSelectNone.text"));
        this.btnSelectNone.setToolTipText(NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.btnSelectNone.toolTipText"));
        this.btnSelectNone.setBorderPainted(false);
        this.btnSelectNone.setContentAreaFilled(false);
        this.btnSelectNone.setFocusPainted(false);
        this.btnSelectNone.setMaximumSize(new Dimension(26, 26));
        this.btnSelectNone.setMinimumSize(new Dimension(26, 26));
        this.btnSelectNone.setPreferredSize(new Dimension(26, 26));
        this.btnSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_stadtbildserieAggregationRendererInfoPanel.this.btnSelectNoneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.jPanel1.add((Component)this.btnSelectNone, gridBagConstraints);
        this.btnSelectAll.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/table-select-all.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectAll, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.btnSelectAll.text"));
        this.btnSelectAll.setToolTipText(NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.btnSelectAll.toolTipText"));
        this.btnSelectAll.setBorderPainted(false);
        this.btnSelectAll.setContentAreaFilled(false);
        this.btnSelectAll.setFocusPainted(false);
        this.btnSelectAll.setMaximumSize(new Dimension(26, 26));
        this.btnSelectAll.setMinimumSize(new Dimension(26, 26));
        this.btnSelectAll.setPreferredSize(new Dimension(26, 26));
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_stadtbildserieAggregationRendererInfoPanel.this.btnSelectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.jPanel1.add((Component)this.btnSelectAll, gridBagConstraints);
        this.btnInvertSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/table_invert.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnInvertSelection, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.btnInvertSelection.text"));
        this.btnInvertSelection.setToolTipText(NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.btnInvertSelection.toolTipText"));
        this.btnInvertSelection.setBorderPainted(false);
        this.btnInvertSelection.setContentAreaFilled(false);
        this.btnInvertSelection.setFocusPainted(false);
        this.btnInvertSelection.setMaximumSize(new Dimension(26, 26));
        this.btnInvertSelection.setMinimumSize(new Dimension(26, 26));
        this.btnInvertSelection.setPreferredSize(new Dimension(26, 26));
        this.btnInvertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Sb_stadtbildserieAggregationRendererInfoPanel.this.btnInvertSelectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.jPanel1.add((Component)this.btnInvertSelection, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel3.add((Component)this.jPanel1, (Object)gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel3.add((Component)this.jLabel4, (Object)gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblSuchworte, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.lblSuchworte.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel3.add((Component)this.lblSuchworte, (Object)gridBagConstraints);
        this.lblSuchworte.setVisible(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel3.add((Component)this.jLabel6, (Object)gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblStrasse, (String)NbBundle.getMessage(Sb_stadtbildserieAggregationRendererInfoPanel.class, (String)"Sb_stadtbildserieAggregationRendererInfoPanel.lblStrasse.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel3.add((Component)this.lblStrasse, (Object)gridBagConstraints);
        this.lblStrasse.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.roundedPanel2.add((Component)this.roundedPanel3, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.roundedPanel2, gridBagConstraints);
    }

    private void btnSelectAllActionPerformed(ActionEvent evt) {
        if (this.gridObject != null) {
            this.gridObject.selectAllStadtbilder();
        }
    }

    private void btnSelectNoneActionPerformed(ActionEvent evt) {
        if (this.gridObject != null) {
            this.gridObject.deselectAllStadtbilder();
        }
    }

    private void btnInvertSelectionActionPerformed(ActionEvent evt) {
        if (this.gridObject != null) {
            for (CidsBean stadtbild : this.gridObject.getImagesToShow()) {
                this.gridObject.selectOrDeselectStadtbild(stadtbild);
            }
        }
    }

    private void setStadtbildserie(CidsBean stadtbildserie) {
        if (stadtbildserie != null) {
            this.stadtbildserie = stadtbildserie;
            this.restrictedLevel = Sb_RestrictionLevelUtils.determineRestrictionLevelForStadtbildserie(stadtbildserie, this.getConnectionContext());
            this.previewImage.setStadtbildserieProvider(this);
            this.refillTable(this.gridObject.getStadtbildUnderMarker());
            Timestamp aufnahmedatum = (Timestamp)stadtbildserie.getProperty("aufnahmedatum");
            DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
            String formattedDate = aufnahmedatum != null ? df.format(aufnahmedatum) : null;
            this.lblAufnahmedatum.setText(formattedDate);
            this.lblAufnahmedatum.setVisible(true);
            List suchworte = stadtbildserie.getBeanCollectionProperty("suchwort_arr");
            this.lblSuchworte.setText("<html><p>" + StringUtils.join((Collection)suchworte, (String)", ") + "</p></html>");
            this.lblSuchworte.setVisible(true);
            String hausnummer = (String)stadtbildserie.getProperty("hausnummer");
            String strassenname = (String)stadtbildserie.getProperty("strasse.name");
            if (StringUtils.isNotBlank((String)strassenname)) {
                String text = strassenname;
                if (StringUtils.isNotBlank((String)hausnummer)) {
                    text = text + ", " + hausnummer;
                }
                this.lblStrasse.setText(text);
                this.lblStrasse.setVisible(true);
            }
        }
    }

    public void setGridObject(Sb_stadtbildserieGridObject gridObject) {
        if (this.gridObject == gridObject) {
            this.selectStadtbildInTable(gridObject.getStadtbildUnderMarker());
        } else {
            this.gridObject = gridObject;
            this.setStadtbildserie(this.gridObject.getCidsBean());
        }
        this.tblStadtbilder.setEnabled(!gridObject.isIsInBin());
    }

    private void refillTable(CidsBean stadtbildToSelect) {
        List bilder = this.stadtbildserie.getBeanCollectionProperty("stadtbilder_arr");
        Set<CidsBean> selectedBilder = this.gridObject.getSelectedBildnummernOfSerie();
        Object[][] data = new Object[bilder.size()][];
        int stadtbildToSelectModelIndex = 0;
        for (int i = 0; i < data.length; ++i) {
            CidsBean bild = (CidsBean)bilder.get(i);
            if (stadtbildToSelect.equals((Object)bild)) {
                stadtbildToSelectModelIndex = i;
            }
            boolean isSelected = selectedBilder.contains(bild);
            data[i] = new Object[]{isSelected, bild};
        }
        List<RowSorter.SortKey> sortedColumns = this.tblStadtbilder.getRowSorter().getSortKeys();
        CustomTableModel newModel = new CustomTableModel(data, COLUMN_NAMES);
        this.tblStadtbilder.setModel(newModel);
        this.createNewTableSorter(sortedColumns);
        int stadtbildToSelectRowIndex = this.tblStadtbilder.convertRowIndexToView(stadtbildToSelectModelIndex);
        this.tblStadtbilder.setRowSelectionInterval(stadtbildToSelectRowIndex, stadtbildToSelectRowIndex);
    }

    private void createNewTableSorter(List<? extends RowSorter.SortKey> sortedColumns) {
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.tblStadtbilder.getModel());
        this.tblStadtbilder.setRowSorter(sorter);
        sorter.addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                if (e.getType() == RowSorterEvent.Type.SORTED) {
                    ArrayList<CidsBean> sortedStadtbilder = new ArrayList<CidsBean>(Sb_stadtbildserieAggregationRendererInfoPanel.this.tblStadtbilder.getRowCount());
                    for (int i = 0; i < Sb_stadtbildserieAggregationRendererInfoPanel.this.tblStadtbilder.getRowCount(); ++i) {
                        sortedStadtbilder.add((CidsBean)Sb_stadtbildserieAggregationRendererInfoPanel.this.tblStadtbilder.getValueAt(i, 1));
                    }
                    Sb_stadtbildserieAggregationRendererInfoPanel.this.gridObject.sortImagesToShow(sortedStadtbilder);
                }
            }
        });
        if (sortedColumns.isEmpty()) {
            ArrayList<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>();
            list.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            this.tblStadtbilder.getRowSorter().setSortKeys(list);
        } else {
            this.tblStadtbilder.getRowSorter().setSortKeys(sortedColumns);
        }
    }

    private void selectStadtbildInTable(CidsBean stadtbildToSelect) {
        int stadtbildToSelectModelIndex = 0;
        Vector<Vector> data = ((DefaultTableModel)this.tblStadtbilder.getModel()).getDataVector();
        for (int i = 0; i < data.size(); ++i) {
            CidsBean bild = (CidsBean)((List)data.get(i)).get(1);
            if (!stadtbildToSelect.equals((Object)bild)) continue;
            stadtbildToSelectModelIndex = i;
            break;
        }
        int stadtbildToSelectRowIndex = this.tblStadtbilder.convertRowIndexToView(stadtbildToSelectModelIndex);
        this.tblStadtbilder.setRowSelectionInterval(stadtbildToSelectRowIndex, stadtbildToSelectRowIndex);
    }

    public Sb_stadtbildserieAggregationRenderer getAggregationRenderer() {
        return this.aggregationRenderer;
    }

    public void setAggregationRenderer(Sb_stadtbildserieAggregationRenderer aggregationRenderer) {
        this.aggregationRenderer = aggregationRenderer;
    }

    @Override
    public CidsBean getStadtbildserie() {
        return this.stadtbildserie;
    }

    @Override
    public CidsBean getSelectedStadtbild() {
        int selectedRowView = this.tblStadtbilder.getSelectedRow();
        int selectedRowModel = this.tblStadtbilder.convertRowIndexToModel(selectedRowView);
        CidsBean selectedBild = (CidsBean)this.tblStadtbilder.getModel().getValueAt(selectedRowModel, 1);
        return selectedBild;
    }

    @Override
    public void previousImageSelected() {
        int selectedRow = this.tblStadtbilder.getSelectedRow();
        this.tblStadtbilder.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
    }

    @Override
    public void nextImageSelected() {
        int selectedRow = this.tblStadtbilder.getSelectedRow();
        this.tblStadtbilder.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
    }

    @Override
    public void newPreviewImageSelected() {
        LOG.fatal((Object)"Sb_stadtbildserieAggregationRendererInfoPanel.newPreviewImageSelected: Not supported yet.", (Throwable)new Exception());
    }

    @Override
    public boolean isFirstSelected() {
        int selectedRow = this.tblStadtbilder.getSelectedRow();
        return selectedRow == 0;
    }

    @Override
    public boolean isLastSelected() {
        int selectedRow = this.tblStadtbilder.getSelectedRow();
        return selectedRow == this.tblStadtbilder.getRowCount() - 1;
    }

    @Override
    public Sb_RestrictionLevelUtils.RestrictionLevel getRestrictionLevel() {
        return this.restrictedLevel;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int rowView = this.tblStadtbilder.getSelectedRow();
            if (rowView >= 0) {
                int rowModel = this.tblStadtbilder.convertRowIndexToModel(rowView);
                CidsBean stadtbild = (CidsBean)this.tblStadtbilder.getModel().getValueAt(rowModel, 1);
                StadtbilderUtils.StadtbildInfo stadtbildInfo = new StadtbilderUtils.StadtbildInfo(this.stadtbildserie, stadtbild);
                this.previewImage.setStadtbildInfo(stadtbildInfo);
                this.tblStadtbilder.scrollRectToVisible(this.tblStadtbilder.getCellRect(rowView, 1, true));
            } else {
                this.previewImage.removeImage();
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        DefaultTableModel model = (DefaultTableModel)this.tblStadtbilder.getModel();
        int rowModel = e.getFirstRow();
        Boolean isSelected = (Boolean)model.getValueAt(rowModel, 0);
        CidsBean bild = (CidsBean)model.getValueAt(rowModel, 1);
        if (!Boolean.valueOf(this.gridObject.isStadtbildSelected(bild)).equals(isSelected)) {
            this.gridObject.selectOrDeselectStadtbild(bild);
        }
    }

    @Override
    public void previewImageChanged() {
    }

    public void previewImageNotAvailable() {
        this.previewImage.indicateNotAvailable("", null, "keine Stadtbildserie ausgew\u00e4hlt");
    }

    public void setEnableTable(boolean enable) {
        this.tblStadtbilder.setEnabled(enable);
        this.btnInvertSelection.setEnabled(enable);
        this.btnSelectAll.setEnabled(enable);
        this.btnSelectNone.setEnabled(enable);
    }

    @Override
    public void stadtbildChosen(Sb_stadtbildserieGridObject source, CidsBean stadtbild) {
        if (source == this.gridObject) {
            TableModel model = this.tblStadtbilder.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                CidsBean stadtbildInTable = (CidsBean)model.getValueAt(i, 1);
                if (!stadtbildInTable.equals((Object)stadtbild)) continue;
                model.setValueAt(true, i, 0);
            }
        }
    }

    @Override
    public void stadtbildUnchosen(Sb_stadtbildserieGridObject source, CidsBean stadtbild) {
        if (source == this.gridObject) {
            TableModel model = this.tblStadtbilder.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                CidsBean stadtbildInTable = (CidsBean)model.getValueAt(i, 1);
                if (!stadtbildInTable.equals((Object)stadtbild)) continue;
                model.setValueAt(false, i, 0);
            }
        }
    }

    @Override
    public void sb_stadtbildserieGridObjectMoveToBin(Sb_stadtbildserieGridObject source) {
    }

    @Override
    public void sb_stadtbildserieGridObjectRemovedFromBin(Sb_stadtbildserieGridObject source) {
    }

    private class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        private CustomTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel renderedLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 1) {
                renderedLabel.setHorizontalAlignment(0);
            }
            return renderedLabel;
        }
    }

    private class CustomTableModel
    extends DefaultTableModel {
        Class[] types;
        boolean[] canEdit;

        public CustomTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
            this.types = new Class[]{Boolean.class, Object.class};
            this.canEdit = new boolean[]{true, false};
            this.addTableModelListener(Sb_stadtbildserieAggregationRendererInfoPanel.this);
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.canEdit[columnIndex];
        }
    }
}

