/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.orbit;

import Sirius.navigator.connection.SessionManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cids.custom.orbit.CamState;
import de.cismet.cids.custom.orbit.OrbitviewerProperties;
import de.cismet.cids.custom.orbit.StacResult;
import de.cismet.cids.custom.wunda_blau.search.actions.GetOrbitStacAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.features.ChildNodesProvider;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.RequestForHidingHandles;
import de.cismet.cismap.commons.features.RequestForNonreflectingFeature;
import de.cismet.cismap.commons.features.RequestForRotatingPivotLock;
import de.cismet.cismap.commons.features.RequestForUnaddableHandles;
import de.cismet.cismap.commons.features.RequestForUnmoveableHandles;
import de.cismet.cismap.commons.features.RequestForUnremovableHandles;
import de.cismet.cismap.commons.features.RequestNoAutoSelectionWhenMoving;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.FixedPImage;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeriveRule;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DerivedCommandArea;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DerivedFixedPImage;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DerivedFixedPImageCommandArea;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.BrowserLauncher;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class OrbitControlFeature
extends DefaultStyledFeature
implements XStyledFeature,
ChildNodesProvider,
RequestForUnaddableHandles,
RequestForUnmoveableHandles,
RequestForUnremovableHandles,
RequestForHidingHandles,
RequestForRotatingPivotLock,
RequestForNonreflectingFeature,
ConnectionContextProvider,
RequestNoAutoSelectionWhenMoving {
    private static final Logger LOG = Logger.getLogger(OrbitControlFeature.class);
    private static final Image OPENORBIT = new ImageIcon(OrbitControlFeature.class.getResource("/de/cismet/cids/custom/orbitviewer/orbit32.png")).getImage();
    private static final Image ROTATE = new ImageIcon(OrbitControlFeature.class.getResource("/de/cismet/cids/custom/virtualcitymap/turn.png")).getImage();
    private static final Image REMOVE = new ImageIcon(OrbitControlFeature.class.getResource("/de/cismet/cids/custom/virtualcitymap/remove.png")).getImage();
    private static final int ARCSIZE = 200;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static OrbitControlFeature CURRENT_CONTROL_FEATURE = null;
    DerivedFixedPImageCommandArea linkAreaRef = null;
    private final ArrayList<PNode> children = new ArrayList();
    private final MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
    private final ConnectionContext connectionContext;
    private FixedPImage arrow;
    private CamState camState = new CamState();
    private String socketChannelId;
    private final String launcherUrl;
    private final StacResult stacInfo;
    private final Socket socket;
    private boolean browserOpened = false;

    public OrbitControlFeature(ConnectionContext connectionContext, StacResult stac, Socket socket, String launcherUrl) {
        this(connectionContext, stac, socket, launcherUrl, null);
    }

    public OrbitControlFeature(ConnectionContext connectionContext, StacResult stac, Socket socket, String launcherUrl, Point centroid) {
        this.connectionContext = connectionContext;
        this.setEditable(true);
        this.setCanBeSelected(true);
        this.setLinePaint(new Color(0, 0, 0, 0));
        this.setHighlightingEnabled(false);
        this.stacInfo = stac;
        this.socket = socket;
        this.launcherUrl = launcherUrl;
        this.camState.setFov(100.0);
        this.camState.setTilt(0.0);
        this.camState.setPan(0.0);
        this.setSocketChannelId(this.stacInfo.getSocketChannelId());
        this.setGeometry(this.getControlFeatureGeometry(centroid));
    }

    public OrbitControlFeature(ConnectionContext connectionContext, StacResult stac, Socket socket, String launcherUrl, Point centroid, float fov, float tilt, float pan) {
        this.connectionContext = connectionContext;
        this.setEditable(true);
        this.setCanBeSelected(true);
        this.setLinePaint(new Color(0, 0, 0, 0));
        this.setHighlightingEnabled(false);
        this.stacInfo = stac;
        this.socket = socket;
        this.launcherUrl = launcherUrl;
        this.camState.setFov(fov);
        this.camState.setTilt(tilt);
        this.camState.setPan(pan);
        this.setSocketChannelId(this.stacInfo.getSocketChannelId());
        this.setGeometry(this.getControlFeatureGeometry(centroid));
    }

    public boolean isBrowserOpened() {
        return this.browserOpened;
    }

    public void setBrowserOpened(boolean browserOpened) {
        this.browserOpened = browserOpened;
    }

    public static OrbitControlFeature getCurrentControlFeature() {
        return CURRENT_CONTROL_FEATURE;
    }

    public static void addToMap(ConnectionContext connectionContext) {
        OrbitControlFeature.addToMap(null, connectionContext);
    }

    public static void controlOrAddOnMap(Point position, ConnectionContext connectionContext) {
        OrbitControlFeature.controlOrAddOnMap(position, connectionContext, null, null, null, null, null);
    }

    public static void controlOrAddOnMap(Point position, ConnectionContext connectionContext, Double fov, Double pan, Double tilt, String reason, String additionalInfo) {
        if (CURRENT_CONTROL_FEATURE != null && OrbitControlFeature.CURRENT_CONTROL_FEATURE.socketChannelId != null && CismapBroker.getInstance().getMappingComponent().getPFeatureHM().get((Object)CURRENT_CONTROL_FEATURE) != null) {
            CURRENT_CONTROL_FEATURE.setGeometry(CURRENT_CONTROL_FEATURE.getControlFeatureGeometry(position));
            CURRENT_CONTROL_FEATURE.updateCamStatePosition();
            if (fov != null) {
                OrbitControlFeature.CURRENT_CONTROL_FEATURE.camState.setFov(fov);
            }
            if (pan != null) {
                OrbitControlFeature.CURRENT_CONTROL_FEATURE.camState.setPan(pan);
            }
            if (tilt != null) {
                OrbitControlFeature.CURRENT_CONTROL_FEATURE.camState.setTilt(tilt);
            }
            if (reason != null) {
                OrbitControlFeature.CURRENT_CONTROL_FEATURE.camState.setReason(reason);
            }
            if (additionalInfo != null) {
                OrbitControlFeature.CURRENT_CONTROL_FEATURE.camState.setAdditionalInfo(additionalInfo);
            }
            CURRENT_CONTROL_FEATURE.updateOrbitIfPossible();
            ((PFeature)CismapBroker.getInstance().getMappingComponent().getPFeatureHM().get((Object)CURRENT_CONTROL_FEATURE)).visualize();
            CURRENT_CONTROL_FEATURE.visualizeRotation();
        } else {
            OrbitControlFeature.addToMap(position, connectionContext, fov, pan, tilt, reason, additionalInfo);
        }
    }

    public static void controlOrAddOnMap(ConnectionContext connectionContext) {
        OrbitControlFeature.controlOrAddOnMap(null, connectionContext);
    }

    public static void addToMap(Point position, ConnectionContext connectionContext) {
        OrbitControlFeature.addToMap(position, connectionContext, null, null, null, null, null);
    }

    public static void addToMap(final Point centroid, final ConnectionContext connectionContext, final Double fov, final Double pan, final Double tilt, final String reason, final String additionalInfo) {
        try {
            new SwingWorker<OrbitControlFeature, Void>(){

                @Override
                protected OrbitControlFeature doInBackground() throws Exception {
                    Socket socket = IO.socket((String)OrbitviewerProperties.getInstance().getSocketBroadcaster());
                    socket.connect();
                    String ip = "notYet";
                    Object ret = SessionManager.getProxy().executeTask("getOrbitStac", "WUNDA_BLAU", null, connectionContext, new ServerActionParameter[]{new ServerActionParameter(GetOrbitStacAction.PARAMETER_TYPE.IP.toString(), (Object)"notYet")});
                    String s = ret.toString();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("raw action result:" + s));
                    }
                    StacResult stacResult = (StacResult)MAPPER.readValue(s, StacResult.class);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("stacResult:" + stacResult));
                    }
                    return new OrbitControlFeature(connectionContext, stacResult, socket, OrbitviewerProperties.getInstance().getLauncherUrl(), centroid);
                }

                @Override
                protected void done() {
                    try {
                        OrbitControlFeature vcmf = (OrbitControlFeature)((Object)this.get());
                        if (CURRENT_CONTROL_FEATURE != null) {
                            CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature((Feature)CURRENT_CONTROL_FEATURE);
                            CURRENT_CONTROL_FEATURE = null;
                        }
                        CURRENT_CONTROL_FEATURE = vcmf;
                        if (fov != null) {
                            CURRENT_CONTROL_FEATURE.camState.setFov(fov);
                        }
                        if (pan != null) {
                            CURRENT_CONTROL_FEATURE.camState.setPan(pan);
                        }
                        if (tilt != null) {
                            CURRENT_CONTROL_FEATURE.camState.setTilt(tilt);
                        }
                        if (reason != null) {
                            CURRENT_CONTROL_FEATURE.camState.setReason(reason);
                        }
                        if (additionalInfo != null) {
                            CURRENT_CONTROL_FEATURE.camState.setAdditionalInfo(additionalInfo);
                        }
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature((Feature)vcmf);
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().holdFeature((Feature)vcmf);
                        CURRENT_CONTROL_FEATURE.visualizeRotation();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            }.execute();
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private Geometry getControlFeatureGeometry(Point centroid) {
        double w;
        double h;
        Geometry bb = this.mappingComponent.getCurrentBoundingBoxFromCamera().getGeometry(CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
        if (centroid == null) {
            centroid = bb.getCentroid();
        }
        if ((h = bb.getEnvelopeInternal().getHeight()) > (w = bb.getEnvelopeInternal().getWidth())) {
            return centroid.buffer(w / 2.0 * 0.625).getEnvelope();
        }
        return centroid.buffer(h / 2.0 * 0.625).getEnvelope();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("started");
        JFrame j = new JFrame("test");
        j.getContentPane().setLayout(new BorderLayout());
        j.setDefaultCloseOperation(3);
        ImageIcon FOVVIS = new ImageIcon(OrbitControlFeature.class.getResource("/de/cismet/cids/custom/virtualcitymap/vcm.control.png"));
        final JLabel l = new JLabel("");
        JLabel lblPan = new JLabel("");
        JLabel lblFOV = new JLabel("");
        j.getContentPane().add((Component)l, "Center");
        j.setVisible(true);
        final JSlider pan = new JSlider(0, 360);
        pan.setMajorTickSpacing(45);
        pan.setMinorTickSpacing(10);
        pan.setPaintTicks(true);
        pan.setPaintLabels(true);
        final JSlider fov = new JSlider(5, 130);
        fov.setMajorTickSpacing(10);
        fov.setMinorTickSpacing(5);
        fov.setPaintTicks(true);
        fov.setPaintLabels(true);
        pan.setValue(0);
        fov.setValue(80);
        l.setIcon(OrbitControlFeature.createArcImage(200, 200, pan.getValue(), 100, fov.getValue()));
        pan.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                l.setIcon(OrbitControlFeature.createArcImage(200, 200, pan.getValue(), 100, fov.getValue()));
            }
        });
        fov.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                l.setIcon(OrbitControlFeature.createArcImage(200, 200, pan.getValue(), 100, fov.getValue()));
            }
        });
        j.getContentPane().add((Component)pan, "North");
        j.getContentPane().add((Component)fov, "South");
        j.getContentPane().add((Component)l, "Center");
        j.setSize(new Dimension(500, 500));
        System.out.println("fertich");
    }

    public static ImageIcon createArcImage(int width, int height, int pan, int tilt, int fov) {
        BufferedImage bi = new BufferedImage(width, height, 6);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        int[] rgba = new int[]{11, 72, 107, 207};
        if (OrbitviewerProperties.getInstance().getArcColorRGBA() != null) {
            String[] rgbaFromSettings = OrbitviewerProperties.getInstance().getArcColorRGBA().split(",");
            try {
                int r = Integer.parseInt(rgbaFromSettings[0].trim());
                int g = Integer.parseInt(rgbaFromSettings[1].trim());
                int b = Integer.parseInt(rgbaFromSettings[2].trim());
                int a = Integer.parseInt(rgbaFromSettings[3].trim());
                rgba[0] = r;
                rgba[1] = g;
                rgba[2] = b;
                rgba[3] = a;
            }
            catch (Exception ex) {
                LOG.warn((Object)"could not parse rgba from settings", (Throwable)ex);
            }
        }
        g2.setPaint(new Color(rgba[0], rgba[1], rgba[2], rgba[3]));
        pan = (pan + (fov += 10) / 2 - 90) * -1 % 360;
        if (pan < 0) {
            pan = 360 + pan;
        }
        g2.fill(new Arc2D.Double(0.0, 0.0, width, height, pan, fov, 2));
        return new ImageIcon(bi);
    }

    public String getSocketChannelId() {
        return this.socketChannelId;
    }

    public void setSocketChannelId(String socketChannelId) {
        this.socketChannelId = socketChannelId;
        if (this.socketChannelId != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("listening for fromOrbit:" + socketChannelId));
            }
            this.socket.on("fromOrbit:" + socketChannelId, new Emitter.Listener(){

                public void call(Object ... args) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("args on socket.io" + args[0]));
                    }
                    CamState cs = null;
                    try {
                        cs = (CamState)MAPPER.readValue(args[0].toString(), CamState.class);
                        Point oldCentroid = OrbitControlFeature.this.getGeometry().getCentroid();
                        if (Math.abs(cs.getX() - oldCentroid.getX()) > 0.1 || Math.abs(cs.getY() - oldCentroid.getY()) > 0.1) {
                            GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), new Integer(OrbitControlFeature.this.camState.getCrs()).intValue());
                            Geometry newGeometry = OrbitControlFeature.this.getControlFeatureGeometry(factory.createPoint(new Coordinate(cs.getX(), cs.getY())));
                            OrbitControlFeature.this.setGeometry(newGeometry);
                            ((PFeature)CismapBroker.getInstance().getMappingComponent().getPFeatureHM().get((Object)CURRENT_CONTROL_FEATURE)).visualize();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("move it: " + cs.getX() + "," + cs.getY()));
                            }
                            OrbitControlFeature.this.setCamState(cs);
                            OrbitControlFeature.this.visualizeRotation();
                            OrbitControlFeature.this.mappingComponent.ensureVisibilityOfSpecialFeatures(OrbitControlFeature.class, true);
                        } else {
                            OrbitControlFeature.this.setCamState(cs);
                            OrbitControlFeature.this.visualizeRotation();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("pan,tilt, fov it: " + cs.getPan() + ", " + cs.getTilt() + ", " + cs.getFov()));
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
            });
        }
    }

    public void publishCamState() {
    }

    public void setCamState(CamState camState) {
        this.camState = camState;
    }

    public void updateCamStatePosition() {
        this.camState.setX(this.getGeometry().getCentroid().getX());
        this.camState.setY(this.getGeometry().getCentroid().getY());
    }

    public String getLaunchUrl() {
        this.updateCamStatePosition();
        return this.launcherUrl + "/?cidsOrbitSTAC=" + this.stacInfo.getStac() + "&initialx=" + this.camState.getX() + "&initialy=" + this.camState.getY() + "&initialPan=" + this.camState.getPan() + "&initialTilt=" + this.camState.getTilt() + "&initialFOV=" + this.camState.getFov();
    }

    public ImageIcon getIconImage() {
        return null;
    }

    public String getType() {
        return "OrbitViewer Steuerung";
    }

    public JComponent getInfoComponent(Refreshable r) {
        return null;
    }

    public Stroke getLineStyle() {
        return null;
    }

    public String getName() {
        return "OrbitViewer Steuerung";
    }

    public Collection<PNode> provideChildren(PFeature parent) {
        this.children.clear();
        this.initPNodeChildren(parent);
        return this.children;
    }

    private void initPNodeChildren(PFeature parent) {
        this.children.add((PNode)this.createArrow(parent));
        this.children.add((PNode)this.createMover(parent));
        this.children.add((PNode)this.createRotateArea(parent));
        this.children.add((PNode)this.createLinkArea(parent));
        this.children.add((PNode)this.createCloseArea(parent));
    }

    private DerivedMoveArea createMover(PFeature parent) {
        DerivedMoveArea mover = new DerivedMoveArea(parent);
        return mover;
    }

    private FixedPImage createArrow(PFeature parent) {
        ImageIcon rotated = OrbitControlFeature.createArcImage(200, 200, (int)(this.camState.getPan() + 0.5), (int)(this.camState.getTilt() + 0.5), (int)(this.camState.getFov() + 0.5));
        this.arrow = new DerivedFixedPImage(rotated.getImage(), parent, new DeriveRule(){

            public Geometry derive(Geometry in) {
                return in.getCentroid();
            }
        });
        this.arrow.setSweetSpotX(0.5);
        this.arrow.setSweetSpotY(0.5);
        return this.arrow;
    }

    private FixedPImage createRotateArea(PFeature parent) {
        DerivedFixedPImageCommandArea rotateArea = new DerivedFixedPImageCommandArea(ROTATE, parent, new DeriveRule(){

            public Geometry derive(Geometry in) {
                Coordinate[] cs = in.buffer(in.getEnvelopeInternal().getHeight() * -0.1).getEnvelope().getCoordinates();
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
                Point point = factory.createPoint(cs[3]);
                return point;
            }
        }){

            public void mousePressed(PInputEvent event) {
                OrbitControlFeature.this.rotate();
            }
        };
        rotateArea.setSweetSpotX(0.5);
        rotateArea.setSweetSpotY(0.5);
        return rotateArea;
    }

    private FixedPImage createLinkArea(PFeature parent) {
        DerivedFixedPImageCommandArea linkArea = new DerivedFixedPImageCommandArea(OPENORBIT, parent, new DeriveRule(){

            public Geometry derive(Geometry in) {
                Coordinate[] cs = in.buffer(in.getEnvelopeInternal().getHeight() * -0.1).getEnvelope().getCoordinates();
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
                Point point = factory.createPoint(cs[0]);
                return point;
            }
        }){

            public void mousePressed(PInputEvent event) {
                OrbitControlFeature.this.openOrbitLauncher();
            }
        };
        linkArea.setSweetSpotX(0.5);
        linkArea.setSweetSpotY(0.5);
        this.linkAreaRef = linkArea;
        return linkArea;
    }

    private FixedPImage createCloseArea(PFeature parent) {
        DerivedFixedPImageCommandArea closeArea = new DerivedFixedPImageCommandArea(REMOVE, parent, new DeriveRule(){

            public Geometry derive(Geometry in) {
                Coordinate[] cs = in.buffer(in.getEnvelopeInternal().getHeight() * -0.1).getEnvelope().getCoordinates();
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
                Point point = factory.createPoint(cs[2]);
                return point;
            }
        }){

            public void mousePressed(PInputEvent event) {
                OrbitControlFeature.this.removeFeature();
            }
        };
        closeArea.setSweetSpotX(0.5);
        closeArea.setSweetSpotY(0.5);
        return closeArea;
    }

    public void removeFeature() {
        this.mappingComponent.getFeatureCollection().removeFeature((Feature)this);
        this.socketChannelId = null;
        CURRENT_CONTROL_FEATURE = null;
    }

    public void openOrbitLauncher() {
        int currentSrid;
        int epsg = currentSrid = CrsTransformer.extractSridFromCrs((String)this.mappingComponent.getMappingModel().getSrs().getCode());
        String url = this.getLaunchUrl();
        String channel = this.getSocketChannelId();
        if (!this.isBrowserOpened()) {
            try {
                BrowserLauncher.openURL((String)url);
                this.setBrowserOpened(true);
                this.linkAreaRef.setTransparency(0.1f);
            }
            catch (Exception ex) {
                LOG.error((Object)("error while browserlaunching url: " + url), (Throwable)ex);
            }
        } else {
            try {
                this.socket.emit("toOrbit:" + this.getSocketChannelId(), new Object[]{MAPPER.writeValueAsString((Object)this.camState)});
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                this.setSocketChannelId("");
            }
        }
    }

    public void rotate() {
        double np = this.camState.getPan();
        np = (np - np % 45.0 + 45.0) % 360.0;
        this.camState.setPan(np);
        this.updateCamStatePosition();
        this.visualizeRotation();
        this.updateOrbitIfPossible();
    }

    public void visualizeRotation() {
        ImageIcon rotated = OrbitControlFeature.createArcImage(200, 200, (int)(this.camState.getPan() + 0.5), (int)(this.camState.getTilt() + 0.5), (int)(this.camState.getFov() + 0.5));
        this.arrow.setImage(rotated.getImage());
        this.arrow.setSweetSpotX(0.5);
        this.arrow.setSweetSpotY(0.5);
        CismapBroker.getInstance().getMappingComponent().repaint();
    }

    public void updateOrbitIfPossible() {
        String channel = this.getSocketChannelId();
        if (channel != null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("toOrbit:" + this.getSocketChannelId() + "  " + MAPPER.writeValueAsString((Object)this.camState)));
                }
                this.socket.emit("toOrbit:" + this.getSocketChannelId(), new Object[]{MAPPER.writeValueAsString((Object)this.camState)});
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                this.setSocketChannelId("");
            }
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public class DerivedMoveArea
    extends DerivedCommandArea {
        private PFeature parentFeature;

        public DerivedMoveArea(PFeature parent) {
            super(parent, new DeriveRule(){

                public Geometry derive(Geometry in) {
                    return OrbitControlFeature.this.getGeometry().buffer(in.getEnvelopeInternal().getHeight() * -0.05);
                }
            });
            this.setPaint(Color.white);
            this.setStroke(null);
            this.setTransparency(0.3f);
            this.parentFeature = parent;
        }

        public void mousePressed(PInputEvent event) {
            super.mousePressed(event);
            ((PBasicInputEventHandler)OrbitControlFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mousePressed(event);
        }

        public void mouseDragged(PInputEvent event) {
            super.mouseDragged(event);
            ((PBasicInputEventHandler)OrbitControlFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mouseDragged(event);
        }

        public void mouseReleased(PInputEvent event) {
            super.mouseReleased(event);
            ((PBasicInputEventHandler)OrbitControlFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mouseReleased(event);
            OrbitControlFeature.this.mappingComponent.ensureVisibilityOfSpecialFeatures(OrbitControlFeature.class, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Geometry changed" + this.parentFeature.getFeature().getGeometry()));
            }
            OrbitControlFeature.this.updateCamStatePosition();
            OrbitControlFeature.this.updateOrbitIfPossible();
        }

        public void mouseMoved(PInputEvent event) {
            super.mouseMoved(event);
            ((PBasicInputEventHandler)OrbitControlFeature.this.mappingComponent.getInputListener("MOVE_POLYGON")).mouseMoved(event);
        }
    }
}

