/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.clientutils.ByteArrayActionDownload;
import de.cismet.cids.custom.objecteditors.utils.ClientAlboProperties;
import de.cismet.cids.custom.wunda_blau.search.actions.AlboVorgangReportServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class AlboReportGenerator {
    private static final Logger LOG = Logger.getLogger(AlboReportGenerator.class);

    private static BufferedImage generateOverviewMap(CidsBean vorgangBean, boolean isDgk) {
        try {
            String mapUrl = ClientAlboProperties.getInstance().getVorgangMapUrl();
            Geometry geom = null;
            ArrayList<CidsFeature> features = new ArrayList<CidsFeature>();
            for (CidsBean flaecheBean : vorgangBean.getBeanCollectionProperty("arr_flaechen")) {
                Geometry flaecheGeom;
                if (flaecheBean == null || (flaecheGeom = (Geometry)flaecheBean.getProperty("fk_geom.geo_field")) == null) continue;
                features.add(new CidsFeature(flaecheBean.getMetaObject()));
                if (geom == null) {
                    geom = (Geometry)flaecheGeom.buffer(0.0).clone();
                    continue;
                }
                geom = geom.union((Geometry)flaecheGeom.buffer(0.0).clone());
            }
            int margin = 50;
            if (geom != null) {
                XBoundingBox boundingBox = new XBoundingBox(geom);
                boundingBox.increase(10);
                boundingBox.setX1(boundingBox.getX1() - 50.0);
                boundingBox.setY1(boundingBox.getY1() - 50.0);
                boundingBox.setX2(boundingBox.getX2() + 50.0);
                boundingBox.setY2(boundingBox.getY2() + 50.0);
                HeadlessMapProvider mapProvider = new HeadlessMapProvider();
                mapProvider.setCenterMapOnResize(true);
                mapProvider.setBoundingBox(boundingBox);
                SimpleWmsGetMapUrl getMapUrl = new SimpleWmsGetMapUrl(mapUrl);
                SimpleWMS simpleWms = new SimpleWMS(getMapUrl);
                mapProvider.addLayer((RetrievalServiceLayer)simpleWms);
                for (Feature feature : features) {
                    mapProvider.addFeature(feature);
                }
                return (BufferedImage)mapProvider.getImageAndWait(72, ClientAlboProperties.getInstance().getVorgangMapDpi().intValue(), (double)ClientAlboProperties.getInstance().getVorgangMapWidth().intValue(), (double)ClientAlboProperties.getInstance().getVorgangMapHeight().intValue());
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving map", (Throwable)e);
            return null;
        }
    }

    public static void startVorgangReportDownload(CidsBean vorgangBean, Component parent, String taskName, ConnectionContext connectionContext) {
        try {
            if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog(parent)) {
                String jobname = DownloadManagerDialog.getInstance().getJobName();
                String vorgang = (String)vorgangBean.getProperty("schluessel");
                FutureParams paramsFuture = new FutureParams(vorgangBean);
                DownloadManager.instance().add((Download)new ByteArrayActionDownload(taskName, (Object)new MetaObjectNode(vorgangBean), String.format("Altlastenkataster - Vorgang %s", vorgang), jobname, String.format("albo_vorgang_%s", vorgang), ".pdf", paramsFuture, connectionContext));
            }
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
        }
    }

    private static class FutureParams
    implements Future<ServerActionParameter[]> {
        private ServerActionParameter[] parameters = null;
        private volatile boolean done = false;
        private volatile boolean cancel = false;
        private final ReentrantLock lock = new ReentrantLock();
        private Condition condition = this.lock.newCondition();

        public FutureParams(final CidsBean vorgangBean) {
            Thread backgroundTask = new Thread(){

                @Override
                public void run() {
                    try {
                        byte[] byteArray;
                        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                            BufferedImage image = AlboReportGenerator.generateOverviewMap(vorgangBean, true);
                            ImageIO.write((RenderedImage)image, "png", bos);
                            byteArray = bos.toByteArray();
                        }
                        FutureParams.access$102(this, new ServerActionParameter[]{new ServerActionParameter(AlboVorgangReportServerAction.Parameter.MAP_IMAGE_BYTES.toString(), (Object)byteArray)});
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                    this.unlock();
                }
            };
            backgroundTask.start();
        }

        private void unlock() {
            this.lock.lock();
            try {
                this.done = true;
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.done || this.cancel) {
                return false;
            }
            this.cancel = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancel;
        }

        @Override
        public boolean isDone() {
            return this.done || this.cancel;
        }

        @Override
        public ServerActionParameter[] get() throws InterruptedException, ExecutionException {
            this.lock.lock();
            try {
                if (!this.isDone()) {
                    this.condition.await();
                }
                ServerActionParameter[] serverActionParameterArray = this.parameters;
                return serverActionParameterArray;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServerActionParameter[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.lock.lock();
            try {
                if (!this.isDone() && !this.condition.await(timeout, unit)) {
                    throw new TimeoutException();
                }
                ServerActionParameter[] serverActionParameterArray = this.parameters;
                return serverActionParameterArray;
            }
            finally {
                this.lock.unlock();
            }
        }

        static /* synthetic */ ServerActionParameter[] access$102(FutureParams x0, ServerActionParameter[] x1) {
            x0.parameters = x1;
            return x1;
        }
    }
}

