/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.reports.wunda_blau;

import de.cismet.cids.client.tools.WebDavTunnelHelper;
import de.cismet.cids.custom.reports.wunda_blau.AbstractReportBeanWithMapAndImages;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.CismetThreadPool;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public abstract class ReportBeanWithMapAndTwoWebDavImages
extends AbstractReportBeanWithMapAndImages
implements ConnectionContextProvider {
    private static final transient Logger LOG = Logger.getLogger(ReportBeanWithMapAndTwoWebDavImages.class);
    private final WebDavTunnelHelper webDavHelper;
    private final String webDavDirectory;

    public ReportBeanWithMapAndTwoWebDavImages(CidsBean cidsBean, String mapUrl, WebDavTunnelHelper webDavHelper, String webDavDirectory, ConnectionContext connectionContext) {
        super(cidsBean, mapUrl, connectionContext);
        this.webDavHelper = webDavHelper;
        this.webDavDirectory = webDavDirectory;
        this.initImgStates();
    }

    protected abstract String getDavFile(CidsBean var1);

    @Override
    protected void initImgStates() {
        List<CidsBean> imageBeans = this.getImageBeans();
        if (imageBeans != null) {
            String url0 = imageBeans.size() > 0 ? this.getDavFile(imageBeans.get(0)) : null;
            String url1 = imageBeans.size() > 1 ? this.getDavFile(imageBeans.get(1)) : null;
            this.setImgState0(url0 != null ? this.loadImage(url0, this.webDavHelper, this.webDavDirectory, true) : null);
            this.setImgState1(url1 != null ? this.loadImage(url1, this.webDavHelper, this.webDavDirectory, false) : null);
            if (url0 == null) {
                this.setImg0Ready(true);
            }
            if (url1 == null) {
                this.setImg1Ready(true);
            }
        }
    }

    private AbstractReportBeanWithMapAndImages.ImageState loadImage(final String url, final WebDavTunnelHelper webDavHelper, final String webDavDirectory, final boolean oneOrTwo) {
        final AbstractReportBeanWithMapAndImages.ImageState imgState = new AbstractReportBeanWithMapAndImages.ImageState();
        CismetThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (url.equals("")) {
                        imgState.setError(true);
                        return;
                    }
                    InputStream iStream = webDavHelper.getFileFromWebDAV(url, webDavDirectory, ReportBeanWithMapAndTwoWebDavImages.this.getConnectionContext());
                    BufferedImage img = ImageIO.read(iStream);
                    if (img == null) {
                        imgState.setError(true);
                        LOG.warn((Object)"error during image retrieval from Webdav");
                    }
                    imgState.setImg(img);
                }
                catch (Exception e) {
                    imgState.setError(true);
                }
                finally {
                    if (oneOrTwo) {
                        ReportBeanWithMapAndTwoWebDavImages.this.setImg0Ready(true);
                    } else {
                        ReportBeanWithMapAndTwoWebDavImages.this.setImg1Ready(true);
                    }
                }
            }
        });
        return imgState;
    }
}

