/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.virtualcitymap;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class VCMProperties
extends Properties {
    private static final Logger LOG = Logger.getLogger(VCMProperties.class);
    private static final String PROP_URL_TEMPLATE = "URL_TEMPLATE";
    private static final String PROP_NEW_URL_TEMPLATE = "NEW_URL_TEMPLATE";
    private static final String PROP_USER = "USER";
    private static final String PROP_PASSWORD = "PASSWORD";
    private static final String PROP_TOOLBAR_CONFATTR = "TOOLBAR_CONFATTR";
    private static final String PROP_ROTATION_INDEX = "ROTATION_INDEX";
    private static final String PROP_HEADINGS = "HEADINGS";
    private static final String PROP_SWEET_SPOTS = "SWEET_SPOTS";
    private static final String USE_NEW_URL = "USE_NEW_URL";
    private static final String USE_AUTHENTIFICATION = "USE_AUTHENTIFICATION";
    private static final String RELOAD_CONFIG_EVERY_TIME = "RELOAD_CONFIG_EVERY_TIME";
    private static final String WITH_JWT = "WITH_JWT";

    private VCMProperties() {
    }

    public String getUrlTemplate() {
        return this.getProperty(PROP_URL_TEMPLATE);
    }

    public String getNewUrlTemplate() {
        return this.getProperty(PROP_NEW_URL_TEMPLATE);
    }

    public boolean isNewUrl() {
        return this.getProperty(USE_NEW_URL) != null && this.getProperty(USE_NEW_URL).equalsIgnoreCase("true");
    }

    public boolean isWithAuthentication() {
        return this.getProperty(USE_AUTHENTIFICATION) != null && this.getProperty(USE_AUTHENTIFICATION).equalsIgnoreCase("true");
    }

    public boolean isWithJWT() {
        return this.getProperty(WITH_JWT) != null && this.getProperty(WITH_JWT).equalsIgnoreCase("true");
    }

    public boolean isReloadConfigEveryTime() {
        return this.getProperty(RELOAD_CONFIG_EVERY_TIME) != null && this.getProperty(RELOAD_CONFIG_EVERY_TIME).equalsIgnoreCase("true");
    }

    public String getUser() {
        return this.getProperty(PROP_USER);
    }

    public String getPassword() {
        return this.getProperty(PROP_PASSWORD);
    }

    public String getToolbarConfAttr() {
        return this.getProperty(PROP_TOOLBAR_CONFATTR);
    }

    public int getRotationIndex() {
        try {
            return Integer.parseInt(this.getProperty(PROP_ROTATION_INDEX));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)"VCMProperties: Cannot parse rotation index");
            return 0;
        }
    }

    public int[] getHeadings() {
        try {
            String[] splitted;
            int[] headings = new int[4];
            String headingsString = this.getProperty(PROP_HEADINGS);
            if (headingsString != null && (splitted = headingsString.split(",")).length == 4) {
                for (int i = 0; i < 4; ++i) {
                    headings[i] = Integer.parseInt(splitted[i].trim());
                }
                return headings;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        LOG.warn((Object)"VCMProperties: Cannot parse headings. Use default values");
        return new int[]{45, 135, 225, 315};
    }

    public double[][] getSweetSpots() {
        try {
            String[] splitted;
            double[][] sweetSpots = new double[4][];
            String spotsString = this.getProperty(PROP_SWEET_SPOTS);
            if (spotsString != null && (splitted = spotsString.split(";")).length == 4) {
                for (int i = 0; i < 4; ++i) {
                    String singleSpot = splitted[i].replace("{", "").replace("}", "").trim();
                    String[] singleSpotValues = singleSpot.split(",");
                    if (singleSpotValues.length != 2) {
                        LOG.warn((Object)"VCMProperties: Cannot parse sweet spots. Use default values");
                        return new double[][]{{1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {0.0, 0.0}};
                    }
                    double[] spotValues = new double[]{Double.parseDouble(singleSpotValues[0].trim()), Double.parseDouble(singleSpotValues[1].trim())};
                    sweetSpots[i] = spotValues;
                }
                return sweetSpots;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        LOG.warn((Object)"Cannot parse sweet spots. Use default values");
        return new double[][]{{1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}, {0.0, 0.0}};
    }

    public static VCMProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public final void load(ConnectionContext connectionContext) {
        try {
            String propertiesString = (String)SessionManager.getSession().getConnection().executeTask(SessionManager.getSession().getUser(), "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.VCM_PROPERTIES.getValue(), connectionContext, new ServerActionParameter[0]);
            super.load(new StringReader(propertiesString));
        }
        catch (Exception ex) {
            LOG.warn((Object)"could not load properties.", (Throwable)ex);
        }
    }

    private static final class LazyInitialiser {
        private static final VCMProperties INSTANCE = new VCMProperties();

        private LazyInitialiser() {
        }
    }
}

