/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda.oab.mapvis;

import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.cids.custom.wunda.oab.OabUtilities;
import de.cismet.cids.custom.wunda.oab.mapvis.OabMapVisualisationDialog;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class OabMapVisualisationAction
extends AbstractAction {
    private static final transient Logger log = Logger.getLogger(OabMapVisualisationAction.class);
    private final Component parent;
    private final OabMapVisualisationDialog dialog;
    private boolean autoAddFeatureToMap;
    private boolean featureAdditionSelected;

    public OabMapVisualisationAction(Component parent, OabMapVisualisationDialog dialog) {
        super(NbBundle.getMessage(OabMapVisualisationAction.class, (String)"OabMapVisualisationAction.<init>(Component,OabMapVisualisationDialog).super.name"));
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        if (dialog == null) {
            throw new IllegalArgumentException("dialog must not be null");
        }
        this.parent = parent;
        this.dialog = dialog;
        this.autoAddFeatureToMap = true;
        this.featureAdditionSelected = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int answer = JOptionPane.showConfirmDialog(this.parent, this.dialog, NbBundle.getMessage(OabMapVisualisationAction.class, (String)"OabMapVisualisationAction.actionPerformed(ActionEvent).dialog.title"), 2, -1);
        if (answer == 0) {
            try {
                String lname;
                String cap;
                MappingComponent map = CismapBroker.getInstance().getMappingComponent();
                if (this.dialog.isAddFeature()) {
                    if (this.isAutoAddFeatureToMap()) {
                        CidsFeature feature = new CidsFeature(this.dialog.getFeatureBean().getMetaObject());
                        map.getFeatureCollection().addFeature((Feature)feature);
                        CismapBroker.getInstance().getMappingComponent().zoomToAFeatureCollection(Arrays.asList(feature), true, false);
                    } else {
                        this.featureAdditionSelected = true;
                    }
                }
                if (this.dialog.isAddTin()) {
                    cap = this.dialog.getTinCapabilitiesUrl();
                    lname = this.dialog.getTinLayername();
                    map.getMappingModel().addLayer(OabUtilities.createWMSLayer(cap, lname));
                }
                if (this.dialog.isAddBE()) {
                    cap = this.dialog.getBeCapabilitiesUrl();
                    lname = this.dialog.getBeLayername();
                    map.getMappingModel().addLayer(OabUtilities.createWMSLayer(cap, lname));
                }
                if (this.dialog.isAddMaxWater()) {
                    cap = this.dialog.getMaxWaterCapabilitiesUrl();
                    lname = this.dialog.getMaxWaterLayername();
                    map.getMappingModel().addLayer(OabUtilities.createWMSLayer(cap, lname));
                }
                if (this.dialog.isAddTSWater()) {
                    cap = this.dialog.getTsWaterCapabilitiesUrl();
                    lname = this.dialog.getTsWaterLayername();
                    map.getMappingModel().addLayer(OabUtilities.createWMSLayer(cap, lname));
                }
                ComponentRegistry.getRegistry().showComponent("map");
            }
            catch (Exception ex) {
                log.warn((Object)"illegal action setup, oab map visualisation state undefined", (Throwable)ex);
            }
        }
    }

    public void setAutoAddFeatureToMap(boolean autoAddFeatureToMap) {
        this.autoAddFeatureToMap = autoAddFeatureToMap;
    }

    public boolean isAutoAddFeatureToMap() {
        return this.autoAddFeatureToMap;
    }

    public boolean isFeatureAdditionSelected() {
        return this.featureAdditionSelected;
    }

    public CidsBean getFeatureBean() {
        return this.dialog.getFeatureBean();
    }
}

