/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.reports.wunda_blau.PrintJahresberichtReport;
import de.cismet.cids.custom.wunda_blau.search.server.CidsBillingSearchStatement;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableDateChooser;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JahresberichtDialog
extends JDialog
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(JahresberichtDialog.class);
    private static JahresberichtDialog INSTANCE = null;
    private SwingWorker worker;
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Date fromDate = null;
    private Date stichtag = null;
    private JButton btnCancel;
    private JButton btnOk;
    private DefaultBindableDateChooser defaultBindableDateChooser1;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JProgressBar jProgressBar1;
    private JLabel lblErrorBillingsText;
    private JLabel lblErrorBillingsTitle;
    private JLabel lblNoBillingsText;
    private JLabel lblNoBillingsTitle;
    private JSpinner spnYear;
    private BindingGroup bindingGroup;

    private JahresberichtDialog() {
        super((Frame)null, false);
        this.initComponents();
    }

    public void setStichtag(Date stichtag) {
        this.stichtag = stichtag;
    }

    public Date getStichtag() {
        return this.stichtag;
    }

    public static JahresberichtDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JahresberichtDialog();
            INSTANCE.pack();
            Calendar date = GregorianCalendar.getInstance();
            int year = date.get(1);
            JahresberichtDialog.INSTANCE.spnYear.setValue(year);
        }
        return INSTANCE;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.lblNoBillingsText = new JLabel();
        this.lblNoBillingsTitle = new JLabel();
        this.lblErrorBillingsText = new JLabel();
        this.lblErrorBillingsTitle = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.spnYear = new JSpinner();
        this.jPanel2 = new JPanel();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.defaultBindableDateChooser1 = new DefaultBindableDateChooser();
        this.jLabel4 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.lblNoBillingsText, (String)NbBundle.getMessage(JahresberichtDialog.class, (String)"JahresberichtDialog.lblNoBillingsText.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblNoBillingsTitle, (String)NbBundle.getMessage(JahresberichtDialog.class, (String)"JahresberichtDialog.lblNoBillingsTitle.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblErrorBillingsText, (String)NbBundle.getMessage(JahresberichtDialog.class, (String)"JahresberichtDialog.lblErrorBillingsText.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblErrorBillingsTitle, (String)NbBundle.getMessage(JahresberichtDialog.class, (String)"JahresberichtDialog.lblErrorBillingsTitle.text"));
        this.setTitle(NbBundle.getMessage(JahresberichtDialog.class, (String)"JahresberichtDialog.title"));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(JahresberichtDialog.class, (String)"JahresberichtDialog.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.spnYear.setModel(new SpinnerNumberModel());
        this.spnYear.setEditor(new JSpinner.NumberEditor(this.spnYear, "#"));
        this.spnYear.setMinimumSize(new Dimension(70, 28));
        this.spnYear.setPreferredSize(new Dimension(70, 28));
        this.spnYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JahresberichtDialog.this.spnYearStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.spnYear, gridBagConstraints);
        this.jPanel2.setLayout(new GridLayout(1, 0, 10, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(JahresberichtDialog.class, (String)"JahresberichtDialog.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JahresberichtDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnCancel);
        Mnemonics.setLocalizedText((AbstractButton)this.btnOk, (String)NbBundle.getMessage(JahresberichtDialog.class, (String)"JahresberichtDialog.btnOk.text"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JahresberichtDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnOk);
        this.getRootPane().setDefaultButton(this.btnOk);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 22;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jProgressBar1.setString(NbBundle.getMessage(JahresberichtDialog.class, (String)"JahresberichtDialog.jProgressBar1.string"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel1.add((Component)this.jProgressBar1, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${stichtag}"), (Object)this.defaultBindableDateChooser1, (Property)BeanProperty.create((String)"date"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.defaultBindableDateChooser1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(JahresberichtDialog.class, (String)"JahresberichtDialog.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.bindingGroup.bind();
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.setVisible(false);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.jProgressBar1.setString(NbBundle.getMessage(JahresberichtDialog.class, (String)"JahresberichtDialog.jProgressBar1.string"));
        this.jProgressBar1.setIndeterminate(true);
        this.jProgressBar1.setStringPainted(true);
        this.btnOk.setEnabled(false);
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.worker = new SwingWorker<Collection, Integer>(){

            @Override
            protected Collection doInBackground() throws Exception {
                CidsBillingSearchStatement cidsBillingSearchStatement = new CidsBillingSearchStatement();
                cidsBillingSearchStatement.setAbrechnungsdatumFrom(JahresberichtDialog.this.fromDate);
                cidsBillingSearchStatement.setAbrechnungsdatumTill(JahresberichtDialog.this.stichtag);
                cidsBillingSearchStatement.setKostentyp(CidsBillingSearchStatement.Kostentyp.KOSTENPFLICHTIG);
                cidsBillingSearchStatement.setShowAbgerechneteBillings(null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Query to get the billings: " + cidsBillingSearchStatement.generateQuery()));
                }
                try {
                    Collection mons = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)cidsBillingSearchStatement, JahresberichtDialog.this.getConnectionContext());
                    if (mons == null) {
                        LOG.error((Object)"Billing metaobjects was null.");
                        return null;
                    }
                    this.publish(mons.size());
                    ArrayList<CidsBean> billingBeans = new ArrayList<CidsBean>(mons.size());
                    for (MetaObjectNode mon : mons) {
                        if (this.isCancelled()) break;
                        if (mon == null) continue;
                        this.publish(billingBeans.size() + 1);
                        MetaObject mo = SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), mon.getDomain(), JahresberichtDialog.this.getConnectionContext());
                        CidsBean bean = mo != null ? mo.getBean() : null;
                        billingBeans.add(bean);
                    }
                    return billingBeans;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while filtering the billings.", (Throwable)ex);
                    return null;
                }
            }

            @Override
            protected void process(List<Integer> chunks) {
                for (Integer chunk : chunks) {
                    if (JahresberichtDialog.this.jProgressBar1.isIndeterminate()) {
                        JahresberichtDialog.this.jProgressBar1.setIndeterminate(false);
                        JahresberichtDialog.this.jProgressBar1.setMaximum(chunk);
                        JahresberichtDialog.this.jProgressBar1.setValue(0);
                        continue;
                    }
                    String string = "Lade Buchung " + chunk + " von " + JahresberichtDialog.this.jProgressBar1.getMaximum();
                    JahresberichtDialog.this.jProgressBar1.setValue(chunk);
                    JahresberichtDialog.this.jProgressBar1.setString(string);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        Collection billings = (Collection)this.get();
                        if (billings.isEmpty()) {
                            JOptionPane.showMessageDialog(JahresberichtDialog.this, JahresberichtDialog.this.lblNoBillingsText.getText(), JahresberichtDialog.this.lblNoBillingsTitle.getText(), 0);
                        } else {
                            Date[] fromDate_tillDate = new Date[]{JahresberichtDialog.this.fromDate, JahresberichtDialog.this.stichtag};
                            int year = (Integer)JahresberichtDialog.this.spnYear.getValue();
                            PrintJahresberichtReport report = new PrintJahresberichtReport(fromDate_tillDate, billings, JahresberichtDialog.this.getConnectionContext());
                            report.print();
                        }
                    }
                    JahresberichtDialog.this.setVisible(false);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    JOptionPane.showMessageDialog(JahresberichtDialog.this, JahresberichtDialog.this.lblErrorBillingsText.getText(), JahresberichtDialog.this.lblErrorBillingsTitle.getText(), 0);
                }
                finally {
                    JahresberichtDialog.this.jProgressBar1.setMaximum(0);
                    JahresberichtDialog.this.jProgressBar1.setValue(0);
                    JahresberichtDialog.this.jProgressBar1.setStringPainted(false);
                    JahresberichtDialog.this.jProgressBar1.setIndeterminate(false);
                    JahresberichtDialog.this.btnOk.setEnabled(true);
                }
            }
        };
        this.worker.execute();
    }

    private void spnYearStateChanged(ChangeEvent evt) {
        boolean fullYear;
        int year = (Integer)this.spnYear.getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(5, 1);
        calendar.set(2, 0);
        calendar.set(1, year);
        this.fromDate = calendar.getTime();
        calendar.clear();
        calendar.set(5, 31);
        calendar.set(2, 11);
        calendar.set(1, year);
        Date tmpTillDate = calendar.getTime();
        Date now = new Date();
        if (now.before(tmpTillDate)) {
            tmpTillDate = now;
            fullYear = false;
        } else {
            fullYear = true;
        }
        this.defaultBindableDateChooser1.setEnabled(!fullYear);
        this.bindingGroup.unbind();
        this.stichtag = tmpTillDate;
        this.bindingGroup.bind();
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

