/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.clientutils;

import java.awt.image.BufferedImage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;

import de.cismet.tools.Base64;

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class ConversionUtils {

    //~ Methods ----------------------------------------------------------------

    /**
     * Converts the given image to a base64 string.
     *
     * @param   i  the image to convert
     *
     * @return  a base64 string representation of the given image
     *
     * @throws  IOException  DOCUMENT ME!
     */
    public static String image2String(final BufferedImage i) throws IOException {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write(i, "png", out);

        return new String(Base64.toBase64(out.toByteArray(), false));
    }

    /**
     * Converts the given base64 string to an image.
     *
     * @param   s  the string to convert (a base64 representation of an image)
     *
     * @return  the image that was generated by the given base 64 string
     *
     * @throws  IOException  DOCUMENT ME!
     */
    public static BufferedImage String2Image(final String s) throws IOException {
        final ByteArrayInputStream in = new ByteArrayInputStream(Base64.fromBase64(s.getBytes(), false));

        return ImageIO.read(in);
    }
}
