/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;

import org.apache.log4j.Logger;

import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.StringWriter;

import java.net.URL;

import java.util.Properties;
import java.util.logging.Level;

import javax.swing.SwingWorker;

import de.cismet.cids.client.tools.DevelopmentTools;

import de.cismet.cids.custom.wunda_blau.search.actions.ListDatasourcesAction;
import de.cismet.cids.custom.wunda_blau.search.actions.RefreshDatasourceAction;

import de.cismet.cids.server.actions.ServerActionParameter;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

import de.cismet.tools.JnlpSystemPropertyHelper;

import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.configuration.NoWriteError;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;

/*
 * Copyright (C) 2013 cismet GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * DOCUMENT ME!
 *
 * @author   therter
 * @version  $Revision$, $Date$
 */
public class DatasourceListAdminDialog extends javax.swing.JDialog implements ConnectionContextProvider, Configurable {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(DatasourceListAdminDialog.class);

    //~ Instance fields --------------------------------------------------------

    private final ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Element config;
    private Element masterConfig;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnChangePassword;
    private javax.swing.JButton btnClose;
    private javax.swing.JButton btnRefreshCapabilitiesList;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form AdminPasswordChangerDialog.
     *
     * @param  parent  DOCUMENT ME!
     * @param  modal   DOCUMENT ME!
     */
    public DatasourceListAdminDialog(final java.awt.Frame parent, final boolean modal) {
        super(parent, modal);
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        btnChangePassword = new javax.swing.JButton();
        btnRefreshCapabilitiesList = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        btnClose = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(
                DatasourceListAdminDialog.class,
                "DatasourceListAdminDialog.title")); // NOI18N
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            btnChangePassword,
            org.openide.util.NbBundle.getMessage(
                DatasourceListAdminDialog.class,
                "DatasourceListAdminDialog.btnChangePassword.text",
                new Object[] {})); // NOI18N
        btnChangePassword.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnChangePasswordActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 0);
        jPanel2.add(btnChangePassword, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            btnRefreshCapabilitiesList,
            org.openide.util.NbBundle.getMessage(
                DatasourceListAdminDialog.class,
                "DatasourceListAdminDialog.btnRefreshCapabilitiesList.text",
                new Object[] {})); // NOI18N
        btnRefreshCapabilitiesList.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnRefreshCapabilitiesListActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 0);
        jPanel2.add(btnRefreshCapabilitiesList, gridBagConstraints);

        jPanel1.add(jPanel2, java.awt.BorderLayout.CENTER);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            btnClose,
            org.openide.util.NbBundle.getMessage(
                DatasourceListAdminDialog.class,
                "DatasourceListAdminDialog.btnClose.text")); // NOI18N
        btnClose.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnCloseActionPerformed(evt);
                }
            });
        jPanel3.add(btnClose, new java.awt.GridBagConstraints());

        jPanel1.add(jPanel3, java.awt.BorderLayout.SOUTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnCloseActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnCloseActionPerformed
        System.exit(0);
    }                                                                            //GEN-LAST:event_btnCloseActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnChangePasswordActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnChangePasswordActionPerformed
        new SwingWorker<Object, Object>() {

                @Override
                protected Object doInBackground() throws Exception {
                    createDatasourceList();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        get();
                    } catch (final Exception ex) {
                        LOG.error("error while executing swingworker", ex);
                        final ErrorInfo errorInfo = new ErrorInfo(
                                "Fehler",
                                "Fehler beim Erstellen der Datenquellenliste: "
                                        + ex.getCause().getMessage(),
                                null,
                                null,
                                ex,
                                Level.ALL,
                                null);
                        JXErrorPane.showDialog(null, errorInfo);
                    }
                }
            }.execute();
    } //GEN-LAST:event_btnChangePasswordActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRefreshCapabilitiesListActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnRefreshCapabilitiesListActionPerformed
        final ConfigurationManager configurationManager = new ConfigurationManager();

        configurationManager.setDefaultFileName("defaultCismapProperties.xml");
        configurationManager.setFallBackFileName("defaultCismapProperties.xml");

        configurationManager.setFileName("configurationPlugin.xml");
        configurationManager.setClassPathFolder("/");
        String dirExtension = "";
        try {
            final String ext = JnlpSystemPropertyHelper.getProperty("directory.extension"); // NOI18N

            System.out.println("SystemdirExtension=:" + ext); // NOI18N

            if (ext != null) {
                dirExtension = ext;
            }
        } catch (final Exception e) {
            LOG.warn("Error while adding DirectoryExtension"); // NOI18N
        }
        configurationManager.setFolder(".cismap" + dirExtension);
        configurationManager.configure(this);

//        final StringWriter writer = new StringWriter();
//        final XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
//        try {
//            xmlOutputter.output(masterConfig, writer);
//            System.out.println(writer.toString());
//        } catch (Exception e) {
//        }
        final Document doc = new Document();
        final Element rootElement = new Element("root");
        // masterConfig.getChild("cismetConfigurationManager").getChild("cismapCapabilitiesPreferences")
        rootElement.addContent(masterConfig.getChild("cismapCapabilitiesPreferences").detach());
        doc.addContent(rootElement);

        final StringWriter writer = new StringWriter();
        final XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());

        try {
            xmlOutputter.output(doc, writer);
            final ServerActionParameter paramServerList = new ServerActionParameter(
                    RefreshDatasourceAction.ParameterType.SERVER_DOCUMENT.toString(),
                    writer.toString());
            final Object ret = SessionManager.getProxy()
                        .executeTask(
                            RefreshDatasourceAction.TASK_NAME,
                            "WUNDA_BLAU",
                            (Object)null,
                            getConnectionContext(),
                            paramServerList);
        } catch (Exception ex) {
            LOG.error("error while write new Capabilities file", ex);
        }
    } //GEN-LAST:event_btnRefreshCapabilitiesListActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  args  the command line arguments
     */
    public static void main(final String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    try {
                        final DatasourceListAdminDialog dialog = new DatasourceListAdminDialog(
                                new javax.swing.JFrame(),
                                true);
                        final String callServerUrl;
                        final String domain;
                        final boolean compressionEnabled;
                        if (args.length == 1) {
                            final String cfgFile = args[0];
                            final Properties properties = new Properties();
                            if ((cfgFile.indexOf("http://") == 0) || (cfgFile.indexOf("https://") == 0)
                                        || (cfgFile.indexOf("file:/") == 0)) {
                                properties.load(new URL(cfgFile).openStream());
                            } else {
                                properties.load(new BufferedInputStream(new FileInputStream(cfgFile)));
                            }
                            callServerUrl = properties.getProperty("callserverURL");
                            domain = properties.getProperty("userDomain");
                            compressionEnabled = Boolean.parseBoolean(
                                    properties.getProperty("compressionEnabled", "true"));
                        } else {
                            callServerUrl = args[0];
                            domain = args[1];
                            compressionEnabled = (args.length > 2) && "compressionEnabled".equals(args[2]);
                        }
                        DevelopmentTools.showSimpleLoginDialog(
                            callServerUrl,
                            domain,
                            compressionEnabled,
                            dialog.getConnectionContext());
                        dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                                @Override
                                public void windowClosing(final java.awt.event.WindowEvent e) {
                                    System.exit(0);
                                }
                            });
                        StaticSwingTools.showDialog(dialog);
                        System.exit(0);
                    } catch (final Exception ex) {
                        LOG.fatal("Fehler beim Starten des Datasource Admin Dialogs.", ex);
                        final ErrorInfo errorInfo = new ErrorInfo(
                                "Fehler",
                                "Fehler beim Starten des Datasource Admin Dialogs.",
                                null,
                                null,
                                ex,
                                Level.ALL,
                                null);
                        JXErrorPane.showDialog(null, errorInfo);
                        System.exit(1);
                    }
                }
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    private void createDatasourceList() throws Exception {
        final Object ret = SessionManager.getProxy()
                    .executeTask(
                        ListDatasourcesAction.TASK_NAME,
                        "WUNDA_BLAU",
                        (Object)null,
                        getConnectionContext());

        if (ret instanceof Exception) {
            throw (Exception)ret;
        }
    }

    @Override
    public final ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    @Override
    public void configure(final Element parent) {
        config = parent;
    }

    @Override
    public void masterConfigure(final Element parent) {
        masterConfig = parent;
    }

    @Override
    public Element getConfiguration() throws NoWriteError {
        return null;
    }
}
