/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.commons.gui;

import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.ui.ComponentRegistry;

import com.vividsolutions.jts.geom.Geometry;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.SwingWorker;

import de.cismet.cids.custom.wunda_blau.search.VermessungRissCreateSearchGeometryListener;
import de.cismet.cids.custom.wunda_blau.search.VermessungRissWindowSearch;

import de.cismet.cids.server.search.MetaObjectNodeServerSearch;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class VermessungsrissSuchDialog extends javax.swing.JDialog implements ConnectionContextProvider {

    //~ Instance fields --------------------------------------------------------

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.cids.custom.wunda_blau.search.VermessungRissWindowSearch vermessungRissWindowSearch1;
    // End of variables declaration//GEN-END:variables

    private final ConnectionContext connectionContext;
    private VermessungRissWindowSearch vermSearch =
        new de.cismet.cids.custom.wunda_blau.search.VermessungRissWindowSearch() {

            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                if (VermessungRissCreateSearchGeometryListener.ACTION_SEARCH_STARTED.equals(evt.getPropertyName())) {
                    if ((evt.getNewValue() != null) && (evt.getNewValue() instanceof Geometry)) {
                        final MetaObjectNodeServerSearch search = getServerSearch((Geometry)evt.getNewValue());
                        CidsSearchExecutor.searchAndDisplayResultsWithDialog(
                            search,
                            new PropertyChangeListener() {

                                @Override
                                public void propertyChange(final PropertyChangeEvent evt) {
                                }
                            },
                            new PropertyChangeListener() {

                                @Override
                                public void propertyChange(final PropertyChangeEvent evt) {
                                    if (!(evt.getSource() instanceof SwingWorker)
                                                || !"state".equalsIgnoreCase(evt.getPropertyName())) {
                                        return;
                                    }

                                    if (SwingWorker.StateValue.DONE.equals(evt.getNewValue())) {
                                        ComponentRegistry.getRegistry().getSearchResultsTree().setSelectionRow(0);
                                    }
                                }
                            },
                            getConnectionContext());
                    }
                }
            }
        };

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form NewJDialog.
     *
     * @param  parent             DOCUMENT ME!
     * @param  modal              DOCUMENT ME!
     * @param  connectionContext  DOCUMENT ME!
     */
    public VermessungsrissSuchDialog(final java.awt.Frame parent,
            final boolean modal,
            final ConnectionContext connectionContext) {
        super(parent, modal);
        this.connectionContext = connectionContext;
        vermSearch.initWithConnectionContext(connectionContext);
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        final java.awt.GridBagConstraints gridBagConstraints;

        vermessungRissWindowSearch1 = vermSearch;

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(
                VermessungsrissSuchDialog.class,
                "VermessungsrissSuchDialog.title")); // NOI18N
        getContentPane().setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(vermessungRissWindowSearch1, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  args  the command line arguments
     */
    public static void main(final String[] args) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (final javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(VermessungsrissSuchDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(VermessungsrissSuchDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(VermessungsrissSuchDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(VermessungsrissSuchDialog.class.getName())
                    .log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    final VermessungsrissSuchDialog dialog = new VermessungsrissSuchDialog(
                            new javax.swing.JFrame(),
                            true,
                            ConnectionContext.createDeprecated());
                    dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                            @Override
                            public void windowClosing(final java.awt.event.WindowEvent e) {
                                System.exit(0);
                            }
                        });
                    dialog.setVisible(true);
                }
            });
    }

    @Override
    public final ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
