/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/*
 * Wbf_gebaeudeFeatureRenderer.java
 *
 * Created on 01.07.2009, 14:59:10
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import org.jdesktop.swingx.image.ColorTintFilter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;

import java.util.Collection;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;

import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten
 * @version  $Revision$, $Date$
 */
public class Wbf_gebaeudeFeatureRenderer extends CustomCidsFeatureRenderer {

    //~ Static fields/initializers ---------------------------------------------

    private static Color BCKGRND = new Color(128, 128, 128, 128);

    //~ Instance fields --------------------------------------------------------

    ColorTintFilter tinter = new ColorTintFilter(Color.BLUE, 0.5f);

    private CidsBean cidsBean;
    private final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(this.getClass());
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextPane txtDescription;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form Wbf_gebaeudeFeatureRenderer.
     */
    public Wbf_gebaeudeFeatureRenderer() {
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        jScrollPane1 = new javax.swing.JScrollPane();
        txtDescription = new javax.swing.JTextPane();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3));
        setOpaque(false);
        setLayout(new java.awt.BorderLayout());

        jScrollPane1.setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jScrollPane1.setOpaque(false);

        txtDescription.setContentType("text/html");
        txtDescription.setEditable(false);
        txtDescription.setOpaque(false);
        jScrollPane1.setViewportView(txtDescription);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     */
    @Override
    public void assign() {
        cidsBean = metaObject.getBean();
        txtDescription.setText(getHtmlString());
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public float getTransparency() {
        return 1;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public Paint getFillingStyle() {
        return BCKGRND;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public FeatureAnnotationSymbol getPointSymbol() {
        Color color = Color.GRAY;
        final int size = 16;
        final BufferedImage bi = new BufferedImage(size, size, BufferedImage.TYPE_INT_ARGB);
        try {
            final CidsBean cb = metaObject.getBean();
            final CidsBean nutzungsart = (CidsBean)cb.getProperty("art");
            final String typ = (String)nutzungsart.getProperty("typ");
            final String beschreibung = (String)nutzungsart.getProperty("beschreibung");
            if (typ.equalsIgnoreCase("eigenheim") && beschreibung.equalsIgnoreCase("eigentumswohnung")) {
                color = Color.GREEN;
                if (log.isDebugEnabled()) {
                    log.debug("grün");
                }
            } else if (typ.equalsIgnoreCase("eigenheim")) {
                color = Color.YELLOW;
                if (log.isDebugEnabled()) {
                    log.debug("gelb");
                }
            } else if (typ.equalsIgnoreCase("mietwohngebäude")) {
                color = Color.RED;
                if (log.isDebugEnabled()) {
                    log.debug("rot");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("grau");
                }
            }

            // Form
            final Graphics2D graphics = (Graphics2D)bi.getGraphics();
            graphics.setColor(color);

            final Integer[] intArray;
            if (typ.equalsIgnoreCase("mietwohngebäude") && beschreibung.equalsIgnoreCase("familiengerechtes Wohnen")) {
                graphics.fillPolygon(new int[] { 0, 16, 8, 0 },
                    new int[] { 0, 0, 16, 0 }, 4);
                if (log.isDebugEnabled()) {
                    log.debug("Dreieck");
                }
            } else if (typ.equalsIgnoreCase("mietwohngebäude")
                        && beschreibung.equalsIgnoreCase("altengerechtes Wohnen")) {
                graphics.setStroke(new BasicStroke(2));
                graphics.drawRect(0, 0, size, size);
                if (log.isDebugEnabled()) {
                    log.debug("ungefülltes Quadrat");
                }
            } else if (typ.equalsIgnoreCase("mietwohngebäude")
                        && beschreibung.equalsIgnoreCase("behindertengerechtes Wohnen")) {
                graphics.fillOval(0, 0, size, size);
                if (log.isDebugEnabled()) {
                    log.debug("Kreis");
                }
            } else {
                graphics.fillRect(0, 0, size, size);
                if (log.isDebugEnabled()) {
                    log.debug("Quadrat");
                }
            }
        } catch (Throwable t) {
            log.warn("Fehler in getPointSymbol()", t);
            color = Color.GRAY;
            final Graphics2D graphics = (Graphics2D)bi.getGraphics();
            graphics.setColor(color);
            graphics.fillRect(0, 0, size, size);
        }

//
//        graphics.f graphics
//        .fillOval(0, 0, size, size);

        final BufferedImage tint = new BufferedImage(size, size, BufferedImage.TYPE_INT_RGB);
        ((Graphics2D)tint.getGraphics()).drawImage(bi, 0, 0, null);
        tinter.filter(tint, tint);

        final FeatureAnnotationSymbol symb = FeatureAnnotationSymbol.newCustomSweetSpotFeatureAnnotationSymbol(
                bi,
                null,
                0.5,
                0.5);

        return symb;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public String getAlternativeName() {
        final Object o = cidsBean.getProperty("vorgaenge");
        if (o instanceof Collection) {
            final Collection c = (Collection)o;
            return c.toArray()[0].toString() + " (Anzahl Vorgänge: " + c.size() + ")";
        }
        final String ret = (String)cidsBean.getProperty("gebaeude_anschrift");
        if (ret != null) {
            return ret;
        } else {
            return "Wohnungsbauförderung";
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private String getHtmlString() {
        try {
            String header = "<html><body style=\"font-family: Arial,Helvetica,sans-serif; font-size:11pt\">"
                        + "<b>Eigentümer: %s</b>"
                        + "<br>%s"
                        + "<hr>";

            final String eigentuemer = (String)cidsBean.getProperty("eigentuemer_name");
            String art = null;
            final Object artO = cidsBean.getProperty("art");
            if ((artO instanceof CidsBean) && (artO != null)) {
                final CidsBean artCidsBean = (CidsBean)artO;
                art = (String)artCidsBean.getProperty("beschreibung");
            }
            if (art == null) {
                art = "keine Nutzungsart";
            }

            header = String.format(header, eigentuemer, art);

            final Object o = cidsBean.getProperty("vorgaenge");
            final StringBuilder vorgaenge = new StringBuilder();
            if (o instanceof Collection) {
                final Collection c = (Collection)o;
                for (final Object ob : c) {
                    String v = "Vorgang: %s (%s)<br>";

                    if (ob instanceof CidsBean) {
                        final CidsBean cb = (CidsBean)ob;
                        String nr = (String)cb.getProperty("vergabenummer");
                        final String fnr = (String)cb.getProperty("folgenummer");
                        if ((fnr != null) && !fnr.trim().equals("0")) {
                            nr += "/" + fnr;
                        }
                        String massnahmenkategorisierung = null;
                        final Object massKatOb = cb.getProperty("massnahmenkategorisierung");

                        if (massKatOb instanceof CidsBean) {
                            final CidsBean mkCidsBean = (CidsBean)massKatOb;
                            massnahmenkategorisierung = (String)mkCidsBean.getProperty("beschreibung");
                        }

                        if (nr == null) {
                            nr = "-";
                        }
                        if (massnahmenkategorisierung == null) {
                            massnahmenkategorisierung = "keine Kategorie";
                        }
                        v = String.format(v, nr, massnahmenkategorisierung);
                        vorgaenge.append(v);
                    }
                }
            }

            final String footer = "</body></html>";
            return header + vorgaenge + footer;
        } catch (Exception e) {
            log.error("Error in getHtmlString", e);
            return "";
        }
    }
}
