/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.motd;

import java.awt.Frame;

import javax.swing.SwingUtilities;

import de.cismet.cids.server.messages.CidsServerMessage;

import de.cismet.cids.servermessage.CidsServerMessageNotifierListener;
import de.cismet.cids.servermessage.CidsServerMessageNotifierListenerEvent;

import de.cismet.tools.gui.DialogOpenedEvent;
import de.cismet.tools.gui.DialogOpenedListener;
import de.cismet.tools.gui.DialogSupport;
import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class MotdDialog extends javax.swing.JDialog implements CidsServerMessageNotifierListener, DialogOpenedListener {

    //~ Static fields/initializers ---------------------------------------------

    private static MotdDialog INSTANCE = new MotdDialog();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.tools.gui.FXWebViewPanel fXWebViewPanel1;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form MotdDialog.
     */
    private MotdDialog() {
        super((Frame)null, true);
        initComponents();
        DialogSupport.addDialogListener(this);
        getRootPane().setDefaultButton(jButton1);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static MotdDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MotdDialog();
        }
        return INSTANCE;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        fXWebViewPanel1 = new de.cismet.tools.gui.FXWebViewPanel();
        jButton1 = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();

        setTitle(org.openide.util.NbBundle.getMessage(MotdDialog.class, "MotdDialog.title")); // NOI18N
        setMinimumSize(new java.awt.Dimension(400, 300));
        setPreferredSize(new java.awt.Dimension(400, 300));
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(fXWebViewPanel1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jButton1,
            org.openide.util.NbBundle.getMessage(MotdDialog.class, "MotdDialog.jButton1.text")); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton1ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LAST_LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        jPanel1.add(jButton1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jSeparator1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton1ActionPerformed
        setVisible(false);
    }                                                                            //GEN-LAST:event_jButton1ActionPerformed

    @Override
    public void messageRetrieved(final CidsServerMessageNotifierListenerEvent event) {
        if (event != null) {
            final CidsServerMessage message = event.getMessage();
            if ((message != null) && (message.getContent() instanceof String)) {
                final String messageContent = (String)message.getContent();
                SwingUtilities.invokeLater(new Runnable() {

                        @Override
                        public void run() {
                            fXWebViewPanel1.loadContent(messageContent);
                            pack();
                            StaticSwingTools.showDialog(MotdDialog.this);
                        }
                    });
            }
        }
    }

    @Override
    public void setVisible(final boolean b) {
        super.setVisible(b);

        if (b) {
            setAlwaysOnTop(true);
            toFront();
            requestFocus();
            setAlwaysOnTop(false);
        }
    }

    @Override
    public void DialogOpened(final DialogOpenedEvent e) {
        if (isVisible()) {
            setAlwaysOnTop(true);
            toFront();
            requestFocus();
            setAlwaysOnTop(false);
        }
    }
}
