/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/*
 * LocationinstanceEditor.java
 *
 * Created on 17.08.2009, 15:40:29
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.server.middleware.types.MetaObject;

import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;

import javax.swing.JOptionPane;

import de.cismet.cids.custom.clientutils.HexcolorFormatter;
import de.cismet.cids.custom.objectrenderer.wunda_blau.SignaturListCellRenderer;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.FastBindableReferenceCombo;

import de.cismet.cids.tools.metaobjectrenderer.Titled;

import de.cismet.connectioncontext.ConnectionContext;

import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   srichter
 * @version  $Revision$, $Date$
 */
public class Poi_locationtypeEditor extends DefaultCustomObjectEditor implements Titled {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(Poi_locationtypeEditor.class);

    //~ Instance fields --------------------------------------------------------

    private String latestIconUrl = null;
    private String title = "";

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAdd;
    private javax.swing.JButton btnMenAbort;
    private javax.swing.JButton btnMenOk;
    private javax.swing.JButton btnRemove;
    private javax.swing.JComboBox cbSignatur;
    private javax.swing.JComboBox cbTypes;
    private javax.swing.JCheckBox chkToPublish;
    private javax.swing.JDialog dlgAddLocationType;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel lblAuswaehlen;
    private javax.swing.JLabel lblDefinition;
    private javax.swing.JLabel lblFarbe;
    private javax.swing.JLabel lblHeader1;
    private javax.swing.JLabel lblHeader2;
    private javax.swing.JLabel lblIcon;
    private javax.swing.JLabel lblLocationTypes;
    private javax.swing.JLabel lblSignatur;
    private javax.swing.JLabel lblToPublish;
    private javax.swing.JList lstLocationTypes;
    private javax.swing.JPanel panButtons;
    private javax.swing.JPanel panCenter;
    private javax.swing.JPanel panContent1;
    private javax.swing.JPanel panContent2;
    private javax.swing.JPanel panMenButtons;
    private javax.swing.JPanel panNewSuchwort;
    private javax.swing.JPanel panSpacing1;
    private javax.swing.JPanel panSpacing2;
    private javax.swing.JScrollPane scpLocationtypeList;
    private javax.swing.JTextField txtDefinition;
    private javax.swing.JFormattedTextField txtFarbe;
    private javax.swing.JTextField txtName;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new Poi_locationtypeEditor object.
     */
    public Poi_locationtypeEditor() {
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        initComponents();
        dlgAddLocationType.pack();
        dlgAddLocationType.getRootPane().setDefaultButton(btnMenOk);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  cidsBean  DOCUMENT ME!
     */
    @Override
    public synchronized void setCidsBean(final CidsBean cidsBean) {
        super.setCidsBean(cidsBean);
    }

    /**
     * DOCUMENT ME!
     */
    @Override
    public void dispose() {
        super.dispose();
        dlgAddLocationType.dispose();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        dlgAddLocationType = new javax.swing.JDialog();
        panNewSuchwort = new javax.swing.JPanel();
        lblAuswaehlen = new javax.swing.JLabel();
        final MetaObject[] lebenslagen = de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils
                    .getLightweightMetaObjectsForTable(
                        "poi_spatialreferencesystemusinggeographicidentifiers",
                        new String[] { "theme" },
                        getConnectionContext());
        if (lebenslagen != null) {
            Arrays.sort(lebenslagen);
            cbTypes = new javax.swing.JComboBox(lebenslagen);
            panMenButtons = new javax.swing.JPanel();
            btnMenAbort = new javax.swing.JButton();
            btnMenOk = new javax.swing.JButton();
            panCenter = new javax.swing.JPanel();
            panContent1 = new RoundedPanel();
            lblHeader1 = new javax.swing.JLabel();
            lblIcon = new javax.swing.JLabel();
            txtName = new javax.swing.JTextField();
            jLabel1 = new javax.swing.JLabel();
            lblDefinition = new javax.swing.JLabel();
            txtDefinition = new javax.swing.JTextField();
            panSpacing1 = new javax.swing.JPanel();
            panContent2 = new RoundedPanel();
            lblHeader2 = new javax.swing.JLabel();
            lblLocationTypes = new javax.swing.JLabel();
            scpLocationtypeList = new javax.swing.JScrollPane();
            lstLocationTypes = new javax.swing.JList();
            panButtons = new javax.swing.JPanel();
            btnAdd = new javax.swing.JButton();
            btnRemove = new javax.swing.JButton();
            lblSignatur = new javax.swing.JLabel();
            cbSignatur = new FastBindableReferenceCombo("%1$2s", new String[] { "definition", "filename" });
            lblFarbe = new javax.swing.JLabel();
            txtFarbe = new javax.swing.JFormattedTextField(new HexcolorFormatter());
            lblToPublish = new javax.swing.JLabel();
            chkToPublish = new javax.swing.JCheckBox();
            panSpacing2 = new javax.swing.JPanel();

            dlgAddLocationType.setModal(true);

            panNewSuchwort.setMaximumSize(new java.awt.Dimension(180, 120));
            panNewSuchwort.setMinimumSize(new java.awt.Dimension(180, 120));
            panNewSuchwort.setPreferredSize(new java.awt.Dimension(180, 120));
            panNewSuchwort.setLayout(new java.awt.GridBagLayout());

            lblAuswaehlen.setText("Bitte Lebenslage auswählen:");
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
            panNewSuchwort.add(lblAuswaehlen, gridBagConstraints);
        }
        cbTypes.setMaximumSize(new java.awt.Dimension(100, 20));
        cbTypes.setMinimumSize(new java.awt.Dimension(100, 20));
        cbTypes.setPreferredSize(new java.awt.Dimension(100, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panNewSuchwort.add(cbTypes, gridBagConstraints);

        panMenButtons.setLayout(new java.awt.GridBagLayout());

        btnMenAbort.setText("Abbrechen");
        btnMenAbort.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnMenAbortActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panMenButtons.add(btnMenAbort, gridBagConstraints);

        btnMenOk.setText("Ok");
        btnMenOk.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnMenOkActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panMenButtons.add(btnMenOk, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panNewSuchwort.add(panMenButtons, gridBagConstraints);

        dlgAddLocationType.getContentPane().add(panNewSuchwort, java.awt.BorderLayout.CENTER);

        setLayout(new java.awt.GridBagLayout());

        panCenter.setOpaque(false);
        panCenter.setLayout(new java.awt.GridBagLayout());

        panContent1.setOpaque(false);
        panContent1.setLayout(new java.awt.GridBagLayout());

        lblHeader1.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        lblHeader1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblHeader1.setText("Beschreibung");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent1.add(lblHeader1, gridBagConstraints);

        lblIcon.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        lblIcon.setText("Name:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent1.add(lblIcon, gridBagConstraints);

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.identification}"),
                txtName,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("");
        binding.setSourceUnreadableValue("<Error>");
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent1.add(txtName, gridBagConstraints);

        jLabel1.setText("                  ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panContent1.add(jLabel1, gridBagConstraints);

        lblDefinition.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        lblDefinition.setText("Definition:        ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent1.add(lblDefinition, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.definition}"),
                txtDefinition,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setSourceNullValue("");
        binding.setSourceUnreadableValue("<Error>");
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent1.add(txtDefinition, gridBagConstraints);

        panSpacing1.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        panContent1.add(panSpacing1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panCenter.add(panContent1, gridBagConstraints);

        panContent2.setOpaque(false);
        panContent2.setLayout(new java.awt.GridBagLayout());

        lblHeader2.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        lblHeader2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblHeader2.setText("Einordnung");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent2.add(lblHeader2, gridBagConstraints);

        lblLocationTypes.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        lblLocationTypes.setText("Lebenslagen:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(7, 5, 5, 5);
        panContent2.add(lblLocationTypes, gridBagConstraints);

        lstLocationTypes.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);

        final org.jdesktop.beansbinding.ELProperty eLProperty = org.jdesktop.beansbinding.ELProperty.create(
                "${cidsBean.locationtypes}");
        final org.jdesktop.swingbinding.JListBinding jListBinding = org.jdesktop.swingbinding.SwingBindings
                    .createJListBinding(
                        org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                        this,
                        eLProperty,
                        lstLocationTypes);
        bindingGroup.addBinding(jListBinding);

        scpLocationtypeList.setViewportView(lstLocationTypes);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent2.add(scpLocationtypeList, gridBagConstraints);

        panButtons.setOpaque(false);
        panButtons.setLayout(new java.awt.GridBagLayout());

        btnAdd.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png"))); // NOI18N
        btnAdd.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnAddActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panButtons.add(btnAdd, gridBagConstraints);

        btnRemove.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png"))); // NOI18N
        btnRemove.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnRemoveActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panButtons.add(btnRemove, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent2.add(panButtons, gridBagConstraints);

        lblSignatur.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        lblSignatur.setText("Signatur:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent2.add(lblSignatur, gridBagConstraints);

        ((FastBindableReferenceCombo)cbSignatur).setSorted(true);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.signatur}"),
                cbSignatur,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        binding.setSourceNullValue("");
        binding.setSourceUnreadableValue("<Error>");
        bindingGroup.addBinding(binding);

        cbSignatur.setRenderer(new SignaturListCellRenderer());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent2.add(cbSignatur, gridBagConstraints);

        lblFarbe.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        lblFarbe.setText("Farbe:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent2.add(lblFarbe, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.color}"),
                txtFarbe,
                org.jdesktop.beansbinding.BeanProperty.create("value"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent2.add(txtFarbe, gridBagConstraints);

        lblToPublish.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        lblToPublish.setText("Veröffentlicht:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent2.add(lblToPublish, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.to_publish}"),
                chkToPublish,
                org.jdesktop.beansbinding.BeanProperty.create("selected"));
        binding.setSourceNullValue(false);
        binding.setSourceUnreadableValue(false);
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent2.add(chkToPublish, gridBagConstraints);

        panSpacing2.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        panContent2.add(panSpacing2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panCenter.add(panContent2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(panCenter, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnAddActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnAddActionPerformed
        StaticSwingTools.showDialog(StaticSwingTools.getParentFrame(Poi_locationtypeEditor.this),
            dlgAddLocationType,
            true);
    }                                                                          //GEN-LAST:event_btnAddActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemoveActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnRemoveActionPerformed
        final Object selection = lstLocationTypes.getSelectedValue();
        if (selection != null) {
            final int answer = JOptionPane.showConfirmDialog(
                    StaticSwingTools.getParentFrame(this),
                    "Soll die Lebenslage wirklich gelöscht werden?",
                    "Lebenslage entfernen",
                    JOptionPane.YES_NO_OPTION);
            if (answer == JOptionPane.YES_OPTION) {
                try {
                    final CidsBean type = (CidsBean)selection;
                    final Object typesCollection = cidsBean.getProperty("locationtypes");
                    if (typesCollection instanceof Collection) {
                        ((Collection)typesCollection).remove(type);
                    }
                } catch (Exception ex) {
                    final ErrorInfo ei = new ErrorInfo(
                            "Fehler beim Löschen",
                            "Beim Löschen der Lebenslage ist ein Fehler aufgetreten",
                            null,
                            null,
                            ex,
                            Level.SEVERE,
                            null);
                    JXErrorPane.showDialog(this, ei);
                }
            }
        }
    }                                                                             //GEN-LAST:event_btnRemoveActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnMenAbortActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnMenAbortActionPerformed
        dlgAddLocationType.setVisible(false);
    }                                                                               //GEN-LAST:event_btnMenAbortActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnMenOkActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnMenOkActionPerformed
        try {
            final Object selItem = cbTypes.getSelectedItem();
            if (selItem instanceof MetaObject) {
                addLebenslageBeanToLebenslagen(((MetaObject)selItem).getBean());
            }
        } catch (Exception ex) {
            LOG.error(ex, ex);
        } finally {
            dlgAddLocationType.setVisible(false);
        }
    }                                                                            //GEN-LAST:event_btnMenOkActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  newTypeBean  DOCUMENT ME!
     */
    private void addLebenslageBeanToLebenslagen(final CidsBean newTypeBean) {
        if (newTypeBean != null) {
            final Object o = cidsBean.getProperty("locationtypes");
            if (o instanceof Collection) {
                try {
                    final Collection<CidsBean> col = (Collection)o;
                    for (final CidsBean bean : col) {
                        if (newTypeBean.equals(bean)) {
                            LOG.info("Locationtype " + newTypeBean.getProperty("theme") + " already present!");
                            return;
                        }
                    }
                    col.add(newTypeBean);
                } catch (Exception ex) {
                    LOG.error(ex, ex);
                }
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public String getTitle() {
        if ((title == null) || (title.length() == 0)) {
            title = getTitleBackup();
        }
        return title;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  title  DOCUMENT ME!
     */
    @Override
    public void setTitle(final String title) {
        this.title = title;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public String getTitleBackup() {
        final CidsBean bean = cidsBean;
        if (bean != null) {
            return bean.getMetaObject().getMetaClass().getName();
        }
        return "POI-Thema";
    }
}
