/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import com.vividsolutions.jts.geom.Geometry;

import org.apache.log4j.Logger;

import java.net.URL;

import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;

import de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

import de.cismet.tools.CismetThreadPool;

import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.HttpDownload;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class RasterfariControlPanel extends javax.swing.JPanel implements ConnectionContextStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(RasterfariControlPanel.class);

    //~ Instance fields --------------------------------------------------------

    private final RasterfariDocumentLoaderPanel rasterfariDocumentLoaderPanel1;
    private ConnectionContext connectionContext;
    private final String downloadName;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup bgrControls;
    private javax.swing.JButton btnHome;
    private javax.swing.JButton btnOpen;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JToggleButton togPan;
    private javax.swing.JToggleButton togZoom;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new RasterfariControlPanel object.
     */
    public RasterfariControlPanel() {
        this(null, null);
    }

    /**
     * Creates new form RasterfariControlPanel.
     *
     * @param  rasterfariDocumentLoaderPanel1  DOCUMENT ME!
     * @param  downloadName                    DOCUMENT ME!
     */
    public RasterfariControlPanel(final RasterfariDocumentLoaderPanel rasterfariDocumentLoaderPanel1,
            final String downloadName) {
        this.rasterfariDocumentLoaderPanel1 = rasterfariDocumentLoaderPanel1;
        this.downloadName = downloadName;
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        initComponents();
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        final java.awt.GridBagConstraints gridBagConstraints;

        bgrControls = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        btnHome = rasterfariDocumentLoaderPanel1.getBtnHome();
        togPan = rasterfariDocumentLoaderPanel1.getTogPan();
        togZoom = rasterfariDocumentLoaderPanel1.getTogZoom();
        btnOpen = new javax.swing.JButton();

        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridLayout(0, 1, 0, 5));

        btnHome.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/home.gif")));                             // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            btnHome,
            org.openide.util.NbBundle.getMessage(RasterfariControlPanel.class, "RasterfariControlPanel.btnHome.text")); // NOI18N
        btnHome.setToolTipText(org.openide.util.NbBundle.getMessage(
                RasterfariControlPanel.class,
                "RasterfariControlPanel.btnHome.toolTipText"));                                                         // NOI18N
        bgrControls.add(btnHome);
        btnHome.setFocusPainted(false);
        btnHome.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        btnHome.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnHomeActionPerformed(evt);
                }
            });
        jPanel1.add(btnHome);

        bgrControls.add(togPan);
        togPan.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/pan.gif")));                             // NOI18N
        togPan.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(
            togPan,
            org.openide.util.NbBundle.getMessage(RasterfariControlPanel.class, "RasterfariControlPanel.togPan.text")); // NOI18N
        togPan.setToolTipText(org.openide.util.NbBundle.getMessage(
                RasterfariControlPanel.class,
                "RasterfariControlPanel.togPan.toolTipText"));                                                         // NOI18N
        togPan.setFocusPainted(false);
        togPan.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        togPan.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    togPanActionPerformed(evt);
                }
            });
        jPanel1.add(togPan);

        bgrControls.add(togZoom);
        togZoom.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/zoom.gif")));                             // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            togZoom,
            org.openide.util.NbBundle.getMessage(RasterfariControlPanel.class, "RasterfariControlPanel.togZoom.text")); // NOI18N
        togZoom.setToolTipText(org.openide.util.NbBundle.getMessage(
                RasterfariControlPanel.class,
                "RasterfariControlPanel.togZoom.toolTipText"));                                                         // NOI18N
        togZoom.setFocusPainted(false);
        togZoom.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        togZoom.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    togZoomActionPerformed(evt);
                }
            });
        jPanel1.add(togZoom);

        btnOpen.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/folder-image.png")));                     // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            btnOpen,
            org.openide.util.NbBundle.getMessage(RasterfariControlPanel.class, "RasterfariControlPanel.btnOpen.text")); // NOI18N
        btnOpen.setToolTipText(org.openide.util.NbBundle.getMessage(
                RasterfariControlPanel.class,
                "RasterfariControlPanel.btnOpen.toolTipText"));                                                         // NOI18N
        bgrControls.add(btnOpen);
        btnOpen.setFocusPainted(false);
        btnOpen.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        btnOpen.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnOpenActionPerformed(evt);
                }
            });
        jPanel1.add(btnOpen);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jPanel1, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void togPanActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_togPanActionPerformed
        rasterfariDocumentLoaderPanel1.actionPan();
    }                                                                          //GEN-LAST:event_togPanActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void togZoomActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_togZoomActionPerformed
        rasterfariDocumentLoaderPanel1.actionZoom();
    }                                                                           //GEN-LAST:event_togZoomActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnHomeActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnHomeActionPerformed
        rasterfariDocumentLoaderPanel1.actionOverview();
    }                                                                           //GEN-LAST:event_btnHomeActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnOpenActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnOpenActionPerformed
        try {
            final String priceGroup = "ea";
            final URL documentUrl = rasterfariDocumentLoaderPanel1.getDocumentUrl();

            if (BillingPopup.doBilling(
                            "fsuekom",
                            documentUrl.toExternalForm(),
                            (Geometry)null,
                            getConnectionContext(),
                            new BillingProductGroupAmount(priceGroup, 1))) {
                downloadProduct(documentUrl);
            }
        } catch (Exception e) {
            LOG.error("Error when trying to produce a alkis product", e);
            // Hier noch ein Fehlerdialog
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  url  DOCUMENT ME!
     */
    private void downloadProduct(final URL url) {
        CismetThreadPool.execute(new Runnable() {

                @Override
                public void run() {
                    if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog(RasterfariControlPanel.this)) {
                        final String urlString = url.toExternalForm();
                        final String filename = urlString.substring(urlString.lastIndexOf("/") + 1);

                        DownloadManager.instance()
                                .add(
                                    new HttpDownload(
                                        url,
                                        "",
                                        DownloadManagerDialog.getInstance().getJobName(),
                                        getDownloadName(),
                                        filename.substring(0, filename.lastIndexOf(".")),
                                        filename.substring(filename.lastIndexOf("."))));
                    }
                }
            });
    } //GEN-LAST:event_btnOpenActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public String getDownloadName() {
        return downloadName;
    }
}
