/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objecteditors.wunda_blau;

import javax.swing.JPanel;

import de.cismet.cids.custom.objectrenderer.utils.VermessungPictureFinderClientUtils;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;

import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;

import de.cismet.connectioncontext.ConnectionContext;

/**
 * DOCUMENT ME!
 *
 * @author   jweintraut
 * @version  $Revision$, $Date$
 */
public class VermessungInselkartenEditor extends AbstractVermessungEditor {

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox cmbGemarkung;
    private javax.swing.JComboBox cmbGeometrie;
    private javax.swing.JComboBox cmbGeometrieStatus;
    private javax.swing.Box.Filler gluGeneralInformationGap;
    private javax.swing.JLabel lblBlatt;
    private javax.swing.JLabel lblFlur;
    private javax.swing.JLabel lblGemarkung;
    private javax.swing.JLabel lblGeometrie;
    private javax.swing.JLabel lblGeometrieStatus;
    private javax.swing.JLabel lblVersion;
    private javax.swing.JPanel pnlInformation;
    private javax.swing.JTextField txtBlatt;
    private javax.swing.JTextField txtFlur;
    private javax.swing.JTextField txtVersion;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new VermessungInselkartenEditor object.
     */
    public VermessungInselkartenEditor() {
        this(false);
    }

    /**
     * Creates new form VermessungInselkartenEditor.
     *
     * @param  readOnly  DOCUMENT ME!
     */
    public VermessungInselkartenEditor(final boolean readOnly) {
        super(readOnly);
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        initComponents();
        super.initWithConnectionContext(connectionContext);
        if (isReadOnly()) {
            getGeneralInformationPanel().setVisible(false);
            /*lblGemarkung.setVisible(false);
             * lblFlur.setVisible(false); lblBlatt.setVisible(false); lblGeometrie.setVisible(false);
             * cmbGemarkung.setVisible(false); txtBlatt.setVisible(false);txtFlur.setVisible(false);*/

            cmbGeometrieStatus.setEditable(false);
            cmbGeometrieStatus.setEnabled(false);
            txtBlatt.setEditable(false);
            txtVersion.setEditable(false);
            txtFlur.setEditable(false);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        pnlInformation = new javax.swing.JPanel();
        lblVersion = new javax.swing.JLabel();
        txtFlur = new javax.swing.JTextField();
        lblGeometrie = new javax.swing.JLabel();
        if (!isReadOnly()) {
            cmbGeometrie = new DefaultCismapGeometryComboBoxEditor();
        }
        lblBlatt = new javax.swing.JLabel();
        lblFlur = new javax.swing.JLabel();
        cmbGeometrieStatus = new DefaultBindableReferenceCombo();
        lblGeometrieStatus = new javax.swing.JLabel();
        cmbGemarkung = new DefaultBindableReferenceCombo();
        lblGemarkung = new javax.swing.JLabel();
        txtBlatt = new javax.swing.JTextField();
        txtVersion = new javax.swing.JTextField();
        gluGeneralInformationGap = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));

        pnlInformation.setOpaque(false);
        pnlInformation.setLayout(new java.awt.GridBagLayout());

        lblVersion.setText(org.openide.util.NbBundle.getMessage(
                VermessungInselkartenEditor.class,
                "VermessungInselkartenEditor.lblVersion.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        pnlInformation.add(lblVersion, gridBagConstraints);

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.flur}"),
                txtFlur,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 7);
        pnlInformation.add(txtFlur, gridBagConstraints);

        lblGeometrie.setText(org.openide.util.NbBundle.getMessage(
                VermessungInselkartenEditor.class,
                "VermessungInselkartenEditor.lblGeometrie.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlInformation.add(lblGeometrie, gridBagConstraints);

        if (!isReadOnly()) {
            binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                    org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                    this,
                    org.jdesktop.beansbinding.ELProperty.create("${cidsBean.geometrie}"),
                    cmbGeometrie,
                    org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)cmbGeometrie).getConverter());
            bindingGroup.addBinding(binding);
        }
        if (!isReadOnly()) {
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
            pnlInformation.add(cmbGeometrie, gridBagConstraints);
        }

        lblBlatt.setText(org.openide.util.NbBundle.getMessage(
                VermessungInselkartenEditor.class,
                "VermessungInselkartenEditor.lblBlatt.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlInformation.add(lblBlatt, gridBagConstraints);

        lblFlur.setText(org.openide.util.NbBundle.getMessage(
                VermessungInselkartenEditor.class,
                "VermessungInselkartenEditor.lblFlur.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        pnlInformation.add(lblFlur, gridBagConstraints);

        cmbGeometrieStatus.setRenderer(new GeometrieStatusRenderer(cmbGeometrieStatus.getRenderer()));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.geometrie_status}"),
                cmbGeometrieStatus,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        cmbGeometrieStatus.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cmbGeometrieStatusActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 7);
        pnlInformation.add(cmbGeometrieStatus, gridBagConstraints);

        lblGeometrieStatus.setText(org.openide.util.NbBundle.getMessage(
                VermessungInselkartenEditor.class,
                "VermessungInselkartenEditor.lblGeometrieStatus.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        pnlInformation.add(lblGeometrieStatus, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.gemarkung}"),
                cmbGemarkung,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        pnlInformation.add(cmbGemarkung, gridBagConstraints);

        lblGemarkung.setLabelFor(cmbGemarkung);
        lblGemarkung.setText(org.openide.util.NbBundle.getMessage(
                VermessungInselkartenEditor.class,
                "VermessungInselkartenEditor.lblGemarkung.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlInformation.add(lblGemarkung, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.blatt}"),
                txtBlatt,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        pnlInformation.add(txtBlatt, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.version}"),
                txtVersion,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 7);
        pnlInformation.add(txtVersion, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.1;
        pnlInformation.add(gluGeneralInformationGap, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cmbGeometrieStatusActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cmbGeometrieStatusActionPerformed
        if (cmbGeometrieStatus.getSelectedItem() instanceof CidsBean) {
            final CidsBean geometrieStatus = (CidsBean)cmbGeometrieStatus.getSelectedItem();

            if (geometrieStatus.getProperty("id") instanceof Integer) {
                cmbGeometrieStatus.setBackground(COLORS_GEOMETRIE_STATUS.get(
                        (Integer)geometrieStatus.getProperty("id")));
            }
        }
    } //GEN-LAST:event_cmbGeometrieStatusActionPerformed

    @Override
    protected String getVermessungName() {
        return "Inselkarte";
    }

    @Override
    protected JPanel getInformationPanel() {
        return pnlInformation;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    protected String getDocumentFilename() {
        final CidsBean cidsBean = getCidsBean();
        final String schluessel = (String)cidsBean.getProperty("schluessel");
        final Integer gemarkung = (Integer)cidsBean.getProperty("gemarkung.id");
        final Integer flur = Integer.parseInt((String)cidsBean.getProperty("flur"));
        final Integer blatt = (Integer)cidsBean.getProperty("blatt");
        final String version = (String)cidsBean.getProperty("version");
        return VermessungPictureFinderClientUtils.getInselkartenPictureFilename(
                schluessel,
                gemarkung,
                flur,
                blatt,
                version);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  cidsBean  DOCUMENT ME!
     */
    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        super.setCidsBean(cidsBean);
        bindingGroup.unbind();

        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                cidsBean,
                getConnectionContext());
            bindingGroup.bind();
        }
    }

    @Override
    protected String findPicture() {
        final CidsBean cidsBean = getCidsBean();
        final String schluessel = (String)cidsBean.getProperty("schluessel");
        final Integer gemarkung = (Integer)cidsBean.getProperty("gemarkung.id");
        final Integer flur = Integer.parseInt((String)cidsBean.getProperty("flur"));
        final Integer blatt = (Integer)cidsBean.getProperty("blatt");
        final String version = (String)cidsBean.getProperty("version");

        return VermessungPictureFinderClientUtils.findInselkartenPicture(
                schluessel,
                gemarkung,
                flur,
                blatt,
                version);
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    protected String generateTitle() {
        final CidsBean cidsBean = getCidsBean();
        final String schluessel = (String)cidsBean.getProperty("schluessel");
        final String flur = (String)cidsBean.getProperty("flur");
        final Integer blatt = (Integer)cidsBean.getProperty("blatt");
        final String version = (String)cidsBean.getProperty("version");
        final String gemarkung = (String)cidsBean.getProperty("gemarkung.name");

        return new StringBuilder().append("Schlüssel ")
                    .append(((schluessel != null) && (schluessel.trim().length() > 0)) ? schluessel : "unbekannt")
                    .append(" - ")
                    .append("Gemarkung ")
                    .append((gemarkung != null) ? gemarkung : "unbekannt")
                    .append(" - ")
                    .append("Flur ")
                    .append((flur != null) ? flur : "unbekannt")
                    .append(" - ")
                    .append("Blatt ")
                    .append((blatt != null) ? blatt : "unbekannt")
                    .append(" - ")
                    .append("Version ")
                    .append((version != null) ? version : "unbekannt")
                    .toString();
    }

    /**
     * DOCUMENT ME!
     */
    @Override
    public void dispose() {
        super.dispose();
        bindingGroup.unbind();
        if (!isReadOnly()) {
            ((DefaultCismapGeometryComboBoxEditor)cmbGeometrie).dispose();
        }
    }
}
