/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.albo;

import Sirius.server.middleware.types.MetaClass;

import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

import org.openide.util.NbBundle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JComboBox;

import de.cismet.cids.custom.clientutils.CidsBeansTableModel;
import de.cismet.cids.custom.objecteditors.utils.ClientAlboProperties;
import de.cismet.cids.custom.objecteditors.utils.LongNumberConverter;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.DefaultBindableScrollableComboBox;

import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;

import de.cismet.tools.BrowserLauncher;

import static de.cismet.cids.custom.objecteditors.wunda_blau.albo.AbstractAlboFlaechePanel.LOG;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class AlboFlaecheMainStandortPanel extends AbstractAlboFlaechePanel {

    //~ Static fields/initializers ---------------------------------------------

    private static final String[] COLUMN_PROPERTIES = new String[] {
            "schluessel",
            "name",
            "massgebliche_branchengruppe",
            "fk_erhebungsklasse.name"
        };
    private static final String[] COLUMN_NAMES = new String[] {
            "WZ-Nummer",
            "Wirtschaftszweig",
            "maßgeblicher Branchengruppe",
            "Erhebungsklasse"
        };
    private static final Class[] COLUMN_CLASSES = new Class[] {
            String.class,
            String.class,
            Boolean.class,
            CidsBean.class
        };

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        jDialog1 = new javax.swing.JDialog();
        jPanel4 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jComboBox27 = new DefaultBindableScrollableComboBox(mcWirtschaftszweig, true, false);
        filler2 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        jPanel3 = new javax.swing.JPanel();
        filler3 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 0));
        jButton3 = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();
        jPanel14 = new javax.swing.JPanel();
        jLabel55 = new javax.swing.JLabel();
        jTextField8 = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        filler20 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 32767));
        jScrollPane4 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jLabel57 = new javax.swing.JLabel();
        jTextField10 = new javax.swing.JTextField();
        filler6 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        filler19 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 0));
        jPanel16 = new javax.swing.JPanel();
        jPanel48 = new javax.swing.JPanel();
        jFormattedTextField17 = new javax.swing.JFormattedTextField();
        jButton5 = new javax.swing.JButton();
        jLabel51 = new javax.swing.JLabel();
        jFormattedTextField18 = new javax.swing.JFormattedTextField();
        jButton6 = new javax.swing.JButton();
        filler63 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 0));
        jXHyperlink1 = new org.jdesktop.swingx.JXHyperlink();
        jLabel6 = new javax.swing.JLabel();
        filler22 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 32767));
        jScrollPane5 = new javax.swing.JScrollPane();
        jTextArea2 = new javax.swing.JTextArea();
        filler23 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        filler24 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 0));
        jPanel5 = new javax.swing.JPanel();
        jLabel50 = new javax.swing.JLabel();
        jLabel52 = new javax.swing.JLabel();
        jPanel15 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jXTable2 = new DroppedBeansTable();
        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 0));

        final FormListener formListener = new FormListener();

        jDialog1.setTitle("Wirtschaftszweig auswählen");
        jDialog1.setMinimumSize(new java.awt.Dimension(300, 100));
        jDialog1.setModal(true);
        jDialog1.setName("jDialog1"); // NOI18N
        jDialog1.setResizable(false);
        jDialog1.getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel4.setName("jPanel4"); // NOI18N
        jPanel4.setLayout(new java.awt.GridBagLayout());

        jPanel2.setName("jPanel2"); // NOI18N
        jPanel2.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, "Wirtschaftszweig:");
        jLabel1.setName("jLabel1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(jLabel1, gridBagConstraints);

        jComboBox27.setName("jComboBox27"); // NOI18N
        jComboBox27.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel2.add(jComboBox27, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add(jPanel2, gridBagConstraints);

        filler2.setName("filler2"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        jPanel4.add(filler2, gridBagConstraints);

        jPanel3.setName("jPanel3"); // NOI18N
        jPanel3.setLayout(new java.awt.GridBagLayout());

        filler3.setName("filler3"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(filler3, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jButton3, "Abbrechen");
        jButton3.setName("jButton3"); // NOI18N
        jButton3.addActionListener(formListener);
        jPanel3.add(jButton3, new java.awt.GridBagConstraints());

        org.openide.awt.Mnemonics.setLocalizedText(jButton4, "Hinzufügen");
        jButton4.setName("jButton4"); // NOI18N
        jButton4.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel3.add(jButton4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel4.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jDialog1.getContentPane().add(jPanel4, gridBagConstraints);

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        jPanel14.setName("jPanel14"); // NOI18N
        jPanel14.setOpaque(false);
        jPanel14.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel55, "Betriebsname:");
        jLabel55.setName("jLabel55"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel14.add(jLabel55, gridBagConstraints);

        jTextField8.setName("jTextField8"); // NOI18N

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.name}"),
                jTextField8,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel14.add(jTextField8, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, "Adressbuch-Adresse:");
        jLabel5.setName("jLabel5"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel14.add(jLabel5, gridBagConstraints);

        filler20.setName("filler20"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel14.add(filler20, gridBagConstraints);

        jScrollPane4.setName("jScrollPane4"); // NOI18N

        jTextArea1.setColumns(20);
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(2);
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setName("jTextArea1"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.adressbuch_adresse}"),
                jTextArea1,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        jScrollPane4.setViewportView(jTextArea1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel14.add(jScrollPane4, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel57, "Adressbuch-Branche:");
        jLabel57.setName("jLabel57"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel14.add(jLabel57, gridBagConstraints);

        jTextField10.setName("jTextField10"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.adressbuch_branche}"),
                jTextField10,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel14.add(jTextField10, gridBagConstraints);

        filler6.setName("filler6"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel14.add(filler6, gridBagConstraints);

        filler19.setName("filler19"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        jPanel14.add(filler19, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jPanel14, gridBagConstraints);

        jPanel16.setName("jPanel16"); // NOI18N
        jPanel16.setOpaque(false);
        jPanel16.setLayout(new java.awt.GridBagLayout());

        jPanel48.setName("jPanel48"); // NOI18N
        jPanel48.setOpaque(false);
        jPanel48.setLayout(new java.awt.GridBagLayout());

        jFormattedTextField17.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(
                new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("###0"))));
        jFormattedTextField17.setName("jFormattedTextField17"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.jahr_von}"),
                jFormattedTextField17,
                org.jdesktop.beansbinding.BeanProperty.create("value"));
        binding.setConverter(new LongNumberConverter());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel48.add(jFormattedTextField17, gridBagConstraints);

        jButton5.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/emptytrash.png"))); // NOI18N
        jButton5.setBorderPainted(false);
        jButton5.setContentAreaFilled(false);
        jButton5.setFocusPainted(false);
        jButton5.setMaximumSize(new java.awt.Dimension(16, 16));
        jButton5.setMinimumSize(new java.awt.Dimension(16, 16));
        jButton5.setName("jButton5");                                                                       // NOI18N
        jButton5.setPreferredSize(new java.awt.Dimension(16, 16));
        jButton5.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel48.add(jButton5, gridBagConstraints);
        jButton5.setVisible(isEditable());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel51, "bis:");
        jLabel51.setName("jLabel51"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 10, 2, 2);
        jPanel48.add(jLabel51, gridBagConstraints);

        jFormattedTextField18.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(
                new javax.swing.text.NumberFormatter(new java.text.DecimalFormat("###0"))));
        jFormattedTextField18.setName("jFormattedTextField18"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.jahr_bis}"),
                jFormattedTextField18,
                org.jdesktop.beansbinding.BeanProperty.create("value"));
        binding.setConverter(new LongNumberConverter());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel48.add(jFormattedTextField18, gridBagConstraints);

        jButton6.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/emptytrash.png"))); // NOI18N
        jButton6.setBorderPainted(false);
        jButton6.setContentAreaFilled(false);
        jButton6.setFocusPainted(false);
        jButton6.setMaximumSize(new java.awt.Dimension(16, 16));
        jButton6.setMinimumSize(new java.awt.Dimension(16, 16));
        jButton6.setName("jButton6");                                                                       // NOI18N
        jButton6.setPreferredSize(new java.awt.Dimension(16, 16));
        jButton6.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel48.add(jButton6, gridBagConstraints);
        jButton6.setVisible(isEditable());

        filler63.setName("filler63"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.weightx = 1.0;
        jPanel48.add(filler63, gridBagConstraints);

        jXHyperlink1.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cismap/commons/gui/infowidgets/res/info.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jXHyperlink1, "Klassifikationsserver");
        jXHyperlink1.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jXHyperlink1.setName("jXHyperlink1");                                                       // NOI18N
        jXHyperlink1.addActionListener(formListener);
        jPanel48.add(jXHyperlink1, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel16.add(jPanel48, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel6, "Bemerkungen:");
        jLabel6.setName("jLabel6"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jLabel6, gridBagConstraints);

        filler22.setName("filler22"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel16.add(filler22, gridBagConstraints);

        jScrollPane5.setName("jScrollPane5"); // NOI18N

        jTextArea2.setColumns(20);
        jTextArea2.setLineWrap(true);
        jTextArea2.setRows(3);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setName("jTextArea2"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.bemerkung}"),
                jTextArea2,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        jScrollPane5.setViewportView(jTextArea2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel16.add(jScrollPane5, gridBagConstraints);

        filler23.setName("filler23"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel16.add(filler23, gridBagConstraints);

        filler24.setName("filler24"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        jPanel16.add(filler24, gridBagConstraints);

        jPanel5.setName("jPanel5"); // NOI18N
        jPanel5.setOpaque(false);
        jPanel5.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel50, "Jahr");
        jLabel50.setName("jLabel50"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel5.add(jLabel50, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel52, "von:");
        jLabel52.setName("jLabel52"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel5.add(jLabel52, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel16.add(jPanel5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jPanel16, gridBagConstraints);

        jPanel15.setName("jPanel15"); // NOI18N
        jPanel15.setOpaque(false);
        jPanel15.setLayout(new java.awt.GridBagLayout());

        jScrollPane2.setName("jScrollPane2"); // NOI18N

        jXTable2.setModel(new StandortWirtschaftszweigTableModel());
        jXTable2.setName("jXTable2"); // NOI18N
        jXTable2.setVisibleRowCount(5);
        jScrollPane2.setViewportView(jXTable2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel15.add(jScrollPane2, gridBagConstraints);

        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jButton1.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/add.png"))); // NOI18N
        jButton1.setName("jButton1");                                                                // NOI18N
        jButton1.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        jPanel1.add(jButton1, gridBagConstraints);

        jButton2.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/remove.png"))); // NOI18N
        jButton2.setName("jButton2");                                                                   // NOI18N
        jButton2.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        jPanel1.add(jButton2, gridBagConstraints);

        filler1.setName("filler1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(filler1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        jPanel15.add(jPanel1, gridBagConstraints);
        jPanel1.setVisible(isEditable());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jPanel15, gridBagConstraints);

        bindingGroup.bind();
    }

    /**
     * Code for dispatching events from components to event handlers.
     *
     * @version  $Revision$, $Date$
     */
    private class FormListener implements java.awt.event.ActionListener {

        /**
         * Creates a new FormListener object.
         */
        FormListener() {
        }

        @Override
        public void actionPerformed(final java.awt.event.ActionEvent evt) {
            if (evt.getSource() == jXHyperlink1) {
                AlboFlaecheMainStandortPanel.this.jXHyperlink1ActionPerformed(evt);
            } else if (evt.getSource() == jButton1) {
                AlboFlaecheMainStandortPanel.this.jButton1ActionPerformed(evt);
            } else if (evt.getSource() == jButton2) {
                AlboFlaecheMainStandortPanel.this.jButton2ActionPerformed(evt);
            } else if (evt.getSource() == jComboBox27) {
                AlboFlaecheMainStandortPanel.this.jComboBox27ActionPerformed(evt);
            } else if (evt.getSource() == jButton3) {
                AlboFlaecheMainStandortPanel.this.jButton3ActionPerformed(evt);
            } else if (evt.getSource() == jButton4) {
                AlboFlaecheMainStandortPanel.this.jButton4ActionPerformed(evt);
            } else if (evt.getSource() == jButton5) {
                AlboFlaecheMainStandortPanel.this.jButton5ActionPerformed(evt);
            } else if (evt.getSource() == jButton6) {
                AlboFlaecheMainStandortPanel.this.jButton6ActionPerformed(evt);
            }
        }
    } // </editor-fold>//GEN-END:initComponents

    //~ Instance fields --------------------------------------------------------

    private MetaClass mcWirtschaftszweig;
    private CidsBean parentBean;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.Box.Filler filler1;
    private javax.swing.Box.Filler filler19;
    private javax.swing.Box.Filler filler2;
    private javax.swing.Box.Filler filler20;
    private javax.swing.Box.Filler filler22;
    private javax.swing.Box.Filler filler23;
    private javax.swing.Box.Filler filler24;
    private javax.swing.Box.Filler filler3;
    private javax.swing.Box.Filler filler6;
    private javax.swing.Box.Filler filler63;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JComboBox<String> jComboBox27;
    private javax.swing.JDialog jDialog1;
    private javax.swing.JFormattedTextField jFormattedTextField17;
    private javax.swing.JFormattedTextField jFormattedTextField18;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel50;
    private javax.swing.JLabel jLabel51;
    private javax.swing.JLabel jLabel52;
    private javax.swing.JLabel jLabel55;
    private javax.swing.JLabel jLabel57;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanel15;
    private javax.swing.JPanel jPanel16;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel48;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextArea jTextArea2;
    private javax.swing.JTextField jTextField10;
    private javax.swing.JTextField jTextField8;
    private org.jdesktop.swingx.JXHyperlink jXHyperlink1;
    private org.jdesktop.swingx.JXTable jXTable2;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new AlboFlaecheMainStandortSinglePanel object.
     */
    public AlboFlaecheMainStandortPanel() {
        initComponents();
    }

    /**
     * Creates a new AlboFlaecheXXXPanel object.
     *
     * @param  editable  DOCUMENT ME!
     */
    public AlboFlaecheMainStandortPanel(final boolean editable) {
        super(editable);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  the parentBean
     */
    public CidsBean getParentBean() {
        return parentBean;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  parentBean  the parentBean to set
     */
    public void setParentBean(final CidsBean parentBean) {
        this.parentBean = parentBean;
    }

    @Override
    protected void initGui() {
        try {
            mcWirtschaftszweig = CidsBean.getMetaClassFromTableName(
                    "WUNDA_BLAU",
                    "ALBO_WIRTSCHAFTSZWEIG",
                    getConnectionContext());
        } catch (Exception ex) {
            LOG.warn(ex, ex);
        }
        initComponents();
        if (!isEditable()) {
            RendererTools.makeReadOnly(getBindingGroup(), "cidsBean");
            RendererTools.makeReadOnly(jXTable2);
        } else {
            try {
                new CidsBeanDropTarget(jXTable2);
            } catch (final Exception ex) {
                LOG.warn("Error while creating CidsBeanDropTarget", ex); // NOI18N
            }
            AutoCompleteDecorator.decorate(jComboBox27);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton1ActionPerformed
        jComboBox27.setSelectedItem(null);
        final ComboBoxFilterDialogEnabledFilter filter = new CustomWirtschaftszweigFilter(jComboBox27);
        ComboBoxFilterDialog.showForCombobox(jComboBox27, "Wirtschaftszweig auswählen", filter, getConnectionContext());
        final CidsBean selected = (CidsBean)jComboBox27.getSelectedItem();
        if (selected != null) {
            ((StandortWirtschaftszweigTableModel)jXTable2.getModel()).add(selected);
        }
    }                                                                            //GEN-LAST:event_jButton1ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton2ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton2ActionPerformed
        ((StandortWirtschaftszweigTableModel)jXTable2.getModel()).remove(
            ((StandortWirtschaftszweigTableModel)jXTable2.getModel()).getCidsBean(
                jXTable2.getRowSorter().convertRowIndexToModel(jXTable2.getSelectedRow())));
    }                                                                            //GEN-LAST:event_jButton2ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton3ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton3ActionPerformed

        jDialog1.setVisible(false);
    } //GEN-LAST:event_jButton3ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton4ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton4ActionPerformed
        jDialog1.setVisible(false);
        ((StandortWirtschaftszweigTableModel)jXTable2.getModel()).add((CidsBean)jComboBox27.getSelectedItem());
    }                                                                            //GEN-LAST:event_jButton4ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jComboBox27ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jComboBox27ActionPerformed
    }                                                                               //GEN-LAST:event_jComboBox27ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jXHyperlink1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jXHyperlink1ActionPerformed
        try {
            BrowserLauncher.openURL(ClientAlboProperties.getInstance().getWzKlassifikationLink());
        } catch (Exception ex) {
            LOG.error(ex, ex);
        }
    }                                                                                //GEN-LAST:event_jXHyperlink1ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton5ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton5ActionPerformed
        jFormattedTextField17.setValue(null);
    }                                                                            //GEN-LAST:event_jButton5ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton6ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton6ActionPerformed
        jFormattedTextField18.setValue(null);
    }                                                                            //GEN-LAST:event_jButton6ActionPerformed

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        super.setCidsBean(cidsBean);

        if (jXTable2 != null) {
            ((StandortWirtschaftszweigTableModel)jXTable2.getModel()).setCidsBeans((getCidsBean() != null)
                    ? getCidsBean().getBeanCollectionProperty(
                        "arr_wirtschaftszweige") : null);
        }
    }

    @Override
    protected BindingGroup getBindingGroup() {
        return bindingGroup;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  beans  DOCUMENT ME!
     */
    private void beansDroppedIntoListener(final List<CidsBean> beans) {
        if (isEditable()) {
            final List<CidsBean> flaecheBeans = ((StandortWirtschaftszweigTableModel)jXTable2.getModel())
                        .getCidsBeans();
            for (final CidsBean wirtschaftszweigBean : beans) {
                if (
                    wirtschaftszweigBean.getMetaObject().getMetaClass().getTableName().equalsIgnoreCase(
                                "albo_wirtschaftszweig")
                            && !flaecheBeans.contains(wirtschaftszweigBean)) {
                    ((StandortWirtschaftszweigTableModel)jXTable2.getModel()).add(wirtschaftszweigBean);
                }
            }
        }
    }

    @Override
    public void dispose() {
        if (jXTable2.getModel() instanceof StandortWirtschaftszweigTableModel) {
            ((StandortWirtschaftszweigTableModel)jXTable2.getModel()).clear();
        }
        super.dispose();
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class StandortWirtschaftszweigTableModel extends CidsBeansTableModel {

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new StandortWirtschaftszweigTableModel object.
         */
        public StandortWirtschaftszweigTableModel() {
            super(COLUMN_PROPERTIES, COLUMN_NAMES, COLUMN_CLASSES);
        }

        //~ Methods ------------------------------------------------------------

        @Override
        public Object getValueAt(final int rowIndex, final int columnIndex) {
            if ((columnIndex == 2) && !loading) {
                if (!isRowWithinBounds(rowIndex)) {
                    return null;
                } else {
                    final CidsBean cidsBean = getCidsBean(rowIndex);
                    final CidsBean massWz = (CidsBean)parentBean.getProperty("massgeblicher_wirtschaftszweig");

                    return (massWz != null) && (cidsBean != null) && massWz.equals(cidsBean);
                }
            }

            return super.getValueAt(rowIndex, columnIndex);
        }

        @Override
        public void setValueAt(final Object value, final int rowIndex, final int columnIndex) {
            if ((columnIndex == 2) && !loading) {
                if (!isRowWithinBounds(rowIndex)) {
                    return;
                } else {
                    final CidsBean cidsBean = getCidsBean(rowIndex);
                    if (cidsBean != null) {
                        if (value instanceof Boolean) {
                            if ((Boolean)value) {
                                try {
                                    parentBean.setProperty("massgeblicher_wirtschaftszweig", cidsBean);
                                } catch (final Exception ex) {
                                    LOG.error(ex, ex);
                                }
                            } else if ((parentBean.getProperty("massgeblicher_wirtschaftszweig") != null)
                                        && parentBean.getProperty("massgeblicher_wirtschaftszweig").equals(cidsBean)) {
                                try {
                                    parentBean.setProperty("massgeblicher_wirtschaftszweig", null);
                                } catch (final Exception ex) {
                                    LOG.error(ex, ex);
                                }
                            }
                        }
                        final int minSelectioNIndex = jXTable2.getSelectionModel().getMinSelectionIndex();
                        final int maxSelectioNIndex = jXTable2.getSelectionModel().getMaxSelectionIndex();

                        fireTableDataChanged();
                        jXTable2.getSelectionModel().setSelectionInterval(minSelectioNIndex, maxSelectioNIndex);
                    }

                    return;
                }
            }

            super.setValueAt(value, rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(final int rowIndex, final int columnIndex) {
            return isEditable() && isRowWithinBounds(rowIndex) && (columnIndex == 2);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private class DroppedBeansTable extends JXTable implements CidsBeanDropListener {

        //~ Methods ------------------------------------------------------------

        @Override
        public void beansDropped(final ArrayList<CidsBean> beans) {
            beansDroppedIntoListener(beans);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    public static class CustomWirtschaftszweigFilter implements ComboBoxFilterDialogEnabledFilter {

        //~ Instance fields ----------------------------------------------------

        private JComboBox correspondingCombobox;
        private boolean selectionAllowed = false;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new CustomWirtschaftszweigFilter object.
         *
         * @param  correspondingCombobox  DOCUMENT ME!
         */
        public CustomWirtschaftszweigFilter(final JComboBox correspondingCombobox) {
            this(correspondingCombobox, false);
        }

        /**
         * Creates a new CustomWirtschaftszweigFilter object.
         *
         * @param  correspondingCombobox  DOCUMENT ME!
         * @param  selectionAllowed       DOCUMENT ME!
         */
        public CustomWirtschaftszweigFilter(final JComboBox correspondingCombobox, final boolean selectionAllowed) {
            this.correspondingCombobox = correspondingCombobox;
            this.selectionAllowed = selectionAllowed;
        }

        //~ Methods ------------------------------------------------------------

        @Override
        public boolean selectionOfDisabledElementsAllowed() {
            return selectionAllowed;
        }

        @Override
        public boolean isEnabled(final Object o, final int row) {
            if (row == -1) {
                return true;
            }
            final Object bean = correspondingCombobox.getModel().getElementAt(row);

            if (bean instanceof CidsBean) {
                final Object schluessel = ((CidsBean)bean).getProperty("fk_erhebungsklasse.schluessel");

                return (schluessel == null) || (!schluessel.equals("0") && !schluessel.equals("4"));
            }

            return true;
        }

        @Override
        public String getTooltip(final Object o, final int row) {
            if (row == -1) {
                return "";
            }
            final Object bean = correspondingCombobox.getModel().getElementAt(row);

            if (bean instanceof CidsBean) {
                final Object schluessel = ((CidsBean)bean).getProperty("fk_erhebungsklasse.schluessel");

                if ((schluessel != null) && (schluessel.equals("0"))) {
                    return NbBundle.getMessage(
                            AlboFlaecheMainStandortPanel.class,
                            "AlboFlaecheMainStandortPanel.getTooltip().wz0");
                } else if ((schluessel != null) && (schluessel.equals("4"))) {
                    return NbBundle.getMessage(
                            AlboFlaecheMainStandortPanel.class,
                            "AlboFlaecheMainStandortPanel.getTooltip().wz4");
                }
            }

            return "";
        }
    }
}
