/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.RequestsFullSizeComponent;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;

import org.openide.util.Exceptions;

import java.awt.CardLayout;

import java.util.Collection;

import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

import de.cismet.cids.custom.wunda_blau.search.server.BaulastSearchInfo;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanAggregationRenderer;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

import de.cismet.tools.gui.BorderProvider;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.TitleComponentProvider;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class Alb_baulastAggregationRenderer extends javax.swing.JPanel implements TitleComponentProvider,
    FooterComponentProvider,
    BorderProvider,
    RequestsFullSizeComponent,
    CidsBeanAggregationRenderer,
    ConnectionContextStore {

    //~ Enums ------------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    enum Mode {

        //~ Enum constants -----------------------------------------------------

        AGGR, SINGLE
    }

    //~ Instance fields --------------------------------------------------------

    private Mode mode;

    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.cids.custom.objectrenderer.wunda_blau.Alb_baulastAggregationRendererPanel
        alb_baulastAggregationRendererPanel1;
    private de.cismet.cids.custom.objectrenderer.wunda_blau.Alb_baulastblattRenderer alb_baulastblattRenderer1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new Alb_baulastAggregationRenderer object.
     */
    public Alb_baulastAggregationRenderer() {
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        initComponents();
        alb_baulastblattRenderer1.initWithConnectionContext(getConnectionContext());
    }

    @Override
    public final ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        alb_baulastAggregationRendererPanel1 =
            new de.cismet.cids.custom.objectrenderer.wunda_blau.Alb_baulastAggregationRendererPanel(
                getConnectionContext());
        alb_baulastblattRenderer1 = new de.cismet.cids.custom.objectrenderer.wunda_blau.Alb_baulastblattRenderer();

        setLayout(new java.awt.CardLayout());
        add(alb_baulastAggregationRendererPanel1, "aggr");

        alb_baulastblattRenderer1.setOpaque(false);
        add(alb_baulastblattRenderer1, "single");
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public JComponent getTitleComponent() {
        if (Mode.AGGR.equals(mode)) {
            return alb_baulastAggregationRendererPanel1.getTitleComponent();
        } else if (Mode.SINGLE.equals(mode)) {
            return alb_baulastblattRenderer1.getTitleComponent();
        } else {
            return null;
        }
    }

    @Override
    public void dispose() {
        if (Mode.AGGR.equals(mode)) {
            alb_baulastAggregationRendererPanel1.dispose();
        } else if (Mode.SINGLE.equals(mode)) {
            alb_baulastblattRenderer1.dispose();
        }
    }

    @Override
    public String getTitle() {
        if (Mode.AGGR.equals(mode)) {
            return alb_baulastAggregationRendererPanel1.getTitle();
        } else if (Mode.SINGLE.equals(mode)) {
            return alb_baulastblattRenderer1.getTitle();
        } else {
            return null;
        }
    }

    @Override
    public void setTitle(final String title) {
        if (Mode.AGGR.equals(mode)) {
            alb_baulastAggregationRendererPanel1.setTitle(title);
        } else if (Mode.SINGLE.equals(mode)) {
            alb_baulastblattRenderer1.setTitle(title);
        }
    }

    @Override
    public Collection<CidsBean> getCidsBeans() {
        if (Mode.AGGR.equals(mode)) {
            return alb_baulastAggregationRendererPanel1.getCidsBeans();
        } else {
            return null;
        }
    }

    @Override
    public JComponent getFooterComponent() {
        if (Mode.SINGLE.equals(mode)) {
            return alb_baulastblattRenderer1.getFooterComponent();
        } else {
            return null;
        }
    }

    @Override
    public Border getTitleBorder() {
        if (Mode.SINGLE.equals(mode)) {
            return alb_baulastblattRenderer1.getTitleBorder();
        } else {
            return new EmptyBorder(20, 20, 20, 20);
        }
    }

    @Override
    public Border getFooterBorder() {
        if (Mode.SINGLE.equals(mode)) {
            return alb_baulastblattRenderer1.getFooterBorder();
        } else {
            return new EmptyBorder(20, 20, 20, 20);
        }
    }

    @Override
    public Border getCenterrBorder() {
        if (Mode.SINGLE.equals(mode)) {
            return alb_baulastblattRenderer1.getCenterrBorder();
        } else {
            return new EmptyBorder(20, 20, 20, 20);
        }
    }

    @Override
    public void setCidsBeans(final Collection<CidsBean> cidsBeans) {
        String blattnummer = null;
        boolean allSameBaulastblatt = true;
        for (final CidsBean cidsBean : cidsBeans) {
            if ((cidsBean != null)
                        && "alb_baulast".equalsIgnoreCase(cidsBean.getMetaObject().getMetaClass().getTableName())
                        && (cidsBean.getProperty("blattnummer") != null)) {
                if (blattnummer == null) {
                    blattnummer = (String)cidsBean.getProperty("blattnummer");
                }
                if (!((String)cidsBean.getProperty("blattnummer")).equals(blattnummer)) {
                    allSameBaulastblatt = false;
                    break;
                }
            } else {
                allSameBaulastblatt = false;
                break;
            }
        }

        if (allSameBaulastblatt) {
            try {
                final BaulastSearchInfo bsi = new BaulastSearchInfo();
                bsi.setBlattnummer(blattnummer);
                final MetaClass mcBaulastBlatt = ClassCacheMultiple.getMetaClass(
                        "WUNDA_BLAU",
                        "ALB_BAULASTBLATT",
                        getConnectionContext());

                final String query = "select " + mcBaulastBlatt.getID() + ", " + mcBaulastBlatt.getPrimaryKey()
                            + " from "
                            + mcBaulastBlatt.getTableName() + " where blattnummer ilike '" + blattnummer + "'"; // NOI18N
                final MetaObject[] res = SessionManager.getProxy()
                            .getMetaObjectByQuery(query, 0, getConnectionContext());

                if ((res != null) && (res.length > 0)) {
                    final CidsBean cidsBean = res[0].getBean();
                    mode = Mode.SINGLE;
                    ((CardLayout)getLayout()).show(this, "single");
                    alb_baulastblattRenderer1.setCidsBean(cidsBean);
                } else {
                    mode = null;
                }
            } catch (ConnectionException ex) {
                Exceptions.printStackTrace(ex);
            }
        } else {
            mode = Mode.AGGR;
            ((CardLayout)getLayout()).show(this, "aggr");
            alb_baulastAggregationRendererPanel1.setCidsBeans(cidsBeans);
        }
    }
}
