/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import org.apache.log4j.Logger;

import java.util.Arrays;
import java.util.Collection;

import javax.swing.SwingWorker;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cismap.commons.interaction.CismapBroker;

import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class MauerObjectsPermissionsProviderDialog extends javax.swing.JDialog implements ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final transient Logger LOG = Logger.getLogger(MauerObjectsPermissionsProviderDialog.class);

    //~ Instance fields --------------------------------------------------------

    private final ConnectionContext connectionContext = ConnectionContext.create(
            AbstractConnectionContext.Category.STATIC,
            MauerObjectsPermissionsProviderDialog.class.getSimpleName());

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancel;
    private javax.swing.JButton btnPersist;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel8;
    private de.cismet.cids.custom.objectrenderer.wunda_blau.ObjectsPermissionsProviderPanel
        objectsPersmissionsProviderPanel1;
        // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form MauerObjectsPersmissionsProviderDialog.
     *
     * @param  parent  DOCUMENT ME!
     * @param  modal   DOCUMENT ME!
     */
    private MauerObjectsPermissionsProviderDialog(final java.awt.Frame parent, final boolean modal) {
        super(parent, modal);
        initComponents();
        objectsPersmissionsProviderPanel1.setGroupConfAttr("objectpermissions.groups.mauern");
        objectsPersmissionsProviderPanel1.initWithConnectionContext(getConnectionContext());

        try {
            objectsPersmissionsProviderPanel1.setMetaClasses(Arrays.asList(
                    CidsBean.getMetaClassFromTableName("WUNDA_BLAU", "MAUER", getConnectionContext())));
        } catch (final Exception ex) {
            LOG.error(ex, ex);
        }
        btnPersist.setEnabled(objectsPersmissionsProviderPanel1.isEnableEdit());
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  cidsBeans  DOCUMENT ME!
     */
    public void setCidsBeans(final Collection<CidsBean> cidsBeans) {
        objectsPersmissionsProviderPanel1.setCidsBeans(cidsBeans);
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel8 = new javax.swing.JPanel();
        jPanel6 = new javax.swing.JPanel();
        btnPersist = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();
        final de.cismet.cids.custom.objectrenderer.wunda_blau.ObjectsPermissionsProviderPanel.Option[] options =
            new de.cismet.cids.custom.objectrenderer.wunda_blau.ObjectsPermissionsProviderPanel.Option[] {
                de.cismet.cids.custom.objectrenderer.wunda_blau.ObjectsPermissionsProviderPanel.Option.ONLY_CONFATTR_GROUPS,
                de.cismet.cids.custom.objectrenderer.wunda_blau.ObjectsPermissionsProviderPanel.Option.DISABLE_CLASS_SELECTION,
                de.cismet.cids.custom.objectrenderer.wunda_blau.ObjectsPermissionsProviderPanel.Option.DISABLE_READ,
                de.cismet.cids.custom.objectrenderer.wunda_blau.ObjectsPermissionsProviderPanel.Option.DISABLE_USER_PERMISSIONS
            };
        objectsPersmissionsProviderPanel1 =
            new de.cismet.cids.custom.objectrenderer.wunda_blau.ObjectsPermissionsProviderPanel(options);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(
                MauerObjectsPermissionsProviderDialog.class,
                "MauerObjectsPermissionsProviderDialog.title")); // NOI18N
        setMinimumSize(new java.awt.Dimension(800, 400));
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel8.setLayout(new java.awt.GridBagLayout());

        jPanel6.setLayout(new java.awt.GridLayout(1, 0, 10, 0));

        org.openide.awt.Mnemonics.setLocalizedText(btnPersist, "Speichern");
        btnPersist.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnPersistActionPerformed(evt);
                }
            });
        jPanel6.add(btnPersist);

        org.openide.awt.Mnemonics.setLocalizedText(
            btnCancel,
            org.openide.util.NbBundle.getMessage(
                MauerObjectsPermissionsProviderDialog.class,
                "MauerObjectsPermissionsProviderDialog.btnCancel.text")); // NOI18N
        btnCancel.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnCancelActionPerformed(evt);
                }
            });
        jPanel6.add(btnCancel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LAST_LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        jPanel8.add(jPanel6, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel8.add(objectsPersmissionsProviderPanel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jPanel8, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnPersistActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnPersistActionPerformed
        new SwingWorker<Void, Void>() {

                @Override
                protected Void doInBackground() throws Exception {
                    objectsPersmissionsProviderPanel1.persistPermissions();
                    return null;
                }

                @Override
                protected void done() {
                    setVisible(false);
                }
            }.execute();
    } //GEN-LAST:event_btnPersistActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnCancelActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnCancelActionPerformed
        setVisible(false);
    }                                                                             //GEN-LAST:event_btnCancelActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static MauerObjectsPermissionsProviderDialog getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    @Override
    public void setVisible(final boolean b) {
        if (b) {
            objectsPersmissionsProviderPanel1.reloadPermissions();
        } else {
            objectsPersmissionsProviderPanel1.cleanup();
        }
        super.setVisible(b);
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private static final class LazyInitialiser {

        //~ Static fields/initializers -----------------------------------------

        private static final MauerObjectsPermissionsProviderDialog INSTANCE = new MauerObjectsPermissionsProviderDialog(
                StaticSwingTools.getParentFrame(CismapBroker.getInstance().getMappingComponent()),
                false);

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new LazyInitialiser object.
         */
        private LazyInitialiser() {
        }
    }
}
