/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.optionspanels.wunda_blau;

import Sirius.navigator.connection.SessionManager;

import org.apache.log4j.Logger;

import org.jdom.Element;

import org.openide.util.lookup.ServiceProvider;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;

import java.io.File;

import java.net.MalformedURLException;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;

import de.cismet.cids.custom.clientutils.DmsUrlPathMapper;

import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;

import de.cismet.lookupoptions.options.NetworkOptionsCategory;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
@ServiceProvider(service = OptionsPanelController.class)
public class DmsUrlMappingOptionsPanel extends AbstractOptionsPanel {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(DmsUrlMappingOptionsPanel.class);
    private static final String CONF_ATTR_ENABLED = "options.dms-url-mapping.enabled";

    //~ Instance fields --------------------------------------------------------

    final List<MyTableEntry> hm = new ArrayList<>();

    private boolean networkPathCanceled = false;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAddVerwaltung;
    private javax.swing.JButton btnRemoveVerwaltung;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JDialog jDialog2;
    private javax.swing.JFileChooser jFileChooser1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextField jTextField1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new DmsUrlOptionsPanel object.
     */
    public DmsUrlMappingOptionsPanel() {
        super(org.openide.util.NbBundle.getMessage(
                DmsUrlMappingOptionsPanel.class,
                DmsUrlMappingOptionsPanel.class.getSimpleName()
                        + ".option.name"),
            NetworkOptionsCategory.class);
        initComponents();
        jTextField1.getDocument().addDocumentListener(new DocumentListener() {

                @Override
                public void insertUpdate(final DocumentEvent e) {
                    update();
                }

                @Override
                public void removeUpdate(final DocumentEvent e) {
                    update();
                }

                @Override
                public void changedUpdate(final DocumentEvent e) {
                    update();
                }

                private void update() {
                    jButton5.setEnabled(
                        jTextField1.getText().matches("\\\\\\\\[\\w\\s\\-.]+(\\\\[\\w\\s\\-.]+)+"));
                }
            });

        jDialog2.pack();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jFileChooser1 = new javax.swing.JFileChooser();
        jDialog2 = new javax.swing.JDialog();
        jPanel3 = new javax.swing.JPanel();
        jTextField1 = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();
        jButton4 = new javax.swing.JButton();
        jButton5 = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        btnRemoveVerwaltung = new javax.swing.JButton();
        btnAddVerwaltung = new javax.swing.JButton();

        jFileChooser1.setDialogType(javax.swing.JFileChooser.CUSTOM_DIALOG);
        jFileChooser1.setApproveButtonText(org.openide.util.NbBundle.getMessage(
                DmsUrlMappingOptionsPanel.class,
                "DmsUrlMappingOptionsPanel.jFileChooser1.approveButtonText")); // NOI18N
        jFileChooser1.setCurrentDirectory(getFileSystemRootDir());
        jFileChooser1.setDialogTitle(org.openide.util.NbBundle.getMessage(
                DmsUrlMappingOptionsPanel.class,
                "DmsUrlMappingOptionsPanel.jFileChooser1.dialogTitle"));       // NOI18N
        jFileChooser1.setFileSelectionMode(javax.swing.JFileChooser.DIRECTORIES_ONLY);
        jFileChooser1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jFileChooser1ActionPerformed(evt);
                }
            });
        disableNewFolderButton(jFileChooser1);

        jDialog2.setTitle(org.openide.util.NbBundle.getMessage(
                DmsUrlMappingOptionsPanel.class,
                "DmsUrlMappingOptionsPanel.jDialog2.title")); // NOI18N
        jDialog2.setModal(true);
        jDialog2.getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jTextField1.setText(org.openide.util.NbBundle.getMessage(
                DmsUrlMappingOptionsPanel.class,
                "DmsUrlMappingOptionsPanel.jTextField1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        jPanel3.add(jTextField1, gridBagConstraints);

        jPanel4.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jButton4,
            org.openide.util.NbBundle.getMessage(
                DmsUrlMappingOptionsPanel.class,
                "DmsUrlMappingOptionsPanel.jButton4.text")); // NOI18N
        jButton4.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton4ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        jPanel4.add(jButton4, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jButton5,
            org.openide.util.NbBundle.getMessage(
                DmsUrlMappingOptionsPanel.class,
                "DmsUrlMappingOptionsPanel.jButton5.text")); // NOI18N
        jButton5.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton5ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        jPanel4.add(jButton5, gridBagConstraints);
        jDialog2.getRootPane().setDefaultButton(jButton5);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        jPanel3.add(jPanel4, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(
                DmsUrlMappingOptionsPanel.class,
                "DmsUrlMappingOptionsPanel.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        jPanel3.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jDialog2.getContentPane().add(jPanel3, gridBagConstraints);

        setLayout(new java.awt.GridBagLayout());

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jTable1.setModel(new MyTableModel());
        jTable1.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseClicked(final java.awt.event.MouseEvent evt) {
                    jTable1MouseClicked(evt);
                }
            });
        jScrollPane1.setViewportView(jTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jScrollPane1, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        btnRemoveVerwaltung.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/remove.png"))); // NOI18N
        btnRemoveVerwaltung.setBorder(null);
        btnRemoveVerwaltung.setBorderPainted(false);
        btnRemoveVerwaltung.setMaximumSize(new java.awt.Dimension(25, 25));
        btnRemoveVerwaltung.setMinimumSize(new java.awt.Dimension(25, 25));
        btnRemoveVerwaltung.setPreferredSize(new java.awt.Dimension(25, 25));
        btnRemoveVerwaltung.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnRemoveVerwaltungActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanel1.add(btnRemoveVerwaltung, gridBagConstraints);

        btnAddVerwaltung.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/add.png"))); // NOI18N
        btnAddVerwaltung.setBorder(null);
        btnAddVerwaltung.setBorderPainted(false);
        btnAddVerwaltung.setMaximumSize(new java.awt.Dimension(25, 25));
        btnAddVerwaltung.setMinimumSize(new java.awt.Dimension(25, 25));
        btnAddVerwaltung.setPreferredSize(new java.awt.Dimension(25, 25));
        btnAddVerwaltung.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnAddVerwaltungActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanel1.add(btnAddVerwaltung, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        jPanel2.add(jPanel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        add(jPanel2, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jFileChooser1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jFileChooser1ActionPerformed
        // TODO add your handling code here:
    } //GEN-LAST:event_jFileChooser1ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jTable1MouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_jTable1MouseClicked
        if (evt.getClickCount() == 2) {
            final int row = jTable1.rowAtPoint(new Point(evt.getX(), evt.getY()));
            final int col = jTable1.columnAtPoint(new Point(evt.getX(), evt.getY()));

            if ((row >= 0) && (col >= 0)) {
                final String oldValue = (String)jTable1.getValueAt(row, col);
                final String newValue;
                if (col == 0) {
                    final String result = showNetworkPathChooser(oldValue);
                    newValue = (result != null) ? result : oldValue;
                } else if (col == 1) {
                    final File input;
                    if (oldValue.isEmpty()) {
                        input = getFileSystemRootDir();
                    } else {
                        input = new File(oldValue);
                    }
                    final File result = showLocalPathChooser(input);
                    newValue = (result != null) ? result.getAbsolutePath() : oldValue;
                } else {
                    return;
                }
                jTable1.setValueAt(newValue, row, col);
            }
        }
    } //GEN-LAST:event_jTable1MouseClicked

    /**
     * DOCUMENT ME!
     *
     * @param   path  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private File showLocalPathChooser(final File path) {
        jFileChooser1.setCurrentDirectory(path);
        final int result = jFileChooser1.showOpenDialog(this);
        switch (result) {
            case JFileChooser.APPROVE_OPTION: {
                return jFileChooser1.getSelectedFile();
            }
            default: {
                return null;
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   path  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private String showNetworkPathChooser(final String path) {
        networkPathCanceled = true;
        if (path != null) {
            jTextField1.setText(path);
        } else {
            jTextField1.setText("");
        }
        StaticSwingTools.showDialog(jDialog2);
        if (networkPathCanceled) {
            return null;
        } else {
            return jTextField1.getText();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton5ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton5ActionPerformed
        networkPathCanceled = false;
        jDialog2.setVisible(false);
    }                                                                            //GEN-LAST:event_jButton5ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton4ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton4ActionPerformed
        networkPathCanceled = true;
        jDialog2.setVisible(false);
    }                                                                            //GEN-LAST:event_jButton4ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnAddVerwaltungActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnAddVerwaltungActionPerformed
        final String networkPath = showNetworkPathChooser(null);
        if (networkPath != null) {
            final File localPath = showLocalPathChooser(getFileSystemRootDir());
            if (localPath != null) {
                try {
                    final MyTableModel model = (MyTableModel)jTable1.getModel();
                    model.addRow(networkPath, localPath.toURI().toURL().toString());
                    model.fireTableDataChanged();
                } catch (final MalformedURLException ex) {
                    LOG.warn(ex, ex);
                }
            }
        }
    }                                                                                    //GEN-LAST:event_btnAddVerwaltungActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemoveVerwaltungActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnRemoveVerwaltungActionPerformed
        final int selRow = jTable1.getSelectedRow();
        if (selRow >= 0) {
            final MyTableModel model = (MyTableModel)jTable1.getModel();
            model.removeRow(selRow);
            model.fireTableDataChanged();
        }
    }                                                                                       //GEN-LAST:event_btnRemoveVerwaltungActionPerformed

    @Override
    public boolean isEnabled() {
        try {
            return SessionManager.getConnection()
                        .hasConfigAttr(SessionManager.getSession().getUser(),
                            CONF_ATTR_ENABLED,
                            ConnectionContext.create(
                                AbstractConnectionContext.Category.OPTIONS,
                                getClass().getSimpleName()));
        } catch (final Exception ex) {
            LOG.error("could not check conf attr " + CONF_ATTR_ENABLED, ex);
            return false;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  args  DOCUMENT ME!
     */
    public static void main(final String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        SwingUtilities.invokeLater(new Runnable() {

                @Override
                public void run() {
                    final JFrame frame = new JFrame();
                    frame.setSize(800, 600);
                    frame.add(new DmsUrlMappingOptionsPanel());
                    frame.setVisible(true);
                    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                }
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param  c  DOCUMENT ME!
     */
    public static void disableNewFolderButton(final Container c) {
        final int len = c.getComponentCount();
        for (int i = 0; i < len; i++) {
            final Component comp = c.getComponent(i);
            if (comp instanceof JButton) {
                final JButton b = (JButton)comp;
                final Icon icon = b.getIcon();
                if ((icon != null)
                            && (icon == UIManager.getIcon("FileChooser.newFolderIcon"))) {
                    b.setEnabled(false);
                }
            } else if (comp instanceof Container) {
                disableNewFolderButton((Container)comp);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static File getFileSystemRootDir() {
        // #60 NPE in DmsUrlOptionsPanel.getFileSystemRootDir
        File[] roots = FileSystemView.getFileSystemView().getRoots();
        if ((roots == null) || (roots.length == 0)) {
            LOG.warn("could not get default FileSystemView roo directory!");
            roots = File.listRoots();
        }

        return roots[0];
    }

    @Override
    public void update() {
        hm.clear();
        for (final String networkPath : DmsUrlPathMapper.getInstance().getAllNetworkPaths()) {
            final String localPath = DmsUrlPathMapper.getInstance().getLocalPath(networkPath);
            hm.add(new MyTableEntry(networkPath, localPath));
        }

        ((MyTableModel)jTable1.getModel()).fireTableDataChanged();
    }

    @Override
    public void applyChanges() {
        DmsUrlPathMapper.getInstance().unmapAll();
        for (final MyTableEntry entry : hm) {
            DmsUrlPathMapper.getInstance().map(entry.getNetworkPath(), entry.getLocalPath());
        }
    }

    @Override
    public boolean isChanged() {
        final Set<String> origNetworkPaths = DmsUrlPathMapper.getInstance().getAllLocalPaths();
        if (origNetworkPaths.size() != hm.size()) {
            return true;
        }
        for (final MyTableEntry entry : hm) {
            final String networkPath = entry.getNetworkPath();
            final String localPath = entry.getLocalPath();

            if (!origNetworkPaths.contains(networkPath)) {
                return true;
            }

            final String origLocalPath = DmsUrlPathMapper.getInstance().getLocalPath(networkPath);
            if (!localPath.equals(origLocalPath)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Element getConfiguration() {
        return DmsUrlPathMapper.getInstance().getConfiguration();
    }

    @Override
    public void configure(final Element parent) {
        DmsUrlPathMapper.getInstance().configure(parent);
        update();
    }

    @Override
    public void masterConfigure(final Element parent) {
        DmsUrlPathMapper.getInstance().masterConfigure(parent);
        update();
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class MyTableModel extends AbstractTableModel {

        //~ Instance fields ----------------------------------------------------

        private final String[] columnNames = {
                org.openide.util.NbBundle.getMessage(
                    DmsUrlMappingOptionsPanel.class,
                    DmsUrlMappingOptionsPanel.class.getSimpleName()
                            + ".columns.network"),
                org.openide.util.NbBundle.getMessage(
                    DmsUrlMappingOptionsPanel.class,
                    DmsUrlMappingOptionsPanel.class.getSimpleName()
                            + ".columns.local")
            };

        //~ Methods ------------------------------------------------------------

        @Override
        public int getRowCount() {
            return hm.size();
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(final int column) {
            return columnNames[column];
        }

        @Override
        public Class<?> getColumnClass(final int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(final int rowIndex, final int columnIndex) {
            if ((rowIndex >= 0) && (rowIndex < hm.size())) {
                final MyTableEntry entry = hm.get(rowIndex);
                if (columnIndex == 0) {
                    return entry.getNetworkPath();
                } else if (columnIndex == 1) {
                    return entry.getLocalPath();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex) {
            if ((rowIndex >= 0) && (rowIndex < hm.size())) {
                final MyTableEntry entry = hm.get(rowIndex);
                if (columnIndex == 0) {
                    entry.setNetworkPath((String)aValue);
                } else if (columnIndex == 1) {
                    entry.setLocalPath((String)aValue);
                }
            }

            super.setValueAt(aValue, rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(final int rowIndex, final int columnIndex) {
            return false;
        }

        /**
         * DOCUMENT ME!
         *
         * @param  row  DOCUMENT ME!
         */
        public void removeRow(final int row) {
            hm.remove(row);
        }

        /**
         * DOCUMENT ME!
         *
         * @param  networkPath  DOCUMENT ME!
         * @param  localPath    DOCUMENT ME!
         */
        public void addRow(final String networkPath, final String localPath) {
            hm.add(new MyTableEntry(networkPath, localPath));
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class MyTableEntry {

        //~ Instance fields ----------------------------------------------------

        private String networkPath;
        private String localPath;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new MyTableEntry object.
         *
         * @param  networkPath  DOCUMENT ME!
         * @param  localPath    DOCUMENT ME!
         */
        public MyTableEntry(final String networkPath, final String localPath) {
            this.networkPath = networkPath;
            this.localPath = localPath;
        }

        //~ Methods ------------------------------------------------------------

        /**
         * DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        public String getNetworkPath() {
            return networkPath;
        }

        /**
         * DOCUMENT ME!
         *
         * @param  networkPath  DOCUMENT ME!
         */
        public void setNetworkPath(final String networkPath) {
            this.networkPath = networkPath;
        }

        /**
         * DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        public String getLocalPath() {
            return localPath;
        }

        /**
         * DOCUMENT ME!
         *
         * @param  localPath  DOCUMENT ME!
         */
        public void setLocalPath(final String localPath) {
            this.localPath = localPath;
        }
    }
}
