/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.wunda.oab.objectrenderer;

import Sirius.navigator.ui.RequestsFullSizeComponent;

import org.openide.util.NbBundle;

import java.awt.EventQueue;

import javax.swing.event.EventListenerList;

import de.cismet.cids.custom.wunda.oab.AbstractCidsBeanRenderer;
import de.cismet.cids.custom.wunda.oab.OabUtilities;
import de.cismet.cids.custom.wunda.oab.mapvis.Oab_GewaessereinzugsgebietMapVisualisationProvider;

import de.cismet.cismap.commons.RetrievalServiceLayer;

/**
 * DOCUMENT ME!
 *
 * @author   martin.scholl@cismet.de
 * @version  1.0
 */
public class Oab_gewaessereinzugsgebietRenderer extends AbstractCidsBeanRenderer implements RequestsFullSizeComponent {

    //~ Instance fields --------------------------------------------------------

    // only to hold strong reference to listeners
    private EventListenerList refHolderList;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.Box.Filler hStaticFillCMList;
    private javax.swing.JLabel lblData;
    private javax.swing.JLabel lblFrom;
    private javax.swing.JLabel lblFromValue;
    private javax.swing.JLabel lblMapTitle;
    private javax.swing.JLabel lblName;
    private javax.swing.JLabel lblNameValue;
    private javax.swing.JLabel lblProjects;
    private javax.swing.JLabel lblStatus;
    private javax.swing.JLabel lblStatusValue;
    private javax.swing.JLabel lblTo;
    private javax.swing.JLabel lblToValue;
    private de.cismet.cismap.commons.gui.MappingComponent map;
    private javax.swing.JPanel pnlData;
    private javax.swing.JPanel pnlMap;
    private javax.swing.JPanel pnlProjects;
    private javax.swing.JPanel pnlProjectsList;
    private de.cismet.tools.gui.SemiRoundedPanel semiRoundedPanelConditionsAndMeasures;
    private de.cismet.tools.gui.SemiRoundedPanel semiRoundedPanelData;
    private de.cismet.tools.gui.SemiRoundedPanel semiRoundedPanelMap;
    private javax.swing.Box.Filler vFillData;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form Oab_Gewaessereinzugsgebiet.
     */
    public Oab_gewaessereinzugsgebietRenderer() {
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    protected void init() {
        final Runnable r = new Runnable() {

                @Override
                public void run() {
                    bindingGroup.unbind();

                    if (cidsBean != null) {
                        refHolderList = new EventListenerList();

                        OabUtilities.initGotoBeanHyperlinkList(cidsBean, "projekte", pnlProjectsList, refHolderList); // NOI18N
                        OabUtilities.initPreviewMap(
                            cidsBean,
                            "umschreibende_geometrie.geo_field",                                                      // NOI18N
                            map,
                            lblMapTitle,
                            new Oab_GewaessereinzugsgebietMapVisualisationProvider().buildAction(cidsBean),
                            (RetrievalServiceLayer[])null);

                        bindingGroup.bind();
                    }
                }
            };

        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        pnlMap = new javax.swing.JPanel();
        semiRoundedPanelMap = new de.cismet.tools.gui.SemiRoundedPanel();
        lblMapTitle = new javax.swing.JLabel();
        map = new de.cismet.cismap.commons.gui.MappingComponent();
        pnlData = new javax.swing.JPanel();
        lblName = new javax.swing.JLabel();
        semiRoundedPanelData = new de.cismet.tools.gui.SemiRoundedPanel();
        lblData = new javax.swing.JLabel();
        lblNameValue = new javax.swing.JLabel();
        lblFrom = new javax.swing.JLabel();
        lblFromValue = new javax.swing.JLabel();
        lblTo = new javax.swing.JLabel();
        lblToValue = new javax.swing.JLabel();
        lblStatus = new javax.swing.JLabel();
        lblStatusValue = new javax.swing.JLabel();
        vFillData = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        pnlProjects = new javax.swing.JPanel();
        semiRoundedPanelConditionsAndMeasures = new de.cismet.tools.gui.SemiRoundedPanel();
        lblProjects = new javax.swing.JLabel();
        pnlProjectsList = new javax.swing.JPanel();
        hStaticFillCMList = new javax.swing.Box.Filler(new java.awt.Dimension(20, 0),
                new java.awt.Dimension(20, 0),
                new java.awt.Dimension(20, 32767));

        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        pnlMap.setOpaque(false);
        pnlMap.setLayout(new java.awt.GridBagLayout());

        semiRoundedPanelMap.setBackground(new java.awt.Color(51, 51, 51));
        semiRoundedPanelMap.setLayout(new java.awt.GridBagLayout());

        lblMapTitle.setFont(new java.awt.Font("Lucida Grande", 0, 14));  // NOI18N
        lblMapTitle.setForeground(new java.awt.Color(255, 255, 255));
        lblMapTitle.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(
            lblMapTitle,
            NbBundle.getMessage(
                Oab_gewaessereinzugsgebietRenderer.class,
                "Oab_gewaessereinzugsgebietRenderer.lblMapTitle.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        semiRoundedPanelMap.add(lblMapTitle, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlMap.add(semiRoundedPanelMap, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        pnlMap.add(map, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        add(pnlMap, gridBagConstraints);

        pnlData.setOpaque(false);
        pnlData.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            lblName,
            NbBundle.getMessage(
                Oab_gewaessereinzugsgebietRenderer.class,
                "Oab_gewaessereinzugsgebietRenderer.lblName.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(lblName, gridBagConstraints);

        semiRoundedPanelData.setBackground(new java.awt.Color(51, 51, 51));
        semiRoundedPanelData.setLayout(new java.awt.GridBagLayout());

        lblData.setFont(new java.awt.Font("Lucida Grande", 0, 14));  // NOI18N
        lblData.setForeground(new java.awt.Color(255, 255, 255));
        lblData.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(
            lblData,
            NbBundle.getMessage(
                Oab_gewaessereinzugsgebietRenderer.class,
                "Oab_gewaessereinzugsgebietRenderer.lblData.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        semiRoundedPanelData.add(lblData, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlData.add(semiRoundedPanelData, gridBagConstraints);

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.name}"),
                lblNameValue,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(lblNameValue, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblFrom,
            NbBundle.getMessage(
                Oab_gewaessereinzugsgebietRenderer.class,
                "Oab_gewaessereinzugsgebietRenderer.lblFrom.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(lblFrom, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.von}"),
                lblFromValue,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(new OabUtilities.DateToStringConverter());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(lblFromValue, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblTo,
            NbBundle.getMessage(
                Oab_gewaessereinzugsgebietRenderer.class,
                "Oab_gewaessereinzugsgebietRenderer.lblTo.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(lblTo, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.bis}"),
                lblToValue,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(new OabUtilities.DateToStringConverter());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(lblToValue, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblStatus,
            NbBundle.getMessage(
                Oab_gewaessereinzugsgebietRenderer.class,
                "Oab_gewaessereinzugsgebietRenderer.lblStatus.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(lblStatus, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.gep_status.name}"),
                lblStatusValue,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlData.add(lblStatusValue, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        pnlData.add(vFillData, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        add(pnlData, gridBagConstraints);

        pnlProjects.setOpaque(false);
        pnlProjects.setLayout(new java.awt.GridBagLayout());

        semiRoundedPanelConditionsAndMeasures.setBackground(new java.awt.Color(51, 51, 51));
        semiRoundedPanelConditionsAndMeasures.setLayout(new java.awt.GridBagLayout());

        lblProjects.setFont(new java.awt.Font("Lucida Grande", 0, 14));  // NOI18N
        lblProjects.setForeground(new java.awt.Color(255, 255, 255));
        lblProjects.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(
            lblProjects,
            NbBundle.getMessage(
                Oab_gewaessereinzugsgebietRenderer.class,
                "Oab_gewaessereinzugsgebietRenderer.lblProjects.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        semiRoundedPanelConditionsAndMeasures.add(lblProjects, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        pnlProjects.add(semiRoundedPanelConditionsAndMeasures, gridBagConstraints);

        pnlProjectsList.setOpaque(false);
        pnlProjectsList.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        pnlProjects.add(pnlProjectsList, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        pnlProjects.add(hStaticFillCMList, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 10);
        add(pnlProjects, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents
}
