/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objectrenderer.utils;

import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class ObjectRendererUtilsTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        DevelopmentTools.initSessionManagerFromRMIConnectionOnLocalhost((String)"WUNDA_BLAU", (String)"Administratoren", (String)"admin", (String)"kif");
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCheckActionTagInternalUse_internalUsage_once() {
        System.out.println("checkActionTag_internalUsage_once");
        String tagToCheck = "custom.stadtbilder.internalUse.internalUsage";
        boolean expResult = true;
        boolean result = ObjectRendererUtils.checkActionTag((String)tagToCheck, (ConnectionContext)ConnectionContext.createDeprecated());
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testCheckActionTagInternalUse_externalUsage_once() {
        System.out.println("checkActionTag_externalUsage_once");
        String tagToCheck = "custom.stadtbilder.internalUse.externalUsage";
        boolean expResult = false;
        boolean result = ObjectRendererUtils.checkActionTag((String)tagToCheck, (ConnectionContext)ConnectionContext.createDeprecated());
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testCheckActionTagInternalUse_externalUsage_multi() {
        System.out.println("checkActionTag_externalUsage_multi");
        String tagToCheck = "custom.stadtbilder.internalUse.externalUsage";
        boolean expResult = false;
        for (int i = 0; i < 1000; ++i) {
            boolean result = ObjectRendererUtils.checkActionTag((String)tagToCheck, (ConnectionContext)ConnectionContext.createDeprecated());
            Assert.assertEquals((Object)expResult, (Object)result);
        }
    }

    @Test
    public void testCheckActionTagInternalUse_externalUsage_multiThread() throws InterruptedException {
        System.out.println("checkActionTag_externalUsage_internalUsage_multiThread");
        String tagToCheckexternalUsage = "custom.stadtbilder.internalUse.externalUsage";
        boolean expResultExternal = false;
        final AtomicBoolean externalFailed = new AtomicBoolean(false);
        ExecutorService executorService = CismetExecutors.newCachedThreadPool();
        int maxIndex = 500;
        final Semaphore externalSemaphore = new Semaphore(1);
        externalSemaphore.acquire();
        int i = 0;
        while (i <= 500) {
            final int index = i++;
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    boolean result = ObjectRendererUtils.checkActionTag((String)"custom.stadtbilder.internalUse.externalUsage", (ConnectionContext)ConnectionContext.createDeprecated());
                    if (result) {
                        System.out.println("fetch externalUsage failed");
                        externalFailed.set(true);
                    }
                    Assert.assertEquals((Object)false, (Object)result);
                    if (index == 500) {
                        externalSemaphore.release();
                    }
                }
            });
        }
        externalSemaphore.acquire();
        Assert.assertEquals((Object)false, (Object)externalFailed.get());
    }

    @Test
    public void testCheckActionTagInternalUse_externalUsage_internalUsage_multiThread() throws InterruptedException {
        System.out.println("checkActionTag_externalUsage_internalUsage_multiThread");
        String tagToCheckexternalUsage = "custom.stadtbilder.internalUse.externalUsage";
        String tagToCheckinternalUsage = "custom.stadtbilder.internalUse.internalUsage";
        boolean expResultExternal = false;
        boolean expResultInternal = true;
        final AtomicBoolean externalFailed = new AtomicBoolean(false);
        final AtomicBoolean internalFailed = new AtomicBoolean(false);
        ExecutorService executorService = CismetExecutors.newFixedThreadPool((int)50);
        int maxIndex = 500;
        final Semaphore externalSemaphore = new Semaphore(1);
        externalSemaphore.acquire();
        final Semaphore internalSemaphore = new Semaphore(1);
        internalSemaphore.acquire();
        final AtomicInteger wrongResultExternal = new AtomicInteger(0);
        final AtomicInteger wrongResultInternal = new AtomicInteger(0);
        int i = 0;
        while (i <= 500) {
            final int index = i++;
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    boolean result = ObjectRendererUtils.checkActionTag((String)"custom.stadtbilder.internalUse.externalUsage", (ConnectionContext)ConnectionContext.createDeprecated());
                    if (result) {
                        System.out.println("fetch externalUsage failed");
                        wrongResultExternal.incrementAndGet();
                        externalFailed.set(true);
                    }
                    Assert.assertEquals((Object)false, (Object)result);
                    if (index == 500) {
                        externalSemaphore.release();
                    }
                }
            });
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    boolean result = ObjectRendererUtils.checkActionTag((String)"custom.stadtbilder.internalUse.internalUsage", (ConnectionContext)ConnectionContext.createDeprecated());
                    if (!result) {
                        System.out.println("fetch internalUsage failed");
                        wrongResultInternal.incrementAndGet();
                        internalFailed.set(true);
                    }
                    Assert.assertEquals((Object)true, (Object)result);
                    if (index == 500) {
                        internalSemaphore.release();
                    }
                }
            });
        }
        boolean internalOrExternalFailed = false;
        externalSemaphore.acquire();
        System.out.println("Wrong external values: " + wrongResultExternal.get());
        if (externalFailed.get()) {
            internalOrExternalFailed = true;
        }
        internalSemaphore.acquire();
        System.out.println("Wrong internal values: " + wrongResultInternal.get());
        if (internalFailed.get()) {
            internalOrExternalFailed = true;
        }
        Assert.assertEquals((Object)false, (Object)internalOrExternalFailed);
    }
}

