/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wupp.client.alkis;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.wupp.client.alkis.GrundbuchblattInputField;
import de.cismet.cids.custom.wupp.client.alkis.GrundbuchblattInputFieldConfig;
import java.io.IOException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GrundbuchblattInputFieldTest {
    private GrundbuchblattInputField field;
    private GrundbuchblattInputFieldConfig config;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        try {
            this.config = (GrundbuchblattInputFieldConfig)new ObjectMapper().readValue(GrundbuchblattInputFieldTest.class.getResourceAsStream("/de/cismet/cids/custom/wunda_blau/res/alkis/GrundbuchblattInputFieldConfig.json"), GrundbuchblattInputFieldConfig.class);
        }
        catch (IOException ex) {
            this.config = GrundbuchblattInputFieldConfig.FallbackConfig;
        }
        this.field = new GrundbuchblattInputField(this.config);
    }

    @After
    public void tearDown() {
        this.config = null;
        this.field = null;
    }

    @Test
    public void testSetDistrictNumber() {
        System.out.println("setDistrictNumber");
        String districtNumber = "3001";
        GrundbuchblattInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals((Object)"053001", (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberSpecialCharacter() {
        System.out.println("setDistrictNumberSpecialCharacter");
        String districtNumber = "n\u00e4";
        GrundbuchblattInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals((Object)"053487", (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberShort() {
        System.out.println("setDistrictNumberShort");
        String districtNumber = "30";
        GrundbuchblattInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals(null, (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberShort2() {
        System.out.println("setDistrictNumberShort2");
        String districtNumber = "ba";
        GrundbuchblattInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals((Object)"053001", (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberShort_samePrefix2Chars() {
        System.out.println("testSetDistrictNumberShort_samePrefix2Chars");
        String districtNumber = "GE";
        GrundbuchblattInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals((Object)"051329", (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberShort_samePrefix3Chars() {
        System.out.println("testSetDistrictNumberShort_samePrefix3Chars");
        String districtNumber = "gev";
        GrundbuchblattInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals((Object)"051310", (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberLong() {
        System.out.println("setDistrictNumberLong");
        String districtNumber = "30017435";
        GrundbuchblattInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals((Object)"053001", (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetDistrictNumberWrong() {
        System.out.println("setDistrictNumberWrong");
        String districtNumber = "sadfh";
        GrundbuchblattInputField instance = this.field;
        instance.setDistrictNumberInTxtDistrict(districtNumber);
        Assert.assertEquals(null, (Object)instance.getDistrictNumber());
    }

    @Test
    public void testSetBuchungsblattnummer() {
        System.out.println("setParcelDenominator");
        String buchungsblattnummer = "0002";
        GrundbuchblattInputField instance = this.field;
        instance.setBuchungsblattnummerInTxtBuchungsblattnummer(buchungsblattnummer);
        Assert.assertEquals((Object)"0000002", (Object)instance.getBuchungsblattnummer());
    }

    @Test
    public void testSetBuchungsblattnummerShort() {
        System.out.println("setParcelDenominatorShort");
        String buchungsblattnummer = "2";
        GrundbuchblattInputField instance = this.field;
        instance.setBuchungsblattnummerInTxtBuchungsblattnummer(buchungsblattnummer);
        Assert.assertEquals((Object)"0000002", (Object)instance.getBuchungsblattnummer());
    }

    @Test
    public void testSetBuchungsblattnummerLong() {
        System.out.println("setParcelDenominatorLong");
        String buchungsblattnummer = "0002000A";
        GrundbuchblattInputField instance = this.field;
        instance.setBuchungsblattnummerInTxtBuchungsblattnummer(buchungsblattnummer);
        Assert.assertEquals((Object)"0002000A", (Object)instance.getBuchungsblattnummer());
    }

    @Test
    public void testSetBuchungsblattnummerLettersNoNumbers() {
        System.out.println("testSetBuchungsblattnummerLettersNoNumbers");
        String buchungsblattnummer = "abced";
        GrundbuchblattInputField instance = this.field;
        instance.setBuchungsblattnummerInTxtBuchungsblattnummer(buchungsblattnummer);
        Assert.assertEquals((Object)"00abced", (Object)instance.getBuchungsblattnummer());
    }

    @Test
    public void testSetBuchungsblattnummerLetters2Numbers() {
        System.out.println("testSetBuchungsblattnummerLetters2Numbers");
        String buchungsblattnummer = "12ab";
        GrundbuchblattInputField instance = this.field;
        instance.setBuchungsblattnummerInTxtBuchungsblattnummer(buchungsblattnummer);
        Assert.assertEquals((Object)"00012ab", (Object)instance.getBuchungsblattnummer());
    }

    @Test
    public void testSetCurrentGrundbuchblattnummer() {
        System.out.println("testSetCurrentGrundbuchblattnummer");
        String grundbuchblattnummer = "3001-000A";
        GrundbuchblattInputField instance = this.field;
        instance.setGrundbuchblattNummerForTest(grundbuchblattnummer);
        Assert.assertEquals((Object)"053001-000000A", (Object)instance.getGrundbuchblattnummer());
    }

    @Test
    public void testSetCurrentGrundbuchblattnummerLong() {
        System.out.println("testSetCurrentGrundbuchblattnummerLong");
        String grundbuchblattnummer = "3001-00000000000A";
        GrundbuchblattInputField instance = this.field;
        instance.setGrundbuchblattNummerForTest(grundbuchblattnummer);
        Assert.assertEquals((Object)"053001-00000000000A", (Object)instance.getGrundbuchblattnummer());
    }

    @Test
    public void testSetCurrentGrundbuchblattnummerWildcards() {
        System.out.println("testSetCurrentGrundbuchblattnummerLong");
        String grundbuchblattnummer = "3001-00000000000A%";
        GrundbuchblattInputField instance = this.field;
        instance.setGrundbuchblattNummerForTest(grundbuchblattnummer);
        Assert.assertEquals((Object)"053001-00000000000A%", (Object)instance.getGrundbuchblattnummer());
    }

    @Test
    public void testSetCurrentGrundbuchblattnummerBothTooLong() {
        System.out.println("testSetCurrentGrundbuchblattnummerLong");
        String grundbuchblattnummer = "300100000-50000031A";
        GrundbuchblattInputField instance = this.field;
        instance.setGrundbuchblattNummerForTest(grundbuchblattnummer);
        Assert.assertEquals((Object)"053001-50000031A", (Object)instance.getGrundbuchblattnummer());
    }
}

