/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.actions.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.actions.wunda_blau.WohnlagenKategorisierungDialog;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.CommonFeatureAction;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeaturesProvider;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.custom.attributerule.WohnlageRuleSet;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class WohnlagenKategorisierungFeatureAction
extends AbstractAction
implements CommonFeatureAction,
FeaturesProvider,
ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(WohnlagenKategorisierungFeatureAction.class);
    private boolean isActive;
    private MetaClass metaClass;
    private List<Feature> features = null;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public WohnlagenKategorisierungFeatureAction() {
        super("Wohnlage kategorisieren");
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        MetaClass metaClass = null;
        try {
            metaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"WOHNLAGE", (ConnectionContext)this.getConnectionContext());
        }
        catch (Exception ex) {
            LOG.error((Object)"Could get MetaClass (WOHNLAGE)!", (Throwable)ex);
        }
        this.metaClass = metaClass;
        boolean isActive = false;
        try {
            isActive = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csa://wohnlagenKategorisierung", this.getConnectionContext());
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not validate action tag (custom.wohnlage.kategorisierung_featureaction)!", (Throwable)ex);
        }
        this.isActive = isActive;
    }

    public int getSorter() {
        return 1;
    }

    public Feature getSourceFeature() {
        return this.features == null ? null : this.features.iterator().next();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setSourceFeature(Feature source) {
        this.features = Arrays.asList(source);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<CidsLayerFeature> cidsLayerFeatures = new ArrayList<CidsLayerFeature>();
        boolean allSameKategorie = true;
        CidsBean kategorie = null;
        for (Feature feature : this.getSourceFeatures()) {
            if (!(feature instanceof CidsLayerFeature)) continue;
            CidsLayerFeature cidsLayerFeature = (CidsLayerFeature)feature;
            cidsLayerFeatures.add(cidsLayerFeature);
        }
        Frame frame = StaticSwingTools.getFirstParentFrame((Component)CismapBroker.getInstance().getMappingComponent());
        WohnlagenKategorisierungDialog dialog = new WohnlagenKategorisierungDialog(frame, cidsLayerFeatures, kategorie, this.getConnectionContext());
        StaticSwingTools.showDialog((JDialog)dialog);
    }

    public boolean isResponsibleFor(Feature feature) {
        if (this.metaClass != null && feature instanceof CidsLayerFeature) {
            CidsLayerFeature cidsLayerFeature = (CidsLayerFeature)feature;
            return cidsLayerFeature.getLayerProperties().getAttributeTableRuleSet() instanceof WohnlageRuleSet;
        }
        return false;
    }

    public void setSourceFeatures(List<Feature> features) {
        this.features = features;
        int size = features.size();
        if (size == 1) {
            super.putValue("Name", "Wohnlage kategorisieren");
        } else {
            super.putValue("Name", features.size() + " Wohnlagen kategorisieren");
        }
    }

    public List<Feature> getSourceFeatures() {
        return this.features;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

