/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.butler;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import de.cismet.cids.custom.utils.butler.ButlerFormat;
import de.cismet.cids.custom.utils.butler.ButlerProduct;
import de.cismet.cids.custom.wunda_blau.search.actions.ButlerQueryAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.commons.security.exceptions.BadHttpStatusCodeException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.HttpDownload;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ButlerDownload
extends HttpDownload
implements ConnectionContextProvider {
    private static final String SERVER_ACTION = "butler1Query";
    private static final String TITLE = "Butler Download";
    private static final long WAIT_PERIOD = 5000L;
    private static String BUTLER_SERVER_BASE_PATH;
    private static String TIF_RESULT_DIR;
    private static String PDF_RESULT_DIR;
    private static String SHAPE_RESULT_DIR;
    private static String DXF_RESULT_DIR;
    private String orderId;
    private ButlerProduct product;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private Future pollingFuture;
    private boolean omitSendingRequest = false;
    private String requestId = null;
    private boolean useZipFile = false;
    private boolean isButler2 = false;
    private String boxSize;
    private boolean isEtrsRahmenkarte = false;
    private final ConnectionContext connectionContext;

    public ButlerDownload(String directory, String orderId, ButlerProduct product, boolean isEtrsRahmenkarte, String boxSize, double middleX, double middleY, ConnectionContext connectionContext) {
        this.isButler2 = true;
        this.directory = directory;
        this.orderId = orderId;
        this.product = product;
        this.isEtrsRahmenkarte = isEtrsRahmenkarte;
        this.minX = middleX;
        this.minY = middleY;
        this.status = Download.State.WAITING;
        this.boxSize = boxSize;
        this.title = orderId;
        this.connectionContext = connectionContext;
        ButlerFormat format = product.getFormat();
        this.determineDestinationFile(orderId, "." + format.getKey());
    }

    public ButlerDownload(String directory, String orderId, ButlerProduct product, double minX, double minY, double maxX, double maxY, ConnectionContext connectionContext) {
        this.directory = directory;
        this.orderId = orderId;
        this.product = product;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.status = Download.State.WAITING;
        this.title = orderId;
        this.connectionContext = connectionContext;
        ButlerFormat format = product.getFormat();
        if (format.getKey().equals("shp") || format.getKey().equals("geotif")) {
            this.determineDestinationFile(orderId, ".zip");
            this.useZipFile = true;
        } else {
            this.determineDestinationFile(orderId, "." + format.getKey());
        }
    }

    ButlerDownload(String requestId, String userOrderId, ButlerProduct product, ConnectionContext connectionContext) {
        this.omitSendingRequest = true;
        this.orderId = userOrderId;
        this.requestId = requestId;
        this.product = product;
        this.status = Download.State.WAITING;
        this.title = this.orderId;
        this.connectionContext = connectionContext;
        ButlerFormat format = product.getFormat();
        if (format.getKey().equals("shp") || format.getKey().equals("geotif")) {
            this.determineDestinationFile(this.orderId, ".zip");
            this.useZipFile = true;
        } else {
            this.determineDestinationFile(this.orderId, "." + format.getKey());
        }
    }

    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        if (!this.downloadFuture.isCancelled()) {
            if (!this.omitSendingRequest) {
                this.requestId = this.sendRequest();
            }
        } else {
            this.doCancellationHandling(false, false);
        }
        if (this.requestId == null) {
            log.error((Object)"could not register butler request.");
            this.error(new IllegalStateException("Fehler beim Senden des Butler Auftrags."));
            this.status = Download.State.COMPLETED_WITH_ERROR;
            this.stateChanged();
            return;
        }
        ArrayList result = null;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        if (!this.downloadFuture.isCancelled()) {
            this.pollingFuture = executor.submit(new ButlerPollingRunnable(this.requestId));
        } else {
            this.doCancellationHandling(true, false);
        }
        try {
            if (!this.downloadFuture.isCancelled()) {
                result = (ArrayList)this.pollingFuture.get(1L, TimeUnit.HOURS);
            } else {
                this.doCancellationHandling(true, true);
            }
        }
        catch (InterruptedException ex) {
            this.doCancellationHandling(true, true);
            Thread.currentThread().interrupt();
            log.error((Object)"Butler Download was interrupted", (Throwable)ex);
            this.error(ex);
            return;
        }
        catch (ExecutionException ex) {
            log.error((Object)"could not execute butler download", (Throwable)ex);
            this.error(ex);
        }
        catch (TimeoutException ex) {
            log.error((Object)"the maximum timeout for butler download is exceeded", (Throwable)ex);
            this.error(new TimeoutException(NbBundle.getMessage(ButlerDownload.class, (String)"ButlerDownload.timeoutErrorMessage")));
        }
        if (result == null || result.isEmpty()) {
            log.error((Object)"error during butler download");
            this.status = Download.State.COMPLETED_WITH_ERROR;
            this.stateChanged();
        }
        if (!this.downloadFuture.isCancelled()) {
            if (this.useZipFile || result.size() > 1) {
                this.saveZipFileOfUnzippedFileCollection(result, this.fileToSaveTo);
            } else {
                this.saveFile(result);
            }
        } else {
            this.doCancellationHandling(false, true);
        }
        this.removeRequestFromServer();
        this.status = Download.State.COMPLETED;
        this.stateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(ArrayList<URL> result) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.fileToSaveTo);
            URL fileUrl = result.get(0);
            InputStream is = this.getUrlInputStreamWithWebAcessManager(fileUrl);
            this.downloadStream(is, out);
        }
        catch (Exception ex) {
            log.warn((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)ex);
            this.error(ex);
            return;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveZipFileOfUnzippedFileCollection(ArrayList<URL> unzippedFiles, File zipFile) {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(zipFile);
            zos = new ZipOutputStream(fos);
            for (URL url : unzippedFiles) {
                StringBuilder extensionBuilder = new StringBuilder();
                int extennstionIndex = url.getFile().lastIndexOf(".");
                extensionBuilder.append(url.getFile().substring(extennstionIndex));
                String fileEntryName = this.orderId + extensionBuilder.toString();
                zos.putNextEntry(new ZipEntry(fileEntryName));
                InputStream is = this.getUrlInputStreamWithWebAcessManager(url);
                this.downloadStream(is, zos);
                zos.closeEntry();
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)ex);
            this.error(ex);
            return;
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void doCancellationHandling(boolean cancelServerRequest, boolean cancelPollingThread) {
        log.warn((Object)"Butler Download was interuppted");
        if (cancelServerRequest) {
            this.removeRequestFromServer();
        }
        if (cancelPollingThread && this.pollingFuture != null) {
            this.pollingFuture.cancel(true);
        }
        this.deleteFile();
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }

    private String sendRequest() {
        ServerActionParameter paramMethod = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.METHOD.toString(), (Object)ButlerQueryAction.METHOD_TYPE.ADD);
        ServerActionParameter paramOrderId = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.ORDER_ID.toString(), (Object)this.orderId);
        ServerActionParameter paramProduct = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.BUTLER_PRODUCT.toString(), (Object)this.product);
        ServerActionParameter paramMinX = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.MIN_X.toString(), (Object)this.minX);
        ServerActionParameter paramMinY = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.MIN_Y.toString(), (Object)this.minY);
        if (this.isButler2) {
            ServerActionParameter paramBoxSize = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.BOX_SIZE.toString(), (Object)this.boxSize);
            ServerActionParameter paramIsWmps = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.IS_WMPS.toString(), (Object)true);
            ServerActionParameter etrsRahmenkarte = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.ETRS_BLATTSCHNITT.toString(), (Object)this.isEtrsRahmenkarte);
            try {
                return (String)SessionManager.getProxy().executeTask(SERVER_ACTION, "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{paramMethod, paramOrderId, paramProduct, etrsRahmenkarte, paramMinX, paramMinY, paramBoxSize, paramIsWmps});
            }
            catch (ConnectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            ServerActionParameter paramMaxX = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.MAX_X.toString(), (Object)this.maxX);
            ServerActionParameter paramMaxY = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.MAX_Y.toString(), (Object)this.maxY);
            try {
                return (String)SessionManager.getProxy().executeTask(SERVER_ACTION, "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{paramMethod, paramOrderId, paramProduct, paramMinX, paramMinY, paramMaxX, paramMaxY});
            }
            catch (ConnectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public boolean cancel() {
        boolean cancelled = false;
        if (this.downloadFuture != null) {
            cancelled = this.downloadFuture.cancel(true);
        } else {
            this.doCancellationHandling(false, false);
        }
        this.status = Download.State.ABORTED;
        this.stateChanged();
        return cancelled;
    }

    private void removeRequestFromServer() {
        ServerActionParameter paramOrderId = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.REQUEST_ID.toString(), (Object)this.requestId);
        ServerActionParameter paramMethod = new ServerActionParameter(ButlerQueryAction.PARAMETER_TYPE.METHOD.toString(), (Object)ButlerQueryAction.METHOD_TYPE.CANCEL);
        try {
            SessionManager.getProxy().executeTask(SERVER_ACTION, "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{paramOrderId, paramMethod});
        }
        catch (Exception ex) {
            log.error((Object)"error during enqueuing nas server request", (Throwable)ex);
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    static {
        Properties prop = new Properties();
        try {
            prop.load(ButlerDownload.class.getResourceAsStream("butlerDownload.properties"));
            BUTLER_SERVER_BASE_PATH = prop.getProperty("butlerBasePath");
            TIF_RESULT_DIR = prop.getProperty("tifResultDir");
            PDF_RESULT_DIR = prop.getProperty("pdfResultDir");
            SHAPE_RESULT_DIR = prop.getProperty("shapeResultDir");
            DXF_RESULT_DIR = prop.getProperty("dxfResultDir");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final class ButlerPollingRunnable
    implements Callable<ArrayList<URL>> {
        private String requestId;

        public ButlerPollingRunnable(String requestId) {
            this.requestId = requestId;
        }

        private ArrayList<URL> getDownloadURLs() {
            ArrayList<URL> result = new ArrayList<URL>();
            StringBuilder baseUrl = new StringBuilder();
            ArrayList<String> fileExtensions = new ArrayList<String>();
            String format = ButlerDownload.this.product.getFormat().getKey();
            try {
                baseUrl.append(BUTLER_SERVER_BASE_PATH);
                if (format.equals("dxf")) {
                    baseUrl.append(DXF_RESULT_DIR);
                    fileExtensions.add(".dxf");
                } else if (format.equals("shp")) {
                    baseUrl.append(SHAPE_RESULT_DIR);
                    fileExtensions.add(".shp");
                    fileExtensions.add(".prj");
                    fileExtensions.add(".dbf");
                    fileExtensions.add(".shx");
                } else if (format.equals("tif")) {
                    baseUrl.append(TIF_RESULT_DIR);
                    fileExtensions.add(".tif");
                } else if (format.equals("geotif")) {
                    baseUrl.append(TIF_RESULT_DIR);
                    fileExtensions.add(".tif");
                    fileExtensions.add(".tfw");
                } else {
                    baseUrl.append(PDF_RESULT_DIR);
                    fileExtensions.add(".pdf");
                }
                baseUrl.append("/");
                baseUrl.append(URLEncoder.encode(this.requestId, "UTF8"));
                for (String fileExtension : fileExtensions) {
                    try {
                        result.add(new URL(baseUrl.toString() + fileExtension));
                    }
                    catch (MalformedURLException ex) {
                        log.error((Object)"Missformed Download URL");
                    }
                }
            }
            catch (UnsupportedEncodingException ex) {
                log.error((Object)"Unsupported Encoding", (Throwable)ex);
            }
            return result;
        }

        @Override
        public ArrayList<URL> call() throws Exception {
            ArrayList<URL> urls = this.getDownloadURLs();
            if (urls.isEmpty()) {
                log.error((Object)"Could not determine Download URLS");
                return null;
            }
            URL url = urls.get(0);
            boolean fileExists = false;
            while (!fileExists) {
                try {
                    fileExists = WebAccessManager.getInstance().doRequest(url) != null;
                }
                catch (BadHttpStatusCodeException e) {
                    if (e.getStatuscode() == 404 || e.getStatuscode() == 403) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Resultfile for order " + this.requestId + " not exists. Trying again"));
                        }
                    }
                    return null;
                }
                catch (Exception ex) {
                    log.warn((Object)"unknown download error", (Throwable)ex);
                    return null;
                }
                if (Thread.interrupted()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Butler polling future was cancelled");
                    }
                    return null;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Result for " + this.requestId + " is not finished, try later again"));
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    log.info((Object)"result fetching thread was interrupted", (Throwable)ex);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return urls;
        }
    }
}

