/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.clientutils.ClientBaulastBescheinigungHelper;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisProductDownloadHelper;
import de.cismet.cids.custom.objectrenderer.utils.alkis.AlkisUtils;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.alkis.BaulastBescheinigungHelper;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungBillingDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungDownloadInfo;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.commons.gui.progress.BusyLoggingTextPane;
import de.cismet.commons.gui.progress.BusyStatusPanel;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BaulastBescheinigungDialog
extends JDialog
implements ConnectionContextProvider {
    public static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(BaulastBescheinigungDialog.class);
    private static BaulastBescheinigungDialog INSTANCE;
    private static ObjectMapper MAPPER;
    private BerechtigungspruefungBescheinigungDownloadInfo downloadInfo = null;
    private SwingWorker worker;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private BusyStatusPanel busyStatusPanel1;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private BusyLoggingTextPane protokollPane;

    private BaulastBescheinigungDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public static BaulastBescheinigungDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BaulastBescheinigungDialog(null, true);
        }
        return INSTANCE;
    }

    public static void addMessage(String message) {
        BaulastBescheinigungDialog.getInstance().protokollPane.addMessage(message, BusyLoggingTextPane.Styles.INFO);
    }

    public void addError(String message) {
        this.protokollPane.addMessage(message, BusyLoggingTextPane.Styles.ERROR);
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jPanel4 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButton2 = new JButton();
        this.jButton1 = new JButton();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.protokollPane = new BusyLoggingTextPane();
        this.jPanel9 = new JPanel();
        this.busyStatusPanel1 = new BusyStatusPanel();
        this.setDefaultCloseOperation(0);
        this.setTitle(NbBundle.getMessage(BaulastBescheinigungDialog.class, (String)"BaulastBescheinigungDialog.title"));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BaulastBescheinigungDialog.class, (String)"BaulastBescheinigungDialog.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(BaulastBescheinigungDialog.class, (String)"BaulastBescheinigungDialog.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jTextField1.setText(NbBundle.getMessage(BaulastBescheinigungDialog.class, (String)"BaulastBescheinigungDialog.jTextField1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jTextField1, gridBagConstraints);
        this.jTextField2.setText(NbBundle.getMessage(BaulastBescheinigungDialog.class, (String)"BaulastBescheinigungDialog.jTextField2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.jTextField2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel4.setMinimumSize(new Dimension(500, 27));
        this.jPanel4.setPreferredSize(new Dimension(500, 27));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridLayout(1, 0, 5, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(BaulastBescheinigungDialog.class, (String)"BaulastBescheinigungDialog.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaulastBescheinigungDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton2);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(BaulastBescheinigungDialog.class, (String)"BaulastBescheinigungDialog.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaulastBescheinigungDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        this.jPanel4.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BaulastBescheinigungDialog.class, (String)"BaulastBescheinigungDialog.jPanel8.border.title")));
        this.jPanel8.setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(500, 300));
        this.jScrollPane1.setPreferredSize(new Dimension(520, 250));
        this.protokollPane.setEditable(false);
        this.jScrollPane1.setViewportView((Component)this.protokollPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel8.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel3.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(400, 27));
        this.jPanel9.setOpaque(false);
        this.jPanel9.setPreferredSize(new Dimension(400, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel9, gridBagConstraints);
        this.busyStatusPanel1.setStatusMessage(NbBundle.getMessage(BaulastBescheinigungDialog.class, (String)"BaulastBescheinigungDialog.busyStatusPanel1.statusMessage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        this.jPanel3.add((Component)this.busyStatusPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.pack();
    }

    public void show(Collection<CidsBean> flurstuecke, Component parent, ConnectionContext connectionContext) {
        try {
            this.connectionContext = connectionContext;
            ArrayList<CidsBean> flurstueckeList = new ArrayList<CidsBean>(new HashSet<CidsBean>(flurstuecke));
            this.jTextField2.setText(new SimpleDateFormat("yy").format(new Date()) + "-");
            this.jPanel1.setVisible(!BillingPopup.hasUserBillingMode(this.getConnectionContext()));
            this.prepareDownload(flurstueckeList);
            StaticSwingTools.showDialog((JDialog)this);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            boolean berechtigungspruefung = false;
            try {
                berechtigungspruefung = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "berechtigungspruefung_baulastbescheinigung", this.getConnectionContext());
            }
            catch (ConnectionException ex) {
                LOG.info((Object)"could not check config attr", (Throwable)ex);
            }
            boolean hasBilling = BillingPopup.hasUserBillingMode(this.getConnectionContext());
            this.downloadInfo.setAuftragsnummer(hasBilling ? null : this.jTextField2.getText());
            this.downloadInfo.setProduktbezeichnung(hasBilling ? null : this.jTextField1.getText());
            ArrayList<BillingProductGroupAmount> prodAmounts = new ArrayList<BillingProductGroupAmount>();
            for (Map.Entry amount : this.downloadInfo.getAmounts().entrySet()) {
                prodAmounts.add(new BillingProductGroupAmount((String)amount.getKey(), ((Integer)amount.getValue()).intValue()));
            }
            if (BillingPopup.doBilling("blab_be", MAPPER.writeValueAsString((Object)this.downloadInfo), (Geometry)null, (BerechtigungspruefungBillingDownloadInfo)(berechtigungspruefung && AlkisProductDownloadHelper.checkBerechtigungspruefung(this.downloadInfo.getProduktTyp(), this.getConnectionContext()) ? this.downloadInfo : null), this.getConnectionContext(), prodAmounts.toArray(new BillingProductGroupAmount[0]))) {
                String berechnung = BillingPopup.getInstance().getBerechnungsProtokoll();
                if (berechnung != null && !berechnung.trim().isEmpty()) {
                    BaulastBescheinigungDialog.addMessage("\n===\n\nGeb\u00fchrenberechnung:\n");
                    BaulastBescheinigungDialog.addMessage(berechnung);
                }
                AlkisProductDownloadHelper.downloadBaulastbescheinigung(this.downloadInfo, "", this.getConnectionContext());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        this.setVisible(false);
    }

    public void prepareDownload(final List<CidsBean> flurstuecke) {
        boolean checkProtokollPane = false;
        try {
            checkProtokollPane = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "baulast.bescheinigung.protokollpane_enabled", this.getConnectionContext());
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        this.jPanel8.setVisible(checkProtokollPane);
        try {
            if (this.worker != null && !this.worker.isDone()) {
                this.worker.cancel(true);
            }
            try {
                this.protokollPane.getDocument().remove(0, this.protokollPane.getDocument().getLength());
            }
            catch (BadLocationException ex) {
                LOG.error((Object)"Could not clear Protokoll Pane", (Throwable)ex);
            }
            this.jButton1.setEnabled(false);
            this.protokollPane.setBusy(true);
            this.busyStatusPanel1.setBusy(true);
            this.pack();
            this.worker = new SwingWorker<BerechtigungspruefungBescheinigungDownloadInfo, Void>(){

                @Override
                protected BerechtigungspruefungBescheinigungDownloadInfo doInBackground() throws Exception {
                    boolean hasBilling = BillingPopup.hasUserBillingMode(BaulastBescheinigungDialog.this.getConnectionContext());
                    return new ClientBaulastBescheinigungHelper(BaulastBescheinigungDialog.this.getConnectionContext()).calculateDownloadInfo(hasBilling ? null : BaulastBescheinigungDialog.this.jTextField2.getText(), hasBilling ? null : BaulastBescheinigungDialog.this.jTextField1.getText(), AlkisUtils.createBaulastenFertigungsVermerk(SessionManager.getSession().getUser(), BaulastBescheinigungDialog.this.getConnectionContext()), flurstuecke, new BaulastBescheinigungHelper.ProtocolBuffer(){

                        public BaulastBescheinigungHelper.ProtocolBuffer appendLine(String string) {
                            BaulastBescheinigungDialog.addMessage(string);
                            return super.appendLine(string);
                        }
                    }, new BaulastBescheinigungHelper.StatusHolder(){

                        public void setMessage(String message) {
                            super.setMessage(message);
                            BaulastBescheinigungDialog.this.setStatusMessage(message);
                        }
                    });
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    boolean errorOccurred;
                    block11: {
                        block9: {
                            errorOccurred = false;
                            try {
                                BaulastBescheinigungDialog.this.downloadInfo = (BerechtigungspruefungBescheinigungDownloadInfo)this.get();
                                if (!errorOccurred) break block9;
                            }
                            catch (Exception ex) {
                                block13: {
                                    block10: {
                                        try {
                                            String errMessage;
                                            BaulastBescheinigungDialog.this.downloadInfo = null;
                                            errorOccurred = true;
                                            if (ex.getCause() instanceof BaulastBescheinigungHelper.BaBeException) {
                                                Throwable exception = ex.getCause();
                                                errMessage = exception.getMessage();
                                                BaulastBescheinigungDialog.this.addError(errMessage);
                                            } else {
                                                Exception exception = ex;
                                                LOG.error((Object)ex, (Throwable)ex);
                                                errMessage = exception.getMessage();
                                                BaulastBescheinigungDialog.this.addError("Es ist ein Fehler aufgetreten: " + errMessage);
                                            }
                                            if (!(ex instanceof CancellationException)) {
                                                JOptionPane.showMessageDialog(BaulastBescheinigungDialog.this, errMessage, "Es ist ein Fehler aufgetreten.", 0);
                                            }
                                            if (!errorOccurred) break block10;
                                        }
                                        catch (Throwable throwable) {
                                            if (errorOccurred) {
                                                BaulastBescheinigungDialog.this.setStatusMessage("Es ist ein Fehler aufgetreten.");
                                            } else {
                                                BaulastBescheinigungDialog.this.setStatusMessage("Die Bescheinigung kann jetzt erzeugt werden.");
                                            }
                                            BaulastBescheinigungDialog.this.busyStatusPanel1.setBusy(false);
                                            BaulastBescheinigungDialog.this.protokollPane.setBusy(false);
                                            BaulastBescheinigungDialog.this.jButton1.setEnabled(!errorOccurred);
                                            throw throwable;
                                        }
                                        BaulastBescheinigungDialog.this.setStatusMessage("Es ist ein Fehler aufgetreten.");
                                        break block13;
                                    }
                                    BaulastBescheinigungDialog.this.setStatusMessage("Die Bescheinigung kann jetzt erzeugt werden.");
                                }
                                BaulastBescheinigungDialog.this.busyStatusPanel1.setBusy(false);
                                BaulastBescheinigungDialog.this.protokollPane.setBusy(false);
                                BaulastBescheinigungDialog.this.jButton1.setEnabled(!errorOccurred);
                            }
                            BaulastBescheinigungDialog.this.setStatusMessage("Es ist ein Fehler aufgetreten.");
                            break block11;
                        }
                        BaulastBescheinigungDialog.this.setStatusMessage("Die Bescheinigung kann jetzt erzeugt werden.");
                    }
                    BaulastBescheinigungDialog.this.busyStatusPanel1.setBusy(false);
                    BaulastBescheinigungDialog.this.protokollPane.setBusy(false);
                    BaulastBescheinigungDialog.this.jButton1.setEnabled(!errorOccurred);
                }
            };
            this.worker.execute();
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BaulastBescheinigungDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(BaulastBescheinigungDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BaulastBescheinigungDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(BaulastBescheinigungDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        try {
            DevelopmentTools.initSessionManagerFromRMIConnectionOnLocalhost((String)"WUNDA_BLAU", null, (String)"admin", (String)"");
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
            System.exit(1);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaulastBescheinigungDialog dialog = BaulastBescheinigungDialog.getInstance();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
            }
        });
    }

    private void setStatusMessage(String message) {
        this.busyStatusPanel1.setStatusMessage(message);
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    static {
        MAPPER = new ObjectMapper();
    }
}

