/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class BerechtigungspruefungKonfiguration {
    public static final Logger LOG = Logger.getLogger(BerechtigungspruefungKonfiguration.class);
    public static BerechtigungspruefungKonfiguration INSTANCE;
    @JsonProperty
    private final List<ProduktTyp> produkte;
    @JsonProperty
    private final List<Freigabegrund> freigabegruende;
    @JsonProperty
    private final List<Ablehnungsgrund> ablehnungsgruende;

    public BerechtigungspruefungKonfiguration(@JsonProperty(value="produkte") List<ProduktTyp> produkte, @JsonProperty(value="freigabegruende") List<Freigabegrund> freigabegruende, @JsonProperty(value="ablehnungsgruende") List<Ablehnungsgrund> ablehnungsgruende) {
        this.produkte = produkte;
        this.freigabegruende = freigabegruende;
        this.ablehnungsgruende = ablehnungsgruende;
    }

    public List<ProduktTyp> getProdukte() {
        return this.produkte;
    }

    public List<Freigabegrund> getFreigabegruende() {
        return this.freigabegruende;
    }

    public List<Ablehnungsgrund> getAblehnungsgruende() {
        return this.ablehnungsgruende;
    }

    static {
        BerechtigungspruefungKonfiguration conf = null;
        try {
            Object ret = SessionManager.getSession().getConnection().executeTask(SessionManager.getSession().getUser(), "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.BERECHTIGUNGSPRUEFUNG_CONF_JSON.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)BerechtigungspruefungKonfiguration.class.getSimpleName()), new ServerActionParameter[0]);
            if (ret instanceof Exception) {
                throw (Exception)ret;
            }
            conf = (BerechtigungspruefungKonfiguration)new ObjectMapper().readValue((Reader)new StringReader((String)ret), BerechtigungspruefungKonfiguration.class);
        }
        catch (Exception ex) {
            LOG.warn((Object)"error while creating BerechtigungspruefungKonfiguration instance", (Throwable)ex);
        }
        INSTANCE = conf;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class Freigabegrund {
        @JsonProperty
        private final String vorlage;
        @JsonProperty
        private final String langtext;

        public Freigabegrund(@JsonProperty(value="vorlage") String vorlage, @JsonProperty(value="langtext") String langtext) {
            this.vorlage = vorlage;
            this.langtext = langtext;
        }

        public String getVorlage() {
            return this.vorlage;
        }

        public String getLangtext() {
            return this.langtext;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class Ablehnungsgrund {
        @JsonProperty
        private final String vorlage;
        @JsonProperty
        private final String langtext;

        public Ablehnungsgrund(@JsonProperty(value="vorlage") String vorlage, @JsonProperty(value="langtext") String langtext) {
            this.vorlage = vorlage;
            this.langtext = langtext;
        }

        public String getVorlage() {
            return this.vorlage;
        }

        public String getLangtext() {
            return this.langtext;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class ProduktTyp {
        @JsonProperty
        private final String produktbezeichnung;
        @JsonProperty
        private final boolean begruendungstextErlaubt;
        @JsonProperty
        private final boolean berechtigungsgrundErlaubt;
        @JsonProperty
        private final boolean dateianhangErlaubt;
        @JsonProperty
        private final Collection<String> berechtigungsgruende;

        public ProduktTyp(@JsonProperty(value="produktbezeichnung") String produktbezeichnung, @JsonProperty(value="begruendungstext_erlaubt") boolean begruendungstextErlaubt, @JsonProperty(value="berechtigungsgrund_erlaubt") boolean berechtigungsgrundErlaubt, @JsonProperty(value="dateianhang_erlaubt") boolean dateianhangErlaubt, @JsonProperty(value="berechtigungsgruende") Collection<String> berechtigungsgruende) {
            this.produktbezeichnung = produktbezeichnung;
            this.begruendungstextErlaubt = begruendungstextErlaubt;
            this.berechtigungsgrundErlaubt = berechtigungsgrundErlaubt;
            this.dateianhangErlaubt = dateianhangErlaubt;
            this.berechtigungsgruende = berechtigungsgruende;
        }

        public String getProduktbezeichnung() {
            return this.produktbezeichnung;
        }

        public boolean isBegruendungstextErlaubt() {
            return this.begruendungstextErlaubt;
        }

        public boolean isBerechtigungsgrundErlaubt() {
            return this.berechtigungsgrundErlaubt;
        }

        public boolean isDateianhangErlaubt() {
            return this.dateianhangErlaubt;
        }

        public Collection<String> getBerechtigungsgruende() {
            return this.berechtigungsgruende;
        }
    }
}

