/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.clientutils.StadtbilderUtils;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.connectioncontext.ConnectionContext;
import java.awt.Image;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class Sb_RestrictionLevelUtils {
    private static final transient Logger LOG = Logger.getLogger(Sb_RestrictionLevelUtils.class);
    private static CidsBean NO_RESTRICTION;
    private static Image FULL_RESTRICTION_IMAGE;
    private static Image NO_RESTRICTION_IMAGE;
    private static Image MIDDLE_RESTRICTION_IMAGE;
    private static String FULL_RESTRICTION_TOOLTIP;
    private static String NO_RESTRICTION_TOOLTIP;
    private static String MIDDLE_RESTRICTION_TOOLTIP;

    public static CidsBean getNoRestriction(ConnectionContext connectionContext) {
        if (NO_RESTRICTION == null) {
            NO_RESTRICTION = Sb_RestrictionLevelUtils.getNutzungseinschraenkungNoRestriction(connectionContext);
        }
        return NO_RESTRICTION;
    }

    private static CidsBean getNutzungseinschraenkungNoRestriction(ConnectionContext connectionContext) {
        block6: {
            try {
                MetaClass nutzungsClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"sb_nutzungseinschraenkung", (ConnectionContext)connectionContext);
                if (nutzungsClass == null) break block6;
                StringBuffer noRestrictionQuery = new StringBuffer("select ").append(nutzungsClass.getId()).append(", ").append(nutzungsClass.getPrimaryKey()).append(" from ").append(nutzungsClass.getTableName()).append(" where key ilike 'noRestriction'");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQL: wuppertalQuery:" + noRestrictionQuery.toString()));
                }
                try {
                    MetaObject[] noRestriction = SessionManager.getProxy().getMetaObjectByQuery(noRestrictionQuery.toString(), 0, connectionContext);
                    if (noRestriction.length > 0) {
                        return noRestriction[0].getBean();
                    }
                }
                catch (ConnectionException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"The Location Wuppertal could not be loaded.", (Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RestrictionLevel determineRestrictionLevelForStadtbildserie(CidsBean stadtbildserie, ConnectionContext connectionContext) {
        RestrictionLevel determinedLevel = new RestrictionLevel();
        if (stadtbildserie != null) {
            CidsBean cidsBean = stadtbildserie;
            synchronized (cidsBean) {
                Object tmp_level = stadtbildserie.getProperty("tmp_restriction_level");
                if (tmp_level instanceof RestrictionLevel) {
                    determinedLevel = (RestrictionLevel)tmp_level;
                } else {
                    CidsBean nutzungseinschraenkung = (CidsBean)stadtbildserie.getProperty("nutzungseinschraenkung");
                    RestrictionLevel level = Sb_RestrictionLevelUtils.determineRestrictionLevelForNutzungseinschraenkung(nutzungseinschraenkung, connectionContext);
                    if (level != null) {
                        try {
                            stadtbildserie.setProperty("tmp_restriction_level", (Object)level);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Could not set property tmp_restriction_level of the stadtbildserie", (Throwable)ex);
                        }
                        determinedLevel = level;
                    }
                }
            }
        }
        return determinedLevel;
    }

    public static synchronized RestrictionLevel determineRestrictionLevelForNutzungseinschraenkung(CidsBean nutzungseinschraenkung, ConnectionContext connectionContext) {
        if (nutzungseinschraenkung != null) {
            RestrictionLevel level = new RestrictionLevel();
            String key = (String)nutzungseinschraenkung.getProperty("key");
            if (StringUtils.isNotBlank((String)key)) {
                String actionTagPreview = "custom.stadtbilder." + key + ".preview";
                String actionTagDownload = "custom.stadtbilder." + key + ".download";
                String actionTagInternalUsage = "custom.stadtbilder." + key + ".internalUsage";
                String actionTagExternalUsage = "custom.stadtbilder." + key + ".externalUsage";
                boolean previewAllowed = ObjectRendererUtils.checkActionTag(actionTagPreview, connectionContext);
                boolean downloadAllowed = ObjectRendererUtils.checkActionTag(actionTagDownload, connectionContext);
                boolean internalUsageAllowed = ObjectRendererUtils.checkActionTag(actionTagInternalUsage, connectionContext);
                boolean externalUsageAllowed = ObjectRendererUtils.checkActionTag(actionTagExternalUsage, connectionContext);
                level.setPreviewAllowed(previewAllowed);
                level.setDownloadAllowed(downloadAllowed);
                level.setInternalUsageAllowed(internalUsageAllowed);
                level.setExternalUsageAllowed(externalUsageAllowed);
            }
            return level;
        }
        return null;
    }

    public static BulletPointSettings determineBulletPointAndInfoText(CidsBean stadtbildserie, ConnectionContext connectionContext) {
        RestrictionLevel level = Sb_RestrictionLevelUtils.determineRestrictionLevelForStadtbildserie(stadtbildserie, connectionContext);
        Image colorImage = FULL_RESTRICTION_IMAGE;
        String tooltipText = FULL_RESTRICTION_TOOLTIP;
        if (level.isInternalUsageAllowed()) {
            if (level.isExternalUsageAllowed()) {
                colorImage = NO_RESTRICTION_IMAGE;
                tooltipText = NO_RESTRICTION_TOOLTIP;
            } else {
                colorImage = MIDDLE_RESTRICTION_IMAGE;
                tooltipText = MIDDLE_RESTRICTION_TOOLTIP;
            }
        }
        return new BulletPointSettings(colorImage, tooltipText);
    }

    static {
        FULL_RESTRICTION_IMAGE = StadtbilderUtils.ERROR_IMAGE;
        NO_RESTRICTION_IMAGE = StadtbilderUtils.ERROR_IMAGE;
        MIDDLE_RESTRICTION_IMAGE = StadtbilderUtils.ERROR_IMAGE;
        FULL_RESTRICTION_TOOLTIP = "";
        NO_RESTRICTION_TOOLTIP = "";
        MIDDLE_RESTRICTION_TOOLTIP = "";
        try {
            FULL_RESTRICTION_IMAGE = ImageIO.read(Sb_RestrictionLevelUtils.class.getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bullet_red.png"));
            FULL_RESTRICTION_TOOLTIP = NbBundle.getMessage(Sb_RestrictionLevelUtils.class, (String)"Sb_RestrictionLevelUtils.fullRestriction.info");
            MIDDLE_RESTRICTION_IMAGE = ImageIO.read(Sb_RestrictionLevelUtils.class.getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bullet_yellow.png"));
            MIDDLE_RESTRICTION_TOOLTIP = NbBundle.getMessage(Sb_RestrictionLevelUtils.class, (String)"Sb_RestrictionLevelUtils.middleRestriction.info");
            NO_RESTRICTION_IMAGE = ImageIO.read(Sb_RestrictionLevelUtils.class.getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/bullet_green.png"));
            NO_RESTRICTION_TOOLTIP = NbBundle.getMessage(Sb_RestrictionLevelUtils.class, (String)"Sb_RestrictionLevelUtils.noRestriction.info");
        }
        catch (Exception ex) {
            LOG.error((Object)"Error in the static block", (Throwable)ex);
        }
    }

    public static class RestrictionLevel
    implements Serializable {
        private boolean previewAllowed;
        private boolean downloadAllowed;
        private boolean internalUsageAllowed;
        private boolean externalUsageAllowed;

        public boolean isPreviewAllowed() {
            return this.previewAllowed;
        }

        public void setPreviewAllowed(boolean previewAllowed) {
            this.previewAllowed = previewAllowed;
        }

        public boolean isDownloadAllowed() {
            return this.downloadAllowed;
        }

        public void setDownloadAllowed(boolean downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
        }

        public boolean isInternalUsageAllowed() {
            return this.internalUsageAllowed;
        }

        public void setInternalUsageAllowed(boolean internalUsageAllowed) {
            this.internalUsageAllowed = internalUsageAllowed;
        }

        public boolean isExternalUsageAllowed() {
            return this.externalUsageAllowed;
        }

        public void setExternalUsageAllowed(boolean externalUsageAllowed) {
            this.externalUsageAllowed = externalUsageAllowed;
        }
    }

    public static class BulletPointSettings {
        Image colorImage;
        String tooltipText;

        public BulletPointSettings(Image colorImage, String tooltipText) {
            this.colorImage = colorImage;
            this.tooltipText = tooltipText;
        }

        public Image getColorImage() {
            return this.colorImage;
        }

        public String getTooltipText() {
            return this.tooltipText;
        }
    }
}

