/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.nas.CSVListDownload;
import de.cismet.cids.custom.nas.NASDownload;
import de.cismet.cids.custom.nas.NasFeePreviewPanel;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.utils.nas.NasProduct;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JComboBoxBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NasDialog
extends JDialog
implements ChangeListener,
DocumentListener,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(NasDialog.class);
    private static double MAP_BUFFER = 50.0;
    private static final Color FEATURE_COLOR_SELECTED = new Color(1.0f, 0.0f, 0.0f, 0.7f);
    private static final Color FEATURE_COLOR = new Color(0.5f, 0.5f, 0.5f, 0.1f);
    private static final String BASE_TITLE_NAS = NbBundle.getMessage(NasDialog.class, (String)"NASDownload.basetitle.nas.text");
    private static final String BASE_TITLE_DXF = NbBundle.getMessage(NasDialog.class, (String)"NASDownload.basetitle.dxf.text");
    long lastDocEvent = 0L;
    boolean ignoreNextDocEvents = false;
    Timer docTimer = new Timer();
    GeomWrapper totalMapWrapper;
    private MappingComponent map;
    private LinkedList<GeomWrapper> geomWrappers;
    private HashMap<GeomWrapper, Feature> bufferedFeatures = new HashMap();
    private NasTableModel tableModel;
    private ArrayList<GeomWrapper> selectedGeomWrappers = new ArrayList();
    private HashMap<GeomWrapper, Feature> bufferFeatureMap = new HashMap();
    private NasFeePreviewPanel feePreview;
    private ArrayList<DefaultStyledFeature> pointFeatures = new ArrayList();
    private boolean firstBufferCall = true;
    private boolean isInitialized = false;
    private int pointAmount = 0;
    private int gebaeudeAmount = 0;
    private int flurstueckAmount = 0;
    private ArrayList<NasProduct> nasProducts;
    private final ConnectionContext connectionContext;
    private JButton btnCancel;
    private JButton btnOk;
    private JComboBox cbType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSlider jsGeomBuffer;
    private JLabel lblAuftragsnummer;
    private JLabel lblGeomBuffer;
    private JLabel lblType;
    private JPanel pnlControls;
    private JPanel pnlFee;
    private JPanel pnlMap;
    private JPanel pnlSettings;
    private JTable tblGeom;
    private JTextField tfAuftragsnummer;
    private JTextField tfGeomBuffer;
    private BindingGroup bindingGroup;

    public NasDialog(Frame parent, boolean modal, ConnectionContext connectionContext) {
        this(parent, modal, null, connectionContext);
    }

    public NasDialog(Frame parent, boolean modal, Collection<Feature> selectedFeatures, ConnectionContext connectionContext) {
        super(parent, modal);
        this.connectionContext = connectionContext;
        this.feePreview = new NasFeePreviewPanel(this.getConnectionContext());
        this.loadNasProducts();
        MAP_BUFFER = Double.parseDouble(NbBundle.getMessage(NasDialog.class, (String)"NasDialog.selectedGeomMapBuffer"));
        this.geomWrappers = new LinkedList();
        this.map = CismapBroker.getInstance().getMappingComponent();
        FeatureCollection fc = this.map.getFeatureCollection();
        for (Feature f : fc.getAllFeatures()) {
            String name = "";
            name = f instanceof XStyledFeature ? name + ((XStyledFeature)f).getType() + " " + ((XStyledFeature)f).getName() : name + f;
            boolean selected = false;
            if (selectedFeatures == null) {
                selected = true;
            } else {
                for (Feature featurToSelect : selectedFeatures) {
                    if (!f.equals(featurToSelect)) continue;
                    selected = true;
                }
            }
            double buffer = 0.0;
            if (f.getGeometry() instanceof Point || f.getGeometry() instanceof LineString) {
                buffer = 0.001;
                if (f.getGeometry() instanceof Point) {
                    DefaultStyledFeature dsf = new DefaultStyledFeature();
                    dsf.setGeometry(f.getGeometry());
                    BufferedImage bi = new BufferedImage(9, 9, 6);
                    Graphics2D g = (Graphics2D)bi.getGraphics().create();
                    g.setStroke(new BasicStroke(1.0f));
                    g.setColor(Color.black);
                    g.drawOval(0, 0, 5, 5);
                    FeatureAnnotationSymbol fas = new FeatureAnnotationSymbol(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/nas/icon-circlerecordempty.png")).getImage());
                    fas.setSweetSpotX(0.5);
                    fas.setSweetSpotY(0.5);
                    dsf.setPointAnnotationSymbol(fas);
                    this.pointFeatures.add(dsf);
                }
            }
            this.geomWrappers.add(new GeomWrapper(f.getGeometry().buffer(buffer), name, selected));
        }
        this.tableModel = new NasTableModel();
        this.initComponents();
        this.tblGeom.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                NasDialog.this.selectedGeomWrappers.clear();
                for (int i = lsm.getMinSelectionIndex(); i <= lsm.getMaxSelectionIndex(); ++i) {
                    if (!lsm.isSelectedIndex(i)) continue;
                    NasDialog.this.selectedGeomWrappers.add(NasDialog.this.tableModel.get(i));
                }
                NasDialog.this.changeMap();
            }
        });
        this.tblGeom.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.tblGeom.getColumnModel().getColumn(0).setMaxWidth(80);
        this.jsGeomBuffer.addChangeListener(this);
        this.tfGeomBuffer.getDocument().addDocumentListener(this);
        this.map = new MappingComponent();
        this.initMap();
        this.pnlMap.setLayout(new BorderLayout());
        this.pnlMap.add((Component)this.map, "Center");
        this.cbType.setSelectedIndex(1);
        this.calculateFee();
        this.isInitialized = true;
        this.map.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NasDialog.this.map.zoomToFeatureCollection();
                NasDialog.this.tblGeom.clearSelection();
            }
        });
    }

    private void loadNasProducts() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object ret = SessionManager.getSession().getConnection().executeTask(SessionManager.getSession().getUser(), "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.NAS_PRODUCT_DESCRIPTION_JSON.getValue(), this.getConnectionContext(), new ServerActionParameter[0]);
            if (ret instanceof Exception) {
                throw (Exception)ret;
            }
            String conf = (String)ret;
            this.nasProducts = (ArrayList)mapper.readValue((Reader)new StringReader(conf), (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, NasProduct.class));
            ArrayList<NasProduct> skips = new ArrayList<NasProduct>();
            for (NasProduct np : this.nasProducts) {
                if (np.getPermissionNeeded() == null || this.validateUserHasActionAttribute(np.getPermissionNeeded())) continue;
                skips.add(np);
            }
            this.nasProducts.removeAll(skips);
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean validateUserHasActionAttribute(String actionAttributeString) {
        try {
            return SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), actionAttributeString, this.getConnectionContext());
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Could not validate action tag for Alkis Buchungsblatt!", (Throwable)ex);
            return false;
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.pnlMap = new JPanel();
        this.pnlSettings = new JPanel();
        this.jsGeomBuffer = new JSlider();
        this.lblType = new JLabel();
        this.cbType = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblGeom = new JTable();
        this.jSeparator1 = new JSeparator();
        this.lblAuftragsnummer = new JLabel();
        this.tfAuftragsnummer = new JTextField();
        this.pnlFee = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblGeomBuffer = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tfGeomBuffer = new JTextField();
        this.pnlControls = new JPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(NasDialog.class, (String)"NasDialog.title"));
        this.setMinimumSize(new Dimension(617, 180));
        this.setPreferredSize(new Dimension(780, 540));
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlMap.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout pnlMapLayout = new GroupLayout(this.pnlMap);
        this.pnlMap.setLayout(pnlMapLayout);
        pnlMapLayout.setHorizontalGroup(pnlMapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 345, Short.MAX_VALUE));
        pnlMapLayout.setVerticalGroup(pnlMapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 450, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlMap, gridBagConstraints);
        this.pnlSettings.setMinimumSize(new Dimension(400, 100));
        this.pnlSettings.setPreferredSize(new Dimension(400, 300));
        this.pnlSettings.setLayout(new GridBagLayout());
        this.jsGeomBuffer.setMajorTickSpacing(50);
        this.jsGeomBuffer.setMaximum(50);
        this.jsGeomBuffer.setMinimum(-50);
        this.jsGeomBuffer.setMinorTickSpacing(1);
        this.jsGeomBuffer.setPaintLabels(true);
        this.jsGeomBuffer.setSnapToTicks(true);
        this.jsGeomBuffer.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        this.pnlSettings.add((Component)this.jsGeomBuffer, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblType, (String)NbBundle.getMessage(NasDialog.class, (String)"NasDialog.lblType.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.pnlSettings.add((Component)this.lblType, gridBagConstraints);
        ELProperty eLProperty = ELProperty.create((String)"${nasProducts}");
        JComboBoxBinding jComboBoxBinding = SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JComboBox)this.cbType);
        this.bindingGroup.addBinding((Binding)jComboBoxBinding);
        this.cbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NasDialog.this.cbTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        this.pnlSettings.add((Component)this.cbType, gridBagConstraints);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        this.pnlSettings.add((Component)this.jPanel1, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(400, 100));
        this.jScrollPane1.setPreferredSize(new Dimension(400, 100));
        this.tblGeom.setModel(this.tableModel);
        this.tblGeom.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NasDialog.this.tblGeomFocusLost(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblGeom);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.pnlSettings.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.pnlSettings.add((Component)this.jSeparator1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblAuftragsnummer, (String)NbBundle.getMessage(NasDialog.class, (String)"NasDialog.lblAuftragsnummer.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.pnlSettings.add((Component)this.lblAuftragsnummer, gridBagConstraints);
        this.tfAuftragsnummer.setText(NbBundle.getMessage(NasDialog.class, (String)"NasDialog.tfAuftragsnummer.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        this.pnlSettings.add((Component)this.tfAuftragsnummer, gridBagConstraints);
        this.pnlFee.setBackground(new Color(254, 254, 254));
        this.pnlFee.setBorder(BorderFactory.createEtchedBorder());
        this.pnlFee.setMinimumSize(new Dimension(144, 100));
        this.pnlFee.setPreferredSize(new Dimension(144, 150));
        this.pnlFee.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weighty = 1.0;
        this.pnlSettings.add((Component)this.pnlFee, gridBagConstraints);
        this.jPanel2.setMinimumSize(new Dimension(160, 27));
        this.jPanel2.setPreferredSize(new Dimension(160, 27));
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblGeomBuffer, (String)NbBundle.getMessage(NasDialog.class, (String)"NasDialog.lblGeomBuffer.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel2.add((Component)this.lblGeomBuffer, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setMinimumSize(new Dimension(25, 17));
        this.jLabel1.setPreferredSize(new Dimension(25, 17));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.tfGeomBuffer, (Property)ELProperty.create((String)"${text}"), (Object)this.jLabel1, (Property)BeanProperty.create((String)"text"), (String)"geomBufferBinding");
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NasDialog.class, (String)"NasDialog.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.pnlSettings.add((Component)this.jPanel2, gridBagConstraints);
        this.tfGeomBuffer.setMinimumSize(new Dimension(50, 27));
        this.tfGeomBuffer.setPreferredSize(new Dimension(50, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        this.pnlSettings.add((Component)this.tfGeomBuffer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlSettings, gridBagConstraints);
        this.pnlControls.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnOk, (String)NbBundle.getMessage(NasDialog.class, (String)"NasDialog.btnOk.text"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NasDialog.this.btnOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlControls.add((Component)this.btnOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(NasDialog.class, (String)"NasDialog.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NasDialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.pnlControls.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlControls, gridBagConstraints);
        this.bindingGroup.bind();
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void tblGeomFocusLost(FocusEvent evt) {
    }

    private void cbTypeActionPerformed(ActionEvent evt) {
        if (this.isInitialized) {
            this.calculateFee();
        }
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    NasProduct product = (NasProduct)NasDialog.this.cbType.getSelectedItem();
                    String requestId = NasDialog.this.tfAuftragsnummer.getText().trim();
                    if (requestId.isEmpty()) {
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)NasDialog.this), NbBundle.getMessage(NasDialog.class, (String)"NasDialog.OrderIdCheck.JOptionPane.emptyRequestIdMessage"), NbBundle.getMessage(NasDialog.class, (String)"NasDialog.OrderIdCheck.JOptionPane.title"), 0);
                        NasDialog.this.tfAuftragsnummer.requestFocus();
                        return;
                    }
                    if (requestId != null) {
                        boolean containsWrongChar = false;
                        String wrongChar = "";
                        if (requestId.contains("/")) {
                            containsWrongChar = true;
                            wrongChar = wrongChar + "/";
                        } else if (requestId.contains("\\")) {
                            containsWrongChar = true;
                            wrongChar = wrongChar + "\\";
                        }
                        if (containsWrongChar) {
                            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)NasDialog.this), NbBundle.getMessage(NasDialog.class, (String)"NasDialog.OrderIdCheck.JOptionPane.message") + " '" + wrongChar + "'", NbBundle.getMessage(NasDialog.class, (String)"NasDialog.OrderIdCheck.JOptionPane.title"), 0);
                            NasDialog.this.tfAuftragsnummer.requestFocus();
                            return;
                        }
                    }
                    ArrayList<BillingProductGroupAmount> list = NasDialog.this.feePreview.getProductGroupAmounts();
                    BillingProductGroupAmount[] goupAmounts = list.toArray(new BillingProductGroupAmount[list.size()]);
                    if (BillingPopup.doBilling(product.getBillingKey(), "request", requestId, null, NasDialog.this.getConnectionContext(), goupAmounts)) {
                        NasDialog.this.doDownload(requestId, product);
                    } else {
                        LOG.error((Object)"do billing returns false. can not start download");
                    }
                    NasDialog.this.dispose();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        });
    }

    private void doDownload(String requestId, NasProduct product) {
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)CismapBroker.getInstance().getMappingComponent())) {
            if (product.getServer() != null && product.getTemplateContent() != null) {
                String jobname = !DownloadManagerDialog.getInstance().getJobName().equals("") ? DownloadManagerDialog.getInstance().getJobName() : null;
                DownloadManager.instance().add((Download)new CSVListDownload("CSV-Download", "", jobname, requestId, product, this.generateSearchGeomCollection(), this.getConnectionContext()));
            } else {
                String jobname = !DownloadManagerDialog.getInstance().getJobName().equals("") ? DownloadManagerDialog.getInstance().getJobName() : null;
                String title = product.getFormat().equalsIgnoreCase(NasProduct.Format.DXF.toString()) ? BASE_TITLE_DXF : BASE_TITLE_NAS;
                DownloadManager.instance().add((Download)new NASDownload(title, "", jobname, requestId, product, this.generateSearchGeomCollection(), this.getConnectionContext()));
            }
        } else if (product.getServer() != null && product.getTemplateContent() != null) {
            DownloadManager.instance().add((Download)new CSVListDownload("CSV-Download", "", "", requestId, product, this.generateSearchGeomCollection(), this.getConnectionContext()));
        } else {
            DownloadManager.instance().add((Download)new NASDownload("title", "", "", requestId, product, this.generateSearchGeomCollection(), this.getConnectionContext()));
        }
    }

    private void initMap() {
        Runnable mapRunnable = new Runnable(){

            @Override
            public void run() {
                ActiveLayerModel mappingModel = new ActiveLayerModel();
                mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
                mappingModel.addHome(this.getBoundingBox());
                SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
                swms.setName("NAS-Dialog");
                swms.setTranslucency(0.4f);
                mappingModel.addLayer((RetrievalServiceLayer)swms);
                NasDialog.this.map.setMappingModel((MappingModel)mappingModel);
                int duration = NasDialog.this.map.getAnimationDuration();
                NasDialog.this.map.setAnimationDuration(0);
                NasDialog.this.map.gotoInitialBoundingBox();
                NasDialog.this.map.setInteractionMode("ZOOM");
                NasDialog.this.map.unlock();
                NasDialog.this.map.setInteractionMode("MUTE");
                NasDialog.this.map.setAnimationDuration(duration);
                NasDialog.this.totalMapWrapper = new GeomWrapper(((XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox()).getGeometry(), "kompletter Kartenausschnitt", NasDialog.this.geomWrappers.isEmpty());
                NasDialog.this.geomWrappers.add(NasDialog.this.totalMapWrapper);
                for (GeomWrapper cidsBeanWrapper : NasDialog.this.geomWrappers) {
                    NasDialog.this.map.getFeatureCollection().addFeature((Feature)cidsBeanWrapper.getFeature());
                }
                NasDialog.this.map.getFeatureCollection().addFeatures((Collection)NasDialog.this.pointFeatures);
            }

            private XBoundingBox getBoundingBox() {
                XBoundingBox currBb = (XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox();
                Geometry transformedGeom = CrsTransformer.transformToGivenCrs((Geometry)currBb.getGeometry(), (String)ClientAlkisConf.getInstance().getSrsService());
                XBoundingBox result = new XBoundingBox(transformedGeom.buffer(MAP_BUFFER));
                for (GeomWrapper gw : NasDialog.this.geomWrappers) {
                    Geometry geometry = CrsTransformer.transformToGivenCrs((Geometry)gw.getGeometry(), (String)ClientAlkisConf.getInstance().getSrsService());
                    if (result == null) {
                        result = new XBoundingBox(geometry.getEnvelope().buffer(MAP_BUFFER));
                        result.setSrs(ClientAlkisConf.getInstance().getSrsService());
                        result.setMetric(true);
                        continue;
                    }
                    XBoundingBox temp = new XBoundingBox(geometry.getEnvelope().buffer(MAP_BUFFER));
                    temp.setSrs(ClientAlkisConf.getInstance().getSrsService());
                    temp.setMetric(true);
                    if (temp.getX1() < result.getX1()) {
                        result.setX1(temp.getX1());
                    }
                    if (temp.getY1() < result.getY1()) {
                        result.setY1(temp.getY1());
                    }
                    if (temp.getX2() > result.getX2()) {
                        result.setX2(temp.getX2());
                    }
                    if (!(temp.getY2() > result.getY2())) continue;
                    result.setY2(temp.getY2());
                }
                return result;
            }
        };
        if (EventQueue.isDispatchThread()) {
            mapRunnable.run();
        } else {
            EventQueue.invokeLater(mapRunnable);
        }
    }

    private void changeMap() {
        Runnable mapChangeRunnable = new Runnable(){

            @Override
            public void run() {
                Geometry g;
                if (!NasDialog.this.selectedGeomWrappers.isEmpty()) {
                    g = NasDialog.this.createUnionGeom(NasDialog.this.selectedGeomWrappers, true);
                    if (g.isEmpty()) {
                        g = NasDialog.this.createUnionGeom(NasDialog.this.selectedGeomWrappers, false);
                    }
                } else {
                    int buffer = 0;
                    try {
                        buffer = Integer.parseInt(NasDialog.this.tfGeomBuffer.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    g = NasDialog.this.totalMapWrapper.getGeometry().buffer((double)buffer);
                }
                XBoundingBox boxToGoto = new XBoundingBox(g.getEnvelope(), ClientAlkisConf.getInstance().getSrsService(), true);
                XBoundingBox bufferedBox = new XBoundingBox(boxToGoto.getGeometry().buffer(MAP_BUFFER));
                NasDialog.this.map.gotoBoundingBox((BoundingBox)bufferedBox, false, true, 500);
            }
        };
        if (EventQueue.isDispatchThread()) {
            mapChangeRunnable.run();
        } else {
            EventQueue.invokeLater(mapChangeRunnable);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.jsGeomBuffer) {
            this.handleBufferChanged();
        }
    }

    private void handleBufferChanged() {
        int buffer = 0;
        try {
            buffer = Integer.parseInt(this.tfGeomBuffer.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tfGeomBuffer.getDocument().removeDocumentListener(this);
        this.tfGeomBuffer.setText("" + this.jsGeomBuffer.getValue());
        this.tfGeomBuffer.getDocument().addDocumentListener(this);
        if (!this.jsGeomBuffer.getValueIsAdjusting()) {
            this.clearMapVisualisation(buffer);
            this.changeMap();
            this.calculateFee();
        } else {
            this.visualizeBufferGeomsInMap(buffer);
        }
    }

    private void clearMapVisualisation(final int buffer) {
        final Runnable mapBufferRunnable = new Runnable(){

            @Override
            public void run() {
                NasDialog.this.bufferFeatureMap.clear();
                NasDialog.this.firstBufferCall = true;
                NasDialog.this.map.getFeatureCollection().removeAllFeatures();
                if (NasDialog.this.jsGeomBuffer.getValue() == 0) {
                    NasDialog.this.map.getFeatureCollection().addFeatures((Collection)NasDialog.this.pointFeatures);
                }
                for (GeomWrapper geomWrapper : NasDialog.this.geomWrappers) {
                    GeomWrapper bufferedGeomWrapper = new GeomWrapper(geomWrapper.getGeometry().buffer((double)buffer), null, geomWrapper.isSelected());
                    NasDialog.this.bufferedFeatures.put(geomWrapper, bufferedGeomWrapper.getFeature());
                    NasDialog.this.map.getFeatureCollection().addFeature((Feature)bufferedGeomWrapper.getFeature());
                }
            }
        };
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (EventQueue.isDispatchThread()) {
                    mapBufferRunnable.run();
                } else {
                    EventQueue.invokeLater(mapBufferRunnable);
                }
            }
        }, 10L);
    }

    private void visualizeBufferGeomsInMap(int buffer) {
        if (this.firstBufferCall) {
            this.firstBufferCall = false;
            this.map.getFeatureCollection().removeAllFeatures();
            this.map.getFeatureCollection().addFeatures(this.pointFeatures);
            for (GeomWrapper geomWrapper : this.geomWrappers) {
                this.map.getFeatureCollection().addFeature((Feature)geomWrapper.getFeature());
            }
        }
        if (this.bufferFeatureMap.isEmpty()) {
            for (GeomWrapper gw : this.geomWrappers) {
                DefaultStyledFeature dsf = new DefaultStyledFeature();
                Geometry bufferGeom = gw.getGeometry().buffer((double)buffer);
                Geometry intersectGeom = buffer > 0 ? bufferGeom.difference(gw.getGeometry()) : bufferGeom.intersection(gw.getGeometry());
                dsf.setGeometry(intersectGeom);
                if (gw.isSelected()) {
                    dsf.setFillingPaint((Paint)FEATURE_COLOR_SELECTED);
                } else {
                    dsf.setFillingPaint((Paint)FEATURE_COLOR);
                }
                dsf.setTransparency(0.5f);
                this.bufferFeatureMap.put(gw, (Feature)dsf);
            }
            this.map.getFeatureCollection().addFeatures(this.bufferFeatureMap.values());
        } else {
            for (GeomWrapper gw : this.bufferFeatureMap.keySet()) {
                Geometry g = gw.getGeometry();
                g = g.buffer((double)buffer);
                Feature f = this.bufferFeatureMap.get(gw);
                f.setGeometry(g);
                this.map.getFeatureCollection().reconsiderFeature(f);
            }
        }
    }

    private void calculateFee() {
        NasProduct selectedTemplate = (NasProduct)this.cbType.getSelectedItem();
        Geometry geom = this.generateSearchGeom();
        this.pnlFee.removeAll();
        this.feePreview = new NasFeePreviewPanel(selectedTemplate, this.getConnectionContext());
        this.feePreview.setGeom(geom);
        this.pnlFee.add(this.feePreview);
        this.pnlFee.revalidate();
        this.pnlFee.repaint();
    }

    private Geometry generateSearchGeom() {
        return this.createUnionGeom();
    }

    private Geometry createUnionGeom() {
        ArrayList<GeomWrapper> geoms = new ArrayList<GeomWrapper>();
        for (GeomWrapper gw : this.geomWrappers) {
            if (!gw.isSelected()) continue;
            geoms.add(gw);
        }
        return this.createUnionGeom(geoms, true);
    }

    private Geometry createUnionGeom(Collection<GeomWrapper> gWrappers, boolean bufferGeoms) {
        Geometry unionGeom = null;
        int buffer = 0;
        try {
            buffer = Integer.parseInt(this.tfGeomBuffer.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (GeomWrapper gw : gWrappers) {
            Geometry g = gw.getGeometry();
            if (bufferGeoms && buffer != 0) {
                g = g.buffer((double)buffer);
            }
            if (unionGeom == null) {
                unionGeom = g;
                continue;
            }
            if (unionGeom instanceof MultiPolygon) {
                unionGeom = unionGeom.union(g);
                continue;
            }
            if (unionGeom instanceof GeometryCollection) {
                GeometryCollection gc = (GeometryCollection)unionGeom;
                Geometry[] geoms = new Geometry[unionGeom.getNumGeometries() + 1];
                for (int i = 0; i < gc.getNumGeometries(); ++i) {
                    geoms[i] = gc.getGeometryN(i);
                }
                geoms[geoms.length - 1] = g;
                unionGeom = new GeometryCollection(geoms, gc.getFactory());
                continue;
            }
            unionGeom = unionGeom.union(g);
        }
        if (unionGeom != null) {
            DefaultStyledFeature testDSF = new DefaultStyledFeature();
            testDSF.setGeometry(unionGeom);
            PFeature pf = new PFeature((Feature)testDSF, this.map);
            pf.hasHole();
        }
        return unionGeom;
    }

    private GeometryCollection generateSearchGeomCollection() {
        Geometry unionGeom = this.createUnionGeom();
        GeometryFactory gf = new GeometryFactory(unionGeom.getPrecisionModel(), unionGeom.getSRID());
        Geometry[] geoms = null;
        if (unionGeom instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)unionGeom;
            geoms = new Geometry[mp.getNumGeometries()];
            for (int i = 0; i < mp.getNumGeometries(); ++i) {
                Geometry g;
                geoms[i] = g = mp.getGeometryN(i);
            }
        } else if (unionGeom instanceof Polygon) {
            geoms = new Geometry[]{unionGeom};
        }
        if (geoms == null) {
            return null;
        }
        return new GeometryCollection(geoms, gf);
    }

    public ArrayList<NasProduct> getNasProducts() {
        return this.nasProducts;
    }

    public void setNasProducts(ArrayList<NasProduct> nasProducts) {
        this.nasProducts = nasProducts;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        long currTime = System.currentTimeMillis();
        if (currTime - this.lastDocEvent < 800L) {
            this.docTimer.cancel();
        }
        this.docTimer = new Timer();
        this.docTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                NasDialog.this.visualizeGeomBuffer();
            }
        }, 1000L);
        this.lastDocEvent = currTime;
    }

    private void visualizeGeomBuffer() {
        this.ignoreNextDocEvents = true;
        final int buffer = Integer.parseInt(this.tfGeomBuffer.getText());
        if (buffer >= -50 && buffer <= 50) {
            this.jsGeomBuffer.removeChangeListener(this);
            this.jsGeomBuffer.setValue(buffer);
            this.jsGeomBuffer.addChangeListener(this);
        }
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                NasDialog.this.clearMapVisualisation(buffer);
                NasDialog.this.calculateFee();
                NasDialog.this.ignoreNextDocEvents = false;
            }
        }, 2000L);
        this.visualizeBufferGeomsInMap(buffer);
        this.changeMap();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        long currTime = System.currentTimeMillis();
        if (currTime - this.lastDocEvent < 800L) {
            this.docTimer.cancel();
        }
        this.docTimer = new Timer();
        this.docTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                NasDialog.this.visualizeGeomBuffer();
            }
        }, 1000L);
        this.lastDocEvent = currTime;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private final class NasTableModel
    extends AbstractTableModel {
        private int selectedGeoms = 0;

        private NasTableModel() {
        }

        @Override
        public int getRowCount() {
            return NasDialog.this.geomWrappers.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (NasDialog.this.geomWrappers == null) {
                return null;
            }
            GeomWrapper gw = (GeomWrapper)NasDialog.this.geomWrappers.get(rowIndex);
            if (columnIndex == 0) {
                return gw.isSelected();
            }
            return gw.getName();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            GeomWrapper geomWrapper;
            if (column != 0) {
                return;
            }
            geomWrapper.setSelected(!(geomWrapper = (GeomWrapper)NasDialog.this.geomWrappers.get(row)).isSelected());
            this.selectedGeoms = geomWrapper.isSelected() ? ++this.selectedGeoms : --this.selectedGeoms;
            this.fireTableRowsUpdated(row, row);
            if (row == NasDialog.this.geomWrappers.size() - 1) {
                NasDialog.this.totalMapWrapper.setSelected(geomWrapper.isSelected());
                for (GeomWrapper gw : NasDialog.this.geomWrappers) {
                    if (gw == geomWrapper || !gw.isSelected()) continue;
                    gw.setSelected(false);
                }
                this.fireTableRowsUpdated(0, NasDialog.this.geomWrappers.size() - 2);
            } else {
                GeomWrapper lastEntry = (GeomWrapper)NasDialog.this.geomWrappers.get(NasDialog.this.geomWrappers.size() - 1);
                boolean otherGeomWrapperSelected = false;
                for (GeomWrapper gw : NasDialog.this.geomWrappers) {
                    if (gw == lastEntry || !gw.isSelected()) continue;
                    otherGeomWrapperSelected = true;
                    break;
                }
                if (otherGeomWrapperSelected) {
                    lastEntry.setSelected(false);
                    NasDialog.this.totalMapWrapper.setSelected(false);
                    this.fireTableRowsUpdated(NasDialog.this.geomWrappers.size() - 1, NasDialog.this.geomWrappers.size() - 1);
                }
            }
            NasDialog.this.changeMap();
            NasDialog.this.calculateFee();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            if (columnIndex == 3) {
                return Color.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return NbBundle.getMessage(NasTableModel.class, (String)("NasDialog.NasTableModel.getColumnName(" + column + ")"));
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public GeomWrapper get(int index) {
            return (GeomWrapper)NasDialog.this.geomWrappers.get(index);
        }
    }

    private final class GeomWrapper {
        private boolean selected;
        private Color color;
        private Geometry geometry;
        private StyledFeature feature;
        private String name;

        public GeomWrapper(Geometry g, String name, boolean selected) {
            this.selected = selected;
            this.name = name;
            this.geometry = CrsTransformer.transformToGivenCrs((Geometry)g, (String)ClientAlkisConf.getInstance().getSrsService());
            this.feature = this.generateFeature();
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
            this.feature.setFillingPaint((Paint)this.color);
            this.feature.setLinePaint((Paint)this.color);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            DefaultStyledFeature bufferedFeature = (DefaultStyledFeature)NasDialog.this.bufferedFeatures.get(this);
            if (selected) {
                this.feature.setFillingPaint((Paint)FEATURE_COLOR_SELECTED);
                if (bufferedFeature != null) {
                    bufferedFeature.setFillingPaint((Paint)FEATURE_COLOR_SELECTED);
                }
            } else {
                this.feature.setFillingPaint((Paint)FEATURE_COLOR);
                if (bufferedFeature != null) {
                    bufferedFeature.setFillingPaint((Paint)FEATURE_COLOR);
                }
            }
            NasDialog.this.map.reconsiderFeature((Feature)this.feature);
            NasDialog.this.map.reconsiderFeature((Feature)bufferedFeature);
        }

        public Geometry getGeometry() {
            return this.geometry;
        }

        public void setGeometry(Geometry geometry) {
            this.geometry = geometry;
            this.feature = this.generateFeature();
        }

        public StyledFeature getFeature() {
            return this.feature;
        }

        public String getName() {
            return this.name;
        }

        private StyledFeature generateFeature() {
            DefaultStyledFeature dsf = new DefaultStyledFeature();
            dsf.setGeometry(this.geometry);
            if (this.selected) {
                dsf.setFillingPaint((Paint)FEATURE_COLOR_SELECTED);
            } else {
                dsf.setFillingPaint((Paint)FEATURE_COLOR);
            }
            return dsf;
        }
    }
}

