/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.billing.BillingProduct;
import de.cismet.cids.custom.wunda_blau.search.actions.NasZaehlObjekteServerAction;
import de.cismet.cids.custom.wunda_blau.search.server.CidsMeasurementPointSearchStatement;
import de.cismet.cids.custom.wunda_blau.search.server.NasPointSearch;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class NasFeeCalculator {
    private static final Logger LOG = Logger.getLogger(NasFeeCalculator.class);
    private static final String PG_POINTS = "eapkt_1000";
    private static final String PG_FLURSTUECK = "eaflst_1000";
    private static final String PG_EIGENTUEMER = "eaeig_1000";
    private static final String PG_GEBAEUDE = "eageb_1000";

    public static double getFeeForPoints(int amount, String productKey) {
        double basePrice = NasFeeCalculator.getPriceForProduct(productKey, PG_POINTS);
        return NasFeeCalculator.calculateFeeWithDiscount(amount, basePrice);
    }

    public static double getFeeForFlurstuecke(int amount, String productKey) {
        double basePrice = NasFeeCalculator.getPriceForProduct(productKey, PG_FLURSTUECK);
        return NasFeeCalculator.calculateFeeWithDiscount(amount, basePrice);
    }

    public static double getFeeForGebaeude(int amount, String productKey) {
        double basePrice = NasFeeCalculator.getPriceForProduct(productKey, PG_GEBAEUDE);
        return NasFeeCalculator.calculateFeeWithDiscount(amount, basePrice);
    }

    public static double getFeeForEigentuemer(int amount, String productKey) {
        double basePrice = NasFeeCalculator.getPriceForProduct(productKey, PG_EIGENTUEMER);
        return NasFeeCalculator.calculateFeeWithDiscount(amount, basePrice);
    }

    public static int getPointAmount(Geometry g, ConnectionContext connectionContext) throws ConnectionException {
        ArrayList<CidsMeasurementPointSearchStatement.Pointtype> pointtypes = new ArrayList<CidsMeasurementPointSearchStatement.Pointtype>();
        pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.AUFNAHMEPUNKTE);
        pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.SONSTIGE_VERMESSUNGSPUNKTE);
        pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.GRENZPUNKTE);
        pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.BESONDERE_GEBAEUDEPUNKTE);
        pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.BESONDERE_BAUWERKSPUNKTE);
        pointtypes.add(CidsMeasurementPointSearchStatement.Pointtype.BESONDERE_TOPOGRAPHISCHE_PUNKTE);
        NasPointSearch search = new NasPointSearch(null, pointtypes, null, g);
        ArrayList c = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, connectionContext);
        return (Integer)c.get(0);
    }

    public static int getFlurstueckAmount(Geometry g, ConnectionContext connectionContext) throws ConnectionException {
        return NasFeeCalculator.getAmount(NasZaehlObjekteServerAction.NasSearchType.FLURSTUECKE, g, connectionContext);
    }

    public static int getAmount(NasZaehlObjekteServerAction.NasSearchType searchType, Geometry geom, ConnectionContext connectionContext) throws ConnectionException {
        ServerActionParameter sapType = new ServerActionParameter(NasZaehlObjekteServerAction.Parameter.SEARCH_TYPE.toString(), (Object)searchType);
        ServerActionParameter sapGeom = new ServerActionParameter(NasZaehlObjekteServerAction.Parameter.GEOMETRY.toString(), (Object)geom);
        ArrayList c = (ArrayList)SessionManager.getProxy().executeTask("nasZaehlObjekte", "WUNDA_BLAU", null, connectionContext, new ServerActionParameter[]{sapType, sapGeom});
        return (Integer)c.get(0);
    }

    public static int getGebaeudeAmount(Geometry g, ConnectionContext connectionContext) throws ConnectionException {
        return NasFeeCalculator.getAmount(NasZaehlObjekteServerAction.NasSearchType.GEBAEUDE, g, connectionContext);
    }

    public static int getDachPunkteAmount(Geometry g, ConnectionContext connectionContext) throws ConnectionException {
        return NasFeeCalculator.getAmount(NasZaehlObjekteServerAction.NasSearchType.DACHPUNKTE, g, connectionContext);
    }

    public static int getBodenPunkteAmount(Geometry g, ConnectionContext connectionContext) throws ConnectionException {
        return NasFeeCalculator.getAmount(NasZaehlObjekteServerAction.NasSearchType.BODENPUNKTE, g, connectionContext);
    }

    private static double getPriceForProduct(String product, String productGroup) {
        HashMap<String, BillingProduct> products = BillingPopup.getProducts();
        Double d = 0.0;
        if (products == null) {
            LOG.warn((Object)"Could not get the list of billing products");
            return d;
        }
        BillingProduct p = products.get(product);
        if (p == null) {
            LOG.warn((Object)("Could not find an entry for the product " + product + " in the billing.json"));
            return d;
        }
        if (p.getPrices() != null && (d = (Double)p.getPrices().get(productGroup)) == null) {
            LOG.warn((Object)("Could not find a price for the product " + product + " and productGroup " + productGroup + " in the billing.json"));
            return 0.0;
        }
        return d;
    }

    private static double calculateFeeWithDiscount(int amount, double basePrice) {
        int tmpPoints;
        double fee = 0.0;
        if (amount > 1000000) {
            tmpPoints = amount - 1000000;
            fee += (double)tmpPoints * basePrice * 0.0625;
            amount = 1000000;
        }
        if (amount > 100000) {
            int tmpPpoints = amount - 100000;
            fee += (double)tmpPpoints * basePrice * 0.125;
            amount = 100000;
        }
        if (amount > 10000) {
            tmpPoints = amount - 10000;
            fee += (double)tmpPoints * basePrice * 0.25;
            amount = 10000;
        }
        if (amount > 1000) {
            tmpPoints = amount - 1000;
            fee += (double)tmpPoints * basePrice * 0.5;
            amount = 1000;
        }
        return fee += (double)amount * basePrice;
    }
}

