/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import de.cismet.cids.custom.nas.NASDownload;
import de.cismet.cids.custom.utils.nas.NasProductInfo;
import de.cismet.cids.custom.wunda_blau.search.actions.NasDataQueryAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.configuration.StartupHook;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class NasStartupHook
implements StartupHook,
ConnectionContextStore {
    private static final String SEVER_ACTION = "nasDataQuery";
    private final transient Logger log = Logger.getLogger(this.getClass());
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public void applicationStarted() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean hasNasAccess = false;
                try {
                    hasNasAccess = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csa://nasDataQuery", NasStartupHook.this.getConnectionContext());
                }
                catch (ConnectionException ex) {
                    NasStartupHook.this.log.error((Object)"Could not validate action tag for NAS!", (Throwable)ex);
                }
                if (hasNasAccess) {
                    ServerActionParameter paramMethod = new ServerActionParameter(NasDataQueryAction.PARAMETER_TYPE.METHOD.toString(), (Object)NasDataQueryAction.METHOD_TYPE.GET_ALL);
                    HashMap openOrderIds = null;
                    try {
                        openOrderIds = (HashMap)SessionManager.getProxy().executeTask(NasStartupHook.SEVER_ACTION, "WUNDA_BLAU", null, NasStartupHook.this.getConnectionContext(), new ServerActionParameter[]{paramMethod});
                    }
                    catch (Exception ex) {
                        NasStartupHook.this.log.error((Object)"error while getting the list of undelivered nas orders from server", (Throwable)ex);
                    }
                    if (openOrderIds == null || openOrderIds.isEmpty()) {
                        NasStartupHook.this.log.info((Object)"no pending nas orders found for the logged in user");
                        return;
                    }
                    StringBuilder logMessageBuilder = new StringBuilder();
                    for (String s : openOrderIds.keySet()) {
                        logMessageBuilder.append(s);
                        logMessageBuilder.append(",");
                    }
                    NasStartupHook.this.log.fatal((Object)("pending nas orders found: " + logMessageBuilder.toString()));
                    for (String orderId : openOrderIds.keySet()) {
                        NasProductInfo pInfo = (NasProductInfo)openOrderIds.get(orderId);
                        NASDownload download = new NASDownload(orderId, pInfo.isIsSplittet(), pInfo.isDxf(), pInfo.getRequestName(), NasStartupHook.this.getConnectionContext());
                        DownloadManager.instance().add((Download)download);
                    }
                }
            }
        }).start();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

