/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

public class WideComboBox
extends JComboBox {
    private boolean layingOut = false;

    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut) {
            dim.width = Math.max(dim.width, this.popupWider());
        }
        return dim;
    }

    protected int popupWider() {
        BasicComboPopup popup = (BasicComboPopup)this.getAccessibleContext().getAccessibleChild(0);
        JList<Object> list = popup.getList();
        Container c = SwingUtilities.getAncestorOfClass(JScrollPane.class, list);
        JScrollPane scrollPane = (JScrollPane)c;
        int popupWidth = list.getPreferredSize().width + 5 + this.getScrollBarWidth(scrollPane);
        Dimension scrollPaneSize = scrollPane.getPreferredSize();
        popupWidth = Math.max(popupWidth, scrollPaneSize.width);
        return popupWidth;
    }

    protected int getScrollBarWidth(JScrollPane scrollPane) {
        int scrollBarWidth = 0;
        if (this.getItemCount() > this.getMaximumRowCount()) {
            JScrollBar vertical = scrollPane.getVerticalScrollBar();
            scrollBarWidth = vertical.getPreferredSize().width;
        }
        return scrollBarWidth;
    }
}

