/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class BaumConfProperties {
    private static final transient Logger LOG = Logger.getLogger(BaumConfProperties.class);
    private final Double bufferMeter;
    private final String beschrPattern;
    private final String azPattern;
    private final String urlErsatzbaum;
    private final String urlFestsetzung;
    private final String urlSchaden;
    private final String urlDefault;
    private final String urlRasterfari;
    private final String ordnerDokumente;
    private final String ordnerFotos;
    private final String ordnerThema;

    private BaumConfProperties(Properties properties) {
        this.bufferMeter = Double.valueOf(this.readProperty(properties, "BUFFER_METER", null));
        this.beschrPattern = String.valueOf(this.readProperty(properties, "BESCHR__PATTERN", null));
        this.azPattern = String.valueOf(this.readProperty(properties, "AZ__PATTERN", null));
        this.urlErsatzbaum = String.valueOf(this.readProperty(properties, "MAP_CALL_STRING_ERSATZBAUM", null));
        this.urlFestsetzung = String.valueOf(this.readProperty(properties, "MAP_CALL_STRING_FESTSETZUNG", null));
        this.urlSchaden = String.valueOf(this.readProperty(properties, "MAP_CALL_STRING_SCHADEN", null));
        this.urlDefault = String.valueOf(this.readProperty(properties, "MAP_CALL_STRING_DEFAULT", null));
        this.urlRasterfari = String.valueOf(this.readProperty(properties, "RASTERFARI_URL", null));
        this.ordnerDokumente = String.valueOf(this.readProperty(properties, "ORDNER_DOKUMENTE", null));
        this.ordnerFotos = String.valueOf(this.readProperty(properties, "ORDNER_FOTOS", null));
        this.ordnerThema = String.valueOf(this.readProperty(properties, "ORDNER_THEMA", null));
    }

    private String readProperty(Properties properties, String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = properties.getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.BAUM_CONF_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public static BaumConfProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public Double getBufferMeter() {
        return this.bufferMeter;
    }

    public String getBeschrPattern() {
        return this.beschrPattern;
    }

    public String getAzPattern() {
        return this.azPattern;
    }

    public String getUrlErsatzbaum() {
        return this.urlErsatzbaum;
    }

    public String getUrlFestsetzung() {
        return this.urlFestsetzung;
    }

    public String getUrlSchaden() {
        return this.urlSchaden;
    }

    public String getUrlDefault() {
        return this.urlDefault;
    }

    public String getUrlRasterfari() {
        return this.urlRasterfari;
    }

    public String getOrdnerDokumente() {
        return this.ordnerDokumente;
    }

    public String getOrdnerFotos() {
        return this.ordnerFotos;
    }

    public String getOrdnerThema() {
        return this.ordnerThema;
    }

    private static final class LazyInitialiser {
        private static final BaumConfProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            BaumConfProperties instance = null;
            try {
                User user = SessionManager.getSession().getUser();
                Object ret = SessionManager.getSession().getConnection().executeTask(user, "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.BAUM_CONF_PROPERTIES.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)BaumConfProperties.class.getSimpleName()), new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                Properties properties = new Properties();
                properties.load(new StringReader((String)ret));
                instance = new BaumConfProperties(properties);
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim Laden der Properties f\u00fcr Baum-Client", (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

