/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.custom.objecteditors.wunda_blau.RasterfariControlPanel;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.BorderProvider;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.TitleComponentProvider;
import de.cismet.tools.gui.panels.AlertPanel;
import de.cismet.tools.gui.panels.LayeredAlertPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.util.NbBundle;

public abstract class AbstractVermessungEditor
extends JPanel
implements DisposableCidsBeanStore,
TitleComponentProvider,
FooterComponentProvider,
BorderProvider,
RequestsFullSizeComponent,
ConnectionContextStore,
RasterfariDocumentLoaderPanel.Listener {
    private static final Logger LOG = Logger.getLogger(AbstractVermessungEditor.class);
    protected static final Map<Integer, Color> COLORS_GEOMETRIE_STATUS = new HashMap<Integer, Color>();
    private static final ListModel MODEL_LOAD = new DefaultListModel(){
        {
            this.add(0, "Wird geladen...");
        }
    };
    private CidsBean cidsBean;
    private boolean readOnly;
    private String document;
    private AlertPanel alertPanel;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Box.Filler gluGapControls;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JXBusyLabel jxLBusyMeasure;
    private JLabel lblGeneralInformation;
    private JLabel lblHeaderControls;
    private JLabel lblHeaderDocument;
    private JLabel lblHeaderPages;
    private JLabel lblTitle;
    private JList lstPages;
    private LayeredAlertPanel measureComponentPanel;
    private JPanel panLeft;
    private JPanel panRight;
    private JPanel pnlBusy;
    private RoundedPanel pnlControls;
    private RoundedPanel pnlDocument;
    private RoundedPanel pnlGeneralInformation;
    private JPanel pnlGrenzniederschriftAlert;
    private SemiRoundedPanel pnlHeaderControls;
    private SemiRoundedPanel pnlHeaderDocument;
    private SemiRoundedPanel pnlHeaderGeneralInformation;
    private SemiRoundedPanel pnlHeaderPages;
    private JPanel pnlMeasureComp;
    private JPanel pnlMeasureComponentWrapper;
    private RoundedPanel pnlPages;
    private JPanel pnlTitle;
    private JPanel pnlUmleitungHeader;
    private RasterfariControlPanel rasterfariControlPanel1;
    private RasterfariDocumentLoaderPanel rasterfariDocumentLoaderPanel1;
    private JScrollPane scpPages;
    private Box.Filler strFooter;
    private JLabel warnMessage;

    protected AbstractVermessungEditor(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.document = null;
        this.initComponents();
        this.alertPanel = new AlertPanel(AlertPanel.TYPE.DANGER, (Component)this.warnMessage, true);
        this.initAlertPanel();
        this.rasterfariControlPanel1.initWithConnectionContext(connectionContext);
    }

    protected JPanel getGeneralInformationPanel() {
        return this.pnlGeneralInformation;
    }

    protected abstract JPanel getInformationPanel();

    private void initComponents() {
        this.strFooter = new Box.Filler(new Dimension(0, 22), new Dimension(0, 22), new Dimension(Short.MAX_VALUE, 22));
        this.pnlTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.pnlMeasureComponentWrapper = new JPanel();
        this.pnlBusy = new JPanel();
        this.jxLBusyMeasure = new JXBusyLabel(new Dimension(64, 64));
        this.pnlMeasureComp = new JPanel();
        this.rasterfariDocumentLoaderPanel1 = new RasterfariDocumentLoaderPanel(ClientAlkisConf.getInstance().getRasterfariUrl(), (RasterfariDocumentLoaderPanel.Listener)this, this.connectionContext);
        this.pnlGrenzniederschriftAlert = new JPanel();
        this.warnMessage = new JLabel();
        this.panLeft = new JPanel();
        this.pnlDocument = new RoundedPanel();
        this.pnlHeaderDocument = new SemiRoundedPanel();
        this.pnlUmleitungHeader = new JPanel();
        this.lblHeaderDocument = new JLabel();
        this.measureComponentPanel = new LayeredAlertPanel(this.pnlMeasureComponentWrapper, this.pnlGrenzniederschriftAlert);
        this.pnlGeneralInformation = new RoundedPanel();
        this.jPanel1 = this.getInformationPanel();
        this.pnlHeaderGeneralInformation = new SemiRoundedPanel();
        this.lblGeneralInformation = new JLabel();
        this.panRight = new JPanel();
        this.pnlPages = new RoundedPanel();
        this.pnlHeaderPages = new SemiRoundedPanel();
        this.lblHeaderPages = new JLabel();
        this.scpPages = new JScrollPane();
        this.lstPages = this.rasterfariDocumentLoaderPanel1.getLstPages();
        this.pnlControls = new RoundedPanel();
        this.pnlHeaderControls = new SemiRoundedPanel();
        this.lblHeaderControls = new JLabel();
        this.jPanel2 = new JPanel();
        this.rasterfariControlPanel1 = new RasterfariControlPanel(this.rasterfariDocumentLoaderPanel1, this.getVermessungName());
        this.gluGapControls = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.pnlTitle.setOpaque(false);
        this.pnlTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 14));
        this.lblTitle.setForeground(Color.white);
        this.lblTitle.setText(NbBundle.getMessage(AbstractVermessungEditor.class, (String)"AbstractVermessungEditor.lblTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.pnlMeasureComponentWrapper.setLayout(new CardLayout());
        this.pnlBusy.setBackground(new Color(254, 254, 254));
        this.pnlBusy.setBorder(BorderFactory.createEtchedBorder());
        this.pnlBusy.setLayout(new GridBagLayout());
        this.jxLBusyMeasure.setPreferredSize(new Dimension(64, 64));
        this.pnlBusy.add((Component)this.jxLBusyMeasure, new GridBagConstraints());
        this.pnlMeasureComponentWrapper.add((Component)this.pnlBusy, "busyCard");
        this.pnlMeasureComp.setLayout(new BorderLayout());
        this.pnlMeasureComp.add((Component)this.rasterfariDocumentLoaderPanel1, "Center");
        this.pnlMeasureComponentWrapper.add((Component)this.pnlMeasureComp, "measureCard");
        this.pnlGrenzniederschriftAlert.setBackground(new Color(254, 254, 254));
        this.pnlGrenzniederschriftAlert.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlGrenzniederschriftAlert.setLayout(new BorderLayout());
        this.warnMessage.setText(NbBundle.getMessage(AbstractVermessungEditor.class, (String)"AbstractVermessungEditor.warnMessage.text"));
        this.setLayout(new GridBagLayout());
        this.panLeft.setOpaque(false);
        this.panLeft.setLayout(new GridBagLayout());
        this.pnlHeaderDocument.setBackground(Color.darkGray);
        this.pnlHeaderDocument.setLayout((LayoutManager)new GridBagLayout());
        this.pnlUmleitungHeader.setOpaque(false);
        this.pnlUmleitungHeader.setLayout(new GridBagLayout());
        this.lblHeaderDocument.setForeground(Color.white);
        this.lblHeaderDocument.setText(this.getVermessungName());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlUmleitungHeader.add((Component)this.lblHeaderDocument, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.pnlHeaderDocument.add((Component)this.pnlUmleitungHeader, (Object)gridBagConstraints);
        this.pnlDocument.add((Component)this.pnlHeaderDocument, (Object)"North");
        this.measureComponentPanel.setPreferredSize(new Dimension(200, 200));
        this.pnlDocument.add((Component)this.measureComponentPanel, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.panLeft.add((Component)this.pnlDocument, gridBagConstraints);
        this.pnlGeneralInformation.setLayout((LayoutManager)new GridBagLayout());
        this.jPanel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlGeneralInformation.add((Component)this.jPanel1, (Object)gridBagConstraints);
        this.pnlHeaderGeneralInformation.setBackground(new Color(51, 51, 51));
        this.pnlHeaderGeneralInformation.setLayout((LayoutManager)new FlowLayout());
        this.lblGeneralInformation.setForeground(new Color(255, 255, 255));
        this.lblGeneralInformation.setText(NbBundle.getMessage(AbstractVermessungEditor.class, (String)"AbstractVermessungEditor.lblGeneralInformation.text"));
        this.pnlHeaderGeneralInformation.add((Component)this.lblGeneralInformation);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        this.pnlGeneralInformation.add((Component)this.pnlHeaderGeneralInformation, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.insets = new Insets(0, 0, 15, 5);
        this.panLeft.add((Component)this.pnlGeneralInformation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panLeft, gridBagConstraints);
        this.panRight.setOpaque(false);
        this.panRight.setLayout(new GridBagLayout());
        this.pnlHeaderPages.setBackground(new Color(51, 51, 51));
        this.pnlHeaderPages.setLayout((LayoutManager)new FlowLayout());
        this.lblHeaderPages.setForeground(new Color(255, 255, 255));
        this.lblHeaderPages.setText(NbBundle.getMessage(AbstractVermessungEditor.class, (String)"AbstractVermessungEditor.lblHeaderPages.text"));
        this.pnlHeaderPages.add((Component)this.lblHeaderPages);
        this.pnlPages.add((Component)this.pnlHeaderPages, (Object)"First");
        this.scpPages.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.scpPages.setMinimumSize(new Dimension(31, 75));
        this.scpPages.setOpaque(false);
        this.scpPages.setPreferredSize(new Dimension(85, 75));
        this.lstPages.setSelectionMode(0);
        this.lstPages.setFixedCellWidth(75);
        this.scpPages.setViewportView(this.lstPages);
        this.pnlPages.add((Component)this.scpPages, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.panRight.add((Component)this.pnlPages, gridBagConstraints);
        this.pnlHeaderControls.setBackground(new Color(51, 51, 51));
        this.pnlHeaderControls.setLayout((LayoutManager)new FlowLayout());
        this.lblHeaderControls.setForeground(new Color(255, 255, 255));
        this.lblHeaderControls.setText(NbBundle.getMessage(AbstractVermessungEditor.class, (String)"AbstractVermessungEditor.lblHeaderControls.text"));
        this.pnlHeaderControls.add((Component)this.lblHeaderControls);
        this.pnlControls.add((Component)this.pnlHeaderControls, (Object)"North");
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.rasterfariControlPanel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.rasterfariControlPanel1, gridBagConstraints);
        this.pnlControls.add((Component)this.jPanel2, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.panRight.add((Component)this.pnlControls, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panRight.add((Component)this.gluGapControls, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panRight, gridBagConstraints);
    }

    private void initAlertPanel() {
        this.warnMessage.setForeground(AlertPanel.dangerMessageColor);
        this.alertPanel.setContent((Component)this.warnMessage);
        this.alertPanel.repaint();
        this.alertPanel.setPreferredSize(new Dimension(500, 50));
        this.alertPanel.setCursor(Cursor.getPredefinedCursor(12));
        this.pnlGrenzniederschriftAlert.add((Component)this.alertPanel, "Center");
        this.pnlGrenzniederschriftAlert.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.8f));
        this.alertPanel.setVisible(false);
        this.alertPanel.addCloseButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractVermessungEditor.this.rasterfariDocumentLoaderPanel1.reset();
                        AbstractVermessungEditor.this.showAlert(true);
                        AbstractVermessungEditor.this.pnlMeasureComponentWrapper.invalidate();
                        AbstractVermessungEditor.this.pnlMeasureComponentWrapper.revalidate();
                        AbstractVermessungEditor.this.pnlMeasureComponentWrapper.repaint();
                    }
                });
            }
        });
    }

    public void showMeasureIsLoading() {
        this.jxLBusyMeasure.setBusy(true);
        CardLayout cl = (CardLayout)this.pnlMeasureComponentWrapper.getLayout();
        cl.show(this.pnlMeasureComponentWrapper, "busyCard");
    }

    public void showMeasurePanel() {
        this.jxLBusyMeasure.setBusy(false);
        CardLayout cl = (CardLayout)this.pnlMeasureComponentWrapper.getLayout();
        cl.show(this.pnlMeasureComponentWrapper, "measureCard");
    }

    private void showAlert(boolean show) {
        if (!this.readOnly) {
            this.alertPanel.setType(AlertPanel.TYPE.DANGER);
            this.alertPanel.setContent((Component)this.warnMessage);
            this.alertPanel.setVisible(show);
            this.alertPanel.repaint();
        }
    }

    protected abstract String getDocumentFilename();

    private void checkLinkInTitle() {
        this.checkLinkInTitle(this.document);
    }

    private void checkLinkInTitle(String document) {
        String filename;
        boolean isUmleitung = false;
        if (document != null && !document.contains(filename = this.getDocumentFilename())) {
            isUmleitung = true;
            this.pnlHeaderDocument.repaint();
        }
        if (!this.readOnly && isUmleitung) {
            this.lblHeaderDocument.setText(String.format("Umleitung auf %s:", this.getVermessungName()));
        } else {
            this.lblHeaderDocument.setText(this.getVermessungName());
        }
    }

    public void successAlert() {
        this.rasterfariDocumentLoaderPanel1.setCurrentPageNull();
        this.alertPanel.setType(AlertPanel.TYPE.SUCCESS);
        this.pnlMeasureComponentWrapper.invalidate();
        this.pnlMeasureComponentWrapper.validate();
        this.pnlMeasureComponentWrapper.repaint();
    }

    public void handleNoDocumentFound() {
        this.alertPanel.setType(AlertPanel.TYPE.DANGER);
        this.rasterfariDocumentLoaderPanel1.removeAllFeatures();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            this.lblTitle.setText(this.generateTitle());
        }
        this.setCurrentDocumentNull();
        new RefreshDocumentWorker().execute();
    }

    protected abstract String getVermessungName();

    public void dispose() {
        this.rasterfariDocumentLoaderPanel1.dispose();
    }

    public JComponent getTitleComponent() {
        return this.pnlTitle;
    }

    public JComponent getFooterComponent() {
        return this.strFooter;
    }

    public Border getTitleBorder() {
        return new EmptyBorder(10, 10, 10, 10);
    }

    public Border getFooterBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public Border getCenterrBorder() {
        return new EmptyBorder(0, 5, 0, 5);
    }

    protected abstract String generateTitle();

    protected Integer getGemarkungOfCurrentCidsBean() {
        Object gemarkung;
        Integer result = -1;
        if (this.cidsBean != null && this.cidsBean.getProperty("gemarkung") != null && (gemarkung = this.cidsBean.getProperty("gemarkung.id")) instanceof Integer) {
            result = (Integer)gemarkung;
        }
        return result;
    }

    protected void loadDokument() {
        this.showMeasureIsLoading();
        this.checkLinkInTitle();
        this.showAlert(false);
        this.rasterfariDocumentLoaderPanel1.setDocument(this.document);
    }

    protected void setCurrentDocumentNull() {
        this.rasterfariDocumentLoaderPanel1.setCurrentPageNull();
    }

    public void warnAlert() {
        this.rasterfariDocumentLoaderPanel1.setCurrentPageNull();
        this.alertPanel.setType(AlertPanel.TYPE.WARNING);
        this.pnlMeasureComponentWrapper.invalidate();
        this.pnlMeasureComponentWrapper.validate();
        this.pnlMeasureComponentWrapper.repaint();
    }

    public void handleDocumentDoesNotExists() {
        this.rasterfariDocumentLoaderPanel1.setCurrentPageNull();
        this.alertPanel.setType(AlertPanel.TYPE.DANGER);
        this.pnlMeasureComponentWrapper.invalidate();
        this.pnlMeasureComponentWrapper.validate();
        this.pnlMeasureComponentWrapper.repaint();
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    protected abstract String findPicture();

    static {
        COLORS_GEOMETRIE_STATUS.put(new Integer(1), Color.green);
        COLORS_GEOMETRIE_STATUS.put(new Integer(2), Color.yellow);
        COLORS_GEOMETRIE_STATUS.put(new Integer(3), Color.yellow);
        COLORS_GEOMETRIE_STATUS.put(new Integer(4), Color.red);
        COLORS_GEOMETRIE_STATUS.put(new Integer(5), Color.red);
        COLORS_GEOMETRIE_STATUS.put(new Integer(6), Color.green);
    }

    protected class GeometrieStatusRenderer
    implements ListCellRenderer {
        private final ListCellRenderer originalRenderer;

        public GeometrieStatusRenderer(ListCellRenderer originalRenderer) {
            this.originalRenderer = originalRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = this.originalRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (isSelected) {
                result.setBackground(list.getSelectionBackground());
                result.setForeground(list.getSelectionForeground());
            } else {
                CidsBean geometrieStatus;
                result.setBackground(list.getBackground());
                result.setForeground(list.getForeground());
                if (value instanceof CidsBean && (geometrieStatus = (CidsBean)value).getProperty("id") instanceof Integer) {
                    result.setBackground(COLORS_GEOMETRIE_STATUS.get((Integer)geometrieStatus.getProperty("id")));
                }
            }
            return result;
        }
    }

    protected final class RefreshDocumentWorker
    extends SwingWorker<String, Object> {
        boolean refreshMeasuringComponent;

        public RefreshDocumentWorker() {
            this(true);
        }

        public RefreshDocumentWorker(boolean refreshMeasuringComponent) {
            this.refreshMeasuringComponent = refreshMeasuringComponent;
            if (this.refreshMeasuringComponent) {
                AbstractVermessungEditor.this.lstPages.setModel(MODEL_LOAD);
                AbstractVermessungEditor.this.showMeasureIsLoading();
            }
        }

        @Override
        protected String doInBackground() throws Exception {
            return AbstractVermessungEditor.this.findPicture();
        }

        @Override
        protected void done() {
            try {
                if (!this.isCancelled()) {
                    String current = (String)this.get();
                    AbstractVermessungEditor.this.document = current;
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)"Was interrupted while refreshing document.", (Throwable)ex);
            }
            catch (Exception ex) {
                LOG.warn((Object)"There was an exception while refreshing document.", (Throwable)ex);
            }
            finally {
                if (this.refreshMeasuringComponent) {
                    AbstractVermessungEditor.this.loadDokument();
                }
            }
        }
    }
}

