/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.custom.objecteditors.utils.AlConfProperties;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableDateChooser;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.util.Exceptions;

public class AlLuftbildEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
RequestsFullSizeComponent,
RasterfariDocumentLoaderPanel.Listener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(AlLuftbildEditor.class);
    public static final String FIELD__NAME = "dateiname";
    public static final String FIELD__GEOREFERENZ = "fk_geom";
    public static final String FIELD__GEO_FIELD = "geo_field";
    public static final String FIELD__GEOREFERENZ__GEO_FIELD = "fk_geom.geo_field";
    public static final String TABLE_NAME = "al_luftbild";
    public static final String TABLE_GEOM = "geom";
    private ConnectionContext connectionContext;
    private final boolean editor;
    private DefaultBindableReferenceCombo cbKategorie;
    JCheckBox chInnerhalb;
    DefaultBindableDateChooser dcDatum;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JXBusyLabel jxLBusy;
    private JLabel lblBemerkung;
    private JLabel lblBild;
    private JLabel lblBildname;
    private JLabel lblDatum;
    private JLabel lblFlug;
    private JLabel lblInnerhalb;
    private JLabel lblKarte;
    private JLabel lblKategorie;
    private JLabel lblKeineFotos;
    private JPanel panContent;
    private JPanel panFillerUnten;
    private JPanel panGeometrie;
    private JPanel panLage;
    private JPanel panName;
    private DefaultPreviewMapPanel panPreviewMap;
    private JPanel pnlBild;
    private RasterfariDocumentLoaderPanel rasterfariDocumentLoaderPanel;
    private RoundedPanel rpBild;
    private RoundedPanel rpKarte;
    private JScrollPane scpBemerkung;
    private SemiRoundedPanel semiRoundedPanel7;
    private SemiRoundedPanel semiRoundedPanel8;
    JTextArea taBemerkung;
    private JTextField txtBildname;
    private JTextField txtFlug;
    private BindingGroup bindingGroup;

    public AlLuftbildEditor() {
        this(true);
    }

    public AlLuftbildEditor(boolean boolEditor) {
        this.editor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.panName = new JPanel();
        this.lblBildname = new JLabel();
        this.lblFlug = new JLabel();
        this.txtFlug = new JTextField();
        this.lblDatum = new JLabel();
        this.cbKategorie = new DefaultBindableReferenceCombo();
        this.txtBildname = new JTextField();
        this.lblKategorie = new JLabel();
        this.lblInnerhalb = new JLabel();
        this.chInnerhalb = new JCheckBox();
        this.lblBemerkung = new JLabel();
        this.scpBemerkung = new JScrollPane();
        this.taBemerkung = new JTextArea();
        this.dcDatum = new DefaultBindableDateChooser();
        this.panGeometrie = new JPanel();
        this.panLage = new JPanel();
        this.rpKarte = new RoundedPanel();
        this.panPreviewMap = new DefaultPreviewMapPanel();
        this.semiRoundedPanel7 = new SemiRoundedPanel();
        this.lblKarte = new JLabel();
        this.pnlBild = new JPanel();
        this.jPanel1 = new JPanel();
        this.rpBild = new RoundedPanel();
        this.semiRoundedPanel8 = new SemiRoundedPanel();
        this.lblBild = new JLabel();
        this.rasterfariDocumentLoaderPanel = new RasterfariDocumentLoaderPanel(AlConfProperties.getInstance().getRasterfariUrl(), (RasterfariDocumentLoaderPanel.Listener)this, this.connectionContext);
        this.jPanel2 = new JPanel();
        this.jxLBusy = new JXBusyLabel(new Dimension(64, 64));
        this.jPanel3 = new JPanel();
        this.lblKeineFotos = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(600, 646));
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setAutoscrolls(true);
        this.panContent.setMinimumSize(new Dimension(450, 488));
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setLayout(new GridBagLayout());
        this.panName.setMaximumSize(new Dimension(350, Integer.MAX_VALUE));
        this.panName.setName("");
        this.panName.setOpaque(false);
        this.panName.setLayout(new GridBagLayout());
        this.lblBildname.setFont(new Font("Tahoma", 1, 11));
        this.lblBildname.setText("Bildname:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblBildname, gridBagConstraints);
        this.lblFlug.setFont(new Font("Tahoma", 1, 11));
        this.lblFlug.setText("Flugnummer:");
        this.lblFlug.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblFlug, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.flugnummer}"), (Object)this.txtFlug, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtFlug, gridBagConstraints);
        this.lblDatum.setFont(new Font("Tahoma", 1, 11));
        this.lblDatum.setText("Datum:");
        this.lblDatum.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblDatum, gridBagConstraints);
        this.cbKategorie.setFont(new Font("Dialog", 0, 12));
        this.cbKategorie.setMaximumRowCount(20);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.fk_kategorie}"), (Object)this.cbKategorie, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.cbKategorie, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.dateiname}"), (Object)this.txtBildname, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtBildname, gridBagConstraints);
        this.lblKategorie.setFont(new Font("Tahoma", 1, 11));
        this.lblKategorie.setText("Kategorie:");
        this.lblKategorie.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblKategorie, gridBagConstraints);
        this.lblInnerhalb.setFont(new Font("Tahoma", 1, 11));
        this.lblInnerhalb.setText("Innerhalb:");
        this.lblInnerhalb.setToolTipText("");
        this.lblInnerhalb.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblInnerhalb, gridBagConstraints);
        this.chInnerhalb.setContentAreaFilled(false);
        this.chInnerhalb.setEnabled(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.innerhalb}"), (Object)this.chInnerhalb, (Property)BeanProperty.create((String)"selected"));
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.chInnerhalb, gridBagConstraints);
        this.lblBemerkung.setFont(new Font("Tahoma", 1, 11));
        this.lblBemerkung.setText("Bemerkung:");
        this.lblBemerkung.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panName.add((Component)this.lblBemerkung, gridBagConstraints);
        this.scpBemerkung.setOpaque(false);
        this.taBemerkung.setLineWrap(true);
        this.taBemerkung.setRows(2);
        this.taBemerkung.setWrapStyleWord(true);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.bemerkung}"), (Object)this.taBemerkung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scpBemerkung.setViewportView(this.taBemerkung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.panName.add((Component)this.scpBemerkung, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.datum}"), (Object)this.dcDatum, (Property)BeanProperty.create((String)"date"));
        binding.setConverter(this.dcDatum.getConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.dcDatum, gridBagConstraints);
        this.panGeometrie.setOpaque(false);
        this.panGeometrie.setLayout(new GridBagLayout());
        this.panLage.setOpaque(false);
        this.panLage.setLayout(new GridBagLayout());
        this.rpKarte.setName("");
        this.rpKarte.setLayout((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.rpKarte.add((Component)this.panPreviewMap, (Object)gridBagConstraints);
        this.semiRoundedPanel7.setBackground(Color.darkGray);
        this.semiRoundedPanel7.setLayout((LayoutManager)new GridBagLayout());
        this.lblKarte.setForeground(new Color(255, 255, 255));
        this.lblKarte.setText("Lage");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.semiRoundedPanel7.add((Component)this.lblKarte, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.rpKarte.add((Component)this.semiRoundedPanel7, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panLage.add((Component)this.rpKarte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.panGeometrie.add((Component)this.panLage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 5, 2);
        this.panName.add((Component)this.panGeometrie, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panContent.add((Component)this.panName, gridBagConstraints);
        this.pnlBild.setOpaque(false);
        this.pnlBild.setLayout(new CardLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.rpBild.setName("");
        this.rpBild.setLayout((LayoutManager)new GridBagLayout());
        this.semiRoundedPanel8.setBackground(Color.darkGray);
        this.semiRoundedPanel8.setLayout((LayoutManager)new GridBagLayout());
        this.lblBild.setForeground(new Color(255, 255, 255));
        this.lblBild.setText("Luftbild");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.semiRoundedPanel8.add((Component)this.lblBild, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.rpBild.add((Component)this.semiRoundedPanel8, (Object)gridBagConstraints);
        this.rasterfariDocumentLoaderPanel.setMinimumSize(new Dimension(0, 500));
        this.rasterfariDocumentLoaderPanel.setPreferredSize(new Dimension(0, 500));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.rpBild.add((Component)this.rasterfariDocumentLoaderPanel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.jPanel1.add((Component)this.rpBild, gridBagConstraints);
        this.pnlBild.add((Component)this.jPanel1, "DOCUMENT");
        this.jPanel2.setLayout(new BorderLayout());
        this.jxLBusy.setHorizontalAlignment(0);
        this.jxLBusy.setPreferredSize(new Dimension(64, 64));
        this.jPanel2.add((Component)this.jxLBusy, "Center");
        this.pnlBild.add((Component)this.jPanel2, "BUSY");
        this.jPanel3.setLayout(new BorderLayout());
        this.lblKeineFotos.setHorizontalAlignment(0);
        this.lblKeineFotos.setText("F\u00fcr dieses Gebiet sind beim n\u00e4chtlichen Abgleich keine Fotos vorhanden gewesen.");
        this.jPanel3.add((Component)this.lblKeineFotos, "Center");
        this.pnlBild.add((Component)this.jPanel3, "NO_DOCUMENT");
        this.jPanel4.setLayout(new BorderLayout());
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Das Foto f\u00fcr dieses Gebiet kann nicht geladen werden.");
        this.jPanel4.add((Component)this.jLabel2, "Center");
        this.pnlBild.add((Component)this.jPanel4, "ERROR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.insets = new Insets(5, 5, 12, 5);
        this.panContent.add((Component)this.pnlBild, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void loadTheImage() {
        String name = (String)this.getCidsBean().getProperty(FIELD__NAME);
        if (name != null) {
            try {
                String path = "lanuv/Wuppertal_Tif";
                String document = path + "/" + name;
                this.rasterfariDocumentLoaderPanel.setDocument(document);
                URL uRL = this.rasterfariDocumentLoaderPanel.getDocumentUrl();
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    public void setCidsBean(CidsBean cb) {
        try {
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            if (cb != null) {
                DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
            }
            this.setMapWindow();
            this.bindingGroup.bind();
            this.loadTheImage();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Error setCidsBean.", (Throwable)ex);
        }
    }

    private boolean isEditor() {
        return this.editor;
    }

    public void setMapWindow() {
        CidsBean cb = this.getCidsBean();
        try {
            Double bufferMeter = AlConfProperties.getInstance().getBufferMeter();
            String mapUrl = AlConfProperties.getInstance().getMapUrl();
            if (cb.getProperty(FIELD__GEOREFERENZ) != null) {
                this.panPreviewMap.initMap(cb, FIELD__GEOREFERENZ__GEO_FIELD, bufferMeter, mapUrl);
            } else {
                int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode());
                BoundingBox initialBoundingBox = CismapBroker.getInstance().getMappingComponent().getMappingModel().getInitialBoundingBox();
                Point centerPoint = initialBoundingBox.getGeometry(srid).getCentroid();
                MetaClass geomMetaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)TABLE_GEOM, (ConnectionContext)this.getConnectionContext());
                CidsBean newGeom = geomMetaClass.getEmptyInstance(this.getConnectionContext()).getBean();
                newGeom.setProperty(FIELD__GEO_FIELD, (Object)centerPoint);
                this.panPreviewMap.initMap(newGeom, FIELD__GEO_FIELD, bufferMeter);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            LOG.warn((Object)"Map window not set.", (Throwable)ex);
        }
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            RendererTools.makeReadOnly((JComponent)this.cbKategorie);
            RendererTools.makeReadOnly(this.taBemerkung);
            RendererTools.makeReadOnly(this.chInnerhalb);
        }
        RendererTools.makeReadOnly(this.txtBildname);
        RendererTools.makeReadOnly(this.txtFlug);
        RendererTools.makeReadOnly((JComponent)this.dcDatum);
    }

    public String getTitle() {
        return this.getCidsBean().toString();
    }

    public void setTitle(String string) {
    }

    public void showMeasureIsLoading() {
        this.showDocumentCard(DocumentCard.BUSY);
    }

    public void dispose() {
        this.panPreviewMap.dispose();
        this.rasterfariDocumentLoaderPanel.dispose();
        this.bindingGroup.unbind();
        super.dispose();
    }

    private void showDocumentCard(DocumentCard card) {
        ((CardLayout)this.pnlBild.getLayout()).show(this.pnlBild, card.toString());
    }

    public void showMeasurePanel() {
        this.showDocumentCard(DocumentCard.DOCUMENT);
    }

    private static enum DocumentCard {
        BUSY,
        DOCUMENT,
        NO_DOCUMENT,
        ERROR;

    }
}

