/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.clientutils.ByteArrayActionDownload;
import de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheArbeitsstandPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheBemerkungenPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMassnahmenPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboPicturePanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.albo.SimpleAltlastWebDavPanel;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.wunda_blau.search.server.AlboFlaecheLandesRegNrSearch;
import de.cismet.cids.custom.wunda_blau.search.server.AlboFlaecheNummerUniqueSearch;
import de.cismet.cids.custom.wunda_blau.search.server.AlboTeilflaecheSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.BeanInitializer;
import de.cismet.cids.editors.BeanInitializerProvider;
import de.cismet.cids.editors.DefaultBeanInitializer;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.editors.hooks.AfterSavingHook;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.BorderProvider;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.TitleComponentProvider;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class AlboFlaecheEditor
extends JPanel
implements CidsBeanRenderer,
DisposableCidsBeanStore,
TitleComponentProvider,
FooterComponentProvider,
BorderProvider,
RequestsFullSizeComponent,
EditorSaveListener,
ConnectionContextStore,
PropertyChangeListener,
SaveVetoable,
AfterSavingHook,
BeanInitializerProvider {
    private static final Logger LOG = Logger.getLogger(AlboFlaecheEditor.class);
    public static Converter<String, String> DATE_TO_STRING = null;
    private final boolean editable;
    private CidsBean cidsBean;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private CardLayout cardLayout;
    private AlboPicturePanel alboPicturePanel1;
    private JButton btnBack;
    private JButton btnForward;
    JButton btnLandRegNr;
    JButton btnReport1;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JToggleButton jToggleButton1;
    private JLabel lblTitle;
    private AlboFlaecheArbeitsstandPanel panArbeitsstand;
    private AlboFlaecheBemerkungenPanel panBemerkungen;
    private JPanel panButtons;
    private JPanel panCardArbeitsstandUndBemerkungen;
    private JPanel panCardFlaeche;
    private JPanel panCardMassnahmen;
    private JPanel panFooter;
    private AlboFlaecheMainPanel panMain;
    private JPanel panMainCard;
    private AlboFlaecheMassnahmenPanel panMassnahmen;
    private JPanel panTitle;
    private SimpleAltlastWebDavPanel simpleAltlastWebDavPanel1;
    private BindingGroup bindingGroup;

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        this.btnLandRegNr = new JButton();
        this.btnReport1 = new JButton();
        this.panFooter = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.btnBack = new JButton();
        this.panButtons = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.btnForward = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.panMainCard = new JPanel();
        this.panCardFlaeche = new JPanel();
        this.panMain = new AlboFlaecheMainPanel(this.isEditable());
        this.panCardArbeitsstandUndBemerkungen = new JPanel();
        this.panBemerkungen = new AlboFlaecheBemerkungenPanel(this.isEditable());
        this.panArbeitsstand = new AlboFlaecheArbeitsstandPanel(this.isEditable());
        this.alboPicturePanel1 = new AlboPicturePanel(this.isEditable());
        this.simpleAltlastWebDavPanel1 = new SimpleAltlastWebDavPanel(this.isEditable());
        this.panCardMassnahmen = new JPanel();
        this.panMassnahmen = new AlboFlaecheMassnahmenPanel(this.isEditable());
        FormListener formListener = new FormListener();
        this.panTitle.setName("panTitle");
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setName("lblTitle");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"<html><body><h2><nobr>Altlastenkataster - Erhebungsnummer: ${cidsBean.erhebungsnummer}"), (Object)this.lblTitle, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"<html><body><h2><nobr>Altlastenkataster - Erhebungsnummer: -");
        binding.setSourceUnreadableValue((Object)"<html><body><h2><nobr>Altlastenkataster - Erhebungsnummer: <i>[Fehler]");
        this.bindingGroup.addBinding((Binding)binding);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.jToggleButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/lock.png")));
        this.jToggleButton1.setBorderPainted(false);
        this.jToggleButton1.setContentAreaFilled(false);
        this.jToggleButton1.setFocusPainted(false);
        this.jToggleButton1.setName("jToggleButton1");
        this.jToggleButton1.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/lock_edit.png")));
        this.jToggleButton1.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/lock_go.png")));
        this.jToggleButton1.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/lock_open.png")));
        this.jToggleButton1.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.panTitle.add((Component)this.jToggleButton1, gridBagConstraints);
        this.jToggleButton1.setVisible(this.isEditable());
        this.btnLandRegNr.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit-add.png")));
        this.btnLandRegNr.setToolTipText(NbBundle.getMessage(AlboFlaecheEditor.class, (String)"AlboFlaecheEditor.btnLandRegNr.toolTipText"));
        this.btnLandRegNr.setBorderPainted(false);
        this.btnLandRegNr.setContentAreaFilled(false);
        this.btnLandRegNr.setFocusPainted(false);
        this.btnLandRegNr.setName("btnLandRegNr");
        this.btnLandRegNr.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panTitle.add((Component)this.btnLandRegNr, gridBagConstraints);
        this.btnLandRegNr.setVisible(this.isEditable());
        this.btnReport1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/icons/table_export.png")));
        this.btnReport1.setToolTipText(NbBundle.getMessage(AlboFlaecheEditor.class, (String)"AlboFlaecheEditorEditor.btnReport.toolTipText"));
        this.btnReport1.setBorderPainted(false);
        this.btnReport1.setContentAreaFilled(false);
        this.btnReport1.setFocusPainted(false);
        this.btnReport1.setName("btnReport1");
        this.btnReport1.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panTitle.add((Component)this.btnReport1, gridBagConstraints);
        this.panFooter.setName("panFooter");
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new GridBagLayout());
        this.filler1.setName("filler1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panFooter.add((Component)this.filler1, gridBagConstraints);
        this.btnBack.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left.png")));
        this.btnBack.setBorder(null);
        this.btnBack.setBorderPainted(false);
        this.btnBack.setContentAreaFilled(false);
        this.btnBack.setEnabled(false);
        this.btnBack.setFocusPainted(false);
        this.btnBack.setMaximumSize(new Dimension(30, 30));
        this.btnBack.setMinimumSize(new Dimension(30, 30));
        this.btnBack.setName("btnBack");
        this.btnBack.setPreferredSize(new Dimension(30, 30));
        this.btnBack.setPressedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left-pressed.png")));
        this.btnBack.setRolloverIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left-sel.png")));
        this.btnBack.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panFooter.add((Component)this.btnBack, gridBagConstraints);
        this.panButtons.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.panButtons.setName("panButtons");
        this.panButtons.setOpaque(false);
        this.panButtons.setLayout(new GridLayout(1, 0, 10, 0));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("<html><body><center><b><h3>Fl\u00e4che");
        this.jLabel1.setName("jLabel1");
        this.jLabel1.addMouseListener(formListener);
        this.panButtons.add(this.jLabel1);
        this.jLabel2.setForeground(new Color(255, 255, 255));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("<html><body><center><b><h3>Arbeitsstand & Bemerkung");
        this.jLabel2.setEnabled(false);
        this.jLabel2.setName("jLabel2");
        this.jLabel2.addMouseListener(formListener);
        this.panButtons.add(this.jLabel2);
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("<html><body><center><b><h3>Ma\u00dfnahmen");
        this.jLabel3.setEnabled(false);
        this.jLabel3.setName("jLabel3");
        this.jLabel3.addMouseListener(formListener);
        this.panButtons.add(this.jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.panFooter.add((Component)this.panButtons, gridBagConstraints);
        this.btnForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-right.png")));
        this.btnForward.setBorder(null);
        this.btnForward.setBorderPainted(false);
        this.btnForward.setContentAreaFilled(false);
        this.btnForward.setFocusPainted(false);
        this.btnForward.setMaximumSize(new Dimension(30, 30));
        this.btnForward.setMinimumSize(new Dimension(30, 30));
        this.btnForward.setName("btnForward");
        this.btnForward.setPreferredSize(new Dimension(30, 30));
        this.btnForward.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.panFooter.add((Component)this.btnForward, gridBagConstraints);
        this.filler2.setName("filler2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panFooter.add((Component)this.filler2, gridBagConstraints);
        this.setName("Form");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.panMainCard.setName("panMainCard");
        this.panMainCard.setOpaque(false);
        this.panMainCard.setLayout(new CardLayout());
        this.panCardFlaeche.setName("panCardFlaeche");
        this.panCardFlaeche.setOpaque(false);
        this.panCardFlaeche.setLayout(new BorderLayout());
        this.panMain.setName("panMain");
        this.panCardFlaeche.add((Component)this.panMain, "Center");
        this.panMainCard.add((Component)this.panCardFlaeche, "flaeche");
        this.panCardArbeitsstandUndBemerkungen.setName("panCardArbeitsstandUndBemerkungen");
        this.panCardArbeitsstandUndBemerkungen.setOpaque(false);
        this.panCardArbeitsstandUndBemerkungen.setLayout(new GridBagLayout());
        this.panBemerkungen.setName("panBemerkungen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panCardArbeitsstandUndBemerkungen.add((Component)this.panBemerkungen, gridBagConstraints);
        this.panArbeitsstand.setName("panArbeitsstand");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panCardArbeitsstandUndBemerkungen.add((Component)this.panArbeitsstand, gridBagConstraints);
        this.alboPicturePanel1.setName("alboPicturePanel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panCardArbeitsstandUndBemerkungen.add((Component)this.alboPicturePanel1, gridBagConstraints);
        this.simpleAltlastWebDavPanel1.setName("simpleAltlastWebDavPanel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 5);
        this.panCardArbeitsstandUndBemerkungen.add((Component)this.simpleAltlastWebDavPanel1, gridBagConstraints);
        this.panMainCard.add((Component)this.panCardArbeitsstandUndBemerkungen, "arbeitsstand");
        this.panCardMassnahmen.setName("panCardMassnahmen");
        this.panCardMassnahmen.setOpaque(false);
        this.panCardMassnahmen.setLayout(new BorderLayout());
        this.panMassnahmen.setName("panMassnahmen");
        this.panCardMassnahmen.add((Component)this.panMassnahmen, "Center");
        this.panMainCard.add((Component)this.panCardMassnahmen, "massnahmen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.panMainCard, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public AlboFlaecheEditor() {
        this(true);
    }

    public AlboFlaecheEditor(boolean editable) {
        this.editable = editable;
    }

    public final void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.initComponents();
        this.panMain.initWithConnectionContext(connectionContext);
        this.panArbeitsstand.initWithConnectionContext(connectionContext);
        this.panMassnahmen.initWithConnectionContext(connectionContext);
        this.panBemerkungen.initWithConnectionContext(connectionContext);
        this.simpleAltlastWebDavPanel1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object selectedObject = ((JList)e.getSource()).getSelectedValue();
                if (selectedObject instanceof CidsBean) {
                    AlboFlaecheEditor.this.alboPicturePanel1.setWebDavHelper(AlboFlaecheEditor.this.simpleAltlastWebDavPanel1.getWebdavHelper());
                    AlboFlaecheEditor.this.alboPicturePanel1.setCidsBean((CidsBean)selectedObject);
                }
            }
        });
        this.cardLayout = (CardLayout)this.panMainCard.getLayout();
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        try {
            this.bindingGroup.unbind();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.editable && this.cidsBean != null) {
            this.cidsBean.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (cidsBean != null) {
            if (this.isEditable() && cidsBean.getProperty("fk_massnahmen") == null) {
                try {
                    cidsBean.setProperty("fk_massnahmen", (Object)CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"ALBO_MASSNAHMEN", (ConnectionContext)this.getConnectionContext()).getEmptyInstance(this.getConnectionContext()).getBean());
                }
                catch (Exception ex) {
                    LOG.fatal((Object)ex, (Throwable)ex);
                }
            }
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cidsBean, (ConnectionContext)this.getConnectionContext());
            this.cidsBean = cidsBean;
            this.bindingGroup.bind();
        }
        this.panMain.setCidsBean(cidsBean);
        this.panArbeitsstand.setCidsBean(cidsBean);
        this.panBemerkungen.setCidsBean(cidsBean);
        this.panMassnahmen.setCidsBean((CidsBean)cidsBean.getProperty("fk_massnahmen"));
        if (this.editable && this.cidsBean != null) {
            this.cidsBean.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.updateTitleControls();
        this.updateFooterControls();
        this.simpleAltlastWebDavPanel1.setCidsBean(cidsBean);
    }

    private void updateTitleControls() {
        this.btnLandRegNr.setVisible(this.jToggleButton1.isSelected());
        if (this.cidsBean.getProperty("geodaten_id") == null || this.cidsBean.getProperty("geodaten_id").equals("")) {
            this.btnLandRegNr.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit-add.png")));
            this.btnLandRegNr.setToolTipText(NbBundle.getMessage(AlboFlaecheEditor.class, (String)"AlboFlaecheEditor.btnLandRegNr.toolTipText"));
        } else {
            this.btnLandRegNr.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit-delete.png")));
            this.btnLandRegNr.setToolTipText(NbBundle.getMessage(AlboFlaecheEditor.class, (String)"AlboFlaecheEditor.btnLandRegNr.toolTipText.remove"));
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    private void btnBackActionPerformed(ActionEvent evt) {
        this.cardLayout.previous(this.panMainCard);
        this.updateFooterControls();
    }

    private void btnForwardActionPerformed(ActionEvent evt) {
        this.cardLayout.next(this.panMainCard);
        this.updateFooterControls();
    }

    private void jLabel1MouseClicked(MouseEvent evt) {
        this.cardLayout.show(this.panMainCard, "flaeche");
        this.updateFooterControls();
    }

    private void jLabel2MouseClicked(MouseEvent evt) {
        this.cardLayout.show(this.panMainCard, "arbeitsstand");
        this.updateFooterControls();
    }

    private void jLabel3MouseClicked(MouseEvent evt) {
        this.cardLayout.show(this.panMainCard, "massnahmen");
        this.updateFooterControls();
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        if (this.isEditable()) {
            this.panMain.setUnlocked(this.jToggleButton1.isSelected());
            this.updateTitleControls();
        }
    }

    private void btnReport1ActionPerformed(ActionEvent evt) {
        AlboTeilflaecheSearch search = new AlboTeilflaecheSearch();
        try {
            ArrayList number = (ArrayList)SessionManager.getProxy().customServerSearch((CidsServerSearch)search, this.connectionContext);
            ArrayList<String> fisAlboNr = new ArrayList<String>();
            if (number != null && number.size() > 0 && number.get(0) != null && ((ArrayList)number.get(0)).size() > 1) {
                for (ArrayList tmp : number) {
                    fisAlboNr.add((String)tmp.get(0) + " (" + (String)tmp.get(1) + ")");
                }
                String fisAlboNrString = String.join((CharSequence)",\n", fisAlboNr);
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), "Die folgenden Altfl\u00e4chen haben keine Hauptfl\u00e4che: \n" + fisAlboNrString, "Fehlerhafter Bearbeitungsstand", 2);
                return;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot check landesregistriernummer", (Throwable)e);
        }
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)CismapBroker.getInstance().getMappingComponent())) {
            String jobname = DownloadManagerDialog.getInstance().getJobName();
            String name = String.valueOf(System.currentTimeMillis());
            DownloadManager.instance().add((Download)new ByteArrayActionDownload("alboExport", (Object)name, null, "Schnittstellen-Export", jobname, name, ".zip", this.getConnectionContext()));
        }
    }

    private void btnLandRegNrActionPerformed(ActionEvent evt) {
        if (this.cidsBean.getProperty("geodaten_id") == null || this.cidsBean.getProperty("geodaten_id").equals("")) {
            this.createLandesregistriernummer();
        } else {
            try {
                this.cidsBean.setProperty("geodaten_id", null);
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot remove landesregistriernummer", (Throwable)e);
            }
        }
        this.updateTitleControls();
    }

    private void createLandesregistriernummer() {
        String geom = String.valueOf(this.cidsBean.getProperty("fk_geom.geo_field"));
        AlboFlaecheLandesRegNrSearch search = new AlboFlaecheLandesRegNrSearch(geom);
        try {
            ArrayList number = (ArrayList)SessionManager.getProxy().customServerSearch((CidsServerSearch)search, this.connectionContext);
            if (number != null && number.size() > 0 && number.get(0) != null && ((ArrayList)number.get(0)).size() > 1) {
                this.cidsBean.setProperty("geodaten_id", (Object)(((String)((ArrayList)number.get(0)).get(0)).substring(1) + ((String)((ArrayList)number.get(0)).get(1)).substring(1)));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot set landesregistriernummer", (Throwable)e);
        }
    }

    private void updateFooterControls() {
        for (Component card : this.panMainCard.getComponents()) {
            if (!card.isVisible()) continue;
            this.btnBack.setEnabled(!this.panCardFlaeche.equals(card));
            this.jLabel1.setEnabled(!this.panCardFlaeche.equals(card));
            this.jLabel2.setEnabled(!this.panCardArbeitsstandUndBemerkungen.equals(card));
            this.jLabel3.setEnabled(!this.panCardMassnahmen.equals(card));
            this.btnForward.setEnabled(!this.panCardMassnahmen.equals(card));
        }
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public Border getTitleBorder() {
        return new EmptyBorder(10, 10, 10, 10);
    }

    public Border getFooterBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public Border getCenterrBorder() {
        return new EmptyBorder(0, 5, 0, 5);
    }

    public void dispose() {
        this.panMain.dispose();
        this.panArbeitsstand.dispose();
        this.panMassnahmen.dispose();
        this.panBemerkungen.dispose();
        this.alboPicturePanel1.dispose();
        this.simpleAltlastWebDavPanel1.dispose();
        this.bindingGroup.unbind();
        if (this.editable && this.cidsBean != null) {
            this.cidsBean.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.cidsBean = null;
    }

    public void editorClosed(EditorClosedEvent event) {
        this.panMain.editorClosed(event);
        this.panArbeitsstand.editorClosed(event);
        this.panMassnahmen.editorClosed(event);
        this.panBemerkungen.editorClosed(event);
        this.simpleAltlastWebDavPanel1.editorClosed(event);
    }

    public boolean prepareForSave() {
        if (this.cidsBean.getProperty("loeschen") == null) {
            try {
                this.cidsBean.setProperty("loeschen", (Object)false);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return false;
            }
        }
        if (this.cidsBean.getProperty("fk_zuordnung.schluessel") != null && (this.cidsBean.getProperty("fk_zuordnung.schluessel").equals("altlastverdaechtig") || this.cidsBean.getProperty("fk_zuordnung.schluessel").equals("erfassung_schaedliche_bodenveraenderungen")) && (this.cidsBean.getProperty("geodaten_id") == null || this.cidsBean.getProperty("geodaten_id").equals(""))) {
            int answer = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(AlboFlaecheEditor.class, (String)"AlboFlaecheEditor.prepareForSave().geodaten_id.message"), NbBundle.getMessage(AlboFlaecheEditor.class, (String)"AlboFlaecheEditor.prepareForSave().geodaten_id.title"), 1);
            if (answer == 2) {
                return false;
            }
            if (answer == 0) {
                this.createLandesregistriernummer();
            }
        }
        return this.panMain.prepareForSave() && this.panArbeitsstand.prepareForSave() && this.panMassnahmen.prepareForSave() && this.panBemerkungen.prepareForSave();
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        MappingComponent mc = new MappingComponent();
        CismapBroker.getInstance().setMappingComponent(mc);
        DevelopmentTools.createEditorFromRestfulConnection((String)"http://localhost:9986/callserver/binary", (String)"WUNDA_BLAU", null, (boolean)true, (String)"ALBO_FLAECHE", (int)16521, (int)1200, (int)800);
    }

    public String getTitle() {
        return null;
    }

    public void setTitle(String title) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("geodaten_id")) {
            this.updateTitleControls();
        }
    }

    public boolean isOkForSaving() {
        String erhebungsnummer;
        Boolean prop = (Boolean)this.cidsBean.getProperty("entwurf");
        ArrayList<String> errorList = new ArrayList<String>();
        String zuordnung = (String)this.cidsBean.getProperty("fk_zuordnung.schluessel");
        if (prop == null) {
            prop = Boolean.FALSE;
        }
        if (!prop.booleanValue() && zuordnung != null && !zuordnung.equalsIgnoreCase("verzeichnisflaeche")) {
            Boolean schutzBeschrMassnahmen;
            boolean isException;
            erhebungsnummer = (String)this.cidsBean.getProperty("erhebungsnummer");
            if (erhebungsnummer == null || erhebungsnummer.equals("")) {
                errorList.add("Die Erhebungsnummer muss gesetzt sein.");
            } else {
                this.checkErhebungsnummer(errorList, erhebungsnummer);
            }
            Object geom = this.cidsBean.getProperty("fk_geom.geo_field");
            if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon)) {
                errorList.add("Die Geometrie muss entweder ein Polygon oder ein Multipolygon sein.");
            }
            if (this.cidsBean.getProperty("geodaten_id") == null || this.cidsBean.getProperty("geodaten_id").equals("")) {
                errorList.add("Die FISAlBo-Nr m\u00fcssen gesetzt sein.");
            } else {
                String geodaten_id = String.valueOf(this.cidsBean.getProperty("geodaten_id"));
                try {
                    AlboFlaecheNummerUniqueSearch search = new AlboFlaecheNummerUniqueSearch(geodaten_id, Integer.valueOf(this.cidsBean.getMetaObject().getId()), false);
                    ArrayList result = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, this.getConnectionContext());
                    if (result != null && result.size() > 0) {
                        errorList.add("Die FISAlBo-Nr ist nicht eindeutig.");
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while checking erhebungsnummer", (Throwable)e);
                }
            }
            String art = (String)this.cidsBean.getProperty("fk_art.schluessel");
            String status = (String)this.cidsBean.getProperty("fk_status.schluessel");
            if (status == null) {
                status = "";
            }
            if (art == null) {
                errorList.add("Die Art der Fl\u00e4che muss gesetzt sein.");
            } else if (art.equals("altstandort") || art.equals("betriebsstandort")) {
                TreeSet<CidsBean> wz = this.getWz();
                boolean mbFound = false;
                if (this.cidsBean.getProperty("massgeblicher_wirtschaftszweig") != null) {
                    for (CidsBean w : wz) {
                        if (!w.getProperty("id").equals(this.cidsBean.getProperty("massgeblicher_wirtschaftszweig.id"))) continue;
                        mbFound = true;
                    }
                }
                boolean bl = isException = zuordnung.equalsIgnoreCase("erfassung_schaedliche_bodenveraenderungen") && (status.equalsIgnoreCase("verdachtsflaeche") || status.equalsIgnoreCase("kein_handlungsbedarf"));
                if (!(!wz.isEmpty() && mbFound || isException)) {
                    errorList.add("Wenn die Art der Fl\u00e4che \"altstandort\" oder \"betriebsstandort\" ist,\n  muss mindestens eine Branche angegeben sein und der Wert f\u00fcr\n  branche_massgeblich gesetzt sein.");
                }
            } else if (art.equalsIgnoreCase("altablagerung")) {
                List<CidsBean> aa = this.getAa();
                boolean ueberwFound = false;
                for (CidsBean a : aa) {
                    if (a.getProperty("ueberwiegend") == null || !((Boolean)a.getProperty("ueberwiegend")).booleanValue()) continue;
                    ueberwFound = true;
                }
                boolean bl = isException = zuordnung.equalsIgnoreCase("erfassung_schaedliche_bodenveraenderungen") && (status.equalsIgnoreCase("verdachtsflaeche") || status.equalsIgnoreCase("kein_handlungsbedarf"));
                if (!(!aa.isEmpty() && ueberwFound || isException)) {
                    errorList.add("Wenn die Art der Fl\u00e4che \"altablagerung\" ist, muss mindestens\n  eine Hauptabfallart gesetzt sein und es muss die\n  \u00fcberwiegende Abfallart angegeben sein.");
                }
            }
            String bearbeitungsstand = this.getBearbeitungsstand();
            if (status.equals("") && !zuordnung.equalsIgnoreCase("verzeichnisflaeche")) {
                errorList.add("Status der Fl\u00e4che muss gesetzt sein, au\u00dfer wenn es sich um eine Verzeichnisfl\u00e4che handelt.");
            } else if (status.equalsIgnoreCase("kein_handlungsbedarf") && !bearbeitungsstand.equalsIgnoreCase("erfassung") && !bearbeitungsstand.equalsIgnoreCase("ga")) {
                errorList.add("Wenn der Status \"kein Handlungsbedarf bei der derzeitigen Nutzung\" ist,\n  muss der Bearbeitungsstand \"erfassung\" oder \"ga\" sein.");
            } else if (status.equalsIgnoreCase("verdachtsflaeche") && !bearbeitungsstand.equalsIgnoreCase("erfassung") && !bearbeitungsstand.equalsIgnoreCase("ga")) {
                errorList.add("Wenn der Status \"altlastverd\u00e4chtige Fl\u00e4che / Verdachtsfl\u00e4che\" ist,\n  muss der Bearbeitungsstand \"erfassung\" oder \"ga\" sein.");
            } else if (status.equalsIgnoreCase("verdacht_ausgeraeumt") && !bearbeitungsstand.equalsIgnoreCase("erfassung") && !bearbeitungsstand.equalsIgnoreCase("ga")) {
                errorList.add("Wenn der Status \"Verdacht ausger\u00e4umt\" ist,\n  muss der Bearbeitungsstand \"erfassung\" oder \"ga\" sein.");
            } else if (status.equalsIgnoreCase("altlast") && !bearbeitungsstand.equalsIgnoreCase("ga") && !bearbeitungsstand.equalsIgnoreCase("su_sp") && !bearbeitungsstand.equalsIgnoreCase("sa_laufend")) {
                errorList.add("Wenn der Status \"Altlast / sch\u00e4dliche Bodenver\u00e4nderung (sBv)\" ist,\n  muss der Bearbeitungsstand \"ga\", \"su_sp\" order \"sa_laufend\" sein.");
            } else if (status.equalsIgnoreCase("altlast_mit_ueberwachung") && !bearbeitungsstand.equalsIgnoreCase("ga") && !bearbeitungsstand.equalsIgnoreCase("su_sp")) {
                errorList.add("Wenn der Status \"Altlast / sBv mit dauerhafter Beschr\u00e4nkung / \u00dcberwachung\" ist,\n  muss der Bearbeitungsstand \"ga\" oder \"su_sp\" sein.");
            } else if (status.equalsIgnoreCase("sanierte_flaeche") && !bearbeitungsstand.equalsIgnoreCase("sa_abgeschlossen")) {
                errorList.add("Wenn der Status \"sanierte Fl\u00e4che (vollst\u00e4ndig dekontaminiert)\" ist,\n  muss der Bearbeitungsstand \"sa_abgeschlossen\" sein.");
            } else if (status.equalsIgnoreCase("sanierte_flaeche_fuer_bestimmte_nutzung") && !bearbeitungsstand.equalsIgnoreCase("sa_abgeschlossen")) {
                errorList.add("Wenn der Status \"sanierte Fl\u00e4che (gesichert / teilweise dekontaminiert) z.B. f\u00fcr bestimmte Nutzung\" ist,\n  muss der Bearbeitungsstand \"sa_abgeschlossen\" sein.");
            }
            CidsBean massn = (CidsBean)this.cidsBean.getProperty("fk_massnahmen");
            String[] schutzgefaehrdungen = new String[]{"ga_boden_mensch", "ga_boden_pflanze", "ga_boden_wasser", "ga_sonstiges"};
            String[] dekonSicherung = new String[]{"dm_aushub_deponierung", "dm_aushub_bodenbehandlung", "dm_bodenbeh_ohne_aushub", "dm_pneumatisch", "dm_pump_treat", "dm_in_situ_behandlung", "sm_sicherungsbauwerk", "ea_versiegelung", "ea_oberfl_abdicht", "sm_oberflaechenabdeckung", "sm_vertikale_abdichtung", "sm_immobilisierung", "sm_pneumatisch", "sm_pump_treat", "sm_in_situ_behandlung", "sm_sonstige"};
            String[] sicherung = new String[]{"sm_sicherungsbauwerk", "ea_versiegelung", "ea_oberfl_abdicht", "sm_oberflaechenabdeckung", "sm_vertikale_abdichtung", "sm_immobilisierung", "sm_pneumatisch", "sm_pump_treat", "sm_in_situ_behandlung", "sm_sonstige"};
            String[] dekon = new String[]{"dm_aushub_deponierung", "dm_aushub_bodenbehandlung", "dm_bodenbeh_ohne_aushub", "dm_pneumatisch", "dm_pump_treat", "dm_in_situ_behandlung"};
            int sumSchutzgefaehrdung = 0;
            int sumDekonSicherung = 0;
            int sumSicherung = 0;
            int sumDekon = 0;
            Boolean ueberwachungsMassnahmen = massn != null ? (Boolean)massn.getProperty("ueberwachungs_massnahmen") : null;
            Boolean bl = schutzBeschrMassnahmen = massn != null ? (Boolean)massn.getProperty("schutz_beschr_massnahmen") : null;
            if (ueberwachungsMassnahmen == null) {
                ueberwachungsMassnahmen = Boolean.FALSE;
            }
            if (schutzBeschrMassnahmen == null) {
                schutzBeschrMassnahmen = Boolean.FALSE;
            }
            if (massn != null) {
                Boolean value;
                for (String schutz : schutzgefaehrdungen) {
                    value = (Boolean)massn.getProperty(schutz);
                    if (value == null || !value.booleanValue()) continue;
                    ++sumSchutzgefaehrdung;
                }
                for (String dekonV : dekonSicherung) {
                    value = (Boolean)massn.getProperty(dekonV);
                    if (value == null || !value.booleanValue()) continue;
                    ++sumDekonSicherung;
                }
                for (String sich : sicherung) {
                    value = (Boolean)massn.getProperty(sich);
                    if (value == null || !value.booleanValue()) continue;
                    ++sumSicherung;
                }
                for (String dekonV : dekon) {
                    value = (Boolean)massn.getProperty(dekonV);
                    if (value == null || !value.booleanValue()) continue;
                    ++sumDekon;
                }
            }
            if (bearbeitungsstand.equals("sa_laufend") || bearbeitungsstand.equals("sa_abgeschlossen")) {
                if (massn == null) {
                    errorList.add("Wenn der Bearbeitungsstand den Wert \"sa_laufend\" oder \"sa_abgeschlossen\" hat,\n  muss mindestens eine Schutzgutgef\u00e4hrdung gesetzt sein\n  und mindestens eine Dekontaminationsma\u00dfnahme oder Sicherungsma\u00dfnahme gesetzt sein.");
                } else if (sumSchutzgefaehrdung == 0) {
                    errorList.add("Es muss mindestens eine Gef\u00e4hrdungsannahme gesetzt sein wenn die Fl\u00e4che den Bearbeitungsstand \"Sanierung laufend\" oder \"Sanierung abgeschlossen\" hat.");
                } else if (sumDekonSicherung == 0) {
                    errorList.add("Es muss mindestens eine Ma\u00dfnahme zur Dekontaminierung oder Sicherung gesetzt sein wenn die Fl\u00e4che den Bearbeitungsstand \"Sanierung laufend\" oder \"Sanierung abgeschlossen\" hat.");
                } else if (sumSchutzgefaehrdung == 0 || sumDekonSicherung == 0) {
                    errorList.add("Wenn der Bearbeitungsstand den Wert \"sa_laufend\" oder \"sa_abgeschlossen\" hat,\n  muss mindestens eine Schutzgutgef\u00e4hrdung gesetzt sein\n  und mindestens eine Dekontaminationsma\u00dfnahme oder Sicherungsma\u00dfnahme gesetzt sein.");
                }
            } else if (sumDekon > 0) {
                errorList.add("Wenn eine Dekontaminationsma\u00dfnahme gesetzt ist, muss der Bearbeitungsstand den Wert \"sa_laufend\" oder \"sa_abgeschlossen\" haben.");
            }
            if (sumSicherung > 0 && !bearbeitungsstand.equals("sa_laufend") && !bearbeitungsstand.equals("sa_abgeschlossen")) {
                errorList.add("Wenn eine Sicherungsma\u00dfnahme gesetzt ist, muss der Bearbeitungsstand \"Sanierung laufend\" oder \"Sanierung abgeschlossen\" sein.");
            }
            if ((status.equalsIgnoreCase("altlast") || status.equalsIgnoreCase("altlast_mit_ueberwachung")) && (bearbeitungsstand.equals("su_sp") || bearbeitungsstand.equals("ga")) && sumSchutzgefaehrdung == 0) {
                errorList.add("Es muss mindestens eine Gef\u00e4hrdungsannahme gesetzt sein, wenn die Fl\u00e4che den Bearbeitungsstand \"su_sp\" oder \"ga\" hat\nund es sich um eine Altlast oder Altlast mit \u00dcberwachung handelt.");
            }
            if (!(sumSchutzgefaehrdung <= 0 || bearbeitungsstand.equals("ga") || bearbeitungsstand.equals("su_sp") || bearbeitungsstand.equals("sa_laufend") || bearbeitungsstand.equals("sa_abgeschlossen"))) {
                errorList.add("Wenn eine Schutzgutgef\u00e4hrdung ermittelt wurde, muss der Bearbeitungsstand \"Gef\u00e4hrdungsabsch\u00e4tzung\", \"Sanierungsuntersuchung / -planung\", \"Sanierung laufend\" oder \"Sanierung abgeschlossen\" sein.");
            }
            if (status.equalsIgnoreCase("altlast_mit_ueberwachung")) {
                String arbeitsstandUeberwachung = (String)this.cidsBean.getProperty("fk_arbeitsstand_ueberwachung.schluessel");
                String arbeitsstandBegrenzung = (String)this.cidsBean.getProperty("fk_arbeitsstand_schutzundbegrenzung.schluessel");
                if (arbeitsstandUeberwachung != null && arbeitsstandUeberwachung.equalsIgnoreCase("laufend") && (arbeitsstandBegrenzung == null || !arbeitsstandBegrenzung.equalsIgnoreCase("laufend"))) {
                    if (!ueberwachungsMassnahmen.booleanValue()) {
                        errorList.add("Wenn der Status der Fl\u00e4che \"Altlast mit \u00dcberwachung\" ist und \u00dcberwachung ausgew\u00e4hlt ist, muss \u00dcberwachung aktiv sein.");
                    }
                } else if (arbeitsstandBegrenzung != null && arbeitsstandBegrenzung.equalsIgnoreCase("laufend") && !schutzBeschrMassnahmen.booleanValue() && !ueberwachungsMassnahmen.booleanValue()) {
                    errorList.add("Wenn der Status der Fl\u00e4che \"Altlast mit \u00dcberwachung\" ist und Beschr\u00e4nkungsma\u00dfnahmen gesetzt sind, m\u00fcssen \u00dcberwachung und Schutz- und Beschr\u00e4nkungsma\u00dfnahmen aktiv sein.");
                }
            }
        } else if (zuordnung != null && zuordnung.equalsIgnoreCase("verzeichnisflaeche")) {
            if (this.cidsBean.getProperty("geodaten_id") != null && !this.cidsBean.getProperty("geodaten_id").equals("")) {
                int ans = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Wenn es sich um eine Verzeichnisfl\u00e4che handelt, dann darf die FISAlBo-Nr. nicht gesetzt sein.\nSollen diese Nummern automatisch entfernt werden?", "Fehlerhafter Bearbeitungsstand", 0);
                if (ans == 0) {
                    try {
                        this.cidsBean.setProperty("geodaten_id", null);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot set geodaten_id", (Throwable)e);
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if ((erhebungsnummer = (String)this.cidsBean.getProperty("erhebungsnummer")) == null || erhebungsnummer.equals("")) {
                errorList.add("Die Erhebungsnummer muss gesetzt sein.");
            } else {
                this.checkErhebungsnummer(errorList, erhebungsnummer);
            }
        }
        if (errorList.size() > 0) {
            StringBuilder sb = new StringBuilder("Folgende Fehler wurden festgestellt:\n");
            int i = 0;
            for (String error : errorList) {
                sb.append(++i).append(". ").append(error).append("\n");
            }
            sb.append("\nFalls Sie das Objekt trotzdem speichern m\u00f6chten, dann muss es als Entwurf gekennzeichnet werden.");
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), sb, "Fehlerhafter Bearbeitungsstand", 2);
            return false;
        }
        return true;
    }

    private void checkErhebungsnummer(List<String> errorList, String erhebungsnummer) {
        try {
            AlboFlaecheNummerUniqueSearch search = new AlboFlaecheNummerUniqueSearch(erhebungsnummer, Integer.valueOf(this.cidsBean.getMetaObject().getId()), true);
            ArrayList result = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search, this.getConnectionContext());
            if (result != null && result.size() > 0) {
                errorList.add("Diese Erhebungsnummer existiert bereits.");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking erhebungsnummer", (Throwable)e);
        }
    }

    private TreeSet<CidsBean> getWz() {
        TreeSet<CidsBean> wzSet = new TreeSet<CidsBean>(new CidsBeanComparator());
        List<CidsBean> standorte = CidsBeanSupport.getBeanCollectionFromProperty(this.cidsBean, "n_standorte");
        if (standorte != null) {
            for (CidsBean s : standorte) {
                List<CidsBean> wirtschaftszweige = CidsBeanSupport.getBeanCollectionFromProperty(s, "arr_wirtschaftszweige");
                if (wirtschaftszweige == null) continue;
                wzSet.addAll(wirtschaftszweige);
            }
        }
        return wzSet;
    }

    private List<CidsBean> getAa() {
        List<CidsBean> aa;
        ArrayList<CidsBean> aaList = new ArrayList<CidsBean>();
        CidsBean altablagerung = (CidsBean)this.cidsBean.getProperty("fk_altablagerung");
        if (altablagerung != null && (aa = CidsBeanSupport.getBeanCollectionFromProperty(altablagerung, "n_altablagerung_abfallherkuenfte")) != null) {
            aaList.addAll(aa);
        }
        return aaList;
    }

    private String getBearbeitungsstand() {
        String sanierung = (String)this.cidsBean.getProperty("fk_arbeitsstand_sanierung.schluessel");
        String sanierungsplan = (String)this.cidsBean.getProperty("fk_arbeitsstand_sanierungsplan.schluessel");
        String sanierungsunter = (String)this.cidsBean.getProperty("fk_arbeitsstand_sanierungsuntersuchung.schluessel");
        String gefaehrdungsabsch = (String)this.cidsBean.getProperty("fk_arbeitsstand_gefaehrdungsabschaetzung.schluessel");
        if (sanierung != null && sanierung.equalsIgnoreCase("abgeschlossen")) {
            return "sa_abgeschlossen";
        }
        if (sanierung != null && sanierung.equalsIgnoreCase("laufend")) {
            return "sa_laufend";
        }
        if (sanierungsplan != null || sanierungsunter != null) {
            return "su_sp";
        }
        if (gefaehrdungsabsch != null) {
            return "ga";
        }
        return "erfassung";
    }

    public BeanInitializer getBeanInitializer() {
        return new AlboFlaecheInitializer(this.cidsBean);
    }

    public void afterSaving(AfterSavingHook.Event event) {
        this.panMain.afterSaving(event);
    }

    private static class CidsBeanComparator
    implements Comparator<CidsBean> {
        private CidsBeanComparator() {
        }

        @Override
        public int compare(CidsBean o1, CidsBean o2) {
            if (o1 != null && o2 != null) {
                return o1.getPrimaryKeyValue().compareTo(o2.getPrimaryKeyValue());
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null) {
                return -1;
            }
            if (o2 != null) {
                return 1;
            }
            return 0;
        }
    }

    private class AlboFlaecheInitializer
    extends DefaultBeanInitializer {
        public AlboFlaecheInitializer(CidsBean cidsBean) {
            super(cidsBean);
        }

        public void initializeBean(final CidsBean beanToInit) throws Exception {
            super.initializeBean(beanToInit);
            EventQueue.invokeLater(new Thread(""){

                @Override
                public void run() {
                    AlboFlaecheEditor.this.setCidsBean(beanToInit);
                }
            });
        }

        protected void processSimpleProperty(CidsBean beanToInit, String propertyName, Object simpleValueToProcess) throws Exception {
            super.processSimpleProperty(beanToInit, propertyName, simpleValueToProcess);
        }

        protected void processArrayProperty(CidsBean beanToInit, String propertyName, Collection<CidsBean> arrayValueToProcess) throws Exception {
            block3: {
                List<CidsBean> beans;
                block2: {
                    beans = CidsBeanSupport.getBeanCollectionFromProperty(beanToInit, propertyName);
                    beans.clear();
                    if (!propertyName.equalsIgnoreCase("n_standorte")) break block2;
                    for (CidsBean tmp : arrayValueToProcess) {
                        beans.add(CidsBeanSupport.cloneBean(tmp, AlboFlaecheEditor.this.connectionContext));
                    }
                    break block3;
                }
                if (!propertyName.equalsIgnoreCase("dokumente")) break block3;
                for (CidsBean tmp : arrayValueToProcess) {
                    beans.add(CidsBeanSupport.cloneBean(tmp, AlboFlaecheEditor.this.connectionContext));
                }
            }
        }

        protected void processComplexProperty(CidsBean beanToInit, String propertyName, CidsBean complexValueToProcess) throws Exception {
            if (complexValueToProcess.getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("geom")) {
                CidsBean geomBean = complexValueToProcess.getMetaObject().getMetaClass().getEmptyInstance(this.getConnectionContext()).getBean();
                Geometry g = (Geometry)complexValueToProcess.getProperty("geo_field");
                if (g != null) {
                    g = (Geometry)g.clone();
                }
                geomBean.setProperty("geo_field", (Object)g);
                beanToInit.setProperty(propertyName, (Object)geomBean);
            } else if (complexValueToProcess.getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("albo_massnahmen")) {
                CidsBean maBean = CidsBeanSupport.cloneBean(complexValueToProcess, AlboFlaecheEditor.this.connectionContext);
                beanToInit.setProperty(propertyName, (Object)maBean);
            } else if (complexValueToProcess.getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("albo_altablagerung")) {
                CidsBean abBean = CidsBeanSupport.cloneBean(complexValueToProcess, AlboFlaecheEditor.this.connectionContext);
                List beans = complexValueToProcess.getBeanCollectionProperty("n_altablagerung_abfallherkuenfte");
                if (beans != null) {
                    for (CidsBean b : beans) {
                        List newBeans = abBean.getBeanCollectionProperty("n_altablagerung_abfallherkuenfte");
                        newBeans.add(CidsBeanSupport.cloneBean(b, AlboFlaecheEditor.this.connectionContext));
                    }
                }
                beanToInit.setProperty(propertyName, (Object)abBean);
            } else {
                beanToInit.setProperty(propertyName, (Object)complexValueToProcess);
            }
        }
    }

    private class FormListener
    implements ActionListener,
    MouseListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == AlboFlaecheEditor.this.jToggleButton1) {
                AlboFlaecheEditor.this.jToggleButton1ActionPerformed(evt);
            } else if (evt.getSource() == AlboFlaecheEditor.this.btnLandRegNr) {
                AlboFlaecheEditor.this.btnLandRegNrActionPerformed(evt);
            } else if (evt.getSource() == AlboFlaecheEditor.this.btnReport1) {
                AlboFlaecheEditor.this.btnReport1ActionPerformed(evt);
            } else if (evt.getSource() == AlboFlaecheEditor.this.btnBack) {
                AlboFlaecheEditor.this.btnBackActionPerformed(evt);
            } else if (evt.getSource() == AlboFlaecheEditor.this.btnForward) {
                AlboFlaecheEditor.this.btnForwardActionPerformed(evt);
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getSource() == AlboFlaecheEditor.this.jLabel1) {
                AlboFlaecheEditor.this.jLabel1MouseClicked(evt);
            } else if (evt.getSource() == AlboFlaecheEditor.this.jLabel2) {
                AlboFlaecheEditor.this.jLabel2MouseClicked(evt);
            } else if (evt.getSource() == AlboFlaecheEditor.this.jLabel3) {
                AlboFlaecheEditor.this.jLabel3MouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }
    }
}

