/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.utils.TableUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.BindingGroupStore;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.concurrent.ExecutionException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EmobradLadekostenEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
EditorSaveListener,
BindingGroupStore,
RequestsFullSizeComponent {
    private static final Logger LOG = Logger.getLogger(EmobradLadekostenEditor.class);
    public static final String FIELD__SCHLUESSEL = "schluessel";
    public static final String FIELD__NAME = "name";
    public static final String FIELD__ID = "id";
    public static final String TABLE_NAME = "emobrad_ladekosten";
    public static final String BUNDLE_NONAME = "EmobradLadekostenEditor.prepareForSave().noName";
    public static final String BUNDLE_DUPLICATENAME = "EmobradLadekostenEditor.prepareForSave().duplicateName";
    public static final String BUNDLE_DUPLICATEKEY = "EmobradLadekostenEditor.prepareForSave().duplicateSchluessel";
    public static final String BUNDLE_PANE_PREFIX = "EmobradLadekostenEditor.prepareForSave().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "EmobradLadekostenEditor.prepareForSave().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "EmobradLadekostenEditor.prepareForSave().JOptionPane.title";
    private SwingWorker worker_key;
    private SwingWorker worker_name;
    private Boolean redundantName = false;
    private Boolean redundantKey = false;
    private boolean isEditor = true;
    private JLabel lblName;
    private JPanel panContent;
    private JPanel panFillerUnten;
    private JPanel panFillerUnten1;
    private JPanel panName;
    private JTextField txtName;
    private BindingGroup bindingGroup;

    public EmobradLadekostenEditor() {
    }

    public EmobradLadekostenEditor(boolean boolEditor) {
        this.isEditor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.txtName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EmobradLadekostenEditor.this.checkAttributes();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EmobradLadekostenEditor.this.checkAttributes();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EmobradLadekostenEditor.this.checkAttributes();
            }
        });
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panFillerUnten = new JPanel();
        this.panContent = new RoundedPanel();
        this.panFillerUnten1 = new JPanel();
        this.panName = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(600, 646));
        this.setPreferredSize(new Dimension(600, 737));
        this.setLayout(new GridBagLayout());
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.panContent.setAutoscrolls(true);
        this.panContent.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        this.panContent.setMinimumSize(new Dimension(450, 488));
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setPreferredSize(new Dimension(450, 961));
        this.panContent.setLayout(new GridBagLayout());
        this.panFillerUnten1.setName("");
        this.panFillerUnten1.setOpaque(false);
        GroupLayout panFillerUnten1Layout = new GroupLayout(this.panFillerUnten1);
        this.panFillerUnten1.setLayout(panFillerUnten1Layout);
        panFillerUnten1Layout.setHorizontalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUnten1Layout.setVerticalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        this.panContent.add((Component)this.panFillerUnten1, gridBagConstraints);
        this.panName.setOpaque(false);
        this.panName.setLayout(new GridBagLayout());
        this.lblName.setFont(new Font("Tahoma", 1, 11));
        this.lblName.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.panName.add((Component)this.lblName, gridBagConstraints);
        this.txtName.setToolTipText("");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)((Object)this), (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panName.add((Component)this.txtName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panContent.add((Component)this.panName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public boolean prepareForSave() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.txtName.getText().trim().isEmpty()) {
                LOG.warn((Object)"No name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(EmobradLadekostenEditor.class, (String)BUNDLE_NONAME));
            } else {
                if (this.cidsBean.getMetaObject().getStatus() == 1) {
                    this.cidsBean.setProperty(FIELD__SCHLUESSEL, (Object)this.txtName.getText().trim());
                }
                if (this.redundantName.booleanValue()) {
                    LOG.warn((Object)"Duplicate name specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(EmobradLadekostenEditor.class, (String)BUNDLE_DUPLICATENAME));
                } else if (this.redundantKey.booleanValue()) {
                    LOG.warn((Object)"Duplicate key specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(EmobradLadekostenEditor.class, (String)BUNDLE_DUPLICATEKEY));
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(EmobradLadekostenEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(EmobradLadekostenEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(EmobradLadekostenEditor.class, (String)BUNDLE_PANE_TITLE), 2);
            return false;
        }
        return save;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            this.bindingGroup.bind();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void setReadOnly() {
        if (!this.isEditor) {
            RendererTools.makeReadOnly(this.txtName);
        }
    }

    private void checkName(String field, OtherTableCases fall) {
        this.valueFromOtherTable(TABLE_NAME, " where " + field + " ilike '" + this.txtName.getText().trim() + "' and " + FIELD__ID + " <> " + this.cidsBean.getProperty(FIELD__ID), fall);
    }

    private void checkAttributes() {
        this.checkName(FIELD__NAME, OtherTableCases.REDUNDANT_ATT_NAME);
        this.checkName(FIELD__SCHLUESSEL, OtherTableCases.REDUNDANT_ATT_KEY);
    }

    public void dispose() {
        super.dispose();
    }

    public String getTitle() {
        return this.cidsBean.toString();
    }

    public void setTitle(String string) {
    }

    public void editorClosed(EditorClosedEvent ece) {
    }

    public BindingGroup getBindingGroup() {
        return this.bindingGroup;
    }

    private void valueFromOtherTable(final String tableName, final String whereClause, final OtherTableCases fall) {
        SwingWorker<CidsBean, Void> worker = new SwingWorker<CidsBean, Void>(){

            @Override
            protected CidsBean doInBackground() throws Exception {
                return TableUtils.getOtherTableValue(tableName, whereClause, EmobradLadekostenEditor.this.getConnectionContext());
            }

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        CidsBean check = (CidsBean)this.get();
                        if (check != null) {
                            switch (fall) {
                                case REDUNDANT_ATT_KEY: {
                                    EmobradLadekostenEditor.this.redundantKey = true;
                                    break;
                                }
                                case REDUNDANT_ATT_NAME: {
                                    EmobradLadekostenEditor.this.redundantName = true;
                                }
                            }
                        } else {
                            switch (fall) {
                                case REDUNDANT_ATT_KEY: {
                                    EmobradLadekostenEditor.this.redundantKey = false;
                                    break;
                                }
                                case REDUNDANT_ATT_NAME: {
                                    EmobradLadekostenEditor.this.redundantName = false;
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn((Object)"problem in Worker: load values.", (Throwable)e);
                }
            }
        };
        if (fall.equals((Object)OtherTableCases.REDUNDANT_ATT_NAME)) {
            if (this.worker_name != null) {
                this.worker_name.cancel(true);
            }
            this.worker_name = worker;
            this.worker_name.execute();
        } else {
            if (this.worker_key != null) {
                this.worker_key.cancel(true);
            }
            this.worker_key = worker;
            this.worker_key.execute();
        }
    }

    private static enum OtherTableCases {
        REDUNDANT_ATT_KEY,
        REDUNDANT_ATT_NAME;

    }
}

